/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.serviceregistry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceHookTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(ServiceHookTests.class);
    }

    public void testFindHook01() {
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        final BundleContext testContext = OSGiTestsActivator.getContext();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("name", "testFindHook01");
        props.put("service.description", "service 1");
        final ServiceRegistration reg1 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "service 2");
        final ServiceRegistration reg2 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        props.put("service.description", "service 3");
        ServiceRegistration reg3 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
        final int[] hookCalled = new int[5];
        final boolean[] startTest = new boolean[1];
        final AssertionFailedError[] hookError = new AssertionFailedError[4];
        props.put("service.description", "find hook 1");
        props.put("service.description", "min value");
        props.put("service.ranking", new Integer(Integer.MIN_VALUE));
        ServiceRegistration regHook1 = testContext.registerService(FindHook.class.getName(), (Object)new FindHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void find(BundleContext context, String name, String filter, boolean allServices, Collection references) {
                try {
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        if (!startTest[0]) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return;
                        }
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 1;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        ServiceHookTests.assertEquals("wrong context in hook", testContext, context);
                        ServiceHookTests.assertEquals((String)"wrong name in hook", (String)Runnable.class.getName(), (String)name);
                        ServiceHookTests.assertEquals((String)"wrong filter in hook", (String)"(name=testFindHook01)", (String)filter);
                        ServiceHookTests.assertEquals((String)"wrong allservices in hook", (boolean)false, (boolean)allServices);
                        ServiceHookTests.assertEquals((String)"wrong number of services in hook", (int)1, (int)references.size());
                        for (ServiceReference ref : references) {
                            if (ref.equals(reg1.getReference())) {
                                ServiceHookTests.fail((String)"service 1 is present");
                            }
                            if (!ref.equals(reg2.getReference())) continue;
                            ServiceHookTests.fail((String)"service 2 is present");
                        }
                        try {
                            references.add(reg1.getReference());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            references.addAll(Arrays.asList(reg1.getReference()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[0] = a;
                    return;
                }
            }
        }, props);
        props.put("service.description", "find hook 2");
        props.put("service.description", "max value first");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration regHook2 = testContext.registerService(FindHook.class.getName(), (Object)new FindHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void find(BundleContext context, String name, String filter, boolean allServices, Collection references) {
                try {
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        if (!startTest[0]) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return;
                        }
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 2;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        ServiceHookTests.assertEquals("wrong context in hook", testContext, context);
                        ServiceHookTests.assertEquals((String)"wrong name in hook", (String)Runnable.class.getName(), (String)name);
                        ServiceHookTests.assertEquals((String)"wrong filter in hook", (String)"(name=testFindHook01)", (String)filter);
                        ServiceHookTests.assertEquals((String)"wrong allservices in hook", (boolean)false, (boolean)allServices);
                        ServiceHookTests.assertEquals((String)"wrong number of services in hook", (int)3, (int)references.size());
                        Iterator iter = references.iterator();
                        while (iter.hasNext()) {
                            ServiceReference ref = (ServiceReference)iter.next();
                            if (!ref.equals(reg2.getReference())) continue;
                            iter.remove();
                        }
                        try {
                            references.add(reg2.getReference());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            references.addAll(Arrays.asList(reg2.getReference()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[1] = a;
                    return;
                }
            }
        }, props);
        props.put("service.description", "find hook 3");
        props.put("service.description", "max value second");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration regHook3 = testContext.registerService(FindHook.class.getName(), (Object)new FindHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void find(BundleContext context, String name, String filter, boolean allServices, Collection references) {
                try {
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        if (!startTest[0]) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return;
                        }
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 3;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        ServiceHookTests.assertEquals("wrong context in hook", testContext, context);
                        ServiceHookTests.assertEquals((String)"wrong name in hook", (String)Runnable.class.getName(), (String)name);
                        ServiceHookTests.assertEquals((String)"wrong filter in hook", (String)"(name=testFindHook01)", (String)filter);
                        ServiceHookTests.assertEquals((String)"wrong allservices in hook", (boolean)false, (boolean)allServices);
                        ServiceHookTests.assertEquals((String)"wrong number of services in hook", (int)2, (int)references.size());
                        for (ServiceReference ref : references) {
                            if (!ref.equals(reg2.getReference())) continue;
                            ServiceHookTests.fail((String)"service 2 is present");
                        }
                        try {
                            references.add(reg2.getReference());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            references.addAll(Arrays.asList(reg2.getReference()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[2] = a;
                    return;
                }
                {
                    throw new RuntimeException("testFindHook01");
                }
            }
        }, props);
        props.put("service.description", "find hook 4");
        props.put("service.description", "max value third");
        props.put("service.ranking", new Integer(Integer.MAX_VALUE));
        ServiceRegistration regHook4 = testContext.registerService(FindHook.class.getName(), (Object)new FindHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void find(BundleContext context, String name, String filter, boolean allServices, Collection references) {
                try {
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        if (!startTest[0]) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return;
                        }
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 4;
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        ServiceHookTests.assertEquals("wrong context in hook", testContext, context);
                        ServiceHookTests.assertEquals((String)"wrong name in hook", (String)Runnable.class.getName(), (String)name);
                        ServiceHookTests.assertEquals((String)"wrong filter in hook", (String)"(name=testFindHook01)", (String)filter);
                        ServiceHookTests.assertEquals((String)"wrong allservices in hook", (boolean)false, (boolean)allServices);
                        ServiceHookTests.assertEquals((String)"wrong number of services in hook", (int)2, (int)references.size());
                        Iterator iter = references.iterator();
                        while (iter.hasNext()) {
                            ServiceReference ref = (ServiceReference)iter.next();
                            if (ref.equals(reg1.getReference())) {
                                iter.remove();
                            }
                            if (!ref.equals(reg2.getReference())) continue;
                            ServiceHookTests.fail((String)"service 2 is present");
                        }
                        try {
                            references.add(reg2.getReference());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            references.addAll(Arrays.asList(reg2.getReference()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[3] = a;
                    return;
                }
            }
        }, props);
        startTest[0] = true;
        try {
            ServiceReference[] refs = null;
            try {
                refs = testContext.getServiceReferences(Runnable.class.getName(), "(name=testFindHook01)");
            }
            catch (InvalidSyntaxException e) {
                ServiceHookTests.fail((String)"Unexpected syntax error", (Throwable)e);
            }
            ServiceHookTests.assertEquals((String)"all hooks not called", (int)4, (int)hookCalled[0]);
            ServiceHookTests.assertEquals((String)"hook 2 not called first", (int)2, (int)hookCalled[1]);
            ServiceHookTests.assertEquals((String)"hook 3 not called second", (int)3, (int)hookCalled[2]);
            ServiceHookTests.assertEquals((String)"hook 4 not called third", (int)4, (int)hookCalled[3]);
            ServiceHookTests.assertEquals((String)"hook 1 not called fourth ", (int)1, (int)hookCalled[4]);
            int i = 0;
            while (i < hookError.length) {
                if (hookError[i] != null) {
                    throw hookError[i];
                }
                ++i;
            }
            ServiceHookTests.assertNotNull((String)"service refs is null", (Object)refs);
            ServiceHookTests.assertEquals((String)"Wrong number of references", (int)1, (int)refs.length);
            List<ServiceReference> refList = Arrays.asList(refs);
            ServiceHookTests.assertFalse((String)"contains service 1", (boolean)refList.contains(reg1.getReference()));
            ServiceHookTests.assertFalse((String)"contains service 2", (boolean)refList.contains(reg2.getReference()));
            ServiceHookTests.assertTrue((String)"missing service 3", (boolean)refList.contains(reg3.getReference()));
            startTest[0] = false;
            regHook1.unregister();
            regHook1 = null;
            regHook2.unregister();
            regHook2 = null;
            regHook3.unregister();
            regHook3 = null;
            regHook4.unregister();
            regHook4 = null;
            refs = null;
            hookCalled[0] = 0;
            startTest[0] = true;
            try {
                refs = testContext.getServiceReferences(Runnable.class.getName(), "(name=testFindHook01)");
            }
            catch (InvalidSyntaxException e) {
                ServiceHookTests.fail((String)"Unexpected syntax error", (Throwable)e);
            }
            ServiceHookTests.assertEquals((String)"hooks called", (int)0, (int)hookCalled[0]);
            ServiceHookTests.assertNotNull((String)"service refs is null", (Object)refs);
            ServiceHookTests.assertEquals((String)"Wrong number of references", (int)3, (int)refs.length);
            refList = Arrays.asList(refs);
            ServiceHookTests.assertTrue((String)"missing service 1", (boolean)refList.contains(reg1.getReference()));
            ServiceHookTests.assertTrue((String)"missing service 2", (boolean)refList.contains(reg2.getReference()));
            ServiceHookTests.assertTrue((String)"missing service 3", (boolean)refList.contains(reg3.getReference()));
        }
        finally {
            if (regHook1 != null) {
                regHook1.unregister();
            }
            if (regHook2 != null) {
                regHook2.unregister();
            }
            if (regHook3 != null) {
                regHook3.unregister();
            }
            if (regHook4 != null) {
                regHook4.unregister();
            }
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventHook01() {
        Runnable runIt = new Runnable(){

            @Override
            public void run() {
            }
        };
        final BundleContext testContext = OSGiTestsActivator.getContext();
        final int[] hookCalled = new int[2];
        final AssertionFailedError[] hookError = new AssertionFailedError[1];
        final ArrayList events = new ArrayList();
        ServiceListener sl = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                List list = events;
                synchronized (list) {
                    events.add(event);
                }
            }
        };
        Filter tmpFilter = null;
        try {
            tmpFilter = testContext.createFilter("(&(name=testEventHook01)(objectClass=java.lang.Runnable))");
            testContext.addServiceListener(sl, "(&(name=testEventHook01)(objectClass=java.lang.Runnable))");
        }
        catch (InvalidSyntaxException e) {
            ServiceHookTests.fail((String)"Unexpected syntax error", (Throwable)e);
        }
        final Filter filter = tmpFilter;
        EventHook hook1 = new EventHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void event(ServiceEvent event, Collection contexts) {
                try {
                    if (!filter.match(event.getServiceReference())) {
                        return;
                    }
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 1;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        ServiceHookTests.assertTrue((String)"does not contain test context", (boolean)contexts.contains(testContext));
                        try {
                            contexts.add(testContext.getBundle(0L).getBundleContext());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            contexts.addAll(Arrays.asList(testContext.getBundle(0L).getBundleContext()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[0] = a;
                    return;
                }
            }
        };
        EventHook hook2 = new EventHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void event(ServiceEvent event, Collection contexts) {
                try {
                    if (!filter.match(event.getServiceReference())) {
                        return;
                    }
                    int[] nArray = hookCalled;
                    synchronized (hookCalled) {
                        hookCalled[0] = hookCalled[0] + 1;
                        hookCalled[hookCalled[0]] = 1;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        ServiceHookTests.assertTrue((String)"does not contain test context", (boolean)contexts.contains(testContext));
                        contexts.remove(testContext);
                        try {
                            contexts.add(testContext.getBundle(0L).getBundleContext());
                            ServiceHookTests.fail((String)"add to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                        try {
                            contexts.addAll(Arrays.asList(testContext.getBundle(0L).getBundleContext()));
                            ServiceHookTests.fail((String)"addAll to collection succeeded");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception e) {
                            ServiceHookTests.fail((String)"incorrect exception", (Throwable)e);
                        }
                    }
                }
                catch (AssertionFailedError a) {
                    hookError[0] = a;
                    return;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testEventHook01");
        props.put("service.description", "event hook 1");
        ServiceRegistration regHook = testContext.registerService(EventHook.class.getName(), (Object)hook1, props);
        ServiceRegistration reg1 = null;
        try {
            props.put("service.description", "service 1");
            ArrayList arrayList = events;
            synchronized (arrayList) {
                events.clear();
            }
            reg1 = testContext.registerService(Runnable.class.getName(), (Object)runIt, props);
            ServiceHookTests.assertEquals((String)"all hooks not called", (int)1, (int)hookCalled[0]);
            ServiceHookTests.assertEquals((String)"hook 1 not called first", (int)1, (int)hookCalled[1]);
            int i22 = 0;
            while (i22 < hookError.length) {
                if (hookError[i22] != null) {
                    throw hookError[i22];
                }
                ++i22;
            }
            ArrayList i22 = events;
            synchronized (i22) {
                ServiceHookTests.assertEquals((String)"listener not called once", (int)1, (int)events.size());
                for (ServiceEvent event : events) {
                    ServiceHookTests.assertEquals((String)"type not registered", (int)1, (int)event.getType());
                    ServiceHookTests.assertEquals("wrong service", reg1.getReference(), event.getServiceReference());
                }
            }
            regHook.unregister();
            regHook = null;
            i22 = events;
            synchronized (i22) {
                events.clear();
            }
            hookCalled[0] = 0;
            props.put("service.description", "service 2");
            reg1.setProperties(props);
            i22 = events;
            synchronized (i22) {
                ServiceHookTests.assertEquals((String)"listener not called once", (int)1, (int)events.size());
                for (ServiceEvent event : events) {
                    ServiceHookTests.assertEquals((String)"type not registered", (int)2, (int)event.getType());
                    ServiceHookTests.assertEquals("wrong service", reg1.getReference(), event.getServiceReference());
                }
            }
            ServiceHookTests.assertEquals((String)"hooks called", (int)0, (int)hookCalled[0]);
            props.put("service.description", "event hook 2");
            regHook = testContext.registerService(EventHook.class.getName(), (Object)hook2, props);
            i22 = events;
            synchronized (i22) {
                events.clear();
            }
            hookCalled[0] = 0;
            reg1.unregister();
            reg1 = null;
            i22 = events;
            synchronized (i22) {
                ServiceHookTests.assertEquals((String)"listener called", (int)0, (int)events.size());
            }
            ServiceHookTests.assertEquals((String)"all hooks not called", (int)1, (int)hookCalled[0]);
            ServiceHookTests.assertEquals((String)"hook 1 not called first", (int)1, (int)hookCalled[1]);
            int i = 0;
            while (i < hookError.length) {
                if (hookError[i] != null) {
                    throw hookError[i];
                }
                ++i;
            }
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
            if (reg1 != null) {
                reg1.unregister();
            }
            if (sl != null) {
                testContext.removeServiceListener(sl);
            }
        }
    }

    public void testListenerHook01() {
        BundleContext testContext = OSGiTestsActivator.getContext();
        final ArrayList result = new ArrayList();
        final int[] hookCalled = new int[2];
        ListenerHook hook1 = new ListenerHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void added(Collection listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[0] = hookCalled[0] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.addAll(listeners);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removed(Collection listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[1] = hookCalled[1] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.removeAll(listeners);
                    return;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testListenerHook01");
        props.put("service.description", "listener hook 1");
        ServiceRegistration regHook = testContext.registerService(ListenerHook.class.getName(), (Object)hook1, props);
        try {
            try {
                String f;
                BundleContext c;
                ServiceHookTests.assertFalse((String)"no service listeners found", (boolean)result.isEmpty());
                ServiceHookTests.assertEquals((String)"added not called", (int)1, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)0, (int)hookCalled[1]);
                int size = result.size();
                ServiceListener testSL = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                    }
                };
                String filterString1 = "(foo=bar)";
                testContext.addServiceListener(testSL, filterString1);
                ServiceHookTests.assertEquals((String)"added not called", (int)2, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)0, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not added", (int)(size + 1), (int)result.size());
                Iterator iter = result.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    ListenerHook.ListenerInfo info = (ListenerHook.ListenerInfo)iter.next();
                    BundleContext c2 = info.getBundleContext();
                    String f2 = info.getFilter();
                    if (c2 != testContext || !filterString1.equals(f2)) continue;
                    if (found) {
                        ServiceHookTests.fail((String)"found more than once");
                    }
                    found = true;
                }
                if (!found) {
                    ServiceHookTests.fail((String)"listener not found");
                }
                String filterString2 = "(bar=foo)";
                testContext.addServiceListener(testSL, filterString2);
                ServiceHookTests.assertEquals((String)"added not called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed not called", (int)1, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not removed and added", (int)(size + 1), (int)result.size());
                iter = result.iterator();
                found = false;
                while (iter.hasNext()) {
                    ListenerHook.ListenerInfo info = (ListenerHook.ListenerInfo)iter.next();
                    c = info.getBundleContext();
                    f = info.getFilter();
                    if (c == testContext && filterString2.equals(f)) {
                        if (found) {
                            ServiceHookTests.fail((String)"found more than once");
                        }
                        found = true;
                    }
                    if (c != testContext || !filterString1.equals(f)) continue;
                    ServiceHookTests.fail((String)"first listener not removed");
                }
                if (!found) {
                    ServiceHookTests.fail((String)"listener not found");
                }
                testContext.removeServiceListener(testSL);
                ServiceHookTests.assertEquals((String)"added called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed not called", (int)2, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not removed", (int)size, (int)result.size());
                for (ListenerHook.ListenerInfo info : result) {
                    c = info.getBundleContext();
                    f = info.getFilter();
                    if (c != testContext || !filterString2.equals(f)) continue;
                    ServiceHookTests.fail((String)"second listener not removed");
                }
                testContext.removeServiceListener(testSL);
                ServiceHookTests.assertEquals((String)"added called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)2, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener removed", (int)size, (int)result.size());
            }
            catch (InvalidSyntaxException e) {
                ServiceHookTests.fail((String)e.getMessage());
                if (regHook != null) {
                    regHook.unregister();
                }
            }
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
        }
    }

    public void testListenerHook02() {
        BundleContext testContext = OSGiTestsActivator.getContext();
        final ArrayList result = new ArrayList();
        final int[] hookCalled = new int[2];
        ListenerHook hook1 = new ListenerHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void added(Collection listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[0] = hookCalled[0] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.addAll(listeners);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removed(Collection listeners) {
                int[] nArray = hookCalled;
                synchronized (hookCalled) {
                    hookCalled[1] = hookCalled[1] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result.removeAll(listeners);
                    return;
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "testListenerHook02");
        props.put("service.description", "listener hook 1");
        ServiceRegistration regHook = testContext.registerService(ListenerHook.class.getName(), (Object)hook1, props);
        try {
            try {
                String f;
                BundleContext c;
                ServiceHookTests.assertFalse((String)"no service listeners found", (boolean)result.isEmpty());
                ServiceHookTests.assertEquals((String)"added not called", (int)1, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)0, (int)hookCalled[1]);
                int size = result.size();
                ServiceListener testSL = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                    }
                };
                String filterString1 = "(objectClass=bar)";
                testContext.addServiceListener(testSL, filterString1);
                ServiceHookTests.assertEquals((String)"added not called", (int)2, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)0, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not added", (int)(size + 1), (int)result.size());
                Iterator iter = result.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    ListenerHook.ListenerInfo info = (ListenerHook.ListenerInfo)iter.next();
                    BundleContext c2 = info.getBundleContext();
                    String f2 = info.getFilter();
                    if (c2 != testContext || !filterString1.equals(f2)) continue;
                    if (found) {
                        ServiceHookTests.fail((String)"found more than once");
                    }
                    found = true;
                }
                if (!found) {
                    ServiceHookTests.fail((String)"listener not found");
                }
                Object filterString2 = null;
                testContext.addServiceListener(testSL);
                ServiceHookTests.assertEquals((String)"added not called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed not called", (int)1, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not removed and added", (int)(size + 1), (int)result.size());
                iter = result.iterator();
                found = false;
                while (iter.hasNext()) {
                    ListenerHook.ListenerInfo info = (ListenerHook.ListenerInfo)iter.next();
                    c = info.getBundleContext();
                    f = info.getFilter();
                    if (c == testContext && f == filterString2) {
                        if (found) {
                            ServiceHookTests.fail((String)"found more than once");
                        }
                        found = true;
                    }
                    if (c != testContext || !filterString1.equals(f)) continue;
                    ServiceHookTests.fail((String)"first listener not removed");
                }
                if (!found) {
                    ServiceHookTests.fail((String)"listener not found");
                }
                testContext.removeServiceListener(testSL);
                ServiceHookTests.assertEquals((String)"added called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed not called", (int)2, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener not removed", (int)size, (int)result.size());
                for (ListenerHook.ListenerInfo info : result) {
                    c = info.getBundleContext();
                    f = info.getFilter();
                    if (c != testContext || f != filterString2) continue;
                    ServiceHookTests.fail((String)"second listener not removed");
                }
                testContext.removeServiceListener(testSL);
                ServiceHookTests.assertEquals((String)"added called", (int)3, (int)hookCalled[0]);
                ServiceHookTests.assertEquals((String)"removed called", (int)2, (int)hookCalled[1]);
                ServiceHookTests.assertEquals((String)"listener removed", (int)size, (int)result.size());
            }
            catch (InvalidSyntaxException e) {
                ServiceHookTests.fail((String)e.getMessage());
                if (regHook != null) {
                    regHook.unregister();
                }
            }
        }
        finally {
            if (regHook != null) {
                regHook.unregister();
            }
        }
    }
}

