/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.datalocation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public class BasicLocationTests
extends CoreTest {
    String prefix = "";
    boolean windows = Platform.getOS().equals("win32");
    ServiceTracker<Location, Location> configLocationTracker = null;
    ServiceTracker<Location, Location> instanceLocationTracker = null;
    private static final String INSTANCE_DATA_AREA_PREFIX = ".metadata/.plugins/";

    public BasicLocationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(BasicLocationTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.prefix = this.windows ? "c:" : "";
        this.configLocationTracker = new ServiceTracker(OSGiTestsActivator.getContext(), OSGiTestsActivator.getContext().createFilter(Location.CONFIGURATION_FILTER), null);
        this.instanceLocationTracker = new ServiceTracker(OSGiTestsActivator.getContext(), OSGiTestsActivator.getContext().createFilter(Location.INSTANCE_FILTER), null);
        this.configLocationTracker.open();
        this.instanceLocationTracker.open();
    }

    protected void tearDown() throws Exception {
        this.configLocationTracker.close();
        this.instanceLocationTracker.close();
        super.tearDown();
    }

    private void checkSlashes(Map<String, Location> locations) {
        this.checkLocation(locations.get(Location.USER_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, null);
        this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, null);
    }

    private void checkLocation(Location location, boolean leading, boolean trailing, String scheme) {
        if (location == null) {
            return;
        }
        URL url = location.getURL();
        if (scheme != null) {
            BasicLocationTests.assertEquals((String)scheme, (String)url.getProtocol());
        }
        if (!url.getProtocol().equals("file")) {
            return;
        }
        BasicLocationTests.assertTrue((String)(String.valueOf(url.toExternalForm()) + " should " + (trailing ? "" : "not") + " have a trailing slash"), (url.getFile().endsWith("/") == trailing ? 1 : 0) != 0);
        if (this.windows) {
            BasicLocationTests.assertTrue((String)(String.valueOf(url.toExternalForm()) + " should " + (leading ? "" : "not") + " have a leading slash"), (url.getFile().startsWith("/") == leading ? 1 : 0) != 0);
        }
    }

    public void testCreateLocation01() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation01");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), false);
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
        }
        testLocation.release();
    }

    public void testCreateLocation02() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation02");
        Location testLocation = configLocation.createLocation(null, null, true);
        try {
            testLocation.set(testLocationFile.toURL(), false);
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
            testLocation.release();
            BasicLocationTests.fail((String)"Should not be able to lock read-only location");
        }
        catch (IOException iOException) {}
    }

    public void testCreateLocation03() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation03");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true);
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
        }
        testLocation.release();
    }

    public void testCreateLocation04() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation04");
        Location testLocation = configLocation.createLocation(null, null, true);
        try {
            testLocation.set(testLocationFile.toURL(), true);
            testLocation.release();
            BasicLocationTests.fail((String)"Should not be able to lock read-only location");
        }
        catch (Throwable throwable) {}
    }

    public void testCreateLocation05() {
        Location testLocation;
        block12: {
            Location configLocation = (Location)this.configLocationTracker.getService();
            File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testCreateLocation01");
            testLocation = configLocation.createLocation(null, null, false);
            try {
                testLocation.set(testLocationFile.toURL(), false);
            }
            catch (Throwable t) {
                BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
            }
            try {
                try {
                    BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
                    BasicLocationTests.assertFalse((String)"Could lock a secend time", (boolean)testLocation.lock());
                    BasicLocationTests.assertFalse((String)"Could lock a third time", (boolean)testLocation.lock());
                }
                catch (IOException e) {
                    BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
                    testLocation.release();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                testLocation.release();
                throw throwable;
            }
            testLocation.release();
        }
        try {
            try {
                BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.lock());
            }
            catch (IOException e) {
                BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
                testLocation.release();
            }
        }
        finally {
            testLocation.release();
        }
    }

    public void testLocationDataArea01() {
        Location instance = (Location)this.instanceLocationTracker.getService();
        this.doAllTestLocationDataArea(instance, INSTANCE_DATA_AREA_PREFIX);
        Location configuration = (Location)this.configLocationTracker.getService();
        this.doAllTestLocationDataArea(configuration, "");
    }

    private void doAllTestLocationDataArea(Location location, String dataAreaPrefix) {
        this.doTestLocateDataArea(location, dataAreaPrefix, this.getName());
        this.doTestLocateDataArea(location, dataAreaPrefix, "");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test/multiple/paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test/multiple/../paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test\\multiple\\paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "/test/begin/slash");
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/" + this.getName());
        Location createdLocation = location.createLocation(null, null, false);
        try {
            createdLocation.set(testLocationFile.toURL(), false);
        }
        catch (Exception e) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)e);
        }
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, this.getName());
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "");
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "test/multiple/paths");
        this.doTestLocateDataArea(createdLocation, dataAreaPrefix, "test/multiple/../paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "test\\multiple\\paths");
        this.doTestLocateDataArea(location, dataAreaPrefix, "/test/begin/slash");
        createdLocation = location.createLocation(null, null, false);
        try {
            createdLocation.getDataArea("shouldFail");
            BasicLocationTests.fail((String)"expected failure when location is not set");
        }
        catch (IOException iOException) {}
    }

    private void doTestLocateDataArea(Location location, String dataAreaPrefix, String namespace) {
        BasicLocationTests.assertTrue((String)"Location is not set", (boolean)location.isSet());
        URL dataArea = null;
        try {
            dataArea = location.getDataArea(namespace);
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to get data area.", (Throwable)e);
        }
        BasicLocationTests.assertNotNull((String)"Data area is null.", (Object)dataArea);
        namespace = namespace.replace('\\', '/');
        if (namespace.startsWith("/")) {
            namespace = namespace.substring(1);
        }
        BasicLocationTests.assertTrue((String)("Data area is not the expected value: " + dataArea.toExternalForm()), (boolean)dataArea.toExternalForm().endsWith(String.valueOf(dataAreaPrefix) + namespace));
    }

    public void testSetLocationWithEmptyLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithEmptyLockFile");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, "");
            File lockFile = new File(testLocationFile, ".metadata/.lock");
            BasicLocationTests.assertTrue((String)"Lock file does not exist!", (boolean)lockFile.exists());
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
        }
        testLocation.release();
    }

    public void testSetLocationWithRelLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithRelLockFile");
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, ".mocklock");
            File lockFile = new File(testLocationFile, ".mocklock");
            BasicLocationTests.assertTrue((String)"Lock file does not exist!", (boolean)lockFile.exists());
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
        }
        testLocation.release();
    }

    public void testSetLocationWithAbsLockFile() {
        Location configLocation = (Location)this.configLocationTracker.getService();
        File testLocationFile = OSGiTestsActivator.getContext().getDataFile("testLocations/testSetLocationWithAbsLockFile");
        File testLocationLockFile = OSGiTestsActivator.getContext().getDataFile("testLocations/mock.lock");
        BasicLocationTests.assertTrue((boolean)testLocationLockFile.isAbsolute());
        Location testLocation = configLocation.createLocation(null, null, false);
        try {
            testLocation.set(testLocationFile.toURL(), true, testLocationLockFile.getAbsolutePath());
            BasicLocationTests.assertTrue((String)"The lock file should be present!", (boolean)testLocationLockFile.exists());
        }
        catch (Throwable t) {
            BasicLocationTests.fail((String)"Failed to set location", (Throwable)t);
        }
        try {
            BasicLocationTests.assertTrue((String)"Could not lock location", (boolean)testLocation.isLocked());
        }
        catch (IOException e) {
            BasicLocationTests.fail((String)"Failed to lock location", (Throwable)e);
        }
        testLocation.release();
        BasicLocationTests.assertTrue((String)"The lock file could not be removed!", (boolean)testLocationLockFile.delete());
    }

    public void testSlashes() throws BundleException, InvalidSyntaxException {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", String.valueOf(this.prefix) + "/a");
        fwkConfig.put("osgi.instance.area", String.valueOf(this.prefix) + "/c/d");
        fwkConfig.put("osgi.configuration.area", String.valueOf(this.prefix) + "/e/f");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            this.checkSlashes(BasicLocationTests.getLocations(equinox));
        }
        finally {
            equinox.stop();
        }
    }

    private static Map<String, Location> getLocations(Equinox equinox) throws InvalidSyntaxException {
        HashMap<String, Location> locations = new HashMap<String, Location>();
        BundleContext context = equinox.getBundleContext();
        BasicLocationTests.addLocation(context, Location.CONFIGURATION_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.INSTALL_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.INSTANCE_FILTER, locations);
        BasicLocationTests.addLocation(context, Location.USER_FILTER, locations);
        return locations;
    }

    private static void addLocation(BundleContext context, String filter, Map<String, Location> locations) throws InvalidSyntaxException {
        Collection locationRefs = context.getServiceReferences(Location.class, filter);
        if (!locationRefs.isEmpty()) {
            locations.put(filter, (Location)context.getService((ServiceReference)locationRefs.iterator().next()));
        }
    }

    public void testSchemes() throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "http://example.com/a");
        fwkConfig.put("osgi.instance.area", "ftp://example.com/c/d");
        fwkConfig.put("osgi.configuration.area", "platform:/base/e/f");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkSlashes(locations);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "http");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "ftp");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "platform");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    public void testNone() throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "@none");
        fwkConfig.put("osgi.instance.area", "@none");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            BasicLocationTests.assertNull((String)"User location should be null", (Object)locations.get(Location.USER_FILTER));
            BasicLocationTests.assertNull((String)"Instance location should be null", (Object)locations.get(Location.INSTANCE_FILTER));
        }
        finally {
            equinox.stop();
        }
    }

    public void testNoDefault() throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        fwkConfig.put("osgi.instance.area", "@noDefault");
        fwkConfig.put("osgi.user.area", "@noDefault");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            Location userLocation = locations.get(Location.USER_FILTER);
            Location instanceLocation = locations.get(Location.INSTANCE_FILTER);
            BasicLocationTests.assertNull((String)"User locatoin is not null.", (Object)userLocation.getURL());
            BasicLocationTests.assertNull((String)"Instance location is not null.", (Object)instanceLocation.getURL());
        }
        finally {
            equinox.stop();
        }
    }

    public void testUserDir() throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.user.area", "@user.dir");
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.instance.area", "@user.dir");
        fwkConfig.put("osgi.configuration.area", "@user.dir");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    public void testUserHome() throws Exception {
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "@user.home");
        fwkConfig.put("osgi.instance.area", "@user.home");
        fwkConfig.put("osgi.configuration.area", "@user.home");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    public void testUNC() throws Exception {
        if (!this.windows) {
            return;
        }
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.user.area", "//server/share/a");
        fwkConfig.put("osgi.instance.area", "//server/share/b");
        fwkConfig.put("osgi.configuration.area", "//server/share/c");
        fwkConfig.put("osgi.install.area", "file://server/share/g");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            this.checkLocation(locations.get(Location.USER_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTANCE_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.CONFIGURATION_FILTER), true, true, "file");
            this.checkLocation(locations.get(Location.INSTALL_FILTER), true, true, "file");
        }
        finally {
            equinox.stop();
        }
    }

    public void testDebugLogOnGetURL() throws Exception {
        Properties debugOptions = new Properties();
        debugOptions.put("org.eclipse.osgi/debug/location", "true");
        File debugOptionsFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".options");
        debugOptions.store(new FileOutputStream(debugOptionsFile), this.getName());
        HashMap<String, String> fwkConfig = new HashMap<String, String>();
        fwkConfig.put("osgi.configuration.area.readOnly", "true");
        fwkConfig.put("osgi.install.area", "file:" + this.prefix + "/g");
        fwkConfig.put("osgi.debug", debugOptionsFile.getAbsolutePath());
        fwkConfig.put("eclipse.consoleLog", "true");
        Equinox equinox = new Equinox(fwkConfig);
        equinox.init();
        try {
            final ArrayList logEntries = new ArrayList();
            LogReaderService logReaderService = this.getLogReaderService(equinox);
            SynchronousLogListener logListener = new SynchronousLogListener(){

                public void logged(LogEntry entry) {
                    logEntries.add(entry);
                }
            };
            logReaderService.addLogListener((LogListener)logListener);
            Map<String, Location> locations = BasicLocationTests.getLocations(equinox);
            Location userLocation = locations.get(Location.USER_FILTER);
            Location instanceLocation = locations.get(Location.INSTANCE_FILTER);
            BasicLocationTests.assertNotNull((String)"User locatoin is not null.", (Object)userLocation.getURL());
            BasicLocationTests.assertNotNull((String)"Instance location is not null.", (Object)instanceLocation.getURL());
            BasicLocationTests.assertEquals((String)"Wrong number of log entries", (int)2, (int)logEntries.size());
        }
        finally {
            equinox.stop();
        }
    }

    private LogReaderService getLogReaderService(Equinox equinox) {
        return (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
    }
}

