/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class StateComparisonTest
extends AbstractStateTest {
    public StateComparisonTest(String testName) {
        super(testName);
    }

    public void testAddition() throws BundleException {
        State state1 = this.buildEmptyState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"1.0", (int)0, (int)delta.getChanges().length);
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"1.1", (int)0, (int)delta.getChanges().length);
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.a\nBundle-Version: 1.0\n";
        BundleDescription bundleA = state2.getFactory().createBundleDescription(StateComparisonTest.parseManifest(A_MANIFEST), "org.eclipse.a", -1L);
        StateComparisonTest.assertTrue((String)"2.0", (boolean)state2.addBundle(bundleA));
        delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"2.1", (int)1, (int)delta.getChanges().length);
        BundleDelta removal = delta.getChanges()[0];
        this.assertEquals("2.2", bundleA, removal.getBundle());
        StateComparisonTest.assertEquals((String)"2.3", (int)2, (int)removal.getType());
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"3.1", (int)1, (int)delta.getChanges().length);
        BundleDelta addition = delta.getChanges()[0];
        this.assertEquals("3.2", bundleA, addition.getBundle());
        StateComparisonTest.assertEquals((String)"3.3", (int)1, (int)addition.getType());
    }

    public void testRemoval() throws BundleException {
        State state1 = this.buildSimpleState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"1.0", (int)0, (int)delta.getChanges().length);
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"1.1", (int)0, (int)delta.getChanges().length);
        BundleDescription bundle1 = state1.getBundleByLocation("org.eclipse.b1");
        StateComparisonTest.assertNotNull((String)"1.9", (Object)bundle1);
        StateComparisonTest.assertTrue((String)"2.0", (boolean)state1.removeBundle(bundle1));
        delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"2.1", (int)1, (int)delta.getChanges().length);
        BundleDelta removal = delta.getChanges()[0];
        this.assertEquals("2.2", bundle1, removal.getBundle());
        StateComparisonTest.assertEquals((String)"2.3", (int)2, (int)removal.getType());
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"3.1", (int)1, (int)delta.getChanges().length);
        BundleDelta addition = delta.getChanges()[0];
        this.assertEquals("3.2", bundle1, addition.getBundle());
        StateComparisonTest.assertEquals((String)"3.3", (int)1, (int)addition.getType());
    }

    public void testUpdate() throws BundleException {
        State state1 = this.buildSimpleState();
        State state2 = state1.getFactory().createState(state1);
        StateDelta delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"1.0", (int)0, (int)delta.getChanges().length);
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"1.1", (int)0, (int)delta.getChanges().length);
        StateComparisonTest.assertNotNull((String)"1.9", (Object)state1.getBundleByLocation("org.eclipse.b1"));
        String A_MANIFEST = "Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 2.0\n";
        BundleDescription bundle1 = state1.getFactory().createBundleDescription(StateComparisonTest.parseManifest(A_MANIFEST), "org.eclipse.b1", 1L);
        StateComparisonTest.assertTrue((String)"2.0", (boolean)state1.updateBundle(bundle1));
        delta = state1.compare(state2);
        StateComparisonTest.assertEquals((String)"2.1", (int)1, (int)delta.getChanges().length);
        BundleDelta update = delta.getChanges()[0];
        this.assertEquals("2.2", bundle1, update.getBundle());
        StateComparisonTest.assertEquals((String)"2.3", (int)4, (int)update.getType());
        delta = state2.compare(state1);
        StateComparisonTest.assertEquals((String)"3.1", (int)0, (int)delta.getChanges().length);
    }

    public static Test suite() {
        return new TestSuite(StateComparisonTest.class);
    }
}

