/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.CollisionHook;

public class BundleInstallUpdateTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(BundleInstallUpdateTests.class);
    }

    public void testInstallWithLocation01() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location = installer.getBundleLocation("test");
                    test = OSGiTestsActivator.getContext().installBundle(location);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testInstallWithLocation02() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location = installer.getBundleLocation("test");
                    test = OSGiTestsActivator.getContext().installBundle(location, null);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testInstallWithStream03() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location1 = installer.getBundleLocation("test");
                    String location2 = installer.getBundleLocation("test2");
                    test = OSGiTestsActivator.getContext().installBundle(location1, new URL(location2).openStream());
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test2", (String)test.getSymbolicName());
                }
                catch (Exception e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testUpdateNoStream01() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location = installer.getBundleLocation("test");
                    test = OSGiTestsActivator.getContext().installBundle(location);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                    test.update();
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testUpdateNoStream02() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location = installer.getBundleLocation("test");
                    test = OSGiTestsActivator.getContext().installBundle(location);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                    test.update(null);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testUpdateWithStream01() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location1 = installer.getBundleLocation("test");
                    String location2 = installer.getBundleLocation("test2");
                    test = OSGiTestsActivator.getContext().installBundle(location1);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                    test.update(new URL(location2).openStream());
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test2", (String)test.getSymbolicName());
                }
                catch (Exception e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testUpdateWithStream02() {
        block14: {
            Bundle test = null;
            try {
                try {
                    String location1 = installer.getBundleLocation("test");
                    String location2 = installer.getBundleLocation("test2");
                    test = OSGiTestsActivator.getContext().installBundle(location1);
                    Bundle b1 = installer.installBundle("chain.test");
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test1", (String)test.getSymbolicName());
                    test.update(new URL(location2).openStream());
                    BundleInstallUpdateTests.assertEquals((String)"Wrong BSN", (String)"test2", (String)test.getSymbolicName());
                    Bundle[] bundles = OSGiTestsActivator.getContext().getBundles();
                    BundleInstallUpdateTests.assertTrue((String)("Wrong bundle at the end: " + bundles[bundles.length - 1]), (bundles[bundles.length - 1] == b1 ? 1 : 0) != 0);
                    Bundle[] tests = installer.getPackageAdmin().getBundles(test.getSymbolicName(), null);
                    BundleInstallUpdateTests.assertNotNull((String)"null tests", (Object)tests);
                    BundleInstallUpdateTests.assertEquals((String)"Wrong number", (int)1, (int)tests.length);
                    BundleInstallUpdateTests.assertTrue((String)("Wrong bundle: " + tests[0]), (tests[0] == test ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testBug290193() {
        block14: {
            Bundle test = null;
            try {
                try {
                    URL testBundle = OSGiTestsActivator.getContext().getBundle().getEntry("test_files/security/bundles/signed.jar");
                    File testFile = OSGiTestsActivator.getContext().getDataFile("test with space/test.jar");
                    BundleInstallUpdateTests.assertTrue((boolean)testFile.getParentFile().mkdirs());
                    BundleInstallUpdateTests.readFile(testBundle.openStream(), testFile);
                    test = OSGiTestsActivator.getContext().installBundle("reference:" + testFile.toURI().toString());
                }
                catch (Exception e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testCollisionHook() throws BundleException, MalformedURLException, IOException {
        Bundle junk;
        Bundle test1;
        block22: {
            test1 = installer.installBundle("test");
            installer.installBundle("test2");
            try {
                test1.update(new URL(installer.getBundleLocation("test2")).openStream());
                BundleInstallUpdateTests.fail((String)"Expected to fail to update to another bsn/version that causes collision");
            }
            catch (BundleException bundleException) {}
            junk = null;
            try {
                try {
                    junk = OSGiTestsActivator.getContext().installBundle("junk", new URL(installer.getBundleLocation("test2")).openStream());
                    BundleInstallUpdateTests.fail((String)"Expected to fail to install duplication bsn/version that causes collision");
                }
                catch (BundleException bundleException) {
                    if (junk != null) {
                        junk.uninstall();
                    }
                    junk = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (junk != null) {
                    junk.uninstall();
                }
                junk = null;
                throw throwable;
            }
            if (junk != null) {
                junk.uninstall();
            }
            junk = null;
        }
        CollisionHook hook = new CollisionHook(){

            public void filterCollisions(int operationType, Bundle target, Collection collisionCandidates) {
                collisionCandidates.clear();
            }
        };
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(CollisionHook.class, (Object)hook, null);
        try {
            try {
                test1.update(new URL(installer.getBundleLocation("test2")).openStream());
            }
            catch (BundleException e) {
                BundleInstallUpdateTests.fail((String)"Expected to succeed in updating to a duplicate bsn/version", (Throwable)e);
            }
            try {
                try {
                    junk = OSGiTestsActivator.getContext().installBundle("junk", new URL(installer.getBundleLocation("test2")).openStream());
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Expected to succeed to install duplication bsn/version that causes collision", (Throwable)e);
                    if (junk != null) {
                        junk.uninstall();
                    }
                    junk = null;
                }
            }
            finally {
                if (junk != null) {
                    junk.uninstall();
                }
                junk = null;
            }
        }
        finally {
            reg.unregister();
        }
    }

    public void testInstallWithInterruption() {
        block14: {
            Bundle test = null;
            Thread.currentThread().interrupt();
            try {
                try {
                    test = installer.installBundle("test");
                }
                catch (BundleException e) {
                    BundleInstallUpdateTests.fail((String)"Unexpected failure", (Throwable)e);
                    Thread.interrupted();
                    try {
                        if (test != null) {
                            test.uninstall();
                        }
                        break block14;
                    }
                    catch (BundleException bundleException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Thread.interrupted();
                try {
                    if (test != null) {
                        test.uninstall();
                    }
                }
                catch (BundleException bundleException) {}
                throw throwable;
            }
            Thread.interrupted();
            try {
                if (test != null) {
                    test.uninstall();
                }
            }
            catch (BundleException bundleException) {}
        }
    }

    public void testPercentLocation() throws BundleException, IOException {
        this.doTestSpecialChars('%', false);
        this.doTestSpecialChars('%', true);
    }

    public void testSpaceLocation() throws BundleException, IOException {
        this.doTestSpecialChars(' ', false);
        this.doTestSpecialChars(' ', true);
    }

    private void doTestSpecialChars(char c, boolean encode) throws BundleException, IOException {
        File bundlesDirectory = OSGiTestsActivator.getContext().getDataFile("file_with_" + c + "_char");
        bundlesDirectory.mkdirs();
        File testBundleJarFile = SystemBundleTests.createBundle(bundlesDirectory, String.valueOf(this.getName()) + 1, false, false);
        String testBundleJarFileURL = encode ? testBundleJarFile.toURI().toString() : testBundleJarFile.toURL().toString();
        File testBundleDirFile = SystemBundleTests.createBundle(bundlesDirectory, String.valueOf(this.getName()) + 2, false, true);
        String testBundleDirFileURL = encode ? testBundleDirFile.toURI().toString() : testBundleDirFile.toURL().toString();
        Bundle testBundleJarRef = this.getContext().installBundle("reference:" + testBundleJarFileURL);
        testBundleJarRef.start();
        testBundleJarRef.uninstall();
        Bundle testBundleDirRef = this.getContext().installBundle("reference:" + testBundleDirFileURL);
        testBundleDirRef.start();
        testBundleDirRef.uninstall();
        Bundle testBundleJar = this.getContext().installBundle(testBundleJarFileURL);
        testBundleJar.start();
        testBundleJar.uninstall();
        Bundle testBundleDir = this.getContext().installBundle(testBundleDirFileURL);
        testBundleDir.start();
        testBundleDir.uninstall();
    }

    public void testPercentCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry('%');
    }

    public void testSpaceCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry(' ');
    }

    public void testPlusCharBundleEntry() throws IOException, BundleException {
        this.doTestSpaceCharsBundleEntry('+');
    }

    public void doTestSpaceCharsBundleEntry(char c) throws IOException, BundleException {
        String entryName = "file_with_" + c + "_char";
        File bundlesDirectory = OSGiTestsActivator.getContext().getDataFile(this.getName());
        bundlesDirectory.mkdirs();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        Map<String, String> entry = Collections.singletonMap(entryName, "value");
        File testBundleJarFile = SystemBundleTests.createBundle(bundlesDirectory, this.getName(), headers, entry);
        Bundle testBundle = this.getContext().installBundle(this.getName(), (InputStream)new FileInputStream(testBundleJarFile));
        URL entryURL = testBundle.getEntry(entryName);
        BundleInstallUpdateTests.assertNotNull((String)"Entry not found.", (Object)entryURL);
        InputStream is = entryURL.openStream();
        is.close();
        String encodeEntry = URLEncoder.encode(entryName, "UTF-8");
        String urlString = entryURL.toExternalForm();
        urlString = String.valueOf(urlString.substring(0, urlString.indexOf(entryName))) + encodeEntry;
        URL encodedURL = new URL(urlString);
        is = encodedURL.openStream();
        is.close();
    }
}

