/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.FrameworkWiring;

public class CascadeConfigTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(CascadeConfigTests.class);
    }

    public void testCascadeConfigBundleInstall() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_parent");
        HashMap<String, String> parentMap = new HashMap<String, String>();
        parentMap.put("org.osgi.framework.storage", configParent.getAbsolutePath());
        Equinox equinox = new Equinox(parentMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        systemContext.installBundle(installer.getBundleLocation("test"));
        equinox.stop();
        equinox.waitForStop(10000L);
        File configChild = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_child");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        Bundle test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)test1);
        systemContext.installBundle(installer.getBundleLocation("test2"));
        equinox.stop();
        equinox.waitForStop(10000L);
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)test1);
        Bundle test2 = systemContext.getBundle(installer.getBundleLocation("test2"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)test2);
        equinox.stop();
        equinox.waitForStop(10000L);
        equinox = new Equinox(parentMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(installer.getBundleLocation("test"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)test1);
        test2 = systemContext.getBundle(installer.getBundleLocation("test2"));
        CascadeConfigTests.assertNull((String)"Unexpected bundle.", (Object)test2);
        equinox.stop();
        equinox.waitForStop(10000L);
    }

    public void testCascadeConfigDataArea() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_parent");
        HashMap<String, String> parentMap = new HashMap<String, String>();
        parentMap.put("org.osgi.framework.storage", configParent.getAbsolutePath());
        Equinox equinox = new Equinox(parentMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singletonList(b));
        equinox.stop();
        equinox.waitForStop(10000L);
        File configChild = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_child");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        equinox = new Equinox(childMap);
        equinox.init();
        systemContext = equinox.getBundleContext();
        b = systemContext.getBundle(installer.getBundleLocation("substitutes.a"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)b);
        equinox.start();
        b.start();
        BundleContext test1Context = b.getBundleContext();
        File dataFile = test1Context.getDataFile("test1");
        CascadeConfigTests.assertTrue((boolean)dataFile.getAbsolutePath().startsWith(configChild.getAbsolutePath()));
        equinox.stop();
        equinox.waitForStop(10000L);
        equinox = new Equinox(parentMap);
        equinox.start();
        systemContext = equinox.getBundleContext();
        b = systemContext.getBundle(installer.getBundleLocation("substitutes.a"));
        CascadeConfigTests.assertNotNull((String)"Missing bundle.", (Object)b);
        CascadeConfigTests.assertEquals((String)"Bundle is not resolved.", (int)4, (int)b.getState());
        b.start();
        test1Context = b.getBundleContext();
        dataFile = test1Context.getDataFile("test1");
        CascadeConfigTests.assertTrue((boolean)dataFile.getAbsolutePath().startsWith(configParent.getAbsolutePath()));
        equinox.stop();
        equinox.waitForStop(10000L);
    }

    public void testCascadeConfigIni() throws Exception {
        File configParent = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_parent");
        configParent.mkdirs();
        File parentConfigIni = new File(configParent, "config.ini");
        Properties parentProps = new Properties();
        parentProps.put("parent.key", "parent");
        parentProps.put("parent.child.key", "parent");
        parentProps.store(new FileOutputStream(parentConfigIni), "Parent config.ini");
        File configChild = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_child");
        configChild.mkdirs();
        File childConfigIni = new File(configChild, "config.ini");
        Properties childProps = new Properties();
        childProps.put("parent.child.key", "child");
        childProps.put("child.key", "child");
        childProps.store(new FileOutputStream(childConfigIni), "Parent config.ini");
        HashMap<String, String> childMap = new HashMap<String, String>();
        childMap.put("org.osgi.framework.storage", configChild.getAbsolutePath());
        childMap.put("osgi.sharedConfiguration.area", configParent.getCanonicalPath());
        Equinox equinox = new Equinox(childMap);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        CascadeConfigTests.assertEquals((String)"Wrong value for parent.key", (String)"parent", (String)systemContext.getProperty("parent.key"));
        CascadeConfigTests.assertEquals((String)"Wrong value for parent.child.key", (String)"child", (String)systemContext.getProperty("parent.child.key"));
        CascadeConfigTests.assertEquals((String)"Wrong value for child.key", (String)"child", (String)systemContext.getProperty("child.key"));
        equinox.stop();
        equinox.waitForStop(10000L);
    }
}

