/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.BundleException;

public class PersistedBundleTests
extends AbstractBundleTests {
    private static final String ECLIPSE_STATESAVEDELAYINTERVAL = "eclipse.stateSaveDelayInterval";
    private static final String IMMEDIATE_PERSISTENCE = "0";
    private static final String NO_PERSISTENCE = "-1";
    private static final String PERIODIC_PERSISTENCE = "4000";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(PersistedBundleTests.class);
    }

    public void testImmediatePersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, IMMEDIATE_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            PersistedBundleTests.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new BundleBuilder().symbolicName(this.getName()).build());
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                PersistedBundleTests.assertNotNull((String)"Bundle does not exist", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                this.stopQuietly(equinox2);
            }
        }
        finally {
            this.stopQuietly(equinox1);
        }
    }

    public void testNoPersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, NO_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            PersistedBundleTests.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new BundleBuilder().symbolicName(this.getName()).build());
            Thread.sleep(Long.valueOf(PERIODIC_PERSISTENCE));
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                PersistedBundleTests.assertNull((String)"Bundle exists", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                this.stopQuietly(equinox2);
            }
        }
        finally {
            this.stopQuietly(equinox1);
        }
        equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            PersistedBundleTests.assertNotNull((String)"Bundle does not exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
        }
        finally {
            this.stopQuietly(equinox1);
        }
    }

    public void testPeriodicPersistence() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(ECLIPSE_STATESAVEDELAYINTERVAL, PERIODIC_PERSISTENCE);
        Equinox equinox1 = new Equinox(configuration);
        this.initAndStart(equinox1);
        try {
            PersistedBundleTests.assertNull((String)"Bundle exists", (Object)equinox1.getBundleContext().getBundle(this.getName()));
            equinox1.getBundleContext().installBundle(this.getName(), new BundleBuilder().symbolicName(this.getName()).build());
            Equinox equinox2 = new Equinox(configuration);
            this.initAndStart(equinox2);
            try {
                PersistedBundleTests.assertNull((String)"Bundle exists", (Object)equinox2.getBundleContext().getBundle(this.getName()));
                this.stopQuietly(equinox2);
                Thread.sleep(Long.valueOf(PERIODIC_PERSISTENCE) + 2000L);
                equinox2 = new Equinox(configuration);
                this.initAndStart(equinox2);
                PersistedBundleTests.assertNotNull((String)"Bundle does not exist", (Object)equinox2.getBundleContext().getBundle(this.getName()));
            }
            finally {
                this.stopQuietly(equinox2);
            }
        }
        finally {
            this.stopQuietly(equinox1);
        }
    }

    private Map<String, Object> createConfiguration() {
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("org.osgi.framework.storage", file.getAbsolutePath());
        return result;
    }

    private void initAndStart(Equinox equinox) throws BundleException {
        equinox.init();
        equinox.start();
    }

    private void stopQuietly(Equinox equinox) {
        if (equinox == null) {
            return;
        }
        try {
            equinox.stop();
            equinox.waitForStop(5000L);
        }
        catch (Exception exception) {}
    }

    static class BundleBuilder {
        private final BundleManifestBuilder manifestBuilder = new BundleManifestBuilder();

        BundleBuilder() {
        }

        public InputStream build() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream((OutputStream)baos, this.manifestBuilder.build());
            jos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }

        public BundleBuilder symbolicName(String value) {
            this.manifestBuilder.symbolicName(value);
            return this;
        }

        static class BundleManifestBuilder {
            private final Manifest manifest = new Manifest();

            BundleManifestBuilder() {
            }

            public Manifest build() {
                this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                return this.manifest;
            }

            public BundleManifestBuilder symbolicName(String value) {
                this.manifest.getMainAttributes().putValue("Bundle-SymbolicName", value);
                return this;
            }
        }
    }
}

