/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.net.SocketFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.storage.url.reference.Handler;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class SystemBundleTests
extends AbstractBundleTests {
    static final String nullTest = "null.test";

    public static Test suite() {
        return new TestSuite(SystemBundleTests.class);
    }

    public void testSystemBundle01() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        ServiceReference[] refs = null;
        try {
            refs = systemContext.getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        }
        catch (InvalidSyntaxException e) {
            SystemBundleTests.fail((String)"Unexpected syntax error", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        SystemBundleTests.assertEquals((String)"config refs length is wrong", (int)1, (int)refs.length);
        Location configLocation = (Location)systemContext.getService(refs[0]);
        URL configURL = configLocation.getURL();
        SystemBundleTests.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle01/"));
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle02() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle02");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle03() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle03");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        String configArea = systemContext.getProperty("osgi.configuration.area");
        SystemBundleTests.assertNotNull((String)"config property is null", (Object)configArea);
        SystemBundleTests.assertTrue((String)"Wrong configuration area", (boolean)configArea.endsWith("testSystemBundle03/"));
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle04() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle04");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = null;
        try {
            substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
        }
        try {
            substitutesA.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected bundle exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        SystemBundleTests.assertEquals((String)"Wrong state for installed bundle", (int)32, (int)substitutesA.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle05_1() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle05_1");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = null;
        try {
            substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        SystemBundleTests.assertEquals((String)"Wrong state for installed bundle", (int)2, (int)substitutesA.getState());
        try {
            substitutesA.start();
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"Failed to start a bundle", (Throwable)e1);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for active bundle", (int)32, (int)substitutesA.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle05_2() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle05_2");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = null;
        try {
            substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        SystemBundleTests.assertEquals((String)"Wrong state for installed bundle", (int)2, (int)substitutesA.getState());
        try {
            substitutesA.start();
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"Failed to start a bundle", (Throwable)e1);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for active bundle", (int)32, (int)substitutesA.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        Bundle substitutesA2 = null;
        try {
            substitutesA2 = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception installing", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Bundle ids are not the same", (long)substitutesA.getBundleId(), (long)substitutesA2.getBundleId());
        SystemBundleTests.assertEquals((String)"Wrong state for active bundle", (int)32, (int)substitutesA2.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle06() {
        File config1 = OSGiTestsActivator.getContext().getDataFile("testSystemBundle06_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        try {
            equinox1.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile("testSystemBundle06_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        try {
            equinox2.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext2);
        SystemBundleTests.assertNotSame((Object)systemContext1, (Object)systemContext2);
        try {
            equinox1.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox1.getState());
        try {
            equinox2.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox2.getState());
        try {
            equinox1.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox1.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox1.getState());
        try {
            equinox2.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox2.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox2.getState());
    }

    public void testSystemBundle07() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle07_01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        try {
            equinox.init();
        }
        catch (Exception e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        try {
            equinox.init();
        }
        catch (Exception e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        ServiceReference[] refs = null;
        try {
            refs = systemContext.getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        }
        catch (InvalidSyntaxException e) {
            SystemBundleTests.fail((String)"Unexpected syntax error", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        SystemBundleTests.assertEquals((String)"config refs length is wrong", (int)1, (int)refs.length);
        Location configLocation = (Location)systemContext.getService(refs[0]);
        URL configURL = configLocation.getURL();
        SystemBundleTests.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle07_01/"));
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle08() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle08_1");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle08_2");
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        ServiceReference[] refs = null;
        try {
            refs = equinox.getBundleContext().getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
        }
        catch (InvalidSyntaxException e) {
            SystemBundleTests.fail((String)"Unexpected syntax error", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Configuration Location refs is null", (Object)refs);
        SystemBundleTests.assertEquals((String)"config refs length is wrong", (int)1, (int)refs.length);
        Location configLocation = (Location)equinox.getBundleContext().getService(refs[0]);
        URL configURL = configLocation.getURL();
        SystemBundleTests.assertTrue((String)"incorrect configuration location", (boolean)configURL.toExternalForm().endsWith("testSystemBundle08_2/"));
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle09() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle09");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        Bundle testFilterA = null;
        try {
            testFilterA = equinox.getBundleContext().installBundle(installer.getBundleLocation("test.filter.a"));
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception installing", (Throwable)e);
        }
        try {
            testFilterA.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception starting test bundle", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle10() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle10");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        final Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleException[] failureException = new BundleException[1];
        final FrameworkEvent[] success = new FrameworkEvent[1];
        Thread t = new Thread(new Runnable((Exception[])failureException){
            private final /* synthetic */ Exception[] val$failureException;
            {
                this.val$failureException = exceptionArray;
            }

            @Override
            public void run() {
                try {
                    success[0] = equinox.waitForStop(10000L);
                }
                catch (InterruptedException e) {
                    this.val$failureException[0] = e;
                }
            }
        }, "test waitForStop thread");
        t.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"unexpected interuption", (Throwable)e);
        }
        try {
            equinox.update();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to update the framework", (Throwable)e);
        }
        try {
            t.join();
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"unexpected interuption", (Throwable)e);
        }
        if (failureException[0] != null) {
            SystemBundleTests.fail((String)"Error occurred while waiting", (Throwable)failureException[0]);
        }
        SystemBundleTests.assertNotNull((String)"Wait for stop event is null", (Object)success[0]);
        SystemBundleTests.assertEquals((String)"Wait for stop event type is wrong", (int)128, (int)success[0].getType());
        int i = 0;
        while (i < 5 && 32 != equinox.getState()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle11() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle11");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.packages.extra", "test.pkg1, test.pkg2");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"SystemBundle context is null", (Object)systemContext);
        PackageAdmin pa = (PackageAdmin)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(PackageAdmin.class.getName()));
        ExportedPackage[] pkg1 = pa.getExportedPackages("test.pkg1");
        SystemBundleTests.assertNotNull((Object)pkg1);
        SystemBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)pkg1.length);
        SystemBundleTests.assertEquals((String)"Wrong package name", (String)"test.pkg1", (String)pkg1[0].getName());
        ExportedPackage[] pkg2 = pa.getExportedPackages("test.pkg2");
        SystemBundleTests.assertNotNull((Object)pkg2);
        SystemBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)pkg2.length);
        SystemBundleTests.assertEquals((String)"Wrong package name", (String)"test.pkg2", (String)pkg2[0].getName());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle12() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle12");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        FrameworkEvent stopEvent = null;
        try {
            stopEvent = equinox.waitForStop(1000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        SystemBundleTests.assertEquals((String)"Wrong stopEvent", (int)512, (int)stopEvent.getType());
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            stopEvent = equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        SystemBundleTests.assertEquals((String)"Wrong stopEvent", (int)64, (int)stopEvent.getType());
    }

    public void testSystemBundle13() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle13");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle substitutesA = null;
        try {
            substitutesA = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        SystemBundleTests.assertEquals((String)"Wrong state for installed bundle", (int)2, (int)substitutesA.getState());
        try {
            substitutesA.start();
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"Failed to start a bundle", (Throwable)e1);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for active bundle", (int)32, (int)substitutesA.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        substitutesA = equinox.getBundleContext().getBundle(1L);
        SystemBundleTests.assertNotNull((String)"missing installed bundle", (Object)substitutesA);
        SystemBundleTests.assertEquals((String)"Unexpected symbolic name", (String)"substitutes.a", (String)substitutesA.getSymbolicName());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        configuration = new HashMap();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.storage.clean", "onFirstInit");
        equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        substitutesA = equinox.getBundleContext().getBundle(1L);
        SystemBundleTests.assertNull((String)"Unexpected bundle is installed", (Object)substitutesA);
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testSystemBundle14() {
        File config = OSGiTestsActivator.getContext().getDataFile("testSystemBundle14");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.startlevel.beginning", "10");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        StartLevel st = (StartLevel)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(StartLevel.class.getName()));
        SystemBundleTests.assertNotNull((String)"StartLevel service is null", (Object)st);
        SystemBundleTests.assertEquals((String)"Unexpected start level", (int)10, (int)st.getStartLevel());
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        FrameworkEvent stopEvent = null;
        try {
            stopEvent = equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        SystemBundleTests.assertEquals((String)"Wrong stopEvent", (int)64, (int)stopEvent.getType());
    }

    public void testSystemBundle16() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "boot");
        this.checkParentClassLoader(configuration);
    }

    public void testSystemBundle17() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "app");
        this.checkParentClassLoader(configuration);
    }

    public void testSystemBundle18() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "ext");
        this.checkParentClassLoader(configuration);
    }

    public void testSystemBundle19() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.bundle.parent", "framework");
        this.checkParentClassLoader(configuration);
    }

    private void checkParentClassLoader(Map<String, Object> configuration) {
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        Bundle test = null;
        try {
            test = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to install bundle", (Throwable)e);
        }
        try {
            Class activatorClazz = test.loadClass("substitutes.x.Ax");
            ClassLoader parentCL = activatorClazz.getClassLoader().getParent();
            String configParent = (String)configuration.get("org.osgi.framework.bundle.parent");
            if ("app".equals(configParent)) {
                SystemBundleTests.assertTrue((String)"Wrong parent", (parentCL == ClassLoader.getSystemClassLoader() ? 1 : 0) != 0);
            } else if ("ext".equals(configParent)) {
                SystemBundleTests.assertTrue((String)"Wrong parent", (parentCL == ClassLoader.getSystemClassLoader().getParent() ? 1 : 0) != 0);
            } else if ("framework".equals(configParent)) {
                SystemBundleTests.assertTrue((String)"Wrong parent", (parentCL == equinox.getClass().getClassLoader() ? 1 : 0) != 0);
            }
        }
        catch (ClassNotFoundException e) {
            SystemBundleTests.fail((String)"failed to load class", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        FrameworkEvent stopEvent = null;
        try {
            stopEvent = equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"Stop event is null", (Object)stopEvent);
        SystemBundleTests.assertEquals((String)"Wrong stopEvent", (int)64, (int)stopEvent.getType());
    }

    public void testChangeEE() throws IOException, BundleException {
        URL javaSE7Profile = OSGiTestsActivator.getContext().getBundle("System Bundle").getEntry("JavaSE-1.7.profile");
        URL javaSE8Profile = OSGiTestsActivator.getContext().getBundle("System Bundle").getEntry("JavaSE-1.8.profile");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.java.profile", javaSE8Profile.toExternalForm());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        HashMap<String, String> testHeaders = new HashMap<String, String>();
        testHeaders.put("Bundle-ManifestVersion", "2");
        testHeaders.put("Bundle-SymbolicName", this.getName());
        testHeaders.put("Bundle-RequiredExecutionEnvironment", "JavaSE-1.8");
        File testBundle = SystemBundleTests.createBundle(config, this.getName(), testHeaders, new Map[0]);
        Bundle b = systemContext.installBundle("reference:file:///" + testBundle.getAbsolutePath());
        long bid = b.getBundleId();
        Assert.assertTrue((String)"Could not resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        equinox.stop();
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        configuration.put("osgi.java.profile", javaSE7Profile.toExternalForm());
        equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        b = equinox.getBundleContext().getBundle(bid);
        Assert.assertFalse((String)"Could resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        equinox.stop();
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        configuration.put("osgi.java.profile", javaSE8Profile.toExternalForm());
        equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        b = equinox.getBundleContext().getBundle(bid);
        Assert.assertTrue((String)"Could not resolve bundle.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(b)));
        equinox.stop();
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
    }

    public void testMRUBundleFileList() {
        this.doMRUBundleFileList(10);
    }

    private void doMRUBundleFileList(int limit) {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.bundlefile.limit", Integer.toString(limit));
        final Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        File[] testBundles = null;
        try {
            testBundles = SystemBundleTests.createBundles(new File(config, "bundles"), 3000);
        }
        catch (IOException e) {
            SystemBundleTests.fail((String)"Unexpected error creating budnles", (Throwable)e);
        }
        int i = 0;
        while (i < testBundles.length) {
            try {
                systemContext.installBundle("reference:file:///" + testBundles[i].getAbsolutePath());
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected install error", (Throwable)e);
            }
            ++i;
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        this.openAllBundleFiles(equinox.getBundleContext());
        BundleException[] failureException = new BundleException[1];
        final FrameworkEvent[] success = new FrameworkEvent[1];
        Thread waitForUpdate = new Thread(new Runnable((Exception[])failureException){
            private final /* synthetic */ Exception[] val$failureException;
            {
                this.val$failureException = exceptionArray;
            }

            @Override
            public void run() {
                try {
                    success[0] = equinox.waitForStop(10000L);
                }
                catch (InterruptedException e) {
                    this.val$failureException[0] = e;
                }
            }
        }, "test waitForStop thread");
        waitForUpdate.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"unexpected interuption", (Throwable)e);
        }
        try {
            equinox.update();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to update the framework", (Throwable)e);
        }
        try {
            waitForUpdate.join();
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"unexpected interuption", (Throwable)e);
        }
        if (failureException[0] != null) {
            SystemBundleTests.fail((String)"Error occurred while waiting", (Throwable)failureException[0]);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        this.openAllBundleFiles(equinox.getBundleContext());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    private void openAllBundleFiles(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        try {
            int i = 0;
            while (i < bundles.length) {
                SystemBundleTests.assertNotNull((String)("No manifest for: " + bundles[i]), (Object)bundles[i].getEntry("/META-INF/MANIFEST.MF"));
                ++i;
            }
        }
        catch (Throwable t) {
            SystemBundleTests.fail((String)"Failed to get bundle entries", (Throwable)t);
        }
    }

    public void testURLExternalFormat01() {
        File config1 = OSGiTestsActivator.getContext().getDataFile("testURLExternalFormat01_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        try {
            equinox1.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile("testURLExternalFormat01_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        try {
            equinox2.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext2);
        SystemBundleTests.assertNotSame((Object)systemContext1, (Object)systemContext2);
        Bundle test1 = null;
        Bundle test2 = null;
        try {
            test1 = systemContext1.installBundle(installer.getBundleLocation("test"));
            test2 = systemContext2.installBundle(installer.getBundleLocation("test"));
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error installing bundle", (Throwable)e);
        }
        URL entry1 = test1.getEntry("data/resource1");
        SystemBundleTests.assertNotNull((String)"entry1", (Object)entry1);
        URL entry2 = test2.getEntry("data/resource1");
        SystemBundleTests.assertNotNull((String)"entry2", (Object)entry2);
        SystemBundleTests.assertFalse((String)("External form is equal: " + entry1.toExternalForm()), (boolean)entry1.toExternalForm().equals(entry2.toExternalForm()));
        SystemBundleTests.assertFalse((String)("Host is equal: " + entry1.getHost()), (boolean)entry1.getHost().equals(entry2.getHost()));
        SystemBundleTests.assertFalse((String)("URL is equal: " + entry1.toExternalForm()), (boolean)entry1.equals(entry2));
        Bundle substitutes1 = null;
        Bundle substitutes2 = null;
        try {
            substitutes1 = systemContext1.installBundle(installer.getBundleLocation("substitutes.a"));
            substitutes2 = systemContext2.installBundle(installer.getBundleLocation("substitutes.a"));
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error installing bundle", (Throwable)e);
        }
        entry1 = substitutes1.getResource("data/resource1");
        SystemBundleTests.assertNotNull((String)"entry1", (Object)entry1);
        entry2 = substitutes2.getResource("data/resource1");
        SystemBundleTests.assertNotNull((String)"entry2", (Object)entry2);
        SystemBundleTests.assertFalse((String)("External form is equal: " + entry1.toExternalForm()), (boolean)entry1.toExternalForm().equals(entry2.toExternalForm()));
        SystemBundleTests.assertFalse((String)("Host is equal: " + entry1.getHost()), (boolean)entry1.getHost().equals(entry2.getHost()));
        SystemBundleTests.assertFalse((String)("URL is equal: " + entry1.toExternalForm()), (boolean)entry1.equals(entry2));
        try {
            equinox1.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox1.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox1.getState());
        try {
            equinox2.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox2.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox2.getState());
    }

    public void testURLMultiplexing01() throws BundleException {
        File config1 = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        try {
            equinox1.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox1.getState());
        File config2 = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration2);
        try {
            equinox2.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox2.getState());
        BundleContext systemContext1 = equinox1.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext1);
        BundleContext systemContext2 = equinox2.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext2);
        SystemBundleTests.assertNotSame((Object)systemContext1, (Object)systemContext2);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", this.getName().toLowerCase());
        ServiceRegistration handlerReg = OSGiTestsActivator.getContext().registerService(URLStreamHandlerService.class, (Object)new TestHandler(), props);
        try {
            URL baseTestUrl = new URL(this.getName().toLowerCase(), "", "/test/url");
            System.getProperties().put("test.url", baseTestUrl);
            System.setProperty("test.url.spec", baseTestUrl.toExternalForm());
        }
        catch (MalformedURLException e) {
            SystemBundleTests.fail((String)"Unexpected url exception.", (Throwable)e);
        }
        Bundle geturlBundle = systemContext1.installBundle(installer.getBundleLocation("geturl"));
        geturlBundle.start();
        PrivilegedAction geturlAction = (PrivilegedAction)systemContext1.getService(systemContext1.getServiceReference(PrivilegedAction.class));
        try {
            geturlAction.run();
        }
        catch (Exception e) {
            SystemBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        try {
            equinox1.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox1.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox1.getState());
        try {
            equinox2.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox2.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox2.getState());
        handlerReg.unregister();
        System.getProperties().remove("test.url");
    }

    public void testUUID() {
        File config1 = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_1");
        HashMap<String, String> configuration1 = new HashMap<String, String>();
        configuration1.put("org.osgi.framework.storage", config1.getAbsolutePath());
        Equinox equinox1 = new Equinox(configuration1);
        try {
            equinox1.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed init", (Throwable)e);
        }
        String uuid1_1 = equinox1.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid1_1);
        File config2 = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + "_2");
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("org.osgi.framework.storage", config2.getAbsolutePath());
        Equinox equinox2 = new Equinox(configuration1);
        try {
            equinox2.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed init", (Throwable)e);
        }
        String uuid2_1 = equinox2.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid2_1);
        SystemBundleTests.assertFalse((String)("UUIDs are the same: " + uuid1_1), (boolean)uuid1_1.equals(uuid2_1));
        try {
            equinox1.stop();
            equinox2.stop();
            equinox1.waitForStop(1000L);
            equinox2.waitForStop(1000L);
            equinox1.init();
            equinox2.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to re-init frameworks.", (Throwable)e);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Failed to stop frameworks.", (Throwable)e);
        }
        String uuid1_2 = equinox1.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid1_2);
        String uuid2_2 = equinox2.getBundleContext().getProperty("org.osgi.framework.uuid");
        this.verifyUUID(uuid2_2);
        SystemBundleTests.assertFalse((String)("UUIDs are the same: " + uuid1_1), (boolean)uuid1_1.equals(uuid1_2));
        SystemBundleTests.assertFalse((String)("UUIDs are the same: " + uuid1_2), (boolean)uuid1_2.equals(uuid2_2));
        SystemBundleTests.assertFalse((String)("UUIDs are the same: " + uuid2_1), (boolean)uuid2_1.equals(uuid2_2));
        try {
            equinox1.stop();
            equinox2.stop();
            equinox1.waitForStop(1000L);
            equinox2.waitForStop(1000L);
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to re-init frameworks.", (Throwable)e);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Failed to stop frameworks.", (Throwable)e);
        }
    }

    private void verifyUUID(String uuid) {
        SystemBundleTests.assertNotNull((String)"Null uuid.", (Object)uuid);
        StringTokenizer st = new StringTokenizer(uuid, "-");
        String[] uuidSections = new String[5];
        int i = 0;
        while (i < uuidSections.length) {
            try {
                uuidSections[i] = "0x" + st.nextToken();
            }
            catch (NoSuchElementException e) {
                SystemBundleTests.fail((String)("Wrong number of uuid sections: " + uuid), (Throwable)e);
            }
            ++i;
        }
        try {
            st.nextToken();
            SystemBundleTests.fail((String)("Too many sections in uuid: " + uuid));
        }
        catch (NoSuchElementException noSuchElementException) {}
        i = 0;
        while (i < uuidSections.length) {
            int limit = 0;
            switch (i) {
                case 0: {
                    limit = 10;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    limit = 6;
                    break;
                }
                case 4: {
                    limit = 14;
                    break;
                }
            }
            SystemBundleTests.assertTrue((String)("UUISection is too big: " + uuidSections[i]), (uuidSections[i].length() <= limit ? 1 : 0) != 0);
            try {
                Long.decode(uuidSections[i]);
            }
            catch (NumberFormatException e) {
                SystemBundleTests.fail((String)("Invalid section: " + uuidSections[i]), (Throwable)e);
            }
            ++i;
        }
    }

    public void testBug304213() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        File bundleFile = null;
        try {
            File baseDir = new File(config, "bundles");
            baseDir.mkdirs();
            bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        }
        catch (IOException e) {
            SystemBundleTests.fail((String)"Unexpected error creating bundles.", (Throwable)e);
        }
        try {
            systemContext.installBundle("reference:file:///" + bundleFile.getAbsolutePath());
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected install error", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        new File(bundleFile, "META-INF/MANIFEST.MF").delete();
        systemContext = equinox.getBundleContext();
        Bundle[] bundles = systemContext.getBundles();
        try {
            int i = 0;
            while (i < bundles.length) {
                bundles[i].getHeaders();
                ++i;
            }
        }
        catch (Throwable t) {
            SystemBundleTests.fail((String)"Failed to get bundle entries", (Throwable)t);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testBug351083DevClassPath() throws InvalidSyntaxException {
        BundleInstaller testBundleInstaller = new BundleInstaller("test_files/devCPTests", OSGiTestsActivator.getContext());
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("osgi.dev", "../devCP");
            Equinox equinox = new Equinox(configuration);
            try {
                equinox.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
            }
            BundleContext systemContext = equinox.getBundleContext();
            SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
            Bundle tb1 = null;
            try {
                tb1 = systemContext.installBundle(testBundleInstaller.getBundleLocation("tb1"));
            }
            catch (BundleException e1) {
                SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
            }
            URL resource = tb1.getResource("tb1/resource.txt");
            SystemBundleTests.assertNotNull((String)"Resource is null", (Object)resource);
            try {
                equinox.stop();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
            }
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
            SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        }
        finally {
            testBundleInstaller.shutdown();
        }
    }

    public void testBug352275() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.packages.extra", "");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void disabledTestBug351519RefreshEnabled() {
        this.doTestBug351519Refresh(Boolean.TRUE);
    }

    public void testBug351519RefreshDisabled() {
        this.doTestBug351519Refresh(Boolean.FALSE);
    }

    public void testBug351519RefreshDefault() {
        this.doTestBug351519Refresh(null);
    }

    public void testWeavingPersistence() {
        long testID2;
        Bundle test2;
        long testID1;
        Bundle test1;
        BundleContext systemContext;
        Equinox equinox;
        block33: {
            ServiceRegistration reg;
            block31: {
                File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
                HashMap<String, String> configuration = new HashMap<String, String>();
                configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
                equinox = new Equinox(configuration);
                try {
                    equinox.start();
                }
                catch (BundleException e) {
                    SystemBundleTests.fail((String)"Unexpected exception in start()", (Throwable)e);
                }
                systemContext = equinox.getBundleContext();
                SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
                test1 = null;
                try {
                    test1 = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
                }
                catch (BundleException e) {
                    SystemBundleTests.fail((String)"Unexpected error installing bundle", (Throwable)e);
                }
                testID1 = test1.getBundleId();
                final Bundle testFinal1 = test1;
                reg = systemContext.registerService(WeavingHook.class, (Object)new WeavingHook(){

                    public void weave(WovenClass wovenClass) {
                        if (!testFinal1.equals(wovenClass.getBundleWiring().getBundle())) {
                            return;
                        }
                        if (!"substitutes.x.Ax".equals(wovenClass.getClassName())) {
                            return;
                        }
                        List dynamicImports = wovenClass.getDynamicImports();
                        dynamicImports.add("*");
                    }
                }, null);
                try {
                    try {
                        testFinal1.loadClass("substitutes.x.Ax");
                        testFinal1.loadClass("org.osgi.framework.hooks.bundle.FindHook");
                    }
                    catch (Throwable t) {
                        SystemBundleTests.fail((String)"Unexpected testing bundle", (Throwable)t);
                        reg.unregister();
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    reg.unregister();
                    throw throwable;
                }
                reg.unregister();
            }
            try {
                equinox.stop();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
            }
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
            try {
                equinox.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected exception in start()", (Throwable)e);
            }
            systemContext = equinox.getBundleContext();
            test1 = systemContext.getBundle(testID1);
            test2 = null;
            try {
                test2 = systemContext.installBundle(installer.getBundleLocation("exporter.importer1"));
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected error installing bundle", (Throwable)e);
            }
            testID2 = test2.getBundleId();
            final Bundle testFinal2 = test2;
            reg = systemContext.registerService(WeavingHook.class, (Object)new WeavingHook(){

                public void weave(WovenClass wovenClass) {
                    if (!testFinal2.equals(wovenClass.getBundleWiring().getBundle())) {
                        return;
                    }
                    if (!"exporter.importer.test.Test1".equals(wovenClass.getClassName())) {
                        return;
                    }
                    List dynamicImports = wovenClass.getDynamicImports();
                    dynamicImports.add("*");
                }
            }, null);
            try {
                try {
                    testFinal2.loadClass("exporter.importer.test.Test1");
                    testFinal2.loadClass("org.osgi.framework.hooks.service.FindHook");
                }
                catch (Throwable t) {
                    SystemBundleTests.fail((String)"Unexpected testing bundle", (Throwable)t);
                    reg.unregister();
                    break block33;
                }
            }
            catch (Throwable throwable) {
                reg.unregister();
                throw throwable;
            }
            reg.unregister();
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in start()", (Throwable)e);
        }
        systemContext = equinox.getBundleContext();
        test1 = systemContext.getBundle(testID1);
        test2 = systemContext.getBundle(testID2);
        BundleRevision rev1 = (BundleRevision)test1.adapt(BundleRevision.class);
        BundleRevision rev2 = (BundleRevision)test2.adapt(BundleRevision.class);
        BundleWiring wiring1 = rev1.getWiring();
        BundleWiring wiring2 = rev2.getWiring();
        SystemBundleTests.assertNotNull((String)"wiring1 is null", (Object)wiring1);
        SystemBundleTests.assertNotNull((String)"wiring2 is null", (Object)wiring2);
        List packages1 = wiring1.getRequiredWires("osgi.wiring.package");
        List packages2 = wiring2.getRequiredWires("osgi.wiring.package");
        SystemBundleTests.assertEquals((String)"Wrong number of wires for wiring1", (int)1, (int)packages1.size());
        SystemBundleTests.assertEquals((String)"Wrong number of wires for wiring2", (int)1, (int)packages2.size());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
    }

    private void doTestBug351519Refresh(Boolean refreshDuplicates) {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        if (refreshDuplicates != null) {
            configuration.put("equinox.refresh.duplicate.bsn", refreshDuplicates.toString());
        } else {
            refreshDuplicates = Boolean.FALSE;
        }
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        BundleContext systemContext = equinox.getBundleContext();
        systemContext.registerService(ResolverHookFactory.class, (Object)new ResolverHookFactory(){

            public ResolverHook begin(Collection triggers) {
                return new ResolverHook(){

                    public void filterResolvable(Collection candidates) {
                    }

                    public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        collisionCandidates.clear();
                    }

                    public void filterMatches(BundleRequirement requirement, Collection candidates) {
                    }

                    public void end() {
                    }
                };
            }
        }, null);
        BundleInstaller testBundleInstaller = null;
        BundleInstaller testBundleResolver = null;
        try {
            testBundleResolver = new BundleInstaller("test_files/wiringTests/bundles", systemContext);
            testBundleInstaller = new BundleInstaller("test_files/wiringTests/bundles", this.getContext());
        }
        catch (InvalidSyntaxException e) {
            SystemBundleTests.fail((String)"Failed to create installers.", (Throwable)e);
        }
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle tb1v1 = null;
        Bundle tb1v2 = null;
        try {
            tb1v1 = systemContext.installBundle(testBundleInstaller.getBundleLocation("singleton.tb1v1"));
            tb1v2 = systemContext.installBundle(testBundleInstaller.getBundleLocation("singleton.tb1v2"));
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
        }
        SystemBundleTests.assertTrue((String)"Could not resolve test bundles", (boolean)testBundleResolver.resolveBundles(new Bundle[]{tb1v1, tb1v2}));
        Bundle[] refreshed = testBundleResolver.refreshPackages(new Bundle[]{tb1v1});
        if (refreshDuplicates.booleanValue()) {
            List<Bundle> refreshedList = Arrays.asList(refreshed);
            SystemBundleTests.assertEquals((String)"Wrong number of refreshed bundles", (int)2, (int)refreshed.length);
            SystemBundleTests.assertTrue((String)"Refreshed bundles does not include v1", (boolean)refreshedList.contains(tb1v1));
            SystemBundleTests.assertTrue((String)"Refreshed bundles does not include v2", (boolean)refreshedList.contains(tb1v2));
        } else {
            SystemBundleTests.assertEquals((String)"Wrong number of refreshed bundles", (int)1, (int)refreshed.length);
            SystemBundleTests.assertEquals("Refreshed bundles does not include v1", refreshed[0], tb1v1);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testBug375784() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.context.bootdelegation", "true");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        try {
            Bundle tb1 = systemContext.installBundle(installer.getBundleLocation("test.bug375784"));
            tb1.start();
        }
        catch (BundleException e1) {
            SystemBundleTests.fail((String)"failed to install and start test bundle", (Throwable)e1);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testBug258209_1() throws BundleException {
        Equinox equinox;
        block15: {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            equinox = new Equinox(configuration);
            equinox.init();
            Thread.currentThread().setContextClassLoader(current);
            BundleContext systemContext = equinox.getBundleContext();
            Bundle testTCCL = systemContext.installBundle(installer.getBundleLocation("test.tccl"));
            ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(testTCCL));
            try {
                testTCCL.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected exception starting bundle", (Throwable)e);
            }
            SystemBundleTests.assertEquals((String)"Unexpected state", (int)4, (int)testTCCL.getState());
            equinox.start();
            SystemBundleTests.assertEquals((String)"Unexpected state", (int)32, (int)testTCCL.getState());
            try {
                equinox.update();
                this.checkActive(testTCCL);
            }
            catch (Exception e) {
                SystemBundleTests.fail((String)"Unexpected exception", (Throwable)e);
            }
            systemContext = equinox.getBundleContext();
            SystemBundleTests.assertEquals((String)"Unexpected state", (int)32, (int)testTCCL.getState());
            ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).refreshBundles(Arrays.asList(testTCCL), new FrameworkListener[0]);
            this.checkActive(testTCCL);
            SystemBundleTests.assertEquals((String)"Unexpected state", (int)32, (int)testTCCL.getState());
            ClassLoader serviceTCCL = null;
            try {
                serviceTCCL = (ClassLoader)systemContext.getService(systemContext.getServiceReferences(ClassLoader.class.getName(), "(equinox.classloader.type=contextClassLoader)")[0]);
            }
            catch (InvalidSyntaxException e) {
                SystemBundleTests.fail((String)"Unexpected", (Throwable)e);
            }
            current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(serviceTCCL);
            try {
                try {
                    testTCCL.stop();
                    testTCCL.start();
                }
                catch (BundleException e) {
                    SystemBundleTests.fail((String)"Unepected", (Throwable)e);
                    Thread.currentThread().setContextClassLoader(current);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(current);
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(current);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
    }

    private void checkActive(Bundle b) {
        try {
            Thread.sleep(500L);
            if (b.getState() != 32) {
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            SystemBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBug413879() {
        Set errors;
        Equinox equinox;
        block14: {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            equinox = new Equinox(configuration);
            try {
                equinox.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected exception in start()", (Throwable)e);
            }
            BundleContext systemContext = equinox.getBundleContext();
            SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
            Bundle test1 = null;
            try {
                test1 = systemContext.installBundle(installer.getBundleLocation("substitutes.a"));
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected error installing bundle", (Throwable)e);
            }
            final Bundle testFinal1 = test1;
            ServiceRegistration reg = systemContext.registerService(WeavingHook.class, (Object)new WeavingHook(){

                public void weave(WovenClass wovenClass) {
                    if (!testFinal1.equals(wovenClass.getBundleWiring().getBundle())) {
                        return;
                    }
                    if (!"substitutes.x.Ax".equals(wovenClass.getClassName())) {
                        return;
                    }
                    List dynamicImports = wovenClass.getDynamicImports();
                    dynamicImports.add("*");
                }
            }, null);
            ServiceRegistration resolverHookReg = systemContext.registerService(ResolverHookFactory.class, (Object)new ResolverHookFactory(){

                public ResolverHook begin(Collection<BundleRevision> triggers) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            }, null);
            errors = Collections.newSetFromMap(new ConcurrentHashMap());
            try {
                try {
                    Runnable dynamicLoadClass = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                testFinal1.loadClass("substitutes.x.Ax");
                                testFinal1.loadClass("org.osgi.framework.hooks.bundle.FindHook");
                            }
                            catch (Throwable t) {
                                errors.add(t);
                            }
                        }
                    };
                    Thread t1 = new Thread(dynamicLoadClass, String.valueOf(this.getName()) + "-1");
                    Thread t2 = new Thread(dynamicLoadClass, String.valueOf(this.getName()) + "-2");
                    t1.start();
                    t2.start();
                    t1.join();
                    t2.join();
                }
                catch (Throwable t) {
                    SystemBundleTests.fail((String)"Unexpected testing bundle", (Throwable)t);
                    reg.unregister();
                    resolverHookReg.unregister();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                reg.unregister();
                resolverHookReg.unregister();
                throw throwable;
            }
            reg.unregister();
            resolverHookReg.unregister();
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        if (!errors.isEmpty()) {
            SystemBundleTests.fail((String)"Failed to resolve dynamic", (Throwable)((Throwable)errors.iterator().next()));
        }
    }

    public void testBug414070() throws BundleException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle systemBundle = systemContext.getBundle();
        Bundle chainTest = systemContext.installBundle(installer.getBundleLocation("chain.test"));
        final Bundle chainTestD = systemContext.installBundle(installer.getBundleLocation("chain.test.d"));
        Bundle chainTestA = systemContext.installBundle(installer.getBundleLocation("chain.test.a"));
        Bundle chainTestB = systemContext.installBundle(installer.getBundleLocation("chain.test.b"));
        Bundle chainTestC = systemContext.installBundle(installer.getBundleLocation("chain.test.c"));
        systemContext.registerService(WeavingHook.class, (Object)new WeavingHook(){

            public void weave(WovenClass wovenClass) {
                if (!chainTestD.equals(wovenClass.getBundleWiring().getBundle())) {
                    return;
                }
                if (!"chain.test.d.DMultipleChain1".equals(wovenClass.getClassName())) {
                    return;
                }
                List dynamicImports = wovenClass.getDynamicImports();
                dynamicImports.add("*");
            }
        }, null);
        equinox.start();
        chainTest.loadClass("chain.test.TestMultiChain").newInstance();
        chainTestD.loadClass("chain.test.a.AMultiChain1");
        SystemBundleTests.assertEquals((String)"A is not active.", (int)32, (int)chainTestA.getState());
        SystemBundleTests.assertEquals((String)"B is not active.", (int)32, (int)chainTestB.getState());
        SystemBundleTests.assertEquals((String)"C is not active.", (int)32, (int)chainTestC.getState());
        SystemBundleTests.assertEquals((String)"D is not active.", (int)32, (int)chainTestD.getState());
        final ArrayList stoppingOrder = new ArrayList();
        systemContext.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 256) {
                    stoppingOrder.add(event.getBundle());
                }
            }
        });
        equinox.stop();
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            SystemBundleTests.fail((String)"Unexpected interruption.", (Throwable)e);
        }
        List<Bundle> expectedOrder = Arrays.asList(systemBundle, chainTest, chainTestA, chainTestB, chainTestC, chainTestD);
        this.assertEquals("Wrong stopping order", expectedOrder.toArray(), stoppingOrder.toArray());
    }

    public void testBug412228() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle b = systemContext.installBundle(installer.getBundleLocation("test.bug412228"));
        b.start();
        equinox.start();
        long startTime = System.currentTimeMillis();
        equinox.stop();
        try {
            equinox.waitForStop(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            SystemBundleTests.fail((String)"Unexpected interruption.", (Throwable)e);
        }
        long stopTime = System.currentTimeMillis() - startTime;
        if (stopTime > 2000L) {
            SystemBundleTests.fail((String)("waitForStop time took too long: " + stopTime));
        }
    }

    public void testBug432632() throws BundleException, IOException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty("test.substitute1", "Some.$test.prop1$.test");
        configIni.setProperty("test.substitute2", "Some.$test.prop2$.test");
        configIni.store(new FileOutputStream(new File(config, "config.ini")), "Test config.ini");
        System.setProperty("test.prop1", "PASSED");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertEquals((String)"Wrong value for test.substitute1", (String)"Some.PASSED.test", (String)systemContext.getProperty("test.substitute1"));
        SystemBundleTests.assertEquals((String)"Wrong value for test.substitute2", (String)"Some.$test.prop2$.test", (String)systemContext.getProperty("test.substitute2"));
        equinox.stop();
        try {
            equinox.waitForStop(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            SystemBundleTests.fail((String)"Unexpected interruption.", (Throwable)e);
        }
    }

    public void testDynamicSecurityManager() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        SystemBundleTests.assertNull((String)"SecurityManager must be null to test.", (Object)sm);
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            Equinox equinox = new Equinox(configuration);
            try {
                equinox.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Unexpected exception in start()", (Throwable)e);
            }
            Bundle substitutesA = null;
            try {
                substitutesA = equinox.getBundleContext().installBundle(installer.getBundleLocation("substitutes.a"));
            }
            catch (BundleException e1) {
                SystemBundleTests.fail((String)"failed to install a bundle", (Throwable)e1);
            }
            SystemBundleTests.assertTrue((String)"BundleCould not resolve.", (boolean)((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(substitutesA)));
            ((BundleWiring)substitutesA.adapt(BundleWiring.class)).findEntries("/", null, 0);
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm, Object context) {
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            equinox.stop();
            try {
                FrameworkEvent event = equinox.waitForStop(10000L);
                SystemBundleTests.assertEquals((String)"Wrong event.", (int)64, (int)event.getType());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SystemBundleTests.fail((String)"Unexpected interruption.", (Throwable)e);
            }
            SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    public void testNullConfigurationValue() throws BundleException {
        System.setProperty(nullTest, "system");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put(nullTest, null);
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        String nullValue = equinox.getBundleContext().getProperty(nullTest);
        SystemBundleTests.assertNull((String)("null.test is not null: " + nullValue), (Object)nullValue);
        String systemNullValue = System.getProperty(nullTest);
        SystemBundleTests.assertEquals((String)"Wrong system null value.", (String)"system", (String)systemNullValue);
        equinox.stop();
    }

    public void testNullConfigurationValueRequiredProperty() throws BundleException {
        String systemProcessor = System.getProperty("org.osgi.framework.processor");
        SystemBundleTests.assertNotNull((Object)systemProcessor);
        try {
            System.setProperty("org.osgi.framework.processor", "hyperflux");
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("org.osgi.framework.processor", null);
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            String processor = equinox.getBundleContext().getProperty("org.osgi.framework.processor");
            SystemBundleTests.assertEquals((String)"Wrong org.osgi.framework.processor", (String)systemProcessor, (String)processor);
            String systemValue = System.getProperty("org.osgi.framework.processor");
            SystemBundleTests.assertEquals((String)"Wrong system value.", (String)"hyperflux", (String)systemValue);
            equinox.stop();
        }
        finally {
            System.setProperty("org.osgi.framework.processor", systemProcessor);
        }
    }

    public void testAllNullConfigurationValues() throws BundleException {
        List<String> requiredProperties = Arrays.asList("org.osgi.framework.executionenvironment", "org.osgi.framework.language", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.storage", "org.osgi.framework.system.capabilities", "org.osgi.framework.system.packages", "org.osgi.framework.uuid", "org.osgi.framework.vendor", "org.osgi.framework.version", "org.osgi.supports.framework.extension", "org.osgi.supports.framework.fragment", "org.osgi.supports.framework.requirebundle", "osgi.framework", "osgi.arch", "osgi.os", "osgi.ws", "osgi.ws", "osgi.nl", "eclipse.stateSaveDelayInterval", "equinox.init.uuid", "gosh.args", "eclipse.home.location", "osgi.configuration.area", "osgi.install.area", "osgi.logfile");
        Properties systemProperties = (Properties)System.getProperties().clone();
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Object key : systemProperties.keySet()) {
            configuration.put((String)key, null);
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        for (Object key : systemProperties.keySet()) {
            String property = (String)key;
            String value = equinox.getBundleContext().getProperty(property);
            if (requiredProperties.contains(property)) {
                SystemBundleTests.assertNotNull((String)(String.valueOf(property) + " is null"), (Object)value);
            } else {
                SystemBundleTests.assertNull((String)(String.valueOf(property) + " is not null"), (Object)value);
            }
            String systemValue = System.getProperty(property);
            SystemBundleTests.assertEquals((String)("Wrong system value for " + property), (String)systemProperties.getProperty(property), (String)systemValue);
        }
        SystemBundleTests.assertEquals((Object)systemProperties, (Object)System.getProperties());
        equinox.stop();
    }

    public void testNullConfigurationValueSystemProperties() throws BundleException {
        System.setProperty(nullTest, "system");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.useSystemProperties", "true");
        configuration.put(nullTest, null);
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        String nullValue = equinox.getBundleContext().getProperty(nullTest);
        SystemBundleTests.assertNull((String)("null.test is not null: " + nullValue), (Object)nullValue);
        SystemBundleTests.assertNull((String)"Did not get null system value.", (Object)System.getProperties().get(nullTest));
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        envInfo.setProperty(this.getName(), this.getName());
        SystemBundleTests.assertEquals((String)"Got wrong value from system properties.", (String)System.getProperty(this.getName()), (String)this.getName());
        envInfo.setProperty(this.getName(), null);
        SystemBundleTests.assertNull((String)"Did not get null system value.", (Object)System.getProperties().get(this.getName()));
        equinox.stop();
    }

    public void testBackedBySystemReplaceSystemProperties() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.useSystemProperties", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(copy);
        String systemKey = String.valueOf(this.getName()) + ".system";
        System.setProperty(systemKey, this.getName());
        SystemBundleTests.assertEquals((String)"Wrong context value", (String)this.getName(), (String)equinox.getBundleContext().getProperty(systemKey));
        SystemBundleTests.assertEquals((String)"Wrong context value", (String)this.getName(), (String)envInfo.getProperty(systemKey));
        SystemBundleTests.assertEquals((String)"Wrong EquinoxConfiguration config value", (String)this.getName(), (String)((EquinoxConfiguration)envInfo).getConfiguration(systemKey));
        String envKey = String.valueOf(this.getName()) + ".env";
        envInfo.setProperty(envKey, this.getName());
        SystemBundleTests.assertEquals((String)"Wrong system value", (String)this.getName(), (String)System.getProperty(envKey));
        equinox.stop();
    }

    public void testLocalConfigReplaceSystemProperties() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        ServiceReference envRef = equinox.getBundleContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo envInfo = (EnvironmentInfo)equinox.getBundleContext().getService(envRef);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(copy);
        String systemKey = String.valueOf(this.getName()) + ".system";
        System.setProperty(systemKey, this.getName());
        SystemBundleTests.assertEquals((String)"Wrong context value", (String)this.getName(), (String)equinox.getBundleContext().getProperty(systemKey));
        SystemBundleTests.assertEquals((String)"Wrong context value", (String)this.getName(), (String)envInfo.getProperty(systemKey));
        SystemBundleTests.assertNull((String)"Wrong EquinoxConfiguration config value", (Object)((EquinoxConfiguration)envInfo).getConfiguration(systemKey));
        String envKey = String.valueOf(this.getName()) + ".env";
        envInfo.setProperty(envKey, this.getName());
        SystemBundleTests.assertNull((String)"Wrong system value", (Object)System.getProperty(envKey));
        equinox.stop();
    }

    public void testSystemNLFragment() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.nl", "zh");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        equinox.getHeaders();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle systemNLS = systemContext.installBundle(installer.getBundleLocation("test.system.nls"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(systemNLS));
        SystemBundleTests.assertEquals((String)"Wrong fragment state", (int)4, (int)systemNLS.getState());
        SystemBundleTests.assertEquals((String)"Wrong header value.", (String)"TEST NAME", (String)((String)equinox.getHeaders().get("Bundle-Name")));
        equinox.stop();
    }

    public void testNullConfiguration() {
        new Equinox(null);
    }

    public void testNullStorageArea() throws BundleException {
        File install = this.getContext().getDataFile(this.getName());
        install.mkdirs();
        Equinox equinox = new Equinox(Collections.singletonMap("osgi.install.area", install.getAbsolutePath()));
        try {
            equinox.init();
            String storageArea = equinox.getBundleContext().getProperty("org.osgi.framework.storage");
            SystemBundleTests.assertNotNull((String)"No storage area set.", (Object)storageArea);
        }
        finally {
            equinox.stop();
        }
    }

    public void testOSGiDevSetsCheckConfiguration() throws BundleException {
        String originalCheckConfiguration = System.clearProperty("osgi.checkConfiguration");
        try {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("osgi.dev", "true");
            Equinox equinox = new Equinox(configuration);
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            SystemBundleTests.assertEquals((String)"Wrong value for: osgi.checkConfiguration", (String)"true", (String)systemContext.getProperty("osgi.checkConfiguration"));
            equinox.stop();
        }
        finally {
            if (originalCheckConfiguration != null) {
                System.setProperty("osgi.checkConfiguration", originalCheckConfiguration);
            }
        }
    }

    public void testProvideOSGiEEandNative() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.equinox.allow.restricted.provides", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        Bundle testBundle = systemContext.installBundle(installer.getBundleLocation("test.bug449484"));
        ((FrameworkWiring)equinox.adapt(FrameworkWiring.class)).resolveBundles(Collections.singleton(testBundle));
        SystemBundleTests.assertEquals((String)"Wrong bundle state", (int)4, (int)testBundle.getState());
        testBundle.uninstall();
        equinox.stop();
        configuration.remove("osgi.equinox.allow.restricted.provides");
        equinox = new Equinox(configuration);
        equinox.start();
        systemContext = equinox.getBundleContext();
        try {
            testBundle = systemContext.installBundle(installer.getBundleLocation("test.bug449484"));
            testBundle.uninstall();
            SystemBundleTests.fail((String)"Expected to fail to install bundle with restricted provide capabilities.");
        }
        catch (BundleException bundleException) {}
        equinox.stop();
        configuration.put("osgi.equinox.allow.restricted.provides", "false");
        equinox = new Equinox(configuration);
        equinox.start();
        systemContext = equinox.getBundleContext();
        try {
            testBundle = systemContext.installBundle(installer.getBundleLocation("test.bug449484"));
            testBundle.uninstall();
            SystemBundleTests.fail((String)"Expected to fail to install bundle with restricted provide capabilities.");
        }
        catch (BundleException bundleException) {}
        equinox.stop();
    }

    public void testBootDelegationConfigIni() throws BundleException, IOException, InterruptedException {
        String compatBootDelegate = "osgi.compatibility.bootdelegation";
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty(compatBootDelegate, "true");
        configIni.store(new FileWriter(new File(config, "config.ini")), null);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertEquals((String)("Wrong value for: " + compatBootDelegate), (String)"true", (String)systemContext.getProperty(compatBootDelegate));
        File bundleFile = null;
        try {
            File baseDir = new File(config, "bundles");
            baseDir.mkdirs();
            bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        }
        catch (IOException e) {
            SystemBundleTests.fail((String)"Unexpected error creating bundles.", (Throwable)e);
        }
        Bundle b = null;
        try {
            b = systemContext.installBundle("reference:file:///" + bundleFile.getAbsolutePath());
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected install error", (Throwable)e);
        }
        try {
            b.loadClass(SocketFactory.class.getName());
        }
        catch (ClassNotFoundException e) {
            SystemBundleTests.fail((String)"Expected to be able to load the class from boot.", (Throwable)e);
        }
        long bId = b.getBundleId();
        equinox.stop();
        equinox.waitForStop(5000L);
        configIni.remove(compatBootDelegate);
        configIni.store(new FileWriter(new File(config, "config.ini")), null);
        equinox = new Equinox(configuration);
        equinox.start();
        systemContext = equinox.getBundleContext();
        b = systemContext.getBundle(bId);
        try {
            b.loadClass(SocketFactory.class.getName());
            SystemBundleTests.fail((String)"Expected to fail to load the class from boot.");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        equinox.stop();
    }

    public void testSystemBundleListener() throws BundleException, InterruptedException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        final AtomicInteger stoppingEvent = new AtomicInteger();
        final AtomicInteger stoppedEvent = new AtomicInteger();
        SynchronousBundleListener systemBundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().getBundleId() == 0L) {
                    switch (event.getType()) {
                        case 256: {
                            stoppingEvent.incrementAndGet();
                            break;
                        }
                        case 4: {
                            stoppedEvent.incrementAndGet();
                        }
                    }
                }
            }
        };
        systemContext.addBundleListener((BundleListener)systemBundleListener);
        equinox.stop();
        equinox.waitForStop(5000L);
        SystemBundleTests.assertEquals((String)"Wrong number of STOPPING events", (int)1, (int)stoppingEvent.get());
        SystemBundleTests.assertEquals((String)"Wrong number of STOPPED events", (int)1, (int)stoppedEvent.get());
    }

    public void testContextBootDelegation() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        try {
            Bundle b = systemContext.installBundle(installer.getBundleLocation("test.bug471551"));
            b.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error", (Throwable)e);
        }
        equinox.stop();
    }

    public void testExtraSystemBundleHeaders() throws BundleException, InterruptedException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=JavaSE; version:Version=1.7, something.system");
        configuration.put("org.osgi.framework.system.packages", "something.system");
        configuration.put("org.osgi.framework.system.capabilities.extra", "something.extra");
        configuration.put("org.osgi.framework.system.packages.extra", "something.extra");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        Dictionary headers = equinox.getHeaders();
        String provideCapability = (String)headers.get("Provide-Capability");
        String exportPackage = (String)headers.get("Export-Package");
        SystemBundleTests.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        SystemBundleTests.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        SystemBundleTests.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        SystemBundleTests.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        equinox.stop();
        equinox.waitForStop(5000L);
        configuration.put("equinox.system.provide.header", "original");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        SystemBundleTests.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        SystemBundleTests.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        SystemBundleTests.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        SystemBundleTests.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        equinox.stop();
        equinox.waitForStop(5000L);
        configuration.put("equinox.system.provide.header", "system");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        SystemBundleTests.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        SystemBundleTests.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        SystemBundleTests.assertFalse((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        SystemBundleTests.assertFalse((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        equinox.stop();
        equinox.waitForStop(5000L);
        configuration.put("equinox.system.provide.header", "system.extra");
        equinox = new Equinox(configuration);
        equinox.start();
        headers = equinox.getHeaders();
        provideCapability = (String)headers.get("Provide-Capability");
        exportPackage = (String)headers.get("Export-Package");
        SystemBundleTests.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.system"));
        SystemBundleTests.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.system"));
        SystemBundleTests.assertTrue((String)("Unexpected Provide-Capability header: " + provideCapability), (boolean)provideCapability.contains("something.extra"));
        SystemBundleTests.assertTrue((String)("Unexpected Export-Package header: " + exportPackage), (boolean)exportPackage.contains("something.extra"));
        equinox.stop();
        equinox.waitForStop(5000L);
    }

    public void testSystemBundleLoader() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle("System Bundle");
        BundleWiring wiring = (BundleWiring)systemBundle.adapt(BundleWiring.class);
        ClassLoader cl = wiring.getClassLoader();
        SystemBundleTests.assertNotNull((String)"No system bundle class loader.", (Object)cl);
    }

    public void testJavaProfile() throws IOException {
        String originalSpecVersion = System.getProperty("java.specification.version");
        String originalJavaHome = System.getProperty("java.home");
        try {
            this.doTestJavaProfile("9.3.1", "JavaSE-9", null);
            this.doTestJavaProfile("9", "JavaSE-9", null);
            this.doTestJavaProfile("8.4", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.10.1", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.9", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.8", "JavaSE-1.8", null);
            this.doTestJavaProfile("1.7", "JavaSE-1.7", null);
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", "compact3");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", "\"compact3\"");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", " \"compact3\" ");
            this.doTestJavaProfile("1.8", "JavaSE/compact3-1.8", " compact3 ");
            this.doTestJavaProfile("1.8", "JavaSE-1.8", "\"compact4\"");
            this.doTestJavaProfile("9", "JavaSE/compact3-1.8", "compact3");
            this.doTestJavaProfile("9", "JavaSE/compact3-1.8", "\"compact3\"");
            this.doTestJavaProfile("9", "JavaSE-9", "\"compact4\"");
        }
        finally {
            System.setProperty("java.specification.version", originalSpecVersion);
            System.setProperty("java.home", originalJavaHome);
        }
    }

    private void doTestJavaProfile(String javaSpecVersion, String expectedEEName, String releaseName) throws FileNotFoundException, IOException {
        if (releaseName != null) {
            File release = this.getContext().getDataFile("jre/release");
            release.getParentFile().mkdirs();
            Properties props = new Properties();
            props.put("JAVA_PROFILE", releaseName);
            FileOutputStream propStream = new FileOutputStream(release);
            try {
                props.store(propStream, null);
            }
            finally {
                propStream.close();
            }
            System.setProperty("java.home", release.getParentFile().getAbsolutePath());
        }
        System.setProperty("java.specification.version", javaSpecVersion);
        File config = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + javaSpecVersion);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        String osgiEE = equinox.getBundleContext().getProperty("org.osgi.framework.executionenvironment");
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SystemBundleTests.assertTrue((String)("Wrong osgi EE: expected: " + expectedEEName + " but was: " + osgiEE), (boolean)osgiEE.endsWith(expectedEEName));
    }

    private static File[] createBundles(File outputDir, int bundleCount) throws IOException {
        outputDir.mkdirs();
        File[] bundles = new File[bundleCount];
        int i = 0;
        while (i < bundleCount) {
            bundles[i] = SystemBundleTests.createBundle(outputDir, "-b" + i, false, false);
            ++i;
        }
        return bundles;
    }

    static File createBundle(File outputDir, String id, boolean emptyManifest, boolean dirBundle) throws IOException {
        File file = new File(outputDir, "bundle" + id + (dirBundle ? "" : ".jar"));
        if (!dirBundle) {
            JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), SystemBundleTests.createManifest(id, emptyManifest));
            jos.flush();
            jos.close();
        } else {
            File manifest = new File(file, "META-INF/MANIFEST.MF");
            manifest.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(manifest);
            SystemBundleTests.createManifest(id, emptyManifest).write(out);
            out.close();
        }
        return file;
    }

    private static Manifest createManifest(String id, boolean emptyManifest) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        if (!emptyManifest) {
            attributes.putValue("Bundle-ManifestVersion", "2");
            attributes.putValue("Bundle-SymbolicName", "bundle" + id);
        }
        return manifest;
    }

    static File createBundle(File outputDir, String bundleName, Map<String, String> headers, Map<String, String> ... entries) throws IOException {
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDir, "bundle" + bundleName + ".jar");
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), m);
        if (entries != null) {
            Map<String, String>[] mapArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, String> entryMap = mapArray[n2];
                for (Map.Entry<String, String> entry : entryMap.entrySet()) {
                    jos.putNextEntry(new JarEntry(entry.getKey()));
                    jos.write(entry.getValue().getBytes());
                    jos.closeEntry();
                }
                ++n2;
            }
        }
        jos.flush();
        jos.close();
        return file;
    }

    public void testBug405919() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework", "boo");
        Equinox equinox = null;
        try {
            equinox = new Equinox(configuration);
            equinox.start();
        }
        catch (NullPointerException e) {
            SystemBundleTests.fail((String)"failed to accept an invalid value for osgi.framework", (Throwable)e);
        }
        try {
            BundleContext systemContext = equinox.getBundleContext();
            try {
                Bundle tb1 = systemContext.installBundle(installer.getBundleLocation("test.bug375784"));
                tb1.start();
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"failed to install and start test bundle", (Throwable)e);
            }
            BundleRevision inner = (BundleRevision)systemContext.getBundle().adapt(BundleRevision.class);
            BundleRevision outer = (BundleRevision)this.getContext().getBundle(0L).adapt(BundleRevision.class);
            List innerCaps = inner.getCapabilities(null);
            List outerCaps = outer.getCapabilities(null);
            SystemBundleTests.assertEquals((String)"Number of capabilities differ", (int)outerCaps.size(), (int)innerCaps.size());
            int i = 0;
            while (i < innerCaps.size()) {
                Capability innerCap = (Capability)innerCaps.get(i);
                Capability outerCap = (Capability)innerCaps.get(i);
                SystemBundleTests.assertEquals((String)("Capability namespaces differ: " + outerCap.getNamespace()), (String)outerCap.getNamespace(), (String)innerCap.getNamespace());
                String namespace = outerCap.getNamespace();
                if (!"osgi.native".equals(namespace) && !"eclipse.platform".equals(namespace)) {
                    SystemBundleTests.assertEquals("Capability attributes differ: " + outerCap.getNamespace(), outerCap.getAttributes(), innerCap.getAttributes());
                    SystemBundleTests.assertEquals("Capability directives differ: " + outerCap.getNamespace(), outerCap.getDirectives(), innerCap.getDirectives());
                }
                ++i;
            }
            List innerReqs = inner.getRequirements(null);
            List outerReqs = outer.getRequirements(null);
            SystemBundleTests.assertEquals((String)"Number of requirements differ", (int)outerReqs.size(), (int)innerReqs.size());
            int i2 = 0;
            while (i2 < innerReqs.size()) {
                Requirement innerReq = (Requirement)innerReqs.get(i2);
                Requirement outerReq = (Requirement)innerReqs.get(i2);
                SystemBundleTests.assertEquals((String)("Requirement namespaces differ: " + outerReq.getNamespace()), (String)outerReq.getNamespace(), (String)innerReq.getNamespace());
                SystemBundleTests.assertEquals("Requirement attributes differ: " + outerReq.getNamespace(), outerReq.getAttributes(), innerReq.getAttributes());
                SystemBundleTests.assertEquals("Requirement directives differ: " + outerReq.getNamespace(), outerReq.getDirectives(), innerReq.getDirectives());
                ++i2;
            }
        }
        finally {
            equinox.stop();
            equinox.waitForStop(5000L);
        }
    }

    public void testInitialBundleUpdate() throws IOException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected exception in init()", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        File bundleFile = null;
        try {
            File baseDir = new File(config, "bundles");
            baseDir.mkdirs();
            bundleFile = SystemBundleTests.createBundle(baseDir, this.getName(), true, true);
        }
        catch (IOException e) {
            SystemBundleTests.fail((String)"Unexpected error creating bundles.", (Throwable)e);
        }
        Bundle testBundle = null;
        try {
            String location = "reference:file:///" + bundleFile.getAbsolutePath();
            URL url = new URL(null, location, (URLStreamHandler)new Handler(systemContext.getProperty("osgi.install.area")));
            testBundle = systemContext.installBundle("initial@" + location, url.openStream());
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected install error", (Throwable)e);
        }
        try {
            testBundle.update();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected update error", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SystemBundleTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SystemBundleTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SystemBundleTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
    }

    public void testDaemonActiveThread() throws BundleException, InterruptedException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        config.mkdirs();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.framework.activeThreadType", "daemon");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, true);
        equinox.stop();
        equinox.waitForStop(10000L);
        configuration.put("osgi.framework.activeThreadType", "normal");
        equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, false);
        equinox.stop();
        equinox.waitForStop(10000L);
        configuration.remove("osgi.framework.activeThreadType");
        equinox = new Equinox(configuration);
        equinox.start();
        this.checkActiveThreadType(equinox, false);
        equinox.stop();
    }

    public void testLazyTriggerOnLoadError() throws InterruptedException, BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("osgi.compatibility.trigger.lazyActivation.onFailedClassLoad", "true");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle b = systemContext.installBundle(installer.getBundleLocation("chain.test.d"));
        b.start(2);
        SystemBundleTests.assertEquals((String)"Wrong state of bundle.", (int)8, (int)b.getState());
        try {
            b.loadClass("does.not.exist.Clazz");
            SystemBundleTests.fail((String)"Expected class load error");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        SystemBundleTests.assertEquals((String)"Wrong state of bundle.", (int)32, (int)b.getState());
        equinox.stop();
        equinox.waitForStop(10000L);
        configuration.remove("osgi.compatibility.trigger.lazyActivation.onFailedClassLoad");
        equinox = new Equinox(configuration);
        equinox.start();
        b = equinox.getBundleContext().getBundle(b.getBundleId());
        SystemBundleTests.assertEquals((String)"Wrong state of bundle.", (int)8, (int)b.getState());
        try {
            b.loadClass("does.not.exist.Clazz");
            SystemBundleTests.fail((String)"Expected class load error");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        SystemBundleTests.assertEquals((String)"Wrong state of bundle.", (int)8, (int)b.getState());
        equinox.stop();
    }

    public void testConfigPercentChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar('%');
    }

    public void testConfigSpaceChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar(' ');
    }

    public void testConfigPlusChar() throws BundleException, IOException {
        this.doTestConfigSpecialChar('+');
    }

    private void doTestConfigSpecialChar(char c) throws BundleException, IOException {
        File config = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + c + "config");
        config.mkdirs();
        Properties configIni = new Properties();
        configIni.setProperty("test.config", this.getName());
        configIni.store(new FileOutputStream(new File(config, "config.ini")), "Test config.ini");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.init();
        BundleContext systemContext = equinox.getBundleContext();
        SystemBundleTests.assertEquals((String)"Wrong value for test.config", (String)this.getName(), (String)systemContext.getProperty("test.config"));
        equinox.stop();
        try {
            equinox.waitForStop(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            SystemBundleTests.fail((String)"Unexpected interruption.", (Throwable)e);
        }
    }

    void checkActiveThreadType(Equinox equinox, boolean expectIsDeamon) {
        String uuid = equinox.getBundleContext().getProperty("org.osgi.framework.uuid");
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        Object[] threads = new Thread[topGroup.activeCount()];
        topGroup.enumerate((Thread[])threads);
        Thread found = null;
        Object[] objectArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = objectArray[n2];
            String name = t.getName();
            if (("Active Thread: Equinox Container: " + uuid).equals(name)) {
                found = t;
                break;
            }
            ++n2;
        }
        SystemBundleTests.assertNotNull((String)("No framework active thread for \"" + uuid + "\" found in : " + Arrays.toString(threads)), found);
        SystemBundleTests.assertEquals((String)"Wrong daemon type.", (boolean)expectIsDeamon, (boolean)found.isDaemon());
    }

    public void testWindowsAlias() {
        String origOS = System.getProperty("os.name");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        System.setProperty("os.name", "Windows 5000");
        Equinox equinox = null;
        try {
            try {
                equinox = new Equinox(configuration);
                equinox.init();
                Assert.assertEquals((String)"Wrong framework os name value", (Object)"win32", (Object)equinox.getBundleContext().getProperty("org.osgi.framework.os.name"));
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Failed init", (Throwable)e);
                System.setProperty("os.name", origOS);
                try {
                    if (equinox != null) {
                        equinox.stop();
                        equinox.waitForStop(1000L);
                    }
                }
                catch (BundleException e2) {
                    SystemBundleTests.fail((String)"Failed to stop framework.", (Throwable)e2);
                }
                catch (InterruptedException e3) {
                    SystemBundleTests.fail((String)"Failed to stop framework.", (Throwable)e3);
                }
            }
        }
        finally {
            System.setProperty("os.name", origOS);
            try {
                if (equinox != null) {
                    equinox.stop();
                    equinox.waitForStop(1000L);
                }
            }
            catch (BundleException e) {
                SystemBundleTests.fail((String)"Failed to stop framework.", (Throwable)e);
            }
            catch (InterruptedException e) {
                SystemBundleTests.fail((String)"Failed to stop framework.", (Throwable)e);
            }
        }
    }

    class TestHandler
    extends AbstractURLStreamHandlerService {
        TestHandler() {
        }

        public URLConnection openConnection(URL u) throws IOException {
            throw new IOException();
        }

        public URLConnection openConnection(URL u, Proxy p) throws IOException {
            throw new IOException();
        }
    }
}

