/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.SocketFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTest;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EclipseStarterConfigIniTest
extends OSGiTest {
    public static Test suite() {
        TestSuite suite = new TestSuite(EclipseStarterConfigIniTest.class.getName());
        ConfigurationSessionTestSuite falseCompatBootDelegation = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", EclipseStarterConfigIniTest.class.getName());
        String[] ids = ConfigurationSessionTestSuite.MINIMAL_BUNDLE_SET;
        int i = 0;
        while (i < ids.length) {
            falseCompatBootDelegation.addBundle(ids[i]);
            ++i;
        }
        falseCompatBootDelegation.addBundle("org.eclipse.osgi.tests");
        falseCompatBootDelegation.addTest((Test)new EclipseStarterConfigIniTest("testFalseCompatBootDelegation"));
        falseCompatBootDelegation.setConfigIniValue("osgi.compatibility.bootdelegation", "false");
        suite.addTest((Test)falseCompatBootDelegation);
        ConfigurationSessionTestSuite defaultCompatBootDelegation = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", EclipseStarterConfigIniTest.class.getName());
        int i2 = 0;
        while (i2 < ids.length) {
            defaultCompatBootDelegation.addBundle(ids[i2]);
            ++i2;
        }
        defaultCompatBootDelegation.addBundle("org.eclipse.osgi.tests");
        defaultCompatBootDelegation.addTest((Test)new EclipseStarterConfigIniTest("testDefaultCompatBootDelegation"));
        suite.addTest((Test)defaultCompatBootDelegation);
        return suite;
    }

    public EclipseStarterConfigIniTest(String name) {
        super(name);
    }

    public void testFalseCompatBootDelegation() throws Exception {
        this.doTestCompatBootDelegation(true);
    }

    public void testDefaultCompatBootDelegation() throws Exception {
        this.doTestCompatBootDelegation(false);
    }

    public void doTestCompatBootDelegation(boolean expectFailure) throws Exception {
        block3: {
            BundleContext context = OSGiTestsActivator.getContext();
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(bytesOut);
            zipOut.putNextEntry(new ZipEntry("nothing"));
            zipOut.closeEntry();
            zipOut.close();
            Bundle b = context.installBundle(this.getName(), (InputStream)new ByteArrayInputStream(bytesOut.toByteArray()));
            String testClassName = SocketFactory.class.getName();
            try {
                b.loadClass(testClassName);
                if (expectFailure) {
                    EclipseStarterConfigIniTest.fail((String)"Expected to fail to load VM class from bundle that does not import it");
                }
            }
            catch (ClassNotFoundException e) {
                if (expectFailure) break block3;
                EclipseStarterConfigIniTest.fail((String)"Expected to successfully load VM class from bundle that does not import it", (Throwable)e);
            }
        }
    }
}

