/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;

public class ClassLoaderHookTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "substitutes.a";
    private static final String TEST_CLASSNAME = "substitutes.x.Ax";
    private static final String HOOK_CONFIGURATOR_BUNDLE = "classloader.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS = "org.eclipse.osgi.tests.classloader.hooks.a.TestHookConfigurator";
    private static final String REJECT_PROP = "classloader.hooks.a.reject";
    private static final String BAD_TRANSFORM_PROP = "classloader.hooks.a.bad.transform";
    private static final String RECURSION_LOAD = "classloader.hooks.a.recursion.load";
    private static final String RECURSION_LOAD_SUPPORTED = "classloader.hooks.a.recursion.load.supported";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setRejectTransformation(false);
        this.setBadTransform(false);
        this.setRecursionLoad(false);
        this.setRecursionLoadSupported(false);
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.hook.configurators.include", HOOK_CONFIGURATOR_CLASS);
        this.framework = this.createFramework(this.configuration);
    }

    @Override
    protected void tearDown() throws Exception {
        this.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    private void setRejectTransformation(boolean value) {
        System.setProperty(REJECT_PROP, Boolean.toString(value));
    }

    private void setBadTransform(boolean value) {
        System.setProperty(BAD_TRANSFORM_PROP, Boolean.toString(value));
    }

    private void setRecursionLoad(boolean value) {
        System.setProperty(RECURSION_LOAD, Boolean.toString(value));
    }

    private void setRecursionLoadSupported(boolean value) {
        System.setProperty(RECURSION_LOAD_SUPPORTED, Boolean.toString(value));
    }

    public void testRejectTransformationFromWeavingHook() throws Exception {
        this.setRejectTransformation(true);
        this.initAndStartFramework();
        this.framework.getBundleContext().registerService(WeavingHook.class, (Object)new WeavingHook(){

            public void weave(WovenClass wovenClass) {
                wovenClass.setBytes(new byte[]{98, 97, 100, 98, 121, 116, 101, 115});
                wovenClass.getDynamicImports().add("badimport");
            }
        }, null);
        Bundle b = this.installBundle();
        b.loadClass(TEST_CLASSNAME);
        ClassLoaderHookTests.assertEquals((String)"Found some imports.", (int)0, (int)((BundleRevision)b.adapt(BundleRevision.class)).getWiring().getRequirements("osgi.wiring.package").size());
        this.setRejectTransformation(false);
        this.refreshBundles(Collections.singleton(b));
        try {
            b.loadClass(TEST_CLASSNAME);
            ClassLoaderHookTests.fail((String)"Expected a ClassFormatError.");
        }
        catch (ClassFormatError classFormatError) {}
        ClassLoaderHookTests.assertEquals((String)"Found some imports.", (int)1, (int)((BundleRevision)b.adapt(BundleRevision.class)).getWiring().getRequirements("osgi.wiring.package").size());
    }

    public void testRejectTransformationFromClassLoadingHook() throws Exception {
        this.setRejectTransformation(true);
        this.setBadTransform(true);
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        b.loadClass(TEST_CLASSNAME);
        this.setRejectTransformation(false);
        this.refreshBundles(Collections.singleton(b));
        try {
            b.loadClass(TEST_CLASSNAME);
            ClassLoaderHookTests.fail((String)"Expected a ClassFormatError.");
        }
        catch (ClassFormatError classFormatError) {}
    }

    public void testRecursionFromClassLoadingHookNotSupported() throws Exception {
        this.setRecursionLoad(true);
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        b.loadClass(TEST_CLASSNAME);
    }

    public void testRecursionFromClassLoadingHookIsSupported() throws Exception {
        this.setRecursionLoad(true);
        this.setRecursionLoadSupported(true);
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        b.loadClass(TEST_CLASSNAME);
    }

    private void refreshBundles(Collection<Bundle> bundles) throws InterruptedException {
        final CountDownLatch refreshSignal = new CountDownLatch(1);
        ((FrameworkWiring)this.framework.adapt(FrameworkWiring.class)).refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    refreshSignal.countDown();
                }
            }
        }});
        refreshSignal.await(30L, TimeUnit.SECONDS);
    }
}

