/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermission;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.permissions.PermissionTests;
import org.osgi.framework.ServicePermission;

public class ServicePermissionTests
extends PermissionTests {
    public static Test suite() {
        return new TestSuite(ServicePermissionTests.class);
    }

    public void testServicePermission() {
        this.badServicePermission("a.b.c", "x");
        this.badServicePermission("a.b.c", "   get  ,  x   ");
        this.badServicePermission("a.b.c", "");
        this.badServicePermission("a.b.c", "      ");
        this.badServicePermission("a.b.c", null);
        this.badServicePermission("a.b.c", ",");
        this.badServicePermission("a.b.c", ",xxx");
        this.badServicePermission("a.b.c", "xxx,");
        this.badServicePermission("a.b.c", "get,");
        this.badServicePermission("a.b.c", "register,   ");
        this.badServicePermission("a.b.c", "getme,");
        this.badServicePermission("a.b.c", "registerme,");
        this.badServicePermission("a.b.c", ",get");
        this.badServicePermission("a.b.c", ",register");
        this.badServicePermission("a.b.c", "   getme   ");
        this.badServicePermission("a.b.c", "   registerme     ");
        this.badServicePermission("a.b.c", "   ge");
        this.badServicePermission("a.b.c", "   registe");
        PropertyPermission op = new PropertyPermission("java.home", "read");
        ServicePermission p11 = new ServicePermission("com.foo.service1", "    GET,register   ");
        ServicePermission p12 = new ServicePermission("com.foo.service1", "REGISTER  ,   get");
        ServicePermission p13 = new ServicePermission("com.foo.service1", "regisTER   ");
        ServicePermission p14 = new ServicePermission("com.foo.service1", "    Get    ");
        this.shouldImply((Permission)p11, (Permission)p11);
        this.shouldImply((Permission)p11, (Permission)p12);
        this.shouldImply((Permission)p11, (Permission)p13);
        this.shouldImply((Permission)p11, (Permission)p14);
        this.shouldImply((Permission)p12, (Permission)p11);
        this.shouldImply((Permission)p12, (Permission)p12);
        this.shouldImply((Permission)p12, (Permission)p13);
        this.shouldImply((Permission)p12, (Permission)p14);
        this.shouldImply((Permission)p13, (Permission)p13);
        this.shouldImply((Permission)p14, (Permission)p14);
        this.shouldNotImply((Permission)p13, (Permission)p11);
        this.shouldNotImply((Permission)p13, (Permission)p12);
        this.shouldNotImply((Permission)p14, (Permission)p11);
        this.shouldNotImply((Permission)p14, (Permission)p12);
        this.shouldNotImply((Permission)p13, (Permission)p14);
        this.shouldNotImply((Permission)p14, (Permission)p13);
        this.shouldNotImply((Permission)p11, (Permission)op);
        this.shouldEqual((Permission)p11, (Permission)p11);
        this.shouldEqual((Permission)p11, (Permission)p12);
        this.shouldEqual((Permission)p12, (Permission)p11);
        this.shouldEqual((Permission)p12, (Permission)p12);
        this.shouldEqual((Permission)p13, (Permission)p13);
        this.shouldEqual((Permission)p14, (Permission)p14);
        this.shouldNotEqual((Permission)p11, (Permission)p13);
        this.shouldNotEqual((Permission)p11, (Permission)p14);
        this.shouldNotEqual((Permission)p12, (Permission)p13);
        this.shouldNotEqual((Permission)p12, (Permission)p14);
        this.shouldNotEqual((Permission)p13, (Permission)p11);
        this.shouldNotEqual((Permission)p13, (Permission)p12);
        this.shouldNotEqual((Permission)p13, (Permission)p14);
        this.shouldNotEqual((Permission)p14, (Permission)p11);
        this.shouldNotEqual((Permission)p14, (Permission)p12);
        this.shouldNotEqual((Permission)p14, (Permission)p13);
        PermissionCollection pc = p13.newPermissionCollection();
        this.checkEnumeration(pc.elements(), true);
        this.shouldNotImply(pc, (Permission)p11);
        this.shouldAdd(pc, (Permission)p14);
        this.shouldImply(pc, (Permission)p14);
        this.shouldNotImply(pc, (Permission)p11);
        this.shouldNotImply(pc, (Permission)p12);
        this.shouldNotImply(pc, (Permission)p13);
        this.shouldAdd(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        this.shouldNotAdd(pc, op);
        pc = p13.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p13);
        this.shouldNotImply(pc, (Permission)p11);
        this.shouldNotImply(pc, (Permission)p12);
        this.shouldNotImply(pc, (Permission)p14);
        this.shouldAdd(pc, (Permission)p14);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        pc = p11.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        pc.setReadOnly();
        this.shouldNotAdd(pc, (Permission)p12);
        this.checkEnumeration(pc.elements(), false);
        ServicePermission p21 = new ServicePermission("com.foo.service2", "get");
        ServicePermission p22 = new ServicePermission("com.foo.*", "get");
        ServicePermission p23 = new ServicePermission("com.*", "get");
        ServicePermission p24 = new ServicePermission("*", "get");
        this.shouldImply((Permission)p21, (Permission)p21);
        this.shouldImply((Permission)p22, (Permission)p21);
        this.shouldImply((Permission)p23, (Permission)p21);
        this.shouldImply((Permission)p24, (Permission)p21);
        this.shouldImply((Permission)p22, (Permission)p22);
        this.shouldImply((Permission)p23, (Permission)p22);
        this.shouldImply((Permission)p24, (Permission)p22);
        this.shouldImply((Permission)p23, (Permission)p23);
        this.shouldImply((Permission)p24, (Permission)p23);
        this.shouldImply((Permission)p24, (Permission)p24);
        this.shouldNotImply((Permission)p21, (Permission)p22);
        this.shouldNotImply((Permission)p21, (Permission)p23);
        this.shouldNotImply((Permission)p21, (Permission)p24);
        this.shouldNotImply((Permission)p22, (Permission)p23);
        this.shouldNotImply((Permission)p22, (Permission)p24);
        this.shouldNotImply((Permission)p23, (Permission)p24);
        pc = p21.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p21);
        this.shouldNotImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p24);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p24);
        pc = p22.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        pc = p23.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        pc = p24.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p24);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p24);
        this.testSerialization((Permission)p11);
        this.testSerialization((Permission)p12);
        this.testSerialization((Permission)p13);
        this.testSerialization((Permission)p14);
        this.testSerialization((Permission)p21);
        this.testSerialization((Permission)p22);
        this.testSerialization((Permission)p23);
        this.testSerialization((Permission)p24);
    }
}

