/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestGrouping_003
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;
    BundleDescription bundle_4 = null;
    BundleDescription bundle_5 = null;

    public TestGrouping_003(String testName) {
        super(testName);
    }

    public void testTest_003() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.bundle_4 = this.create_bundle_4(sof);
        this.bundle_5 = this.create_bundle_5(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestGrouping_003.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        TestGrouping_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestGrouping_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestGrouping_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("r")) {
                TestGrouping_003.assertNotNull((String)"Package [r] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [r] is wired incorrectly ", exp.getExporter(), this.bundle_2);
            } else if (exportPackageName.equals("s")) {
                TestGrouping_003.assertNotNull((String)"Package [s] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [s] is wired incorrectly ", exp.getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiringState_2() {
    }

    public void checkWiringState_3() {
        ExportPackageDescription[] exports = this.bundle_3.getResolvedImports();
        TestGrouping_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestGrouping_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestGrouping_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("p")) {
                TestGrouping_003.assertNotNull((String)"Package [p] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [p] is wired incorrectly ", exp.getExporter(), this.bundle_4);
            } else if (exportPackageName.equals("q")) {
                TestGrouping_003.assertNotNull((String)"Package [q] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [q] is wired incorrectly ", exp.getExporter(), this.bundle_4);
            }
            ++i;
        }
    }

    public void checkWiringState_4() {
    }

    public void checkWiringState_5() {
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
        this.checkWiringState_4();
        this.checkWiringState_5();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestGrouping_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestGrouping_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        TestGrouping_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_4);
        TestGrouping_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_5);
        TestGrouping_003.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestGrouping_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestGrouping_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_2.isResolved());
        TestGrouping_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
        TestGrouping_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_4.isResolved());
        TestGrouping_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_5.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Export-Package", "foo; version=\"1.0\"; a=x; b=y");
        ((Dictionary)dictionary_1).put("Import-Package", "r; version=2.0, s; version=\"[2.0, 2.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestGrouping_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Export-Package", "r; s; version=2.0; uses:=\"r,s\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestGrouping_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "C");
        ((Dictionary)dictionary_3).put("Export-Package", "r; s; version=2.1; uses:=\"r,s\"");
        ((Dictionary)dictionary_3).put("Import-Package", "p; version=2.0, q; version=\"[2.0, 2.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            TestGrouping_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_4(StateObjectFactory sof) {
        Properties dictionary_4 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_4).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_4).put("Bundle-SymbolicName", "D");
        ((Dictionary)dictionary_4).put("Export-Package", "p; q; version=2.0; uses:=\"p,q\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_4, "bundle_4", 4L);
        }
        catch (BundleException be) {
            TestGrouping_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_5(StateObjectFactory sof) {
        Properties dictionary_5 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_5).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_5).put("Bundle-SymbolicName", "E");
        ((Dictionary)dictionary_5).put("Export-Package", "p; q; version=2.1; uses:=\"p,q\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_5, "bundle_5", 5L);
        }
        catch (BundleException be) {
            TestGrouping_003.fail((String)be.getMessage());
        }
        return bundle;
    }
}

