/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.File;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SignedBundleTest
extends BaseSecurityTest {
    public SignedBundleTest() {
    }

    public SignedBundleTest(String name, String jarname, String[] aliases) {
        super(name);
    }

    public static Test suite() {
        ConfigurationSessionTestSuite suite = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", "Unit session tests for SignedContent");
        SignedBundleTest.addDefaultSecurityBundles(suite);
        suite.addTestSuite(SignedBundleTest.class);
        return suite;
    }

    public static Test localSuite() {
        return new TestSuite(SignedBundleTest.class, "Unit local tests for SignedContent");
    }

    protected void setUp() throws Exception {
        this.registerEclipseTrustEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSignedContent01() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("unsigned"));
                SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                }
                catch (BundleException e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
            }
            catch (BundleException e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent02() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed"));
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                signedContent.checkValidity(infos[0]);
                SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
                SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
                SignedContentEntry[] entries = signedContent.getSignedEntries();
                SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
                int i = 0;
                while (i < entries.length) {
                    entries[i].verify();
                    SignerInfo[] entryInfos = entries[i].getSignerInfos();
                    SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                    this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
                this.getTrustEngine().removeTrustAnchor("ca1_leafa");
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent03() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca2_leafa"), "ca2_leafa");
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
                int i = 0;
                while (i < infos.length) {
                    signedContent.checkValidity(infos[i]);
                    signedContent.checkValidity(infos[i]);
                    SignedBundleTest.assertTrue((String)("Signer is not trusted: " + infos[i].getCertificateChain()[0]), (boolean)infos[i].isTrusted());
                    SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[i].getTrustAnchor());
                    ++i;
                }
                SignedContentEntry[] entries = signedContent.getSignedEntries();
                SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
                int i2 = 0;
                while (i2 < entries.length) {
                    entries[i2].verify();
                    SignerInfo[] entryInfos = entries[i2].getSignerInfos();
                    SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)2, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                    ++i2;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                    this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                    this.getTrustEngine().removeTrustAnchor("ca2_leafa");
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
                this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                this.getTrustEngine().removeTrustAnchor("ca2_leafa");
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent04() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed"));
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                int i = 0;
                while (i < infos.length) {
                    SignedBundleTest.assertTrue((String)("Signer is trusted: " + infos[i].getCertificateChain()[0]), (!infos[i].isTrusted() ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                }
                catch (BundleException e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
            }
            catch (BundleException e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent05() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
                int i = 0;
                while (i < infos.length) {
                    SignedBundleTest.assertTrue((String)("Signer is trusted: " + infos[i].getCertificateChain()[0]), (!infos[i].isTrusted() ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                }
                catch (BundleException e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
            }
            catch (BundleException e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent06() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("multiply_signed"));
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
                int i = 0;
                while (i < infos.length) {
                    Certificate[] certs = infos[i].getCertificateChain();
                    if (infos[i].isTrusted()) {
                        X509Certificate x509Cert = (X509Certificate)certs[0];
                        SignedBundleTest.assertTrue((String)"CA1 LeafA signer is not trusted", (x509Cert.getSubjectDN().getName().indexOf("CA1 LeafA") >= 0 ? 1 : 0) != 0);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                    this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
                this.getTrustEngine().removeTrustAnchor("ca1_leafa");
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent07() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                SignedContentEntry[] entries = signedContent.getSignedEntries();
                SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
                int i = 0;
                while (i < entries.length) {
                    block15: {
                        try {
                            entries[i].verify();
                            if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entries[i].getName())) {
                                SignedBundleTest.fail((String)("Expected a corruption for: " + entries[i].getName()));
                            }
                        }
                        catch (InvalidContentException e) {
                            if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entries[i].getName())) break block15;
                            SignedBundleTest.fail((String)("Unexpected corruption in: " + entries[i].getName()), (Throwable)e);
                        }
                    }
                    SignerInfo[] entryInfos = entries[i].getSignerInfos();
                    SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                    this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
                this.getTrustEngine().removeTrustAnchor("ca1_leafa");
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent07a() {
        block15: {
            Bundle testBundle = null;
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
                testBundle.loadClass("org.eclipse.equinox.security.junit.CorruptClass");
            }
            catch (LinkageError error) {
                if ("all".equals(System.getProperty("osgi.signedcontent.support"))) {
                    Throwable t = error.getCause();
                    SignedBundleTest.assertTrue((String)("Cause is the wrong type: " + t), (boolean)(t instanceof InvalidContentException));
                }
                try {
                    testBundle.uninstall();
                }
                catch (Exception exception) {}
                break block15;
            }
            catch (Exception e) {
                try {
                    SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        testBundle.uninstall();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    testBundle.uninstall();
                }
                catch (Exception exception) {}
                break block15;
            }
            try {
                testBundle.uninstall();
            }
            catch (Exception exception) {}
        }
    }

    public void testSignedContent08() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_tsa"));
                this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                SignedBundleTest.assertNotNull((String)"Signing time is null!", (Object)signedContent.getSigningTime(infos[0]));
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                    this.getTrustEngine().removeTrustAnchor("ca1_leafa");
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
                this.getTrustEngine().removeTrustAnchor("ca1_leafa");
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testSignedContent09() {
        try {
            File unsignedFile = this.getEntryFile(SignedBundleTest.getTestJarPath("unsigned"));
            SignedBundleTest.assertNotNull((String)"Could not find unsigned file!", (Object)unsignedFile);
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(unsignedFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent10() {
        try {
            File signedFile = this.getEntryFile(SignedBundleTest.getTestJarPath("signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            signedContent.checkValidity(infos[0]);
            SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
            SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            int i = 0;
            while (i < entries.length) {
                entries[i].verify();
                SignerInfo[] entryInfos = entries[i].getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++i;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent11() {
        try {
            File multipleSigned = this.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca2_leafa"), "ca2_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            int i = 0;
            while (i < infos.length) {
                signedContent.checkValidity(infos[i]);
                signedContent.checkValidity(infos[i]);
                SignedBundleTest.assertTrue((String)("Signer is not trusted: " + infos[i].getCertificateChain()[0]), (boolean)infos[i].isTrusted());
                SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[i].getTrustAnchor());
                ++i;
            }
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            int i2 = 0;
            while (i2 < entries.length) {
                entries[i2].verify();
                SignerInfo[] entryInfos = entries[i2].getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)2, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++i2;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent12() {
        try {
            File signedFile = this.getEntryFile(SignedBundleTest.getTestJarPath("signed"));
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            int i = 0;
            while (i < infos.length) {
                SignedBundleTest.assertTrue((String)("Signer is trusted: " + infos[i].getCertificateChain()[0]), (!infos[i].isTrusted() ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent13() {
        try {
            File multipleSigned = this.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            int i = 0;
            while (i < infos.length) {
                SignedBundleTest.assertTrue((String)("Signer is trusted: " + infos[i].getCertificateChain()[0]), (!infos[i].isTrusted() ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent14() {
        try {
            File multipleSigned = this.getEntryFile(SignedBundleTest.getTestJarPath("multiply_signed"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(multipleSigned);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)2, (int)infos.length);
            int i = 0;
            while (i < infos.length) {
                Certificate[] certs = infos[i].getCertificateChain();
                if (infos[i].isTrusted()) {
                    X509Certificate x509Cert = (X509Certificate)certs[0];
                    SignedBundleTest.assertTrue((String)"CA1 LeafA signer is not trusted", (x509Cert.getSubjectDN().getName().indexOf("CA1 LeafA") >= 0 ? 1 : 0) != 0);
                }
                ++i;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent15() {
        try {
            File corruptedFile = this.getEntryFile(SignedBundleTest.getTestJarPath("signed_with_corrupt"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(corruptedFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            SignedContentEntry[] entries = signedContent.getSignedEntries();
            SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
            int i = 0;
            while (i < entries.length) {
                block6: {
                    try {
                        entries[i].verify();
                        if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entries[i].getName())) {
                            SignedBundleTest.fail((String)("Expected a corruption for: " + entries[i].getName()));
                        }
                    }
                    catch (InvalidContentException e) {
                        if ("org/eclipse/equinox/security/junit/CorruptClass.class".equals(entries[i].getName())) break block6;
                        SignedBundleTest.fail((String)("Unexpected corruption in: " + entries[i].getName()), (Throwable)e);
                    }
                }
                SignerInfo[] entryInfos = entries[i].getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                ++i;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testSignedContent16() {
        try {
            File signedTsaFile = this.getEntryFile(SignedBundleTest.getTestJarPath("signed_tsa"));
            this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedTsaFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
            SignerInfo[] infos = signedContent.getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
            SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
            SignedBundleTest.assertNotNull((String)"Signing time is null!", (Object)signedContent.getSigningTime(infos[0]));
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBug225090_01() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed"));
        this.getTrustEngine().addTrustAnchor(SignedBundleTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
        SignerInfo[] infos = signedContent.getSignerInfos();
        SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
        SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
        signedContent.checkValidity(infos[0]);
        SignedBundleTest.assertTrue((String)"Signer is not trusted", (boolean)infos[0].isTrusted());
        SignedBundleTest.assertNotNull((String)"Trust anchor is null", (Object)infos[0].getTrustAnchor());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        int i = 0;
        while (i < entries.length) {
            entries[i].verify();
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
            ++i;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug225090_02() throws Exception {
        File unsignedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("unsigned"));
        SignedBundleTest.assertNotNull((String)"Could not find unsigned file!", (Object)unsignedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(unsignedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertFalse((String)"Content is signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        int i = 0;
        while (i < entries.length) {
            entries[i].verify();
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)0, (int)entryInfos.length);
            ++i;
        }
        unsignedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)unsignedFile.exists());
    }

    public void testBug228427_01() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        int i = 0;
        while (i < entries.length) {
            entries[i].verify();
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++i;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_02() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_added"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        int i = 0;
        while (i < entries.length) {
            entries[i].verify();
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++i;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_03() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_corrupt"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        int i = 0;
        while (i < entries.length) {
            try {
                entries[i].verify();
                SignedBundleTest.assertFalse((String)("Wrong entry is validated: " + entries[i].getName()), (boolean)"META-INF/test/test1.file".equals(entries[i].getName()));
            }
            catch (InvalidContentException invalidContentException) {
                SignedBundleTest.assertEquals((String)"Wrong entry is corrupted", (String)"META-INF/test/test1.file", (String)entries[i].getName());
            }
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++i;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug228427_04() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_metadata_removed"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        SignedContent signedContent = this.getSignedContentFactory().getSignedContent(signedFile);
        SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
        SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
        SignedContentEntry[] entries = signedContent.getSignedEntries();
        SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
        SignedBundleTest.assertEquals((String)"Incorrect number of signed entries", (int)4, (int)entries.length);
        int i = 0;
        while (i < entries.length) {
            try {
                entries[i].verify();
                SignedBundleTest.assertFalse((String)("Wrong entry is validated: " + entries[i].getName()), (boolean)"META-INF/test.file".equals(entries[i].getName()));
            }
            catch (InvalidContentException invalidContentException) {
                SignedBundleTest.assertEquals((String)"Wrong entry is corrupted", (String)"META-INF/test.file", (String)entries[i].getName());
            }
            SignerInfo[] entryInfos = entries[i].getSignerInfos();
            SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
            SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
            ++i;
        }
        signedFile.delete();
        SignedBundleTest.assertFalse((String)"File should not exist", (boolean)signedFile.exists());
    }

    public void testBug236329_01() throws Exception {
        File signedFile = this.copyEntryFile(SignedBundleTest.getTestJarPath("signed_with_sf_corrupted"));
        SignedBundleTest.assertNotNull((String)"Could not find signed file!", (Object)signedFile);
        try {
            this.getSignedContentFactory().getSignedContent(signedFile);
            SignedBundleTest.fail((String)("Should have gotten a SignatureException for file: " + signedFile));
        }
        catch (SignatureException signatureException) {}
    }

    public void testBug252098() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("test.bug252098"));
                SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
                testBundle.start();
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    if (testBundle != null) {
                        testBundle.uninstall();
                    }
                }
                catch (BundleException e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (testBundle != null) {
                    testBundle.uninstall();
                }
            }
            catch (BundleException e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testBug378155() {
        this.doTestBug378155("SHA1withDSA");
        this.doTestBug378155("SHA1withRSA");
        this.doTestBug378155("SHA256withRSA");
        this.doTestBug378155("SHA384withRSA");
        this.doTestBug378155("SHA512withRSA");
    }

    private void doTestBug378155(String bundleName) {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath(bundleName));
                SignedBundleTest.assertNotNull((String)"Test bundle not installed!", (Object)testBundle);
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                signedContent.checkValidity(infos[0]);
                SignedBundleTest.assertFalse((String)"Signer is trusted", (boolean)infos[0].isTrusted());
                SignedBundleTest.assertNull((String)"Trust anchor is not null", (Object)infos[0].getTrustAnchor());
                SignedContentEntry[] entries = signedContent.getSignedEntries();
                SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
                int i = 0;
                while (i < entries.length) {
                    entries[i].verify();
                    SignerInfo[] entryInfos = entries[i].getSignerInfos();
                    SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    if (testBundle != null) {
                        testBundle.uninstall();
                    }
                }
                catch (BundleException e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (testBundle != null) {
                    testBundle.uninstall();
                }
            }
            catch (BundleException e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }

    public void testBug434711() {
        try {
            File nonAsciiFile = this.getEntryFile(SignedBundleTest.getTestJarPath("bundleWithNonAsciiCharsFilename"));
            SignedBundleTest.assertNotNull((String)"Could not find Non Ascii Chars file!", (Object)nonAsciiFile);
            SignedContent signedContent = this.getSignedContentFactory().getSignedContent(nonAsciiFile);
            SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
            SignedBundleTest.assertTrue((String)"Content is not signed!!", (boolean)signedContent.isSigned());
            SignedContentEntry[] signedContentEntryArray = signedContent.getSignedEntries();
            int n = signedContentEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                SignedContentEntry entry = signedContentEntryArray[n2];
                entry.verify();
                ++n2;
            }
        }
        catch (Exception e) {
            SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void test489686() {
        Bundle testBundle = null;
        try {
            try {
                testBundle = this.installBundle(SignedBundleTest.getTestJarPath("signed_with_missing_digest"));
                SignedContent signedContent = this.getSignedContentFactory().getSignedContent(testBundle);
                SignedBundleTest.assertNotNull((String)"SignedContent is null", (Object)signedContent);
                SignedBundleTest.assertTrue((String)"Should be signed", (boolean)signedContent.isSigned());
                SignerInfo[] infos = signedContent.getSignerInfos();
                SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)infos);
                SignedBundleTest.assertEquals((String)"wrong number of signers", (int)1, (int)infos.length);
                SignedContentEntry[] entries = signedContent.getSignedEntries();
                SignedBundleTest.assertNotNull((String)"Entries is null", (Object)entries);
                int i = 0;
                while (i < entries.length) {
                    try {
                        entries[i].verify();
                        SignedBundleTest.fail((String)("Expected a corruption for: " + entries[i].getName()));
                    }
                    catch (InvalidContentException invalidContentException) {}
                    SignerInfo[] entryInfos = entries[i].getSignerInfos();
                    SignedBundleTest.assertNotNull((String)"SignerInfo is null", (Object)entryInfos);
                    SignedBundleTest.assertEquals((String)"wrong number of entry signers", (int)1, (int)entryInfos.length);
                    SignedBundleTest.assertEquals((String)"Entry signer does not equal content signer", (Object)infos[0], (Object)entryInfos[0]);
                    ++i;
                }
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Unexpected exception", (Throwable)e);
                try {
                    testBundle.uninstall();
                }
                catch (Exception e2) {
                    SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                testBundle.uninstall();
            }
            catch (Exception e) {
                SignedBundleTest.fail((String)"Failed to uninstall bundle", (Throwable)e);
            }
        }
    }
}

