/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.securityadmin;

import java.io.File;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.condpermadmin.BundleLocationCondition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.osgi.service.startlevel.StartLevel;

public class SecurityManagerTests
extends AbstractBundleTests {
    private static final PermissionInfo hostFragmentPermission = new PermissionInfo(BundlePermission.class.getName(), "*", "host,fragment");
    private static final PermissionInfo hostFragmentProvidePermission = new PermissionInfo(BundlePermission.class.getName(), "*", "host,fragment,provide");
    private static final PermissionInfo allPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "*", "import,export");
    private static final PermissionInfo importPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "*", "import");
    private static final PermissionInfo importFrameworkPackagePermission = new PermissionInfo(PackagePermission.class.getName(), "org.osgi.framework", "import");
    private Policy previousPolicy;

    public static Test suite() {
        return new TestSuite(SecurityManagerTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        if (System.getSecurityManager() != null) {
            SecurityManagerTests.fail((String)"Cannot test with security manager set");
        }
        this.previousPolicy = Policy.getPolicy();
        final AllPermission allPermission = new AllPermission();
        final PermissionCollection allPermissions = new PermissionCollection(){
            private static final long serialVersionUID = 3258131349494708277L;

            @Override
            public void add(Permission permission) {
            }

            @Override
            public boolean implies(Permission permission) {
                return true;
            }

            public Enumeration elements() {
                return new Enumeration(){
                    int cur = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.cur < 1;
                    }

                    public Object nextElement() {
                        if (this.cur == 0) {
                            this.cur = 1;
                            return allPermission;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                return allPermissions;
            }

            @Override
            public void refresh() {
            }
        });
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (System.getSecurityManager() != null) {
            System.setSecurityManager(null);
        }
        Policy.setPolicy(this.previousPolicy);
    }

    public void testEnableSecurityManager01() {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager01");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testEnableSecurityManager02() throws BundleException {
        Equinox equinox;
        block13: {
            File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager02");
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("org.osgi.framework.security", "osgi");
            equinox = new Equinox(configuration);
            try {
                equinox.init();
            }
            catch (BundleException e) {
                SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
            }
            SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
            SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
            BundleContext systemContext = equinox.getBundleContext();
            SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
            String locationSecurityA = installer.getBundleLocation("security.a");
            String locationSecurityAFragA = installer.getBundleLocation("security.a.frag.a");
            ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
            ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
            List rows = update.getConditionalPermissionInfos();
            rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, allPackagePermission}, "allow"));
            SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            Bundle securityA = systemContext.installBundle(locationSecurityA);
            systemContext.installBundle(locationSecurityAFragA);
            equinox.start();
            try {
                try {
                    securityA.start();
                }
                catch (BundleException e) {
                    SecurityManagerTests.fail((String)"Failed to start securityA", (Throwable)e);
                    equinox.stop();
                    try {
                        equinox.waitForStop(10000L);
                    }
                    catch (InterruptedException e2) {
                        SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e2);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                equinox.stop();
                try {
                    equinox.waitForStop(10000L);
                }
                catch (InterruptedException e) {
                    SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
                }
                throw throwable;
            }
            equinox.stop();
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testEnableSecurityManager03() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager03");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationSecurityA = installer.getBundleLocation("security.a");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, importPackagePermission}, "allow"));
        SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle securityA = systemContext.installBundle(locationSecurityA);
        equinox.start();
        PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
        try {
            SecurityManagerTests.assertTrue((boolean)pa.resolveBundles(new Bundle[]{securityA}));
            ExportedPackage[] eps = pa.getExportedPackages(securityA);
            SecurityManagerTests.assertNull((String)"Found unexpected exports", (Object)eps);
            RequiredBundle[] rbs = pa.getRequiredBundles(securityA.getSymbolicName());
            SecurityManagerTests.assertNull((String)"Found unexpected required bundle", (Object)rbs);
            update = ca.newConditionalPermissionUpdate();
            rows = update.getConditionalPermissionInfos();
            rows.clear();
            rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
            SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            securityA.uninstall();
            securityA = systemContext.installBundle(locationSecurityA);
            SecurityManagerTests.assertTrue((boolean)pa.resolveBundles(new Bundle[]{securityA}));
            eps = pa.getExportedPackages(securityA);
            SecurityManagerTests.assertNotNull((String)"Did not find expected exports", (Object)eps);
            SecurityManagerTests.assertEquals((String)"Wrong number of exports found", (int)1, (int)eps.length);
            rbs = pa.getRequiredBundles(securityA.getSymbolicName());
            SecurityManagerTests.assertNotNull((String)"Did not find required bundle", (Object)eps);
            SecurityManagerTests.assertEquals((String)"Wrong number of required bundles found", (int)1, (int)rbs.length);
        }
        finally {
            equinox.stop();
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testEnableSecurityManager04() throws BundleException {
        Equinox equinox;
        block13: {
            File config = OSGiTestsActivator.getContext().getDataFile("testEnableSecurityManager04");
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("org.osgi.framework.security", "osgi");
            equinox = new Equinox(configuration);
            try {
                equinox.init();
            }
            catch (BundleException e) {
                SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
            }
            SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
            SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
            BundleContext systemContext = equinox.getBundleContext();
            SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
            String locationLinkA = installer.getBundleLocation("test.link.a");
            String locationLinkAClient = installer.getBundleLocation("test.link.a.client");
            ConditionInfo linkACondition = new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{locationLinkA});
            ConditionInfo linkAClientCondition = new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{locationLinkAClient});
            PermissionInfo filterPermission = new PermissionInfo(PackagePermission.class.getName(), "(&(name=test.link.a)(package.name=test.link.*))", "import");
            ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
            ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
            List rows = update.getConditionalPermissionInfos();
            rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkACondition}, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
            rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkAClientCondition}, new PermissionInfo[]{importFrameworkPackagePermission, filterPermission}, "allow"));
            SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            Bundle linkA = systemContext.installBundle(locationLinkA);
            Bundle linkAClient = systemContext.installBundle(locationLinkAClient);
            equinox.start();
            PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
            try {
                try {
                    SecurityManagerTests.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
                    filterPermission = new PermissionInfo(PackagePermission.class.getName(), "(&(name=fail.match)(package.name=test.link.*))", "import");
                    update = ca.newConditionalPermissionUpdate();
                    rows = update.getConditionalPermissionInfos();
                    rows.clear();
                    rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkACondition}, new PermissionInfo[]{hostFragmentProvidePermission, allPackagePermission}, "allow"));
                    rows.add(ca.newConditionalPermissionInfo(null, new ConditionInfo[]{linkAClientCondition}, new PermissionInfo[]{importFrameworkPackagePermission, filterPermission}, "allow"));
                    SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
                    pa.refreshPackages(new Bundle[]{linkA, linkAClient});
                    Thread.sleep(2000L);
                    SecurityManagerTests.assertEquals((String)"linkA has wrong state", (int)4, (int)linkA.getState());
                    SecurityManagerTests.assertEquals((String)"linkAClient has wrong state", (int)2, (int)linkAClient.getState());
                }
                catch (InterruptedException e) {
                    SecurityManagerTests.fail((String)"interrupted", (Throwable)e);
                    equinox.stop();
                    try {
                        equinox.waitForStop(10000L);
                    }
                    catch (InterruptedException e2) {
                        SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e2);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                equinox.stop();
                try {
                    equinox.waitForStop(10000L);
                }
                catch (InterruptedException e) {
                    SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
                }
                throw throwable;
            }
            equinox.stop();
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testEnableSecurityManager05() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        String locationLinkA = installer.getBundleLocation("test.link.a");
        String locationLinkAClient = installer.getBundleLocation("test.link.a.client");
        Bundle linkA = systemContext.installBundle(locationLinkA);
        Bundle linkAClient = systemContext.installBundle(locationLinkAClient);
        equinox.start();
        try {
            PackageAdmin pa = (PackageAdmin)systemContext.getService(systemContext.getServiceReference(PackageAdmin.class.getName()));
            SecurityManagerTests.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
            linkA.uninstall();
            linkAClient.uninstall();
            linkA = systemContext.installBundle(locationLinkA);
            linkAClient = systemContext.installBundle(locationLinkAClient);
            SecurityManagerTests.assertTrue((boolean)pa.resolveBundles(new Bundle[]{linkA, linkAClient}));
        }
        finally {
            equinox.stop();
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testLocalization01() throws BundleException {
        Equinox equinox;
        block13: {
            File config = OSGiTestsActivator.getContext().getDataFile("testLocalization01");
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
            configuration.put("org.osgi.framework.security", "osgi");
            equinox = new Equinox(configuration);
            try {
                equinox.init();
            }
            catch (BundleException e) {
                SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
            }
            SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
            SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
            BundleContext systemContext = equinox.getBundleContext();
            SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
            String locationSecurityA = installer.getBundleLocation("security.a");
            String locationSecurityAFragA = installer.getBundleLocation("security.a.frag.a");
            ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
            ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
            List rows = update.getConditionalPermissionInfos();
            rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{hostFragmentPermission, allPackagePermission}, "allow"));
            SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
            Bundle securityA = systemContext.installBundle(locationSecurityA);
            systemContext.installBundle(locationSecurityAFragA);
            equinox.start();
            try {
                try {
                    securityA.start();
                    Dictionary headers = securityA.getHeaders("en_US");
                    String name = (String)headers.get("Bundle-Name");
                    SecurityManagerTests.assertEquals((String)"Wrong Bundle-Name", (String)"en_US", (String)name);
                    headers = securityA.getHeaders("en");
                    name = (String)headers.get("Bundle-Name");
                    SecurityManagerTests.assertEquals((String)"Wrong Bundle-Name", (String)"default", (String)name);
                }
                catch (BundleException e) {
                    SecurityManagerTests.fail((String)"Failed to start securityA", (Throwable)e);
                    equinox.stop();
                    try {
                        equinox.waitForStop(10000L);
                    }
                    catch (InterruptedException e2) {
                        SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e2);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                equinox.stop();
                try {
                    equinox.waitForStop(10000L);
                }
                catch (InterruptedException e) {
                    SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
                }
                throw throwable;
            }
            equinox.stop();
            try {
                equinox.waitForStop(10000L);
            }
            catch (InterruptedException e) {
                SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
            }
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testBug254600() {
        File config = OSGiTestsActivator.getContext().getDataFile("testBug254600");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle securityB = null;
        long idB = -1L;
        try {
            String locationSecurityA = installer.getBundleLocation("security.a");
            String locationSecurityB = installer.getBundleLocation("security.b");
            systemContext.installBundle(locationSecurityA);
            securityB = systemContext.installBundle(locationSecurityB);
            idB = securityB.getBundleId();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to install security test bundles", (Throwable)e);
        }
        try {
            securityB.start();
            securityB.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start security.b bundle", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        systemContext = equinox.getBundleContext();
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        securityB = systemContext.getBundle(idB);
        try {
            securityB.start();
            securityB.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start security.b bundle", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testBug287750() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        Bundle testBundle = null;
        try {
            String locationTestBundle = installer.getBundleLocation("test.bug287750");
            testBundle = systemContext.installBundle(locationTestBundle);
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to install security test bundles", (Throwable)e);
        }
        try {
            testBundle.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start security.b bundle", (Throwable)e);
        }
        StartLevel sl = (StartLevel)systemContext.getService(systemContext.getServiceReference(StartLevel.class.getName()));
        if (sl.getStartLevel() != 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SecurityManagerTests.assertEquals((String)"Wrong startlevel", (int)10, (int)sl.getStartLevel());
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testBug367614() {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.init();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected exception on init()", (Throwable)e);
        }
        SecurityManagerTests.assertNotNull((String)"SecurityManager is null", (Object)System.getSecurityManager());
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)8, (int)equinox.getState());
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)32, (int)equinox.getState());
        BundleContext systemContext = equinox.getBundleContext();
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        update = ca.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        try {
            update.commit();
            SecurityManagerTests.fail((String)"Expected failure to commit duplicate named rows");
        }
        catch (Throwable t) {
            SecurityManagerTests.assertTrue((String)("Wrong exception: " + t), (boolean)(t instanceof IllegalStateException));
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        systemContext = equinox.getBundleContext();
        ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        update = ca.newConditionalPermissionUpdate();
        rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo("test", null, new PermissionInfo[]{allPackagePermission}, "allow"));
        try {
            update.commit();
            SecurityManagerTests.fail((String)"Expected failure to commit duplicate named rows");
        }
        catch (Throwable t) {
            SecurityManagerTests.assertTrue((String)("Wrong exception: " + t), (boolean)(t instanceof IllegalStateException));
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected erorr stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }

    public void testDynamicImportWithSecurity() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("org.osgi.framework.security", "osgi");
        Equinox equinox = new Equinox(configuration);
        try {
            equinox.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Failed to start the framework", (Throwable)e);
        }
        BundleContext systemContext = equinox.getBundleContext();
        ResolverHookFactory dummyHook = new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                    }

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                        if ("dynamic".equals(requirement.getDirectives().get("resolution"))) {
                            candidates.clear();
                        }
                    }

                    public void end() {
                    }
                };
            }
        };
        systemContext.registerService(ResolverHookFactory.class, (Object)dummyHook, null);
        SecurityManagerTests.assertNotNull((String)"System context is null", (Object)systemContext);
        String testDynamicImportLocation = installer.getBundleLocation("test.dynamicimport");
        ConditionalPermissionAdmin ca = (ConditionalPermissionAdmin)systemContext.getService(systemContext.getServiceReference(ConditionalPermissionAdmin.class.getName()));
        ConditionalPermissionUpdate update = ca.newConditionalPermissionUpdate();
        List rows = update.getConditionalPermissionInfos();
        rows.add(ca.newConditionalPermissionInfo(null, null, new PermissionInfo[]{allPackagePermission}, "allow"));
        SecurityManagerTests.assertTrue((String)"Cannot commit rows", (boolean)update.commit());
        Bundle testDynamicImport = systemContext.installBundle(testDynamicImportLocation);
        try {
            testDynamicImport.start();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Did not start test bundle successfully.", (Throwable)e);
        }
        try {
            equinox.stop();
        }
        catch (BundleException e) {
            SecurityManagerTests.fail((String)"Unexpected error stopping framework", (Throwable)e);
        }
        try {
            equinox.waitForStop(10000L);
        }
        catch (InterruptedException e) {
            SecurityManagerTests.fail((String)"Unexpected interrupted exception", (Throwable)e);
        }
        SecurityManagerTests.assertEquals((String)"Wrong state for SystemBundle", (int)4, (int)equinox.getState());
        SecurityManagerTests.assertNull((String)"SecurityManager is not null", (Object)System.getSecurityManager());
    }
}

