/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import junit.framework.TestCase;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;

public class ExtendedLogServiceTest
extends TestCase {
    private Bundle bundle;
    private ExtendedLogService log;
    private ServiceReference logReference;
    private ExtendedLogReaderService reader;
    private ServiceReference readerReference;
    private TestListener listener;

    public ExtendedLogServiceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.bundle = OSGiTestsActivator.getContext().getBundle();
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogReaderService.class.getName());
        this.log = (ExtendedLogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (ExtendedLogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.listener = new TestListener();
        this.reader.addLogListener((LogListener)this.listener);
    }

    protected void tearDown() throws Exception {
        this.reader.removeLogListener((LogListener)this.listener);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogContext() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log((Object)this, 3, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogServiceTest.assertTrue((this.listener.getEntryX().getContext() == this ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullLogContext() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(null, 3, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogServiceTest.assertTrue((this.listener.getEntryX().getContext() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogContextWithNullThrowable() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log((Object)this, 3, null, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogServiceTest.assertTrue((this.listener.getEntryX().getContext() == this ? 1 : 0) != 0);
    }

    public void testIsLoggableTrue() throws Exception {
        if (!this.log.isLoggable(3)) {
            ExtendedLogServiceTest.fail();
        }
    }

    public void testNotIsLoggableWithNoListener() throws Exception {
        this.reader.removeLogListener((LogListener)this.listener);
        if (this.log.isLoggable(3)) {
            ExtendedLogServiceTest.fail();
        }
    }

    public void testNotIsLoggableWithListener() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return false;
            }
        });
        if (this.log.isLoggable(3)) {
            ExtendedLogServiceTest.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedLoggerLogNull() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.getLogger("test").log(null, 0, null, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        ExtendedLogServiceTest.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullLoggerLogNull() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.getLogger(null).log(null, 0, null, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        ExtendedLogServiceTest.assertTrue((entry.getLoggerName() == null ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedLoggerLogFull() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.getLogger("test").log(this.logReference, 3, message, t);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        ExtendedLogServiceTest.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        ExtendedLogServiceTest.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        ExtendedLogServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedLoggerLogFullWithNullBundle() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.getLogger(null, "test").log(this.logReference, 3, message, t);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        ExtendedLogServiceTest.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        ExtendedLogServiceTest.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        ExtendedLogServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedLoggerLogFullWithBundle() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.getLogger(this.bundle, "test").log(this.logReference, 3, message, t);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        ExtendedLogServiceTest.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        ExtendedLogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        ExtendedLogServiceTest.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        ExtendedLogServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    public void testLoggerIsLoggableTrue() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return loggerName.equals("test");
            }
        });
        if (!this.log.getLogger("test").isLoggable(3)) {
            ExtendedLogServiceTest.fail();
        }
    }

    public void testLoggerNotIsLoggableWithListener() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return !loggerName.equals("test");
            }
        });
        if (this.log.getLogger("test").isLoggable(3)) {
            ExtendedLogServiceTest.fail();
        }
    }
}

