/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

class TestListener
implements LogListener {
    private final Bundle testBundle;
    LogEntry entry;

    public TestListener() {
        this(null);
    }

    public TestListener(Bundle testBundle) {
        this.testBundle = testBundle == null ? OSGiTestsActivator.getContext().getBundle() : testBundle;
    }

    public synchronized void logged(LogEntry entry) {
        if (!this.testBundle.equals(entry.getBundle())) {
            return;
        }
        this.entry = entry;
        this.notifyAll();
    }

    public synchronized ExtendedLogEntry getEntryX() {
        ExtendedLogEntry current = (ExtendedLogEntry)this.entry;
        this.entry = null;
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLogEntry() throws InterruptedException {
        TestListener testListener = this;
        synchronized (testListener) {
            long timeToWait = 20000L;
            long startTime = System.currentTimeMillis();
            while (this.entry == null && timeToWait > 0L) {
                this.wait(timeToWait);
                timeToWait -= System.currentTimeMillis() - startTime;
            }
            if (this.entry == null) {
                Assert.fail((String)"No log entry logged.");
            }
        }
    }
}

