/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.ITestRunner;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.tests.bundles.TestService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class ClassLoadingBundleTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(ClassLoadingBundleTests.class);
    }

    public void testSimple() throws Exception {
        Bundle test = installer.installBundle("test");
        test.start();
        installer.shutdown();
        Object[] expectedEvents = new Object[]{new BundleEvent(1, test), new BundleEvent(32, test), new BundleEvent(2, test), new BundleEvent(4, test), new BundleEvent(64, test), new BundleEvent(16, test)};
        Object[] actualEvents = listenerResults.getResults(expectedEvents.length);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testLoadTriggerClass() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        installer.installBundle("chain.test.b");
        installer.installBundle("chain.test.c");
        installer.installBundle("chain.test.d");
        ClassLoadingBundleTests.assertTrue((String)"Did not resolve chainTest", (boolean)installer.resolveBundles(new Bundle[]{chainTest}));
        chainTest.start(2);
        chainTestA.start(2);
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)8, (int)chainTest.getState());
        chainTest.loadClass("org.osgi.framework.BundleActivator");
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)8, (int)chainTest.getState());
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)8, (int)chainTestA.getState());
        chainTest.loadClass("chain.test.a.AChain");
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)8, (int)chainTest.getState());
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)32, (int)chainTestA.getState());
    }

    public void testChainDepedencies() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        installer.installBundle("chain.test.c");
        installer.installBundle("chain.test.d");
        ((ITestRunner)chainTest.loadClass("chain.test.TestSingleChain").newInstance()).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(4, chainTestB), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestA)};
        installer.refreshPackages(new Bundle[]{chainTestB});
        ((ITestRunner)chainTest.loadClass("chain.test.TestSingleChain").newInstance()).testIt();
        Object[] actualEvents = simpleResults.getResults(6);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testMultiChainDepedencies01() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        chainTest.loadClass("chain.test.TestMultiChain").newInstance();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, chainTestD), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestC), new BundleEvent(2, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(4, chainTestB), new BundleEvent(4, chainTestC), new BundleEvent(4, chainTestD)};
        installer.refreshPackages(new Bundle[]{chainTestC, chainTestD});
        Object[] actualEvents = simpleResults.getResults(8);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        chainTest.loadClass("chain.test.TestMultiChain").newInstance();
        expectedEvents = new Object[]{new BundleEvent(2, chainTestD), new BundleEvent(2, chainTestB), new BundleEvent(2, chainTestC), new BundleEvent(2, chainTestA)};
        actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testMultiChainDepedencies02() throws Exception {
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        installer.resolveBundles(new Bundle[]{chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(512, chainTestD), new BundleEvent(512, chainTestC), new BundleEvent(512, chainTestB), new BundleEvent(512, chainTestA)};
        Object[] actualEvents = syncListenerResults.getResults(8);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        installer.refreshPackages(new Bundle[]{chainTestC, chainTestD});
        expectedEvents = new Object[]{new BundleEvent(256, chainTestA), new BundleEvent(4, chainTestA), new BundleEvent(256, chainTestB), new BundleEvent(4, chainTestB), new BundleEvent(256, chainTestC), new BundleEvent(4, chainTestC), new BundleEvent(256, chainTestD), new BundleEvent(4, chainTestD), new BundleEvent(64, chainTestA), new BundleEvent(64, chainTestB), new BundleEvent(64, chainTestC), new BundleEvent(64, chainTestD), new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(512, chainTestD), new BundleEvent(512, chainTestC), new BundleEvent(512, chainTestB), new BundleEvent(512, chainTestA)};
        actualEvents = syncListenerResults.getResults(12);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testBug300692_01() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents = new Object[14];
            int i = 0;
            expectedEvents[i++] = new BundleEvent(512, chainTestA);
            expectedEvents[i++] = new BundleEvent(512, chainTestB);
            expectedEvents[i++] = new BundleEvent(512, chainTestC);
            expectedEvents[i++] = new BundleEvent(512, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTest);
            expectedEvents[i++] = new BundleEvent(128, chainTestD);
            expectedEvents[i++] = new BundleEvent(2, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTestB);
            expectedEvents[i++] = new BundleEvent(2, chainTestB);
            expectedEvents[i++] = new BundleEvent(128, chainTestC);
            expectedEvents[i++] = new BundleEvent(2, chainTestC);
            expectedEvents[i++] = new BundleEvent(128, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualFrameworkEvents);
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    public void testBug300692_02() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        Object[] expectedEvents = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            System.setProperty("test.bug300692.listener", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents = new Object[14];
            int i = 0;
            expectedEvents[i++] = new BundleEvent(512, chainTestA);
            expectedEvents[i++] = new BundleEvent(512, chainTestB);
            expectedEvents[i++] = new BundleEvent(512, chainTestC);
            expectedEvents[i++] = new BundleEvent(512, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTest);
            expectedEvents[i++] = new BundleEvent(128, chainTestD);
            expectedEvents[i++] = new BundleEvent(2, chainTestD);
            expectedEvents[i++] = new BundleEvent(128, chainTestB);
            expectedEvents[i++] = new BundleEvent(2, chainTestB);
            expectedEvents[i++] = new BundleEvent(128, chainTestC);
            expectedEvents[i++] = new BundleEvent(2, chainTestC);
            expectedEvents[i++] = new BundleEvent(128, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTestA);
            expectedEvents[i++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualFrameworkEvents);
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            System.getProperties().remove("test.bug300692.listener");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        System.getProperties().remove("test.bug300692.listener");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    public void testBug408629() throws BundleException {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        syncListenerResults.getResults(0);
        StartLevel sl = installer.getStartLevel();
        int currentSL = sl.getStartLevel();
        int testSL = currentSL + 1;
        sl.setBundleStartLevel(chainTest, testSL);
        sl.setBundleStartLevel(chainTestA, testSL);
        sl.setBundleStartLevel(chainTestB, testSL);
        sl.setBundleStartLevel(chainTestC, testSL);
        sl.setBundleStartLevel(chainTestD, testSL);
        installer.resolveBundles(new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD});
        chainTestD.start();
        Object[] expectedEvents1 = new Object[]{new BundleEvent(32, chainTestD), new BundleEvent(32, chainTestC), new BundleEvent(32, chainTestB), new BundleEvent(32, chainTestA), new BundleEvent(32, chainTest)};
        Object[] actualEvents = syncListenerResults.getResults(5);
        ClassLoadingBundleTests.compareResults(expectedEvents1, actualEvents);
        try {
            System.setProperty("test.bug300692", "true");
            System.setProperty("test.bug300692.listener", "true");
            chainTest.start();
            sl.setStartLevel(testSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            expectedEvents1 = new Object[14];
            Object[] expectedEvents2 = new Object[14];
            int i1 = 0;
            int i2 = 0;
            expectedEvents1[i1++] = new BundleEvent(512, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestB);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(128, chainTest);
            expectedEvents2[i2++] = new BundleEvent(128, chainTest);
            expectedEvents1[i1++] = new BundleEvent(512, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestB);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestB);
            expectedEvents2[i2++] = new BundleEvent(512, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestD);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestD);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestD);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestC);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestC);
            expectedEvents1[i1++] = new BundleEvent(128, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(128, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(2, chainTestA);
            expectedEvents2[i2++] = new BundleEvent(2, chainTestA);
            expectedEvents1[i1++] = new BundleEvent(2, chainTest);
            expectedEvents2[i2++] = new BundleEvent(2, chainTest);
            actualFrameworkEvents = syncListenerResults.getResults(14);
            try {
                ClassLoadingBundleTests.compareResults(expectedEvents1, actualFrameworkEvents);
            }
            catch (AssertionFailedError assertionFailedError) {
                ClassLoadingBundleTests.compareResults(expectedEvents2, actualFrameworkEvents);
            }
        }
        catch (Throwable throwable) {
            System.getProperties().remove("test.bug300692");
            System.getProperties().remove("test.bug300692.listener");
            sl.setStartLevel(currentSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        System.getProperties().remove("test.bug300692");
        System.getProperties().remove("test.bug300692.listener");
        sl.setStartLevel(currentSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    public void testClassCircularityError() throws Exception {
        Bundle circularityTest = installer.installBundle("circularity.test");
        Bundle circularityTestA = installer.installBundle("circularity.test.a");
        circularityTest.loadClass("circularity.test.TestCircularity");
        Object[] expectedEvents = new Object[]{new BundleEvent(2, circularityTest), new BundleEvent(2, circularityTestA)};
        Object[] actualEvents = simpleResults.getResults(2);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testFragmentPackageAccess() throws Exception {
        Bundle hostA = installer.installBundle("fragment.test.attach.host.a");
        Bundle fragA = installer.installBundle("fragment.test.attach.frag.a");
        ClassLoadingBundleTests.assertTrue((String)"Host/Frag resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA, fragA}));
        ITestRunner testRunner = (ITestRunner)hostA.loadClass("fragment.test.attach.host.a.internal.test.TestPackageAccess").newInstance();
        try {
            testRunner.testIt();
        }
        catch (Exception e) {
            ClassLoadingBundleTests.fail((String)("Failed package access test: " + e.getMessage()));
        }
    }

    public void testFragmentMultiHost() throws Exception {
        Bundle hostA1 = installer.installBundle("fragment.test.attach.host.a");
        Bundle hostA2 = installer.installBundle("fragment.test.attach.host.a.v2");
        Bundle fragA = installer.installBundle("fragment.test.attach.frag.a");
        ClassLoadingBundleTests.assertTrue((String)"Host/Frag resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA1, hostA2, fragA}));
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of hosts", (int)2, (int)installer.getPackageAdmin().getHosts(fragA).length);
        this.runTestRunner(hostA1, "fragment.test.attach.host.a.internal.test.TestPackageAccess");
        this.runTestRunner(hostA2, "fragment.test.attach.host.a.internal.test.TestPackageAccess2");
    }

    private void runTestRunner(Bundle host, String classname) {
        try {
            ITestRunner testRunner = (ITestRunner)host.loadClass(classname).newInstance();
            testRunner.testIt();
        }
        catch (Exception e) {
            ClassLoadingBundleTests.fail((String)"Failed package access test", (Throwable)e);
        }
    }

    public void testFragmentExportPackage() throws Exception {
        Bundle hostA = installer.installBundle("fragment.test.attach.host.a");
        ClassLoadingBundleTests.assertTrue((String)"Host resolve", (boolean)installer.resolveBundles(new Bundle[]{hostA}));
        hostA.loadClass("fragment.test.attach.host.a.internal.test.PackageAccessTest");
        Bundle fragB = installer.installBundle("fragment.test.attach.frag.b");
        Bundle hostARequire = installer.installBundle("fragment.test.attach.host.a.require");
        ClassLoadingBundleTests.assertTrue((String)"RequireA/Frag", (boolean)installer.resolveBundles(new Bundle[]{hostARequire, fragB}));
        try {
            hostARequire.loadClass("fragment.test.attach.frag.b.Test");
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected class loading exception", (Throwable)e);
        }
    }

    public void testLegacyLazyStart() throws Exception {
        Bundle legacy = installer.installBundle("legacy.lazystart");
        Bundle legacyA = installer.installBundle("legacy.lazystart.a");
        Bundle legacyB = installer.installBundle("legacy.lazystart.b");
        Bundle legacyC = installer.installBundle("legacy.lazystart.c");
        ClassLoadingBundleTests.assertTrue((String)"legacy lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{legacy, legacyA, legacyB, legacyC}));
        ((ITestRunner)legacy.loadClass("legacy.lazystart.SimpleLegacy").newInstance()).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, legacyA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.TrueExceptionLegacy1").newInstance()).testIt();
        ClassLoadingBundleTests.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.TrueExceptionLegacy2").newInstance()).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, legacyB)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.FalseExceptionLegacy1").newInstance()).testIt();
        ClassLoadingBundleTests.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)legacy.loadClass("legacy.lazystart.FalseExceptionLegacy2").newInstance()).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, legacyC)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testLegacyLoadActivation() throws Exception {
        Bundle test = installer.installBundle("test");
        try {
            test.loadClass("does.not.exist.Test");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        Bundle legacyA = installer.installBundle("legacy.lazystart.a");
        try {
            legacyA.loadClass("does.not.exist.Test");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ClassLoadingBundleTests.assertEquals((String)"Wrong state for lazy bundle.", (int)8, (int)legacyA.getState());
    }

    public void testOSGiLazyStart() throws Exception {
        Bundle osgi = installer.installBundle("osgi.lazystart");
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        Bundle osgiB = installer.installBundle("osgi.lazystart.b");
        Bundle osgiC = installer.installBundle("osgi.lazystart.c");
        ClassLoadingBundleTests.assertTrue((String)"osgi lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{osgi, osgiA, osgiB, osgiC}));
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazySimple").newInstance()).testIt();
        Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyExclude1").newInstance()).testIt();
        ClassLoadingBundleTests.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyExclude2").newInstance()).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, osgiB)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyInclude1").newInstance()).testIt();
        ClassLoadingBundleTests.assertTrue((String)"exceptions no event", (simpleResults.getResults(0).length == 0 ? 1 : 0) != 0);
        ((ITestRunner)osgi.loadClass("osgi.lazystart.LazyInclude2").newInstance()).testIt();
        expectedEvents = new Object[]{new BundleEvent(2, osgiC)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testOSGiLazyStartDelay() throws Exception {
        final Bundle osgiD = installer.installBundle("osgi.lazystart.d");
        Bundle osgiE = installer.installBundle("osgi.lazystart.e");
        ClassLoadingBundleTests.assertTrue((String)"osgi lazy start resolve", (boolean)installer.resolveBundles(new Bundle[]{osgiD, osgiE}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    osgiD.loadClass("osgi.lazystart.d.DTest");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "Starting: " + osgiD);
        t.start();
        Thread.sleep(100L);
        long startTime = System.currentTimeMillis();
        osgiE.start();
        long endTime = System.currentTimeMillis() - startTime;
        ClassLoadingBundleTests.assertTrue((String)("Starting of test bundle was too short: " + endTime), (endTime > 3000L ? 1 : 0) != 0);
    }

    public void testStartTransientByLoadClass() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testStartTransient() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        try {
            osgiA.start(1);
            ClassLoadingBundleTests.assertFalse((String)"Bundle is started!!", (osgiA.getState() == 32 ? 1 : 0) != 0);
        }
        catch (BundleException e) {
            ClassLoadingBundleTests.assertEquals((String)"Expected invalid operation", (int)10, (int)e.getType());
        }
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        osgiA.start(1);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testStartResolve() throws Exception {
        Bundle test = installer.installBundle("test");
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(test, startLevel.getStartLevel() + 10);
        try {
            test.start();
        }
        catch (BundleException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)2, (int)test.getState());
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        ClassLoadingBundleTests.assertEquals((String)"Wrong state", (int)32, (int)test.getState());
    }

    public void testStopTransient() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        StartLevel startLevel = installer.getStartLevel();
        startLevel.setBundleStartLevel(osgiA, startLevel.getStartLevel() + 10);
        osgiA.start();
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        Object[] actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.stop(1);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() + 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        startLevel.setStartLevel(startLevel.getStartLevel() - 15);
        expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        expectedEvents = new Object[]{new BundleEvent(4, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testBug258659_01() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        SynchronousBundleListener testLoadClassListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 512) {
                    try {
                        event.getBundle().loadClass("osgi.lazystart.a.ATest");
                    }
                    catch (ClassNotFoundException e) {
                        simpleResults.addEvent(e);
                    }
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            osgiA.start(2);
            Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
            Object[] actualEvents = simpleResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    public void testBug258659_02() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        osgiA.start(2);
        SynchronousBundleListener testLoadClassListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 512) {
                    try {
                        event.getBundle().loadClass("osgi.lazystart.a.ATest");
                    }
                    catch (ClassNotFoundException e) {
                        simpleResults.addEvent(e);
                    }
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            installer.refreshPackages(new Bundle[]{osgiA});
            Object[] expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
            Object[] actualEvents = simpleResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    public void testBug258659_03() throws Exception {
        Bundle test = installer.installBundle("test");
        SynchronousBundleListener testLoadClassListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2) {
                    try {
                        event.getBundle().stop();
                    }
                    catch (BundleException e) {
                        simpleResults.addEvent((Object)e);
                    }
                }
            }
        };
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            test.start();
            Object[] expectedEvents = new Object[]{new BundleEvent(2, test), new BundleEvent(4, test)};
            Object[] actualEvents = simpleResults.getResults(2);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    public void testBug258659_04() throws Exception {
        Bundle test = installer.installBundle("test");
        test.start();
        SynchronousBundleListener testLoadClassListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2) {
                    try {
                        event.getBundle().stop();
                    }
                    catch (BundleException e) {
                        simpleResults.addEvent((Object)e);
                    }
                }
            }
        };
        simpleResults.getResults(0);
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testLoadClassListener);
        try {
            installer.refreshPackages(new Bundle[]{test});
            Object[] expectedEvents = new Object[]{new BundleEvent(4, test), new BundleEvent(2, test), new BundleEvent(4, test)};
            Object[] actualEvents = simpleResults.getResults(3);
            ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testLoadClassListener);
        }
    }

    public void testBug213791() throws Exception {
        Bundle osgiA = installer.installBundle("osgi.lazystart.a");
        installer.resolveBundles(new Bundle[]{osgiA});
        if (osgiA.getState() == 8) {
            osgiA.stop();
        }
        osgiA.start(2);
        Object[] expectedEvents = new Object[]{};
        Object[] actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.start(2);
        expectedEvents = new Object[]{};
        actualEvents = simpleResults.getResults(0);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
        osgiA.loadClass("osgi.lazystart.a.ATest");
        expectedEvents = new Object[]{new BundleEvent(2, osgiA)};
        actualEvents = simpleResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testThreadLock() throws Exception {
        Bundle threadLockTest = installer.installBundle("thread.locktest");
        threadLockTest.loadClass("thread.locktest.ATest");
        Object[] expectedEvents = new Object[]{new Long(5000L), new BundleEvent(2, threadLockTest)};
        Object[] actualEvents = simpleResults.getResults(2);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testURLsBug164077() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL[] urls = new URL[]{test.getResource("a/b/c/d"), test.getEntry("a/b/c/d")};
        ClassLoadingBundleTests.assertNotNull((String)"resource", (Object)urls[0]);
        ClassLoadingBundleTests.assertNotNull((String)"entry", (Object)urls[1]);
        int i = 0;
        while (i < urls.length) {
            URL testURL = new URL(urls[i], "g");
            ClassLoadingBundleTests.assertEquals((String)"g", (String)"/a/b/c/g", (String)testURL.getPath());
            testURL = new URL(urls[i], "./g");
            ClassLoadingBundleTests.assertEquals((String)"./g", (String)"/a/b/c/g", (String)testURL.getPath());
            testURL = new URL(urls[i], "g/");
            ClassLoadingBundleTests.assertEquals((String)"g/", (String)"/a/b/c/g/", (String)testURL.getPath());
            testURL = new URL(urls[i], "/g");
            ClassLoadingBundleTests.assertEquals((String)"/g", (String)"/g", (String)testURL.getPath());
            testURL = new URL(urls[i], "?y");
            ClassLoadingBundleTests.assertEquals((String)"?y", (String)"/a/b/c/?y", (String)testURL.getPath());
            testURL = new URL(urls[i], "g?y");
            ClassLoadingBundleTests.assertEquals((String)"g?y", (String)"/a/b/c/g?y", (String)testURL.getPath());
            testURL = new URL(urls[i], "g#s");
            ClassLoadingBundleTests.assertEquals((String)"g#s", (String)"/a/b/c/g#s", (String)(String.valueOf(testURL.getPath()) + "#s"));
            testURL = new URL(urls[i], "g?y#s");
            ClassLoadingBundleTests.assertEquals((String)"g?y#s", (String)"/a/b/c/g?y#s", (String)(String.valueOf(testURL.getPath()) + "#s"));
            testURL = new URL(urls[i], ";x");
            ClassLoadingBundleTests.assertEquals((String)";x", (String)"/a/b/c/;x", (String)testURL.getPath());
            testURL = new URL(urls[i], "g;x");
            ClassLoadingBundleTests.assertEquals((String)"g;x", (String)"/a/b/c/g;x", (String)testURL.getPath());
            testURL = new URL(urls[i], "g;x?y#s");
            ClassLoadingBundleTests.assertEquals((String)"g;x?y#s", (String)"/a/b/c/g;x?y#s", (String)(String.valueOf(testURL.getPath()) + "#s"));
            testURL = new URL(urls[i], ".");
            ClassLoadingBundleTests.assertEquals((String)".", (String)"/a/b/c/", (String)testURL.getPath());
            testURL = new URL(urls[i], "./");
            ClassLoadingBundleTests.assertEquals((String)"./", (String)"/a/b/c/", (String)testURL.getPath());
            testURL = new URL(urls[i], "..");
            ClassLoadingBundleTests.assertEquals((String)"..", (String)"/a/b/", (String)testURL.getPath());
            testURL = new URL(urls[i], "../");
            ClassLoadingBundleTests.assertEquals((String)"../", (String)"/a/b/", (String)testURL.getPath());
            testURL = new URL(urls[i], "../g");
            ClassLoadingBundleTests.assertEquals((String)"../g", (String)"/a/b/g", (String)testURL.getPath());
            testURL = new URL(urls[i], "../..");
            ClassLoadingBundleTests.assertEquals((String)"../..", (String)"/a/", (String)testURL.getPath());
            testURL = new URL(urls[i], "../../");
            ClassLoadingBundleTests.assertEquals((String)"../../", (String)"/a/", (String)testURL.getPath());
            testURL = new URL(urls[i], "../../g");
            ClassLoadingBundleTests.assertEquals((String)"../../g", (String)"/a/g", (String)testURL.getPath());
            ++i;
        }
    }

    public void testEntryURLEqualsHashCode() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL testEntry1 = test.getEntry("a/b/c/d");
        URL testEntry2 = test.getEntry("a/b/c/d");
        ClassLoadingBundleTests.assertEquals("url equals 1.0", testEntry1, testEntry2);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 1.1", (int)testEntry1.hashCode(), (int)testEntry2.hashCode());
        URL testEntry3 = new URL(testEntry1, "./d");
        ClassLoadingBundleTests.assertEquals("url equals 2.0", testEntry1, testEntry3);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 2.1", (int)testEntry1.hashCode(), (int)testEntry3.hashCode());
        URL testEntry4 = new URL(testEntry3.toString());
        ClassLoadingBundleTests.assertEquals("url equals 3.0", testEntry4, testEntry3);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 3.1", (int)testEntry4.hashCode(), (int)testEntry3.hashCode());
    }

    public void testResourceURLEqualsHashCode() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL testResource1 = test.getResource("a/b/c/d");
        URL testResource2 = test.getResource("a/b/c/d");
        ClassLoadingBundleTests.assertEquals("url equals 1.0", testResource1, testResource2);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 1.1", (int)testResource1.hashCode(), (int)testResource2.hashCode());
        URL testResource3 = new URL(testResource1, "./d");
        ClassLoadingBundleTests.assertEquals("url equals 2.0", testResource1, testResource3);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 2.1", (int)testResource1.hashCode(), (int)testResource3.hashCode());
        URL testResource4 = new URL(testResource3.toString());
        ClassLoadingBundleTests.assertEquals("url equals 3.0", testResource4, testResource3);
        ClassLoadingBundleTests.assertEquals((String)"hashcode equals 3.1", (int)testResource4.hashCode(), (int)testResource3.hashCode());
    }

    public void testGetEntryDir01() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL aDir = test.getEntry("a");
        ClassLoadingBundleTests.assertNotNull((String)"aDir", (Object)aDir);
        ClassLoadingBundleTests.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        URL bDir = test.getEntry("a/b");
        ClassLoadingBundleTests.assertNotNull((String)"bDir", (Object)bDir);
        ClassLoadingBundleTests.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        aDir = test.getEntry("a/");
        ClassLoadingBundleTests.assertNotNull((String)"aDir", (Object)aDir);
        ClassLoadingBundleTests.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        bDir = test.getEntry("a/b/");
        ClassLoadingBundleTests.assertNotNull((String)"bDir", (Object)bDir);
        ClassLoadingBundleTests.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        URL dResource = test.getEntry("a/b/c/d");
        ClassLoadingBundleTests.assertNotNull((String)"dResource", (Object)dResource);
        ClassLoadingBundleTests.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        dResource = test.getEntry("a/b/c/d/");
        if (dResource != null) {
            ClassLoadingBundleTests.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        }
    }

    public void testGetResourceDir01() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        URL aDir = test.getResource("a");
        ClassLoadingBundleTests.assertNotNull((String)"aDir", (Object)aDir);
        ClassLoadingBundleTests.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        URL bDir = test.getResource("a/b");
        ClassLoadingBundleTests.assertNotNull((String)"bDir", (Object)bDir);
        ClassLoadingBundleTests.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        aDir = test.getResource("a/");
        ClassLoadingBundleTests.assertNotNull((String)"aDir", (Object)aDir);
        ClassLoadingBundleTests.assertTrue((String)aDir.toExternalForm(), (boolean)aDir.getFile().endsWith("/"));
        bDir = test.getResource("a/b/");
        ClassLoadingBundleTests.assertNotNull((String)"bDir", (Object)bDir);
        ClassLoadingBundleTests.assertTrue((String)bDir.toExternalForm(), (boolean)bDir.getFile().endsWith("/"));
        URL dResource = test.getResource("a/b/c/d");
        ClassLoadingBundleTests.assertNotNull((String)"dResource", (Object)dResource);
        ClassLoadingBundleTests.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        dResource = test.getResource("a/b/c/d/");
        if (dResource != null) {
            ClassLoadingBundleTests.assertFalse((String)dResource.toExternalForm(), (boolean)dResource.getFile().endsWith("/"));
        }
    }

    public void testBootGetResources01() throws Exception {
        if (System.getProperty("org.osgi.framework.bootdelegation") != null) {
            return;
        }
        Bundle test = installer.installBundle("test");
        Enumeration manifests = test.getResources("META-INF/MANIFEST.MF");
        ClassLoadingBundleTests.assertNotNull((String)"manifests", (Object)manifests);
        ArrayList manifestURLs = new ArrayList();
        while (manifests.hasMoreElements()) {
            manifestURLs.add(manifests.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"manifest number", (int)1, (int)manifestURLs.size());
        URL manifest = (URL)manifestURLs.get(0);
        int dotIndex = manifest.getHost().indexOf(46);
        long bundleId = dotIndex >= 0 && dotIndex < manifest.getHost().length() - 1 ? Long.parseLong(manifest.getHost().substring(0, dotIndex)) : Long.parseLong(manifest.getHost());
        ClassLoadingBundleTests.assertEquals((String)"host id", (long)test.getBundleId(), (long)bundleId);
    }

    public void testBootGetResources02() throws Exception {
        if (System.getProperty("org.osgi.framework.bootdelegation") != null) {
            return;
        }
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoader bcl = wiring.getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], bcl);
        Enumeration<URL> manifests = cl.getResources("META-INF/MANIFEST.MF");
        ClassLoadingBundleTests.assertNotNull((String)"manifests", manifests);
        ArrayList<URL> manifestURLs = new ArrayList<URL>();
        while (manifests.hasMoreElements()) {
            manifestURLs.add(manifests.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"manifest number", (int)1, (int)manifestURLs.size());
        URL manifest = (URL)manifestURLs.get(0);
        ClassLoadingBundleTests.assertEquals((String)"wrong protocol", (String)"bundleresource", (String)manifest.getProtocol());
        int dotIndex = manifest.getHost().indexOf(46);
        long bundleId = dotIndex >= 0 && dotIndex < manifest.getHost().length() - 1 ? Long.parseLong(manifest.getHost().substring(0, dotIndex)) : Long.parseLong(manifest.getHost());
        ClassLoadingBundleTests.assertEquals((String)"host id", (long)test.getBundleId(), (long)bundleId);
    }

    public void testMultipleGetResources01() throws Exception {
        Bundle test = installer.installBundle("test");
        Enumeration resources = test.getResources("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = new ArrayList();
        while (resources.hasMoreElements()) {
            resourceURLs.add(resources.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"resource number", (int)2, (int)resourceURLs.size());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL((URL)resourceURLs.get(0)));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath", (String)this.readURL((URL)resourceURLs.get(1)));
    }

    public void testMultipleGetResources01a() throws Exception {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoader bcl = wiring.getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], bcl);
        Enumeration<URL> resources = cl.getResources("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"resources", resources);
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            resourceURLs.add(resources.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"resource number", (int)2, (int)resourceURLs.size());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL((URL)resourceURLs.get(0)));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath", (String)this.readURL((URL)resourceURLs.get(1)));
    }

    public void testMultipleGetResources02() throws Exception {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        Enumeration resources = test2.getResources("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = new ArrayList();
        while (resources.hasMoreElements()) {
            resourceURLs.add(resources.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"resource number", (int)4, (int)resourceURLs.size());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL((URL)resourceURLs.get(0)));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath", (String)this.readURL((URL)resourceURLs.get(1)));
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath test2", (String)this.readURL((URL)resourceURLs.get(2)));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath test2", (String)this.readURL((URL)resourceURLs.get(3)));
    }

    public void testMultipleGetResources03() throws Exception {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        Enumeration resources = test2.getResources("data/");
        ClassLoadingBundleTests.assertNotNull((String)"resources", (Object)resources);
        ArrayList resourceURLs = new ArrayList();
        while (resources.hasMoreElements()) {
            resourceURLs.add(resources.nextElement());
        }
        ClassLoadingBundleTests.assertEquals((String)"resource number", (int)4, (int)resourceURLs.size());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL(new URL((URL)resourceURLs.get(0), "resource1")));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath", (String)this.readURL(new URL((URL)resourceURLs.get(1), "resource1")));
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath test2", (String)this.readURL(new URL((URL)resourceURLs.get(2), "resource1")));
        ClassLoadingBundleTests.assertEquals((String)"stuff resource", (String)"stuff classpath test2", (String)this.readURL(new URL((URL)resourceURLs.get(3), "resource1")));
    }

    public void testListResources() throws BundleException {
        installer.installBundle("test");
        Bundle test2 = installer.installBundle("test2");
        ClassLoadingBundleTests.assertTrue((String)"Could not resolve test2 bundle", (boolean)installer.resolveBundles(new Bundle[]{test2}));
        BundleWiring test2Wiring = (BundleWiring)test2.adapt(BundleWiring.class);
        Collection resources = test2Wiring.listResources("/", "*", 0);
        ClassLoadingBundleTests.assertTrue((String)"could not find resource", (boolean)resources.contains("resource2"));
        resources = test2Wiring.listResources("data/", "resource2", 0);
        ClassLoadingBundleTests.assertTrue((String)"could not find resource", (boolean)resources.contains("data/resource2"));
        resources = test2Wiring.listResources("/", "resource*", 1);
        ClassLoadingBundleTests.assertTrue((String)"could not find resource", (boolean)resources.contains("data/resource2"));
    }

    public void testURLExternalFormat01() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getEntry("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"entry", (Object)entry);
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL(entry));
        URL entryCopy = new URL(entry.toExternalForm());
        ClassLoadingBundleTests.assertEquals((String)"external format", (String)entry.toExternalForm(), (String)entryCopy.toExternalForm());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL(entryCopy));
    }

    public void testURLExternalFormat02() throws Exception {
        Bundle test = installer.installBundle("test");
        URL entry = test.getResource("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"entry", (Object)entry);
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL(entry));
        URL entryCopy = new URL(entry.toExternalForm());
        ClassLoadingBundleTests.assertEquals((String)"external format", (String)entry.toExternalForm(), (String)entryCopy.toExternalForm());
        ClassLoadingBundleTests.assertEquals((String)"root resource", (String)"root classpath", (String)this.readURL(entryCopy));
    }

    public void testURLExternalFormat03() throws BundleException {
        Bundle test = installer.installBundle("test");
        URL entry = test.getEntry("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"entry", (Object)entry);
        URI uri1 = null;
        URI uri2 = null;
        URI uri3 = null;
        try {
            uri1 = new URI(entry.getProtocol(), null, entry.getHost(), entry.getPort(), entry.getPath(), null, entry.getQuery());
            uri2 = new URI(entry.getProtocol(), entry.getHost(), entry.getPath(), entry.getQuery());
            uri3 = new URI(entry.toExternalForm());
        }
        catch (URISyntaxException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected URI exception", (Throwable)e);
        }
        URL url1 = null;
        URL url2 = null;
        URL url3 = null;
        URL url4 = null;
        try {
            url1 = uri1.toURL();
            url2 = uri2.toURL();
            url3 = uri3.toURL();
            url4 = new URL(uri1.toString());
        }
        catch (MalformedURLException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected URL exception", (Throwable)e);
        }
        this.checkURL("root classpath", entry, url1);
        this.checkURL("root classpath", entry, url2);
        this.checkURL("root classpath", entry, url3);
        this.checkURL("root classpath", entry, url4);
    }

    public void testURLExternalFormat04() throws BundleException {
        Bundle test = installer.installBundle("test");
        URL entry = test.getResource("data/resource1");
        ClassLoadingBundleTests.assertNotNull((String)"entry", (Object)entry);
        URI uri1 = null;
        URI uri2 = null;
        URI uri3 = null;
        try {
            uri1 = new URI(entry.getProtocol(), null, entry.getHost(), entry.getPort(), entry.getPath(), null, entry.getQuery());
            uri2 = new URI(entry.getProtocol(), entry.getHost(), entry.getPath(), entry.getQuery());
            uri3 = new URI(entry.toExternalForm());
        }
        catch (URISyntaxException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected URI exception", (Throwable)e);
        }
        URL url1 = null;
        URL url2 = null;
        URL url3 = null;
        URL url4 = null;
        try {
            url1 = uri1.toURL();
            url2 = uri2.toURL();
            url3 = uri3.toURL();
            url4 = new URL(uri1.toString());
        }
        catch (MalformedURLException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected URL exception", (Throwable)e);
        }
        this.checkURL("root classpath", entry, url1);
        this.checkURL("root classpath", entry, url2);
        this.checkURL("root classpath", entry, url3);
        this.checkURL("root classpath", entry, url4);
    }

    private void checkURL(String content, URL orig, URL copy) {
        ClassLoadingBundleTests.assertEquals((String)"external format", (String)orig.toExternalForm(), (String)copy.toExternalForm());
        ClassLoadingBundleTests.assertEquals((String)content, (String)content, (String)this.readURL(copy));
    }

    public void testURI() throws URISyntaxException {
        new URI("bundleentry", "1", "/test", null);
    }

    public void testMultipleExportFragments01() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag});
        PackageAdmin packageAdmin = installer.getPackageAdmin();
        ExportedPackage[] hostExports = packageAdmin.getExportedPackages(host);
        ClassLoadingBundleTests.assertEquals((String)"Number host exports", (int)4, (int)(hostExports == null ? 0 : hostExports.length));
        BundleWiring hostWiring = (BundleWiring)host.adapt(BundleWiring.class);
        ClassLoadingBundleTests.assertNotNull((String)"No host wiring", (Object)hostWiring);
        List packageCapabilities = hostWiring.getCapabilities("osgi.wiring.package");
        ClassLoadingBundleTests.assertEquals((String)"Number host export capabilities", (int)4, (int)packageCapabilities.size());
        ClassLoadingBundleTests.assertEquals("Check export name", "host.multiple.exports", ((BundleCapability)packageCapabilities.get(0)).getAttributes().get("osgi.wiring.package"));
        ClassLoadingBundleTests.assertEquals((String)"Check include directive", (String)"Public*", (String)((String)((BundleCapability)packageCapabilities.get(0)).getDirectives().get("include")));
        ClassLoadingBundleTests.assertEquals("Check export name", "host.multiple.exports.onlyone", ((BundleCapability)packageCapabilities.get(1)).getAttributes().get("osgi.wiring.package"));
        ClassLoadingBundleTests.assertEquals("Check export name", "host.multiple.exports", ((BundleCapability)packageCapabilities.get(2)).getAttributes().get("osgi.wiring.package"));
        ClassLoadingBundleTests.assertEquals((String)"Check scope attribute", (String)"private", (String)((String)((BundleCapability)packageCapabilities.get(2)).getAttributes().get("scope")));
        ClassLoadingBundleTests.assertEquals("Check export name", "host.multiple.exports.onlyone", ((BundleCapability)packageCapabilities.get(3)).getAttributes().get("osgi.wiring.package"));
    }

    public void testMultipleExportFragments02() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        Bundle client1 = installer.installBundle("client1.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag, client1});
        client1.start();
        client1.stop();
        Object[] expectedEvents = new Object[]{"host.multiple.exports.PublicClass1", "host.multiple.exports.PublicClass2", "success", "success"};
        Object[] actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testMultipleExportFragments03() throws Exception {
        Bundle host = installer.installBundle("host.multiple.exports");
        Bundle frag = installer.installBundle("frag.multiple.exports");
        Bundle client2 = installer.installBundle("client2.multiple.exports");
        installer.resolveBundles(new Bundle[]{host, frag, client2});
        client2.start();
        client2.stop();
        Object[] expectedEvents = new Object[]{"host.multiple.exports.PublicClass1", "host.multiple.exports.PublicClass2", "host.multiple.exports.PrivateClass1", "host.multiple.exports.PrivateClass2"};
        Object[] actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void disableTestXFriends() throws Exception {
        Bundle test1 = installer.installBundle("xfriends.test1");
        Bundle test2 = installer.installBundle("xfriends.test2");
        Bundle test3 = installer.installBundle("xfriends.test3");
        installer.resolveBundles(new Bundle[]{test1, test2, test3});
        test2.start();
        test2.stop();
        test3.start();
        test3.stop();
        Object[] expectedEvents = new Object[]{"xfriends.test1.onlyforfriends.TestFriends", "xfriends.test1.external.TestFriends", "success", "xfriends.test1.external.TestFriends"};
        Object[] actualEvents = simpleResults.getResults(4);
        ClassLoadingBundleTests.compareResults(expectedEvents, actualEvents);
    }

    public void testImporterExporter01() throws BundleException {
        Bundle importerExporter1 = installer.installBundle("exporter.importer1");
        installer.resolveBundles(new Bundle[]{importerExporter1});
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] origExportedPackages = pa.getExportedPackages("exporter.importer.test");
        ClassLoadingBundleTests.assertNotNull((String)"No exporter.importer.test found", (Object)origExportedPackages);
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)origExportedPackages.length);
        Bundle exporter = origExportedPackages[0].getExportingBundle();
        ClassLoadingBundleTests.assertEquals("Wrong exporter", importerExporter1, exporter);
        Bundle[] origImporters = origExportedPackages[0].getImportingBundles();
        ClassLoadingBundleTests.assertTrue((String)"Should have no importers", (origImporters == null || origImporters.length == 0 ? 1 : 0) != 0);
        Bundle importerExporter2 = installer.installBundle("exporter.importer2");
        installer.resolveBundles(new Bundle[]{importerExporter2});
        origImporters = origExportedPackages[0].getImportingBundles();
        ClassLoadingBundleTests.assertNotNull((String)"No importers found", (Object)origImporters);
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of importers", (int)1, (int)origImporters.length);
        ClassLoadingBundleTests.assertEquals("Wrong importer", importerExporter2, origImporters[0]);
        ExportedPackage[] newExportedPackages = pa.getExportedPackages("exporter.importer.test");
        ClassLoadingBundleTests.assertNotNull((String)"No exporter.importer.test found", (Object)newExportedPackages);
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)newExportedPackages.length);
        exporter = newExportedPackages[0].getExportingBundle();
        ClassLoadingBundleTests.assertEquals("Wrong exporter", importerExporter1, exporter);
        Bundle[] newImporters = newExportedPackages[0].getImportingBundles();
        ClassLoadingBundleTests.assertNotNull((String)"No importers found", (Object)newImporters);
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of importers", (int)1, (int)newImporters.length);
        ClassLoadingBundleTests.assertEquals("Wrong importer", importerExporter2, newImporters[0]);
    }

    public void testImporterExporter02() throws BundleException {
        Bundle importerExporter3 = installer.installBundle("exporter.importer3");
        Bundle importerExporter4 = installer.installBundle("exporter.importer4");
        installer.resolveBundles(new Bundle[]{importerExporter3, importerExporter4});
        importerExporter3.start();
        importerExporter3.stop();
        importerExporter3.update();
        try {
            importerExporter3.start();
        }
        catch (Throwable t) {
            ClassLoadingBundleTests.fail((String)"Unexpected exception", (Throwable)t);
        }
    }

    public void testUninstallInUse01() throws BundleException {
        Bundle exporter1 = installer.installBundle("exporter.importer1");
        BundleRevision iExporter1 = (BundleRevision)exporter1.adapt(BundleRevision.class);
        Bundle exporter2 = installer.installBundle("exporter.importer2");
        installer.resolveBundles(new Bundle[]{exporter1, exporter2});
        exporter1.uninstall();
        Bundle importer = installer.installBundle("exporter.importer4");
        installer.resolveBundles(new Bundle[]{importer});
        BundleWiring importerWiring = (BundleWiring)importer.adapt(BundleWiring.class);
        ClassLoadingBundleTests.assertNotNull((String)"Bundle b has no wiring.", (Object)importerWiring);
        List bImports = importerWiring.getRequiredWires("osgi.wiring.package");
        ClassLoadingBundleTests.assertEquals((String)"Wrong number of imported packages.", (int)1, (int)bImports.size());
        ClassLoadingBundleTests.assertEquals("Wrong exporter.", iExporter1, ((BundleWire)bImports.get(0)).getProvider());
    }

    public void testBug207847() throws BundleException {
        Bundle test = installer.installBundle("test");
        installer.resolveBundles(new Bundle[]{test});
        test.start();
        Bundle frag1 = installer.installBundle("test.fragment1");
        Bundle frag2 = installer.installBundle("test.fragment2");
        Bundle frag3 = installer.installBundle("test.fragment3");
        Bundle frag4 = installer.installBundle("test.fragment4");
        Bundle frag5 = installer.installBundle("test.fragment5");
        installer.resolveBundles(new Bundle[]{frag1, frag2, frag3, frag4, frag5});
        ClassLoadingBundleTests.assertTrue((String)"host is not resolved", ((test.getState() & 0x20) != 0 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertTrue((String)"frag1 is not resolved", ((frag1.getState() & 4) != 0 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertTrue((String)"frag2 is not resolved", ((frag2.getState() & 4) != 0 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertTrue((String)"frag3 is not resolved", ((frag3.getState() & 4) != 0 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertTrue((String)"frag4 is not resolved", ((frag4.getState() & 4) != 0 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertTrue((String)"frag5 is not resolved", ((frag5.getState() & 4) != 0 ? 1 : 0) != 0);
    }

    public void testBug235958() throws BundleException {
        Bundle testX = installer.installBundle("test.bug235958.x");
        Bundle testY = installer.installBundle("test.bug235958.y");
        installer.resolveBundles(new Bundle[]{testX, testY});
        try {
            testX.start();
        }
        catch (Exception e) {
            ClassLoadingBundleTests.fail((String)"Unexpected Exception", (Throwable)e);
        }
    }

    public void testBuddyClassLoadingRegistered1() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        Enumeration testFiles = registeredA.getResources("resources/test.txt");
        ClassLoadingBundleTests.assertNotNull((String)"testFiles", (Object)testFiles);
        ArrayList<String> texts = new ArrayList<String>();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        ClassLoadingBundleTests.assertEquals((String)"test.txt number", (int)1, (int)texts.size());
        ClassLoadingBundleTests.assertTrue((String)"buddy.registered.a", (boolean)texts.contains("buddy.registered.a"));
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        testFiles = registeredA.getResources("resources/test.txt");
        ClassLoadingBundleTests.assertNotNull((String)"testFiles", (Object)testFiles);
        texts = new ArrayList();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        ClassLoadingBundleTests.assertEquals((String)"test.txt number", (int)3, (int)texts.size());
        ClassLoadingBundleTests.assertTrue((String)"buddy.registered.a", (boolean)texts.contains("buddy.registered.a"));
        ClassLoadingBundleTests.assertTrue((String)"buddy.registered.a.test1", (boolean)texts.contains("buddy.registered.a.test1"));
        ClassLoadingBundleTests.assertTrue((String)"buddy.registered.a.test2", (boolean)texts.contains("buddy.registered.a.test2"));
    }

    public void testBuddyClassLoadingRegistered2() throws Exception {
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        URL testFile = registeredA.getResource("resources/test1.txt");
        ClassLoadingBundleTests.assertNull((String)"test1.txt", (Object)testFile);
        testFile = registeredA.getResource("resources/test2.txt");
        ClassLoadingBundleTests.assertNull((String)"test2.txt", (Object)testFile);
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        testFile = registeredA.getResource("resources/test1.txt");
        ClassLoadingBundleTests.assertNotNull((String)"test1.txt", (Object)testFile);
        ClassLoadingBundleTests.assertEquals((String)"buddy.registered.a.test1", (String)"buddy.registered.a.test1", (String)this.readURL(testFile));
        testFile = registeredA.getResource("resources/test2.txt");
        ClassLoadingBundleTests.assertNotNull((String)"test2.txt", (Object)testFile);
        ClassLoadingBundleTests.assertEquals((String)"buddy.registered.a.test2", (String)"buddy.registered.a.test2", (String)this.readURL(testFile));
    }

    public void testBuddyClassLoadingRegistered3() throws Exception {
        Class testClass;
        Bundle registeredA = installer.installBundle("buddy.registered.a");
        installer.resolveBundles(new Bundle[]{registeredA});
        try {
            registeredA.loadClass("buddy.registered.a.test1.ATest");
            ClassLoadingBundleTests.fail((String)"expected ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            registeredA.loadClass("buddy.registered.a.test2.ATest");
            ClassLoadingBundleTests.fail((String)"expected ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        Bundle registeredATest1 = installer.installBundle("buddy.registered.a.test1");
        Bundle registeredATest2 = installer.installBundle("buddy.registered.a.test2");
        installer.resolveBundles(new Bundle[]{registeredATest1, registeredATest2});
        try {
            testClass = registeredA.loadClass("buddy.registered.a.test1.ATest");
            ClassLoadingBundleTests.assertNotNull((String)"testClass", (Object)testClass);
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected ClassNotFoundException", (Throwable)e);
        }
        try {
            testClass = registeredA.loadClass("buddy.registered.a.test2.ATest");
            ClassLoadingBundleTests.assertNotNull((String)"testClass", (Object)testClass);
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected ClassNotFoundException", (Throwable)e);
        }
    }

    public void testBuddyClassLoadingDependent1() throws Exception {
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        Enumeration testFiles = dependentA.getResources("resources/test.txt");
        ClassLoadingBundleTests.assertNotNull((String)"testFiles", (Object)testFiles);
        ArrayList<String> texts = new ArrayList<String>();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        ClassLoadingBundleTests.assertEquals((String)"test.txt number", (int)1, (int)texts.size());
        ClassLoadingBundleTests.assertTrue((String)"buddy.dependent.a", (boolean)texts.contains("buddy.dependent.a"));
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        testFiles = dependentA.getResources("resources/test.txt");
        ClassLoadingBundleTests.assertNotNull((String)"testFiles", (Object)testFiles);
        texts = new ArrayList();
        while (testFiles.hasMoreElements()) {
            texts.add(this.readURL((URL)testFiles.nextElement()));
        }
        ClassLoadingBundleTests.assertEquals((String)"test.txt number", (int)3, (int)texts.size());
        ClassLoadingBundleTests.assertTrue((String)"buddy.dependent.a", (boolean)texts.contains("buddy.dependent.a"));
        ClassLoadingBundleTests.assertTrue((String)"buddy.dependent.a.test1", (boolean)texts.contains("buddy.dependent.a.test1"));
        ClassLoadingBundleTests.assertTrue((String)"buddy.dependent.a.test2", (boolean)texts.contains("buddy.dependent.a.test2"));
    }

    public void testBuddyClassLoadingDependent2() throws Exception {
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        URL testFile = dependentA.getResource("resources/test1.txt");
        ClassLoadingBundleTests.assertNull((String)"test1.txt", (Object)testFile);
        testFile = dependentA.getResource("resources/test2.txt");
        ClassLoadingBundleTests.assertNull((String)"test2.txt", (Object)testFile);
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        testFile = dependentA.getResource("resources/test1.txt");
        ClassLoadingBundleTests.assertNotNull((String)"test1.txt", (Object)testFile);
        ClassLoadingBundleTests.assertEquals((String)"buddy.dependent.a.test1", (String)"buddy.dependent.a.test1", (String)this.readURL(testFile));
        testFile = dependentA.getResource("resources/test2.txt");
        ClassLoadingBundleTests.assertNotNull((String)"test2.txt", (Object)testFile);
        ClassLoadingBundleTests.assertEquals((String)"buddy.dependent.a.test2", (String)"buddy.dependent.a.test2", (String)this.readURL(testFile));
    }

    public void testBuddyClassLoadingDependent3() throws Exception {
        Class testClass;
        Bundle dependentA = installer.installBundle("buddy.dependent.a");
        installer.resolveBundles(new Bundle[]{dependentA});
        try {
            dependentA.loadClass("buddy.dependent.a.test1.ATest");
            ClassLoadingBundleTests.fail((String)"expected ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            dependentA.loadClass("buddy.dependent.a.test2.ATest");
            ClassLoadingBundleTests.fail((String)"expected ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        Bundle dependentATest1 = installer.installBundle("buddy.dependent.a.test1");
        Bundle dependentATest2 = installer.installBundle("buddy.dependent.a.test2");
        installer.resolveBundles(new Bundle[]{dependentATest1, dependentATest2});
        try {
            testClass = dependentA.loadClass("buddy.dependent.a.test1.ATest");
            ClassLoadingBundleTests.assertNotNull((String)"testClass", (Object)testClass);
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected ClassNotFoundException", (Throwable)e);
        }
        try {
            testClass = dependentA.loadClass("buddy.dependent.a.test2.ATest");
            ClassLoadingBundleTests.assertNotNull((String)"testClass", (Object)testClass);
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected ClassNotFoundException", (Throwable)e);
        }
    }

    public void testBuddyClassLoadingInvalid() throws Exception {
        Bundle invalidA = installer.installBundle("buddy.invalid.a");
        installer.resolveBundles(new Bundle[]{invalidA});
        invalidA.getResource("doesNotExist");
        try {
            invalidA.loadClass("does.not.Exist");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void testBuddyClassloadingBug438904() throws Exception {
        Bundle host = installer.installBundle("test.bug438904.host");
        Bundle frag = installer.installBundle("test.bug438904.frag");
        Bundle global = installer.installBundle("test.bug438904.global");
        installer.resolveBundles(new Bundle[]{host, frag, global});
        global.loadClass("test.bug438904.host.Test1");
        global.loadClass("test.bug438904.frag.Test2");
    }

    public void testContextFinderGetResource() throws IOException, InvalidSyntaxException {
        ClassLoader contextFinder = (ClassLoader)this.getContext().getService((ServiceReference)this.getContext().getServiceReferences(ClassLoader.class, "(equinox.classloader.type=contextClassLoader)").iterator().next());
        String resource = "META-INF/services/javax.print.PrintServiceLookup";
        URL systemURL = ClassLoader.getSystemClassLoader().getResource(resource);
        ClassLoadingBundleTests.assertNotNull((String)("Did not find a parent resource: " + resource), (Object)systemURL);
        URL url = contextFinder.getResource(resource);
        ArrayList<URL> urls = Collections.list(contextFinder.getResources(resource));
        ClassLoadingBundleTests.assertTrue((String)("Did not find a parent resource: " + urls), (urls.size() > 1 ? 1 : 0) != 0);
        ClassLoadingBundleTests.assertEquals((String)url.toExternalForm(), (String)((URL)urls.get(0)).toExternalForm());
    }

    public void testContextFinderEmptyGetResources() throws Exception {
        ClassLoader contextFinder = (ClassLoader)this.getContext().getService((ServiceReference)this.getContext().getServiceReferences(ClassLoader.class, "(equinox.classloader.type=contextClassLoader)").iterator().next());
        ClassLoader previousTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(contextFinder);
        ExecutorService pool = null;
        try {
            pool = Executors.newFixedThreadPool(3);
            WebService annotation = TestService.class.getAnnotation(WebService.class);
            String namespaceURI = annotation.serviceName();
            String localPart = annotation.targetNamespace();
            QName serviceName = new QName(namespaceURI, localPart);
            TestServiceImpl tsi = new TestServiceImpl();
            Endpoint endpoint = Endpoint.create((Object)tsi);
            HashMap<String, QName> props = new HashMap<String, QName>();
            props.put("javax.xml.ws.wsdl.service", serviceName);
            endpoint.setProperties(props);
            endpoint.setExecutor((Executor)pool);
            endpoint.publish("http://localhost:23512/service");
            URL wsdlURL = new URL("http://localhost:23512/service?wsdl");
            Service s = Service.create((URL)wsdlURL, (QName)serviceName);
            ClassLoadingBundleTests.assertNotNull((String)"Service is null.", (Object)s);
            TestService port = (TestService)s.getPort(TestService.class);
            ClassLoadingBundleTests.assertEquals((String)"Wrong result.", (String)"Hello World", (String)port.hello("World"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousTCCL);
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    public void testBundleClassLoaderEmptyGetResources() throws Exception {
        ClassLoader bundleClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.doTestEmptyGetResources(bundleClassLoader, "META-INF/services/test.does.note.ExistService");
    }

    private void doTestEmptyGetResources(ClassLoader testClassLoader, String resource) throws Exception {
        URL systemURL = ClassLoader.getSystemClassLoader().getResource(resource);
        ClassLoadingBundleTests.assertNull((String)("Found a parent resource: " + resource), (Object)systemURL);
        URL testurl = testClassLoader.getResource(resource);
        ClassLoadingBundleTests.assertNull((String)("Found a resource: " + resource), (Object)testurl);
        Enumeration<URL> testResources = testClassLoader.getResources(resource);
        ClassLoadingBundleTests.assertNotNull((String)("null resources from testClassLoader: " + resource), testResources);
        ClassLoadingBundleTests.assertFalse((String)"Resources has elements.", (boolean)testResources.hasMoreElements());
    }

    public void testBundleReference01() throws Exception {
        Bundle test = installer.installBundle("test");
        Class clazz = test.loadClass("test1.Activator");
        Bundle bundle = FrameworkUtil.getBundle((Class)clazz);
        ClassLoadingBundleTests.assertEquals("Wrong bundle", test, bundle);
    }

    public void testBundleReference02() throws Exception {
        Bundle test = installer.installBundle("test");
        Class clazz = test.loadClass("test1.Activator");
        ClassLoader cl = clazz.getClassLoader();
        if (!(cl instanceof BundleReference)) {
            ClassLoadingBundleTests.fail((String)"ClassLoader is not of type BundleReference");
        }
        ClassLoadingBundleTests.assertEquals("Wrong bundle", test, ((BundleReference)cl).getBundle());
    }

    public void testResolveURLRelativeBundleResourceWithPort() throws Exception {
        URL directory = new URL("bundleresource://82:1/dictionaries/");
        ClassLoadingBundleTests.assertEquals((int)1, (int)directory.getPort());
        URL resource = new URL(directory, "en_GB.dictionary");
        ClassLoadingBundleTests.assertEquals((int)1, (int)resource.getPort());
    }

    public void testManifestPackageSpec() {
        try {
            Bundle test = installer.installBundle("test.manifestpackage");
            test.start();
        }
        catch (Exception e) {
            ClassLoadingBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testArrayTypeLoad() {
        this.doTestArrayTypeLoad("[B");
        this.doTestArrayTypeLoad("[C");
        this.doTestArrayTypeLoad("[D");
        this.doTestArrayTypeLoad("[F");
        this.doTestArrayTypeLoad("[I");
        this.doTestArrayTypeLoad("[J");
        this.doTestArrayTypeLoad("[S");
        this.doTestArrayTypeLoad("[Z");
        this.doTestArrayTypeLoad("[Lorg.eclipse.osgi.tests.bundles.ArrayTest;");
        this.doTestArrayTypeLoad("[[D");
        this.doTestArrayTypeLoad("[[Lorg.eclipse.osgi.tests.bundles.ArrayTest;");
    }

    public void testSystemBundleGetResources01() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        Enumeration resources = null;
        try {
            resources = systemBundle.getResources("systembundle.properties");
        }
        catch (IOException e) {
            ClassLoadingBundleTests.fail((String)"Failed to get resources", (Throwable)e);
        }
        ClassLoadingBundleTests.assertNotNull((String)"Resources is null", (Object)resources);
    }

    public void testSystemBundleGetResources02() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        Enumeration resources = null;
        try {
            resources = systemBundle.getResources("java/lang/test.resource");
        }
        catch (IOException e) {
            ClassLoadingBundleTests.fail((String)"Failed to get resources", (Throwable)e);
        }
        ClassLoadingBundleTests.assertNull((String)"Resources is not null", (Object)resources);
    }

    public void testBug299921() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Enumeration resources = null;
        try {
            Method findMethod = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            findMethod.setAccessible(true);
            resources = (Enumeration)findMethod.invoke((Object)cl, "test/doesnotexist.txt");
        }
        catch (Exception e) {
            ClassLoadingBundleTests.fail((String)"Unexpected error calling getResources", (Throwable)e);
        }
        ClassLoadingBundleTests.assertNotNull((String)"Should not be null", resources);
        ClassLoadingBundleTests.assertFalse((String)"Found resources!", (boolean)resources.hasMoreElements());
        try {
            resources = cl.getResources("test/doesnotexist.txt");
        }
        catch (IOException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected IOException", (Throwable)e);
        }
        ClassLoadingBundleTests.assertNotNull((String)"Should not be null", resources);
        ClassLoadingBundleTests.assertFalse((String)"Found resources!", (boolean)resources.hasMoreElements());
    }

    public void testBug306181() throws BundleException {
        StartLevel sl = installer.getStartLevel();
        int origSL = sl.getStartLevel();
        int origBundleSL = sl.getInitialBundleStartLevel();
        int newSL = origSL + 1;
        sl.setInitialBundleStartLevel(newSL);
        try {
            Bundle a = installer.installBundle("test.bug306181a");
            Bundle b = installer.installBundle("test.bug306181b");
            sl.setBundleStartLevel(a, newSL);
            sl.setBundleStartLevel(b, newSL);
            installer.resolveBundles(new Bundle[]{a, b});
            a.start();
            b.start(2);
            sl.setStartLevel(newSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            ClassLoadingBundleTests.assertEquals((String)"Bundle A is not active", (int)32, (int)a.getState());
            ClassLoadingBundleTests.assertEquals((String)"Bundle B is not active", (int)8, (int)b.getState());
            ServiceReference[] regs = a.getRegisteredServices();
            if (regs != null && regs.length > 0) {
                ClassLoadingBundleTests.fail((String)OSGiTestsActivator.getContext().getService(regs[0]).toString());
            }
        }
        catch (Throwable throwable) {
            sl.setInitialBundleStartLevel(origBundleSL);
            sl.setStartLevel(origSL);
            Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
            Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
            ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
            throw throwable;
        }
        sl.setInitialBundleStartLevel(origBundleSL);
        sl.setStartLevel(origSL);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(8, OSGiTestsActivator.getContext().getBundle(0L), null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    public void testBug348805() {
        boolean[] endCalled;
        block7: {
            endCalled = new boolean[1];
            ResolverHookFactory error = new ResolverHookFactory(){

                public ResolverHook begin(Collection triggers) {
                    return new ResolverHook(){

                        public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        }

                        public void filterResolvable(Collection candidates) {
                            throw new RuntimeException("Error");
                        }

                        public void filterMatches(BundleRequirement requirement, Collection candidates) {
                        }

                        public void end() {
                            endCalled[0] = true;
                        }
                    };
                }
            };
            ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
            try {
                try {
                    Bundle test = installer.installBundle("test");
                    try {
                        test.start();
                        ClassLoadingBundleTests.fail((String)"Should not be able to start this bundle");
                    }
                    catch (BundleException e) {
                        ClassLoadingBundleTests.assertEquals((String)"Wrong exception type.", (int)12, (int)e.getType());
                    }
                }
                catch (BundleException e) {
                    ClassLoadingBundleTests.fail((String)"Unexpected install fail", (Throwable)e);
                    reg.unregister();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                reg.unregister();
                throw throwable;
            }
            reg.unregister();
        }
        ClassLoadingBundleTests.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    public void testBug348806() {
        ResolverHookFactory error = new ResolverHookFactory(){

            public ResolverHook begin(Collection triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                    }

                    public void filterResolvable(Collection candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection candidates) {
                    }

                    public void end() {
                        throw new RuntimeException("Error");
                    }
                };
            }
        };
        ServiceRegistration reg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
        try {
            try {
                Bundle test = installer.installBundle("test");
                try {
                    test.start();
                    ClassLoadingBundleTests.fail((String)"Should not be able to start this bundle");
                }
                catch (BundleException e) {
                    ClassLoadingBundleTests.assertEquals((String)"Wrong exception type.", (int)12, (int)e.getType());
                }
            }
            catch (BundleException e) {
                ClassLoadingBundleTests.fail((String)"Unexpected install fail", (Throwable)e);
                reg.unregister();
            }
        }
        finally {
            reg.unregister();
        }
    }

    public void testBug370258_beginException() {
        boolean[] endCalled;
        block7: {
            endCalled = new boolean[1];
            ResolverHookFactory endHook = new ResolverHookFactory(){

                public ResolverHook begin(Collection triggers) {
                    return new ResolverHook(){

                        public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        }

                        public void filterResolvable(Collection candidates) {
                            throw new RuntimeException("Error");
                        }

                        public void filterMatches(BundleRequirement requirement, Collection candidates) {
                        }

                        public void end() {
                            endCalled[0] = true;
                        }
                    };
                }
            };
            ResolverHookFactory error = new ResolverHookFactory(){

                public ResolverHook begin(Collection triggers) {
                    throw new RuntimeException("Error");
                }
            };
            ServiceRegistration endReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)endHook, null);
            ServiceRegistration errorReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
            try {
                try {
                    Bundle test = installer.installBundle("test");
                    try {
                        test.start();
                        ClassLoadingBundleTests.fail((String)"Should not be able to start this bundle");
                    }
                    catch (BundleException e) {
                        ClassLoadingBundleTests.assertEquals((String)"Wrong exception type.", (int)12, (int)e.getType());
                    }
                }
                catch (BundleException e) {
                    ClassLoadingBundleTests.fail((String)"Unexpected install fail", (Throwable)e);
                    errorReg.unregister();
                    endReg.unregister();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                errorReg.unregister();
                endReg.unregister();
                throw throwable;
            }
            errorReg.unregister();
            endReg.unregister();
        }
        ClassLoadingBundleTests.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    public void testBug370258_endException() {
        boolean[] endCalled;
        block7: {
            endCalled = new boolean[1];
            ResolverHookFactory endHook = new ResolverHookFactory(){

                public ResolverHook begin(Collection triggers) {
                    return new ResolverHook(){

                        public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        }

                        public void filterResolvable(Collection candidates) {
                            throw new RuntimeException("Error");
                        }

                        public void filterMatches(BundleRequirement requirement, Collection candidates) {
                        }

                        public void end() {
                            endCalled[0] = true;
                        }
                    };
                }
            };
            ResolverHookFactory error = new ResolverHookFactory(){

                public ResolverHook begin(Collection triggers) {
                    return new ResolverHook(){

                        public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        }

                        public void filterResolvable(Collection candidates) {
                        }

                        public void filterMatches(BundleRequirement requirement, Collection candidates) {
                        }

                        public void end() {
                            throw new RuntimeException("Error");
                        }
                    };
                }
            };
            ServiceRegistration errorReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)error, null);
            ServiceRegistration endReg = OSGiTestsActivator.getContext().registerService(ResolverHookFactory.class, (Object)endHook, null);
            try {
                try {
                    Bundle test = installer.installBundle("test");
                    try {
                        test.start();
                        ClassLoadingBundleTests.fail((String)"Should not be able to start this bundle");
                    }
                    catch (BundleException e) {
                        ClassLoadingBundleTests.assertEquals((String)"Wrong exception type.", (int)12, (int)e.getType());
                    }
                }
                catch (BundleException e) {
                    ClassLoadingBundleTests.fail((String)"Unexpected install fail", (Throwable)e);
                    errorReg.unregister();
                    endReg.unregister();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                errorReg.unregister();
                endReg.unregister();
                throw throwable;
            }
            errorReg.unregister();
            endReg.unregister();
        }
        ClassLoadingBundleTests.assertTrue((String)"end is not called", (boolean)endCalled[0]);
    }

    public void testLoadClassUnresolved() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        ClassLoadingBundleTests.assertFalse((String)("Should not resolve bundle: " + chainTest), (boolean)installer.resolveBundles(new Bundle[]{chainTest}));
        try {
            ClassLoadingBundleTests.fail((String)("Should not be able to load class: " + chainTest.loadClass("chain.test.TestSingleChain")));
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private void doTestArrayTypeLoad(String name) {
        try {
            Class arrayType = OSGiTestsActivator.getContext().getBundle().loadClass(name);
            ClassLoadingBundleTests.assertNotNull((String)"Null class", (Object)arrayType);
            ClassLoadingBundleTests.assertTrue((String)("Class is not an array: " + arrayType), (boolean)arrayType.isArray());
        }
        catch (ClassNotFoundException e) {
            ClassLoadingBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    private String readURL(URL url) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    sb.append('\n');
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ClassLoadingBundleTests.fail((String)("Unexpected exception reading url: " + url.toExternalForm()), (Throwable)e);
        }
        return sb.toString();
    }

    public void testDefaultLocalUninstall() throws Exception {
        Bundle test = installer.installBundle("security.a");
        test.uninstall();
        Dictionary headers = test.getHeaders();
        String bundleName = (String)headers.get("Bundle-Name");
        ClassLoadingBundleTests.assertEquals((String)"Wrong bundle name header.", (String)"default", (String)bundleName);
    }

    public void testBug490902() throws BundleException, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        final Bundle a1 = installer.installBundle("test.bug490902.a");
        final Bundle b1 = installer.installBundle("test.bug490902.b");
        installer.resolveBundles(new Bundle[]{a1, b1});
        final CountDownLatch startingB = new CountDownLatch(1);
        final CountDownLatch endedSecondThread = new CountDownLatch(1);
        SynchronousBundleListener delayB1 = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == b1 && 128 == event.getType()) {
                    try {
                        startingB.countDown();
                        System.out.println(String.valueOf(ClassLoadingBundleTests.this.getName()) + ": Delaying now ...");
                        Thread.sleep(15000L);
                        System.out.println(String.valueOf(ClassLoadingBundleTests.this.getName()) + ": Done delaying.");
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.getContext().addBundleListener((BundleListener)delayB1);
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println(String.valueOf(ClassLoadingBundleTests.this.getName()) + ": Initial load test.");
                        a1.loadClass("test.bug490902.a.TestLoadA1").newInstance();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }, "Initial load test thread.").start();
            startingB.await();
            Thread secondThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            System.out.println(String.valueOf(ClassLoadingBundleTests.this.getName()) + ": Second load test.");
                            a1.loadClass("test.bug490902.a.TestLoadA1").newInstance();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            endedSecondThread.countDown();
                        }
                    }
                    finally {
                        endedSecondThread.countDown();
                    }
                }
            }, "Second load test thread.");
            secondThread.start();
            Thread.sleep(10000L);
            System.out.println(String.valueOf(this.getName()) + ": About to interrupt:" + secondThread.getName());
            secondThread.interrupt();
            endedSecondThread.await();
            a1.loadClass("test.bug490902.a.TestLoadA1").newInstance();
        }
        finally {
            this.getContext().removeBundleListener((BundleListener)delayB1);
        }
    }

    public void testRecursiveWeavingHookFactory() {
        final ThreadLocal<Boolean> testThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        testThread.set(Boolean.TRUE);
        final HashSet weavingHookClasses = new HashSet();
        final ArrayList called = new ArrayList();
        final AtomicBoolean loadNewClassInWeave = new AtomicBoolean(false);
        ServiceFactory<WeavingHook> topFactory = new ServiceFactory<WeavingHook>(){

            public WeavingHook getService(Bundle bundle, ServiceRegistration<WeavingHook> registration) {
                if (!((Boolean)testThread.get()).booleanValue()) {
                    return null;
                }
                WeavingHook hook = new WeavingHook(){

                    public void weave(WovenClass wovenClass) {
                        if (loadNewClassInWeave.get()) {
                            Runnable run = new Runnable(){

                                @Override
                                public void run() {
                                }
                            };
                            run.run();
                            weavingHookClasses.add(run.getClass().getName());
                        }
                        called.add(wovenClass);
                    }
                };
                weavingHookClasses.add(hook.getClass().getName());
                return hook;
            }

            public void ungetService(Bundle bundle, ServiceRegistration<WeavingHook> registration, WeavingHook service) {
            }
        };
        ServiceRegistration reg = this.getContext().registerService(WeavingHook.class, (ServiceFactory)topFactory, null);
        Runnable run = null;
        try {
            topFactory.getService(null, null);
            loadNewClassInWeave.set(true);
            run = new Runnable(){

                @Override
                public void run() {
                }
            };
            run.run();
        }
        finally {
            reg.unregister();
        }
        ClassLoadingBundleTests.assertEquals((String)"Unexpected number of woven classes.", (int)3, (int)called.size());
        for (WovenClass wovenClass : called) {
            if (weavingHookClasses.contains(wovenClass.getClassName())) {
                ClassLoadingBundleTests.assertNull((String)("Did not expect to find class: " + wovenClass.getDefinedClass()), (Object)wovenClass.getDefinedClass());
                continue;
            }
            ClassLoadingBundleTests.assertEquals("Expected the inner runnable class.", run.getClass(), wovenClass.getDefinedClass());
        }
    }

    public void testLoaderUninstalledBundle() throws BundleException, IOException {
        String testResourcePath = "testResource";
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> testHeaders = new HashMap<String, String>();
        testHeaders.put("Bundle-ManifestVersion", "2");
        testHeaders.put("Bundle-SymbolicName", this.getName());
        config.mkdirs();
        File testBundleFile = SystemBundleTests.createBundle(config, this.getName(), testHeaders, Collections.singletonMap(testResourcePath, "testValue"));
        Bundle test = this.getContext().installBundle(this.getName(), (InputStream)new FileInputStream(testBundleFile));
        test.start();
        BundleWiring wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoadingBundleTests.assertNotNull((String)"No wiring found.", (Object)wiring);
        ModuleClassLoader bundleClassLoader = (ModuleClassLoader)wiring.getClassLoader();
        URL testResource = bundleClassLoader.findLocalResource(testResourcePath);
        ClassLoadingBundleTests.assertNotNull((String)"No test resource found.", (Object)testResource);
        test.update((InputStream)new FileInputStream(testBundleFile));
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        ClassLoadingBundleTests.assertNull((String)"Found resource.", (Object)testResource);
        Object[] expectedFrameworkEvents = new Object[]{new FrameworkEvent(32, test, null)};
        Object[] actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
        wiring = (BundleWiring)test.adapt(BundleWiring.class);
        ClassLoadingBundleTests.assertNotNull((String)"No wiring found.", (Object)wiring);
        bundleClassLoader = (ModuleClassLoader)wiring.getClassLoader();
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        ClassLoadingBundleTests.assertNotNull((String)"No test resource found.", (Object)testResource);
        test.uninstall();
        testResource = bundleClassLoader.findLocalResource(testResourcePath);
        ClassLoadingBundleTests.assertNull((String)"Found resource.", (Object)testResource);
        actualFrameworkEvents = frameworkListenerResults.getResults(1);
        ClassLoadingBundleTests.compareResults(expectedFrameworkEvents, actualFrameworkEvents);
    }

    @WebService(endpointInterface="org.eclipse.osgi.tests.bundles.TestService")
    public static class TestServiceImpl
    implements TestService {
        @Override
        public String hello(String name) {
            return "Hello " + name;
        }
    }
}

