/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class DiscardBundleTests
extends AbstractBundleTests {
    private static final String BUNDLE_DIR = "discardable";
    private static final String BUNDLE_JAR = "discardable.jar";
    private static final String BUNDLE_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String OSGI_DEV = "osgi.dev";
    private static final String OSGI_CHECKCONFIGURATION = "osgi.checkConfiguration";
    private static final String REFERENCE_PROTOCOL = "reference:";
    private File root;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.root = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.createBundleDirectory();
        this.createBundleJar();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(DiscardBundleTests.class);
    }

    public void testDiscardOsgiCheckConfigurationTrueOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.TRUE.toString());
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, true);
    }

    public void testDiscardOsgiCheckConfigurationTrueOsgiDevUnspecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.TRUE.toString());
        this.doTest(configuration, true);
    }

    public void testDiscardOsgiCheckConfigurationUnspecifiedOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, true);
    }

    public void testNoDiscardOsgiCheckConfigurationFalseOsgiDevSpecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.FALSE.toString());
        configuration.put(OSGI_DEV, "");
        this.doTest(configuration, false);
    }

    public void testNoDiscardOsgiCheckConfigurationFalseOsgiDevUnspecified() throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        configuration.put(OSGI_CHECKCONFIGURATION, Boolean.FALSE.toString());
        this.doTest(configuration, false);
    }

    public void testNoDiscardOsgiCheckConfigurationUnspecifiedOsgiDevUnspecified() throws Exception {
        this.doTest(this.createConfiguration(), false);
    }

    public void testDiscardDeletedBundleFile() throws Exception {
        this.doTestDiscardDeletedBundleFile(this.getDirectoryLocation());
        this.doTestDiscardDeletedBundleFile(this.getJarLocation());
    }

    private void doTestDiscardDeletedBundleFile(File bundleFile) throws Exception {
        Map<String, Object> configuration = this.createConfiguration();
        Equinox equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        try {
            String location = REFERENCE_PROTOCOL + bundleFile.toURI();
            equinox.getBundleContext().installBundle(location);
            equinox = this.restart(equinox, configuration);
            this.assertNotDiscarded(location, equinox);
            this.stop(equinox);
            DiscardBundleTests.rm(bundleFile);
            equinox = this.restart(equinox, configuration);
            this.assertDiscarded(location, equinox);
        }
        finally {
            this.stopQuietly(equinox);
        }
    }

    private void assertDiscarded(String location, Equinox equinox) {
        DiscardBundleTests.assertNull((String)"The bundle was not discarded", (Object)equinox.getBundleContext().getBundle(location));
    }

    private void assertNotDiscarded(String location, Equinox equinox) {
        DiscardBundleTests.assertNotNull((String)"The bundle was discarded", (Object)equinox.getBundleContext().getBundle(location));
    }

    private void createBundleDirectory() throws IOException {
        File file = new File(this.root, "discardable/META-INF/MANIFEST.MF");
        DiscardBundleTests.assertTrue((String)"Could not make directories", (boolean)file.getParentFile().mkdirs());
        Manifest manifest = this.createBundleManifest();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            manifest.write(fos);
        }
        finally {
            fos.close();
        }
    }

    private void createBundleJar() throws IOException {
        Manifest manifest = this.createBundleManifest();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(new File(this.root, BUNDLE_JAR)), manifest);
        target.close();
    }

    private Manifest createBundleManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Bundle-SymbolicName", BUNDLE_DIR);
        return manifest;
    }

    private Map<String, Object> createConfiguration() {
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("org.osgi.framework.storage", file.getAbsolutePath());
        return result;
    }

    private void doTest(Map<String, ?> configuration, boolean discard) throws Exception {
        this.doTest(configuration, discard, this.getDirectoryLocation());
        this.doTest(configuration, discard, this.getJarLocation());
    }

    private void doTest(Map<String, ?> configuration, boolean discard, File bundleFile) throws Exception {
        Equinox equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        try {
            String location = REFERENCE_PROTOCOL + bundleFile.toURI();
            equinox.getBundleContext().installBundle(location);
            try {
                equinox = this.restart(equinox, configuration);
                this.assertNotDiscarded(location, equinox);
                this.stop(equinox);
                this.touchFile(bundleFile);
                equinox = this.restart(equinox, configuration);
                if (discard) {
                    this.assertDiscarded(location, equinox);
                } else {
                    this.assertNotDiscarded(location, equinox);
                }
            }
            catch (Throwable throwable) {
                try {
                    equinox.getBundleContext().getBundle(location).uninstall();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                equinox.getBundleContext().getBundle(location).uninstall();
            }
            catch (Exception exception) {}
        }
        finally {
            this.stopQuietly(equinox);
        }
    }

    private File getDirectoryLocation() {
        return new File(this.root, BUNDLE_DIR);
    }

    private File getJarLocation() {
        return new File(this.root, BUNDLE_JAR);
    }

    private void initAndStart(Equinox equinox) throws BundleException {
        equinox.init();
        equinox.start();
    }

    private Equinox restart(Equinox equinox, Map<String, ?> configuration) throws BundleException, InterruptedException {
        this.stop(equinox);
        equinox = new Equinox(configuration);
        this.initAndStart(equinox);
        return equinox;
    }

    private void stop(Equinox equinox) throws BundleException, InterruptedException {
        equinox.stop();
        FrameworkEvent event = equinox.waitForStop(5000L);
        DiscardBundleTests.assertEquals((String)"The framework was not stopped", (int)64, (int)event.getType());
    }

    private void stopQuietly(Equinox equinox) {
        if (equinox == null) {
            return;
        }
        try {
            equinox.stop();
            equinox.waitForStop(5000L);
        }
        catch (Exception exception) {}
    }

    private void touchFile(File file) {
        if (file.isDirectory()) {
            file = new File(file, BUNDLE_MANIFEST);
        }
        DiscardBundleTests.assertTrue((String)("Could not set last modified: " + file), (boolean)file.setLastModified(file.lastModified() + 1000L));
    }

    public static boolean rm(File file) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                int i = 0;
                while (i < len) {
                    DiscardBundleTests.rm(new File(file, list[i]));
                    ++i;
                }
            }
            return file.delete();
        }
        return true;
    }
}

