/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class SubstituteExportsBundleTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(SubstituteExportsBundleTests.class);
    }

    public void testSubstituteExports01x() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.x.Ax";
        Class ax = null;
        Class bx = null;
        Class cx = null;
        Class dx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            cx = c.loadClass(className);
            dx = d.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, cx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, dx);
    }

    public void testSubstituteExports01y() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.y.Ay";
        Class ax = null;
        Class bx = null;
        Class cx = null;
        Class dx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            cx = c.loadClass(className);
            dx = d.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, cx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, dx);
    }

    public void testSubstituteExports02() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        String className = "substitutes.x.Ax";
        Class ax = null;
        Class bx = null;
        Class ex = null;
        Class fx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            ex = e.loadClass(className);
            fx = f.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, ex);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, fx);
    }

    public void testSubstituteExports03() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        String className = "substitutes.x.Ax";
        Class ax = null;
        Class bx = null;
        Class ex = null;
        Class fx = null;
        Class gx = null;
        Class hx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            ex = e.loadClass(className);
            fx = f.loadClass(className);
            gx = g.loadClass(className);
            hx = h.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, ex);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, fx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, gx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, hx);
    }

    public void testSubstituteExports04() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        installer.installBundle("substitutes.a.frag");
        Bundle b = installer.installBundle("substitutes.b");
        installer.installBundle("substitutes.b.frag");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        String className = "substitutes.x.Ax";
        Class ax = null;
        Class bx = null;
        Class cx = null;
        Class dx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            cx = c.loadClass(className);
            dx = d.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, cx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, dx);
        String className2 = "substitutes.q.AFq";
        Class aq = null;
        Class bq = null;
        Class cq = null;
        Class dq = null;
        try {
            aq = a.loadClass(className2);
            bq = b.loadClass(className2);
            cq = c.loadClass(className2);
            dq = d.loadClass(className2);
        }
        catch (ClassNotFoundException e) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", aq, bq);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", aq, cq);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", aq, dq);
    }

    public void testSubstituteExports05() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        installer.installBundle("substitutes.a.frag");
        Bundle b = installer.installBundle("substitutes.b");
        installer.installBundle("substitutes.b.frag");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        String className = "substitutes.x.Ax";
        Class ax = null;
        Class bx = null;
        Class ex = null;
        Class fx = null;
        Class gx = null;
        Class hx = null;
        try {
            ax = a.loadClass(className);
            bx = b.loadClass(className);
            ex = e.loadClass(className);
            fx = f.loadClass(className);
            gx = g.loadClass(className);
            hx = h.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", ax, bx);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", ax, ex);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, fx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, gx);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", ax, hx);
        String className2 = "substitutes.q.AFq";
        Class aq = null;
        Class bq = null;
        Class eq = null;
        Class fq = null;
        Class gq = null;
        Class hq = null;
        try {
            aq = a.loadClass(className2);
            bq = b.loadClass(className2);
            eq = e.loadClass(className2);
            fq = f.loadClass(className2);
            gq = g.loadClass(className2);
            hq = h.loadClass(className2);
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        SubstituteExportsBundleTests.assertEquals("class from b is wrong", aq, bq);
        SubstituteExportsBundleTests.assertEquals("class from c is wrong", aq, eq);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", aq, fq);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", aq, gq);
        SubstituteExportsBundleTests.assertEquals("class from d is wrong", aq, hq);
    }

    public void testSubstituteExports06() throws BundleException {
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        String classNameIx = "substitutes.x.Ix";
        String classNameKx = "substitutes.x.Kx";
        String classNameMx = "substitutes.x.Mx";
        String classNameIy = "substitutes.y.Iy";
        String classNameKy = "substitutes.y.Ky";
        String classNameMy = "substitutes.y.My";
        try {
            Class iX = iBundle.loadClass(classNameIx);
            SubstituteExportsBundleTests.assertEquals("jBundle has different copy of iX", iX, jBundle.loadClass(classNameIx));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of iX", iX, mBundle.loadClass(classNameIx));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of iX", iX, nBundle.loadClass(classNameIx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of iX", iX, pBundle.loadClass(classNameIx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of iX", iX, qBundle.loadClass(classNameIx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class iY = iBundle.loadClass(classNameIy);
            SubstituteExportsBundleTests.assertEquals("jBundle has different copy of iY", iY, jBundle.loadClass(classNameIy));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of iY", iY, mBundle.loadClass(classNameIy));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of iY", iY, nBundle.loadClass(classNameIy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of iY", iY, pBundle.loadClass(classNameIy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of iY", iY, qBundle.loadClass(classNameIy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class kX = kBundle.loadClass(classNameKx);
            SubstituteExportsBundleTests.assertEquals("lBundle has different copy of Kx", kX, lBundle.loadClass(classNameKx));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Kx", kX, mBundle.loadClass(classNameKx));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Kx", kX, nBundle.loadClass(classNameKx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Kx", kX, pBundle.loadClass(classNameKx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Kx", kX, qBundle.loadClass(classNameKx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class kY = kBundle.loadClass(classNameKy);
            SubstituteExportsBundleTests.assertEquals("lBundle has different copy of Ky", kY, lBundle.loadClass(classNameKy));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Ky", kY, mBundle.loadClass(classNameKy));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Ky", kY, nBundle.loadClass(classNameKy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Ky", kY, pBundle.loadClass(classNameKy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Ky", kY, qBundle.loadClass(classNameKy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class mX = mBundle.loadClass(classNameMx);
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of mX", mX, nBundle.loadClass(classNameMx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of mX", mX, pBundle.loadClass(classNameMx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of mX", mX, qBundle.loadClass(classNameMx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class mY = mBundle.loadClass(classNameMy);
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of mY", mY, nBundle.loadClass(classNameMy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of mY", mY, pBundle.loadClass(classNameMy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of mY", mY, qBundle.loadClass(classNameMy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        String[] unexpectedClasseNames = new String[]{"substitutes.x.Jx", "substitutes.x.Lx", "substitutes.x.Nx", "substitutes.y.Jy", "substitutes.y.Ly", "substitutes.y.Ny"};
        int i = 0;
        while (i < unexpectedClasseNames.length) {
            int j = 0;
            while (j < allBundles.length) {
                try {
                    Class found = allBundles[j].loadClass(unexpectedClasseNames[i]);
                    SubstituteExportsBundleTests.fail((String)("Found class " + found + " in bundle " + allBundles[j]));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++j;
            }
            ++i;
        }
    }

    public void testSubstituteExports07() throws BundleException {
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        String classNameJx = "substitutes.x.Jx";
        String classNameLx = "substitutes.x.Lx";
        String classNameNx = "substitutes.x.Nx";
        String classNameJy = "substitutes.y.Jy";
        String classNameLy = "substitutes.y.Ly";
        String classNameNy = "substitutes.y.Ny";
        try {
            Class jX = jBundle.loadClass(classNameJx);
            SubstituteExportsBundleTests.assertEquals("iBundle has different copy of Jx", jX, iBundle.loadClass(classNameJx));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Jx", jX, mBundle.loadClass(classNameJx));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Jx", jX, nBundle.loadClass(classNameJx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Jx", jX, pBundle.loadClass(classNameJx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Jx", jX, qBundle.loadClass(classNameJx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class jY = jBundle.loadClass(classNameJy);
            SubstituteExportsBundleTests.assertEquals("jBundle has different copy of Jy", jY, iBundle.loadClass(classNameJy));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Jy", jY, mBundle.loadClass(classNameJy));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Jy", jY, nBundle.loadClass(classNameJy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Jy", jY, pBundle.loadClass(classNameJy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Jy", jY, qBundle.loadClass(classNameJy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class lX = lBundle.loadClass(classNameLx);
            SubstituteExportsBundleTests.assertEquals("lBundle has different copy of Lx", lX, kBundle.loadClass(classNameLx));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Lx", lX, mBundle.loadClass(classNameLx));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Lx", lX, nBundle.loadClass(classNameLx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Lx", lX, pBundle.loadClass(classNameLx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Lx", lX, qBundle.loadClass(classNameLx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class lY = lBundle.loadClass(classNameLy);
            SubstituteExportsBundleTests.assertEquals("lBundle has different copy of Ly", lY, kBundle.loadClass(classNameLy));
            SubstituteExportsBundleTests.assertEquals("mBundle has different copy of Ly", lY, mBundle.loadClass(classNameLy));
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Ly", lY, nBundle.loadClass(classNameLy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Ly", lY, pBundle.loadClass(classNameLy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Ly", lY, qBundle.loadClass(classNameLy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class nX = nBundle.loadClass(classNameNx);
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Nx", nX, mBundle.loadClass(classNameNx));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Nx", nX, pBundle.loadClass(classNameNx));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Nx", nX, qBundle.loadClass(classNameNx));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        try {
            Class nY = nBundle.loadClass(classNameNy);
            SubstituteExportsBundleTests.assertEquals("nBundle has different copy of Ny", nY, mBundle.loadClass(classNameNy));
            SubstituteExportsBundleTests.assertEquals("pBundle has different copy of Ny", nY, pBundle.loadClass(classNameNy));
            SubstituteExportsBundleTests.assertEquals("qBundle has different copy of Ny", nY, qBundle.loadClass(classNameNy));
        }
        catch (ClassNotFoundException cnfe) {
            SubstituteExportsBundleTests.fail((String)"Unexpected exception", (Throwable)cnfe);
        }
        String[] unexpectedClasseNames = new String[]{"substitutes.x.Ix", "substitutes.x.Kx", "substitutes.x.Mx", "substitutes.y.Iy", "substitutes.y.Ky", "substitutes.y.My"};
        int i = 0;
        while (i < unexpectedClasseNames.length) {
            int j = 0;
            while (j < allBundles.length) {
                try {
                    Class found = allBundles[j].loadClass(unexpectedClasseNames[i]);
                    SubstituteExportsBundleTests.fail((String)("Found class " + found + " in bundle " + allBundles[j]));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++j;
            }
            ++i;
        }
    }

    public void testSubstituteExports08() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        Bundle[] allBundles = new Bundle[]{a, b, c, d};
        this.doRefreshTest(allBundles, a);
    }

    public void testSubstituteExports09() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle[] allBundles = new Bundle[]{a, b, e, f};
        this.doRefreshTest(allBundles, a);
    }

    public void testSubstituteExports10() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle e = installer.installBundle("substitutes.e");
        Bundle f = installer.installBundle("substitutes.f");
        Bundle g = installer.installBundle("substitutes.g");
        Bundle h = installer.installBundle("substitutes.h");
        Bundle[] allBundles = new Bundle[]{a, b, e, f, g, h};
        this.doRefreshTest(allBundles, a);
    }

    public void testSubstituteExports11() throws BundleException {
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        installer.installBundle("substitutes.k");
        installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, mBundle, nBundle, pBundle, qBundle};
        this.doRefreshTest(allBundles, iBundle);
    }

    public void testSubstituteExports12() throws BundleException {
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle iBundle = installer.installBundle("substitutes.i");
        installer.installBundle("substitutes.l");
        installer.installBundle("substitutes.k");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, mBundle, nBundle, pBundle, qBundle};
        this.doRefreshTest(allBundles, jBundle);
    }

    private void doRefreshTest(Bundle[] allBundles, Bundle toRefresh) {
        installer.resolveBundles(allBundles);
        Bundle[] refreshed = installer.refreshPackages(new Bundle[]{toRefresh});
        int i = 0;
        while (i < allBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < refreshed.length && !found) {
                found = allBundles[i] == refreshed[j];
                ++j;
            }
            if (!found) {
                SubstituteExportsBundleTests.fail((String)("bundle did not get refreshed: " + allBundles[i]));
            }
            ++i;
        }
        SubstituteExportsBundleTests.assertEquals((String)"Wrong number of bundles refreshed", (int)allBundles.length, (int)refreshed.length);
    }

    public void testSubstituteExports13() throws BundleException {
        Bundle a = installer.installBundle("substitutes.a");
        Bundle b = installer.installBundle("substitutes.b");
        Bundle c = installer.installBundle("substitutes.c");
        Bundle d = installer.installBundle("substitutes.d");
        Bundle[] allBundles = new Bundle[]{a, b, c, d};
        SubstituteExportsBundleTests.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(allBundles));
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] xPackages = pa.getExportedPackages("substitutes.x");
        SubstituteExportsBundleTests.assertNotNull((String)"xPackages is null", (Object)xPackages);
        SubstituteExportsBundleTests.assertEquals((String)"xPackages wrong number", (int)1, (int)xPackages.length);
        SubstituteExportsBundleTests.assertEquals("Wrong exporter", a, xPackages[0].getExportingBundle());
        Bundle[] xImporters = xPackages[0].getImportingBundles();
        SubstituteExportsBundleTests.assertNotNull((String)"xImporters is null", (Object)xImporters);
        SubstituteExportsBundleTests.assertEquals((String)"Wrong number of xImporters", (int)3, (int)xImporters.length);
        ExportedPackage[] yPackages = pa.getExportedPackages("substitutes.y");
        SubstituteExportsBundleTests.assertNotNull((String)"yPackages is null", (Object)yPackages);
        SubstituteExportsBundleTests.assertEquals((String)"yPackages wrong number", (int)1, (int)yPackages.length);
        SubstituteExportsBundleTests.assertEquals("Wrong exporter", a, yPackages[0].getExportingBundle());
        Bundle[] yImporters = yPackages[0].getImportingBundles();
        SubstituteExportsBundleTests.assertNotNull((String)"yImporters is null", (Object)yImporters);
        SubstituteExportsBundleTests.assertEquals((String)"Wrong number of yImporters", (int)3, (int)yImporters.length);
        Bundle[] expectedImporters = new Bundle[]{b, c, d};
        int i = 0;
        while (i < expectedImporters.length) {
            this.contains("xPackages importers does not contain", xImporters, expectedImporters[i]);
            this.contains("yPackages importers does not contain", yImporters, expectedImporters[i]);
            ++i;
        }
    }

    public void testSubstituteExports14() throws BundleException {
        Bundle iBundle = installer.installBundle("substitutes.i");
        Bundle jBundle = installer.installBundle("substitutes.j");
        Bundle kBundle = installer.installBundle("substitutes.k");
        Bundle lBundle = installer.installBundle("substitutes.l");
        Bundle mBundle = installer.installBundle("substitutes.m");
        Bundle nBundle = installer.installBundle("substitutes.n");
        Bundle pBundle = installer.installBundle("substitutes.p");
        Bundle qBundle = installer.installBundle("substitutes.q");
        Bundle[] allBundles = new Bundle[]{iBundle, jBundle, kBundle, lBundle, mBundle, nBundle, pBundle, qBundle};
        SubstituteExportsBundleTests.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(allBundles));
        PackageAdmin pa = installer.getPackageAdmin();
        ExportedPackage[] xPackages = pa.getExportedPackages("substitutes.x");
        SubstituteExportsBundleTests.assertNotNull((String)"xPackages is null", (Object)xPackages);
        SubstituteExportsBundleTests.assertEquals((String)"xPackages wrong number", (int)3, (int)xPackages.length);
        ExportedPackage[] yPackages = pa.getExportedPackages("substitutes.y");
        SubstituteExportsBundleTests.assertNotNull((String)"yPackages is null", (Object)yPackages);
        SubstituteExportsBundleTests.assertEquals((String)"yPackages wrong number", (int)3, (int)yPackages.length);
        Bundle[] expectedExporters = new Bundle[]{iBundle, kBundle, mBundle};
        int i = 0;
        while (i < expectedExporters.length) {
            boolean found = false;
            int j = 0;
            while (j < xPackages.length && !found) {
                boolean bl = found = expectedExporters[i] == xPackages[j].getExportingBundle();
                if (found) {
                    Bundle[] importingBundles = xPackages[j].getImportingBundles();
                    Bundle[] expectedImporters = null;
                    String message = null;
                    if (expectedExporters[i] == iBundle) {
                        expectedImporters = new Bundle[]{jBundle, mBundle, nBundle, pBundle, qBundle};
                        message = "iBundle ";
                    } else if (expectedExporters[i] == kBundle) {
                        expectedImporters = new Bundle[]{lBundle, mBundle, nBundle, pBundle, qBundle};
                        message = "kBundle ";
                    } else if (expectedExporters[i] == mBundle) {
                        expectedImporters = new Bundle[]{nBundle, pBundle, qBundle};
                        message = "mBundle ";
                    }
                    SubstituteExportsBundleTests.assertEquals(message, (int)expectedImporters.length, (int)importingBundles.length);
                    int k = 0;
                    while (k < expectedImporters.length) {
                        this.contains(message, importingBundles, expectedImporters[k]);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void contains(String message, Bundle[] bundles, Bundle b) {
        boolean found = false;
        int i = 0;
        while (i < bundles.length && !found) {
            found = bundles[i] == b;
            ++i;
        }
        if (!found) {
            SubstituteExportsBundleTests.fail((String)(String.valueOf(message) + b));
        }
    }
}

