/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestRFC79_006
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;
    BundleDescription bundle_4 = null;
    BundleDescription bundle_5 = null;
    BundleDescription bundle_6 = null;

    public TestRFC79_006(String testName) {
        super(testName);
    }

    public void testTest_006() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.bundle_4 = this.create_bundle_4(sof);
        this.bundle_5 = this.create_bundle_5(sof);
        this.bundle_6 = this.create_bundle_6(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestRFC79_006.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        TestRFC79_006.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_006.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestRFC79_006.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("org.xml.sax")) {
                TestRFC79_006.assertNotNull((String)"Package [org.xml.sax] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [org.xml.sax] is wired incorrectly ", exp.getExporter(), this.bundle_3);
            } else if (exportPackageName.equals("org.w3c.dom")) {
                TestRFC79_006.assertNotNull((String)"Package [org.w3c.dom] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [org.w3c.dom] is wired incorrectly ", exp.getExporter(), this.bundle_4);
            } else if (exportPackageName.equals("javax.xml.parsers")) {
                TestRFC79_006.assertNotNull((String)"Package [javax] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [javax] is wired incorrectly ", exp.getExporter(), this.bundle_6);
            }
            ++i;
        }
    }

    public void checkWiringState_2() {
    }

    public void checkWiringState_3() {
    }

    public void checkWiringState_4() {
    }

    public void checkWiringState_5() {
    }

    public void checkWiringState_6() {
        ExportPackageDescription[] exports = this.bundle_6.getResolvedImports();
        TestRFC79_006.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_006.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestRFC79_006.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("org.w3c.dom")) {
                TestRFC79_006.assertNotNull((String)"Package [org.w3c.dom] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [org.w3c.dom] is wired incorrectly ", exp.getExporter(), this.bundle_4);
            } else if (exportPackageName.equals("org.xml.sax")) {
                TestRFC79_006.assertNotNull((String)"Package [org.xml.sax] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [org.xml.sax] is wired incorrectly ", exp.getExporter(), this.bundle_3);
            }
            ++i;
        }
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
        this.checkWiringState_4();
        this.checkWiringState_5();
        this.checkWiringState_6();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_4);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_5);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_6);
        TestRFC79_006.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (!this.bundle_2.isResolved() ? 1 : 0) != 0);
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_4.isResolved());
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_5.isResolved());
        TestRFC79_006.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_6.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "Client A");
        ((Dictionary)dictionary_1).put("Import-Package", "org.xml.sax; version=\"[1.3.0, 1.3.0]\", org.w3c.dom; version=\"[2.1.0, 2.1.0]\", javax.xml.parsers; version=\"[1.1.0, 1.1.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "Client B");
        ((Dictionary)dictionary_2).put("Import-Package", "org.xml.sax; version=\"[1.3.0, 1.3.0]\", org.w3c.dom; version=\"[2.2.0, 2.2.0]\", javax.xml.parsers; version=\"[1.1.0, 1.1.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "SAX");
        ((Dictionary)dictionary_3).put("Export-Package", "org.xml.sax; version=1.3.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_4(StateObjectFactory sof) {
        Properties dictionary_4 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_4).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_4).put("Bundle-SymbolicName", "DOM A");
        ((Dictionary)dictionary_4).put("Export-Package", "org.w3c.dom; version=2.1.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_4, "bundle_4", 4L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_5(StateObjectFactory sof) {
        Properties dictionary_5 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_5).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_5).put("Bundle-SymbolicName", "DOM B");
        ((Dictionary)dictionary_5).put("Export-Package", "org.w3c.dom; version=2.2.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_5, "bundle_5", 5L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_6(StateObjectFactory sof) {
        Properties dictionary_6 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_6).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_6).put("Bundle-SymbolicName", "JAXP");
        ((Dictionary)dictionary_6).put("Export-Package", "javax.xml.parsers; version=1.1.0; uses:=\"org.w3c.dom,org.xml.sax\"");
        ((Dictionary)dictionary_6).put("Import-Package", "org.w3c.dom; version=\"[2.1.0, 2.1.0]\", org.xml.sax; version=\"[1.3.0, 1.3.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_6, "bundle_6", 6L);
        }
        catch (BundleException be) {
            TestRFC79_006.fail((String)be.getMessage());
        }
        return bundle;
    }
}

