/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.services.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;

public class StateResolverTest
extends AbstractStateTest {
    private static final String MANIFEST_ROOT = "test_files/resolverTests/";

    public static Test suite() {
        return new TestSuite(StateResolverTest.class);
    }

    public StateResolverTest(String name) {
        super(name);
    }

    public void testAdd3Resolve1() throws BundleException {
        State state = this.buildInitialState();
        StateDelta delta = state.resolve();
        BundleDelta[] deltas = delta.getChanges();
        BundleDescription b0 = state.getBundle(0L);
        StateResolverTest.assertNotNull((String)"0.1", (Object)b0);
        this.assertFullyResolved("0.2", b0);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b1");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework");
        manifest.put("Export-Package", "org.eclipse.p1; specification-version=1.0");
        BundleDescription b1 = null;
        try {
            b1 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b1", 1L);
            state.removeBundle(1L);
            state.addBundle(b1);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p1");
        manifest.put("Export-Package", "org.eclipse.p2; specification-version=1.0");
        BundleDescription b2 = null;
        try {
            b2 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b2", 2L);
            state.removeBundle(2L);
            state.addBundle(b2);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b3");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p2");
        manifest.put("Export-Package", "org.eclipse.p3; specification-version=1.0");
        BundleDescription b3 = null;
        try {
            b3 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b3", 3L);
            state.removeBundle(3L);
            state.addBundle(b3);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        delta = state.resolve(new BundleDescription[]{state.getBundle(1L)});
        deltas = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)deltas.length);
        HashMap<Long, BundleDelta> deltasMap = new HashMap<Long, BundleDelta>();
        int i = 0;
        while (i < deltas.length) {
            deltasMap.put(new Long(deltas[i].getBundle().getBundleId()), deltas[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"1.1", deltasMap.get(new Long(1L)));
        StateResolverTest.assertNotNull((String)"1.2", deltasMap.get(new Long(2L)));
        StateResolverTest.assertNotNull((String)"1.3", deltasMap.get(new Long(3L)));
        StateResolverTest.assertEquals((String)"2.1", (int)9, (int)((BundleDelta)deltasMap.get(new Long(1L))).getType());
        StateResolverTest.assertEquals((String)"2.2", (int)9, (int)((BundleDelta)deltasMap.get(new Long(2L))).getType());
        StateResolverTest.assertEquals((String)"2.3", (int)9, (int)((BundleDelta)deltasMap.get(new Long(3L))).getType());
    }

    public void testBasicResolution() throws BundleException {
        State state = this.buildSimpleState();
        StateDelta delta = state.resolve();
        BundleDescription b1 = state.getBundle(1L);
        BundleDescription b2 = state.getBundle(2L);
        BundleDescription b3 = state.getBundle(3L);
        StateResolverTest.assertNotNull((String)"0.1", (Object)b1);
        StateResolverTest.assertNotNull((String)"0.2", (Object)b2);
        StateResolverTest.assertNotNull((String)"0.3", (Object)b3);
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)changes.length);
        BundleDelta[] additions = delta.getChanges(1, false);
        StateResolverTest.assertEquals((String)"2.0", (int)3, (int)additions.length);
        BundleDelta[] resolutions = delta.getChanges(8, false);
        StateResolverTest.assertEquals((String)"3.0", (int)2, (int)resolutions.length);
        HashMap<String, BundleDelta> deltasMap = new HashMap<String, BundleDelta>();
        int i = 0;
        while (i < resolutions.length) {
            deltasMap.put(resolutions[i].getBundle().getSymbolicName(), resolutions[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"3.1", deltasMap.get(b1.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.2", deltasMap.get(b2.getSymbolicName()));
        this.assertFullyResolved("5.1", b1);
        this.assertFullyResolved("5.2", b2);
        this.assertFullyUnresolved("5.3", b3);
    }

    public void testComplexResolution() throws BundleException {
        State state = this.buildComplexState();
        StateDelta delta = state.resolve();
        BundleDescription b1 = state.getBundle("org.eclipse.b1", Version.parseVersion((String)"1.0"));
        BundleDescription b2 = state.getBundle("org.eclipse.b2", Version.parseVersion((String)"2.0"));
        BundleDescription b3 = state.getBundle("org.eclipse.b3", Version.parseVersion((String)"2.0"));
        BundleDescription b4 = state.getBundle("org.eclipse.b4", Version.parseVersion((String)"2.0"));
        BundleDescription b5 = state.getBundle("org.eclipse.b5", Version.parseVersion((String)"1.0"));
        BundleDescription b6 = state.getBundle("org.eclipse.b6", Version.parseVersion((String)"1.0"));
        StateResolverTest.assertNotNull((String)"0.1", (Object)b1);
        StateResolverTest.assertNotNull((String)"0.2", (Object)b2);
        StateResolverTest.assertNotNull((String)"0.3", (Object)b3);
        StateResolverTest.assertNotNull((String)"0.4", (Object)b4);
        StateResolverTest.assertNotNull((String)"0.5", (Object)b5);
        StateResolverTest.assertNotNull((String)"0.6", (Object)b6);
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)6, (int)changes.length);
        BundleDelta[] additions = delta.getChanges(1, false);
        StateResolverTest.assertEquals((String)"2.0", (int)6, (int)additions.length);
        BundleDelta[] resolutions = delta.getChanges(8, false);
        StateResolverTest.assertEquals((String)"3.0", (int)6, (int)resolutions.length);
        HashMap<String, BundleDelta> deltasMap = new HashMap<String, BundleDelta>();
        int i = 0;
        while (i < resolutions.length) {
            deltasMap.put(resolutions[i].getBundle().getSymbolicName(), resolutions[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"3.1", deltasMap.get(b1.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.2", deltasMap.get(b2.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.3", deltasMap.get(b3.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.4", deltasMap.get(b4.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.5", deltasMap.get(b5.getSymbolicName()));
        StateResolverTest.assertNotNull((String)"3.6", deltasMap.get(b6.getSymbolicName()));
        BundleDelta[] unresolutions = delta.getChanges(16, false);
        StateResolverTest.assertEquals((String)"4.0", (int)0, (int)unresolutions.length);
        this.assertFullyResolved("5.1", b1);
        this.assertFullyResolved("5.2", b2);
        this.assertFullyResolved("5.3", b3);
        this.assertFullyResolved("5.4", b4);
        this.assertFullyResolved("5.5", b5);
        this.assertFullyResolved("5.6", b6);
    }

    public void testDependentBundles() throws BundleException {
        State state = this.buildComplexState();
        state.resolve();
        Object[] dependent = state.getStateHelper().getDependentBundles(new BundleDescription[]{state.getBundle(2L)});
        StateResolverTest.assertEquals((String)"1.0", (int)1, (int)dependent.length);
        this.assertEquals("1.1", state.getBundle(2L), dependent[0]);
        dependent = state.getStateHelper().getDependentBundles(new BundleDescription[]{state.getBundle(1L)});
        StateResolverTest.assertEquals((String)"2.0", (int)4, (int)dependent.length);
        this.assertContains("2.1", dependent, state.getBundle(1L));
        this.assertContains("2.2", dependent, state.getBundle(2L));
        this.assertContains("2.3", dependent, state.getBundle(4L));
        this.assertContains("2.4", dependent, state.getBundle(6L));
    }

    public void testPrerequisiteBundle() throws BundleException {
        State state = this.buildComplexState();
        state.resolve();
        Object[] prereqs = state.getStateHelper().getPrerequisites(state.getResolvedBundles());
        StateResolverTest.assertEquals((String)"1.0", (int)6, (int)prereqs.length);
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(1L)});
        StateResolverTest.assertEquals((String)"2.0", (int)2, (int)prereqs.length);
        this.assertContains("2.1", prereqs, state.getBundle(1L));
        this.assertContains("2.2", prereqs, state.getBundle(3L));
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(2L)});
        StateResolverTest.assertEquals((String)"3.0", (int)3, (int)prereqs.length);
        this.assertContains("3.1", prereqs, state.getBundle(1L));
        this.assertContains("3.2", prereqs, state.getBundle(2L));
        this.assertContains("3.3", prereqs, state.getBundle(3L));
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(3L)});
        StateResolverTest.assertEquals((String)"4.0", (int)1, (int)prereqs.length);
        this.assertContains("4.1", prereqs, state.getBundle(3L));
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(4L)});
        StateResolverTest.assertEquals((String)"5.0", (int)3, (int)prereqs.length);
        this.assertContains("5.1", prereqs, state.getBundle(1L));
        this.assertContains("5.2", prereqs, state.getBundle(3L));
        this.assertContains("5.3", prereqs, state.getBundle(4L));
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(5L)});
        StateResolverTest.assertEquals((String)"6.0", (int)2, (int)prereqs.length);
        this.assertContains("6.1", prereqs, state.getBundle(3L));
        this.assertContains("6.2", prereqs, state.getBundle(5L));
        prereqs = state.getStateHelper().getPrerequisites(new BundleDescription[]{state.getBundle(6L)});
        StateResolverTest.assertEquals((String)"6.0", (int)4, (int)prereqs.length);
        this.assertContains("6.1", prereqs, state.getBundle(1L));
        this.assertContains("6.2", prereqs, state.getBundle(3L));
        this.assertContains("6.3", prereqs, state.getBundle(4L));
        this.assertContains("6.4", prereqs, state.getBundle(6L));
    }

    public void testLinkageChange() throws BundleException {
        State state = this.buildEmptyState();
        String B1_LOCATION = "org.eclipse.b1";
        BundleDescription b1 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\n"), B1_LOCATION, (long)(Math.random() * 9.223372036854776E18));
        String B2_LOCATION = "org.eclipse.b2";
        BundleDescription b2 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 2.0\nRequire-Bundle: org.eclipse.b1;optional=true"), B2_LOCATION, (long)(Math.random() * 9.223372036854776E18));
        String B3_LOCATION = "org.eclipse.b3";
        BundleDescription b3 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b3\nBundle-Version: 2.0\nRequire-Bundle: org.eclipse.b1"), B3_LOCATION, (long)(Math.random() * 9.223372036854776E18));
        state.addBundle(b2);
        state.addBundle(b3);
        StateDelta delta = state.resolve();
        this.assertFullyUnresolved("0.1", b1);
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)2, (int)changes.length);
        BundleDelta[] additions = delta.getChanges(1, false);
        StateResolverTest.assertEquals((String)"2.0", (int)2, (int)additions.length);
        BundleDelta[] resolutions = delta.getChanges(8, false);
        StateResolverTest.assertEquals((String)"3.0", (int)1, (int)resolutions.length);
        this.assertEquals("3.1", b2, resolutions[0].getBundle());
        BundleDelta[] addtionsNotResolved = delta.getChanges(1, true);
        StateResolverTest.assertEquals((String)"4.0", (int)1, (int)addtionsNotResolved.length);
        this.assertEquals("4.1", b3, addtionsNotResolved[0].getBundle());
        state.addBundle(b1);
        delta = state.resolve();
        changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"5.0", (int)2, (int)changes.length);
        additions = delta.getChanges(1, false);
        StateResolverTest.assertEquals((String)"6.0", (int)1, (int)additions.length);
        this.assertEquals("6.1", b1, additions[0].getBundle());
        resolutions = delta.getChanges(8, false);
        StateResolverTest.assertEquals((String)"7.0", (int)2, (int)resolutions.length);
        BundleDelta[] existingResolved = delta.getChanges(8, true);
        StateResolverTest.assertEquals((String)"8.0", (int)1, (int)existingResolved.length);
        this.assertEquals("8.1", b3, existingResolved[0].getBundle());
        delta = state.resolve(new BundleDescription[]{b2});
        changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"9.0", (int)1, (int)changes.length);
        resolutions = delta.getChanges(8, true);
        StateResolverTest.assertEquals((String)"9.1", (int)1, (int)resolutions.length);
        this.assertEquals("9.2", b2, resolutions[0].getBundle());
        this.assertFullyResolved("10.1", b1);
        this.assertFullyResolved("10.2", b2);
        this.assertFullyResolved("10.3", b3);
    }

    public void testReinstall() throws BundleException {
        State state = this.buildComplexState();
        StateDelta delta = state.resolve();
        state.removeBundle(4L);
        delta = state.resolve();
        StateResolverTest.assertEquals((String)"1.0", (int)1, (int)delta.getChanges(274, true).length);
        StateResolverTest.assertEquals((String)"1.1", (long)4L, (long)delta.getChanges(274, true)[0].getBundle().getBundleId());
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)delta.getChanges(16, true).length);
        StateResolverTest.assertEquals((String)"2.1", (long)6L, (long)delta.getChanges(16, true)[0].getBundle().getBundleId());
        BundleDescription b4 = delta.getChanges(274, true)[0].getBundle();
        state.addBundle(b4);
        delta = state.resolve();
        StateResolverTest.assertEquals((String)"3.0", (int)1, (int)delta.getChanges(9, true).length);
        StateResolverTest.assertEquals((String)"3.1", (long)4L, (long)delta.getChanges(9, true)[0].getBundle().getBundleId());
        StateResolverTest.assertEquals((String)"4.0", (int)1, (int)delta.getChanges(8, true).length);
        StateResolverTest.assertEquals((String)"4.1", (long)6L, (long)delta.getChanges(8, true)[0].getBundle().getBundleId());
    }

    public void testRemoval() throws BundleException {
        String B1_LOCATION = "org.eclipse.b1";
        String B2_LOCATION = "org.eclipse.b2";
        State state = this.buildEmptyState();
        BundleDescription b1 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\n"), B1_LOCATION, 1L);
        BundleDescription b2 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b2\nBundle-Version: 1.0\n"), B2_LOCATION, 2L);
        state.addBundle(b1);
        state.addBundle(b2);
        StateDelta delta = state.resolve();
        StateResolverTest.assertTrue((String)"1.1", (boolean)this.contains(state.getResolvedBundles(), b1));
        StateResolverTest.assertTrue((String)"1.2", (boolean)this.contains(state.getResolvedBundles(), b2));
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.3", (int)2, (int)changes.length);
        StateResolverTest.assertEquals((String)("1.4 - " + changes[0].getBundle()), (int)9, (int)changes[0].getType());
        StateResolverTest.assertEquals((String)("1.5 - " + changes[1].getBundle()), (int)9, (int)changes[1].getType());
        this.assertFullyResolved("1.6", b1);
        this.assertFullyResolved("1.7", b2);
        state.removeBundle(b1);
        StateResolverTest.assertTrue((String)"2.0", (!this.contains(state.getResolvedBundles(), b1) ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (boolean)this.contains(state.getResolvedBundles(), b2));
        delta = state.resolve();
        changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"2.2", (int)1, (int)changes.length);
        this.assertEquals("2.3", b1, changes[0].getBundle());
        StateResolverTest.assertEquals((String)"2.4", (int)18, (int)changes[0].getType());
    }

    public void testRemoveAndAdd() throws BundleException {
        String B_LOCATION = "org.eclipse.b";
        State state = this.buildEmptyState();
        BundleDescription b1 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\n"), B_LOCATION, 1L);
        BundleDescription b2 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b\nBundle-Version: 1.0\n"), B_LOCATION, 2L);
        state.addBundle(b1);
        StateDelta delta = state.resolve();
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)1, (int)changes.length);
        this.assertEquals("1.1", b1, changes[0].getBundle());
        StateResolverTest.assertEquals((String)"1.2", (int)9, (int)changes[0].getType());
        this.assertFullyResolved("1.3", b1);
        state.removeBundle(b1);
        state.addBundle(b2);
        delta = state.resolve();
        StateResolverTest.assertEquals((String)"2.0", (int)2, (int)delta.getChanges().length);
        StateResolverTest.assertEquals((String)"2.1", (int)1, (int)delta.getChanges(18, true).length);
        this.assertEquals("2.2", b1, delta.getChanges(18, true)[0].getBundle());
        StateResolverTest.assertEquals((String)"2.3", (int)1, (int)delta.getChanges(9, true).length);
        this.assertEquals("2.3", b2, delta.getChanges(9, true)[0].getBundle());
    }

    public void testRemovalResolve() throws BundleException {
        State state = this.buildInitialState();
        StateDelta delta = state.resolve();
        BundleDelta[] deltas = delta.getChanges();
        BundleDescription b0 = state.getBundle(0L);
        StateResolverTest.assertNotNull((String)"0.1", (Object)b0);
        this.assertFullyResolved("0.2", b0);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b1");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework");
        manifest.put("Export-Package", "org.eclipse.p1; specification-version=1.0");
        BundleDescription b1 = null;
        try {
            b1 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b1", 1L);
            state.removeBundle(1L);
            state.addBundle(b1);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p1");
        manifest.put("Export-Package", "org.eclipse.p2; specification-version=1.0");
        BundleDescription b2 = null;
        try {
            b2 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b2", 2L);
            state.removeBundle(2L);
            state.addBundle(b2);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b3");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p2");
        manifest.put("Export-Package", "org.eclipse.p3; specification-version=1.0");
        BundleDescription b3 = null;
        try {
            b3 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b3", 3L);
            state.removeBundle(3L);
            state.addBundle(b3);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        delta = state.resolve(false);
        deltas = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)4, (int)deltas.length);
        HashMap<Long, BundleDelta> deltasMap = new HashMap<Long, BundleDelta>();
        int i = 0;
        while (i < deltas.length) {
            deltasMap.put(new Long(deltas[i].getBundle().getBundleId()), deltas[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"1.1", deltasMap.get(new Long(1L)));
        StateResolverTest.assertNotNull((String)"1.2", deltasMap.get(new Long(2L)));
        StateResolverTest.assertNotNull((String)"1.3", deltasMap.get(new Long(3L)));
        StateResolverTest.assertEquals((String)"2.1", (int)9, (int)((BundleDelta)deltasMap.get(new Long(1L))).getType());
        StateResolverTest.assertEquals((String)"2.2", (int)9, (int)((BundleDelta)deltasMap.get(new Long(2L))).getType());
        StateResolverTest.assertEquals((String)"2.3", (int)9, (int)((BundleDelta)deltasMap.get(new Long(3L))).getType());
        state.removeBundle(1L);
        delta = state.resolve(false);
        deltas = delta.getChanges();
        b2 = state.getBundle(2L);
        b3 = state.getBundle(3L);
        StateResolverTest.assertEquals((String)"3.1", (boolean)false, (boolean)b2.isResolved());
        StateResolverTest.assertEquals((String)"3.2", (boolean)false, (boolean)b3.isResolved());
    }

    public void testReresolveBundle() throws BundleException {
        State state = this.buildInitialState();
        StateDelta delta = state.resolve();
        BundleDelta[] deltas = delta.getChanges();
        BundleDescription b0 = state.getBundle(0L);
        StateResolverTest.assertNotNull((String)"0.1", (Object)b0);
        this.assertFullyResolved("0.2", b0);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b1");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework");
        manifest.put("Export-Package", "org.eclipse.p1; specification-version=1.0");
        BundleDescription b1 = null;
        try {
            b1 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b1", 1L);
            state.removeBundle(1L);
            state.addBundle(b1);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b2");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p1");
        manifest.put("Export-Package", "org.eclipse.p2; specification-version=1.0");
        BundleDescription b2 = null;
        try {
            b2 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b2", 2L);
            state.removeBundle(2L);
            state.addBundle(b2);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        manifest = new Hashtable();
        manifest.put("Bundle-SymbolicName", "org.eclipse.b3");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "org.osgi.framework,org.eclipse.p2");
        manifest.put("Export-Package", "org.eclipse.p3; specification-version=1.0");
        BundleDescription b3 = null;
        try {
            b3 = state.getFactory().createBundleDescription(manifest, "org.eclipse.b3", 3L);
            state.removeBundle(3L);
            state.addBundle(b3);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Failed to create BundleDescription: " + e.getMessage()));
        }
        delta = state.resolve(new BundleDescription[]{state.getBundle(1L)});
        deltas = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)deltas.length);
        HashMap<Long, BundleDelta> deltasMap = new HashMap<Long, BundleDelta>();
        int i = 0;
        while (i < deltas.length) {
            deltasMap.put(new Long(deltas[i].getBundle().getBundleId()), deltas[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"1.1", deltasMap.get(new Long(1L)));
        StateResolverTest.assertNotNull((String)"1.2", deltasMap.get(new Long(2L)));
        StateResolverTest.assertNotNull((String)"1.3", deltasMap.get(new Long(3L)));
        StateResolverTest.assertEquals((String)"2.1", (int)9, (int)((BundleDelta)deltasMap.get(new Long(1L))).getType());
        StateResolverTest.assertEquals((String)"2.2", (int)9, (int)((BundleDelta)deltasMap.get(new Long(2L))).getType());
        StateResolverTest.assertEquals((String)"2.3", (int)9, (int)((BundleDelta)deltasMap.get(new Long(3L))).getType());
        delta = state.resolve(new BundleDescription[]{state.getBundle(1L)});
        deltas = delta.getChanges();
        StateResolverTest.assertEquals((String)"3.0", (int)3, (int)deltas.length);
        deltasMap = new HashMap();
        i = 0;
        while (i < deltas.length) {
            deltasMap.put(new Long(deltas[i].getBundle().getBundleId()), deltas[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"3.1", deltasMap.get(new Long(1L)));
        StateResolverTest.assertNotNull((String)"3.2", deltasMap.get(new Long(2L)));
        StateResolverTest.assertNotNull((String)"3.3", deltasMap.get(new Long(3L)));
        StateResolverTest.assertEquals((String)"3.4", (int)8, (int)((BundleDelta)deltasMap.get(new Long(1L))).getType());
        StateResolverTest.assertEquals((String)"3.5", (int)8, (int)((BundleDelta)deltasMap.get(new Long(2L))).getType());
        StateResolverTest.assertEquals((String)"3.6", (int)8, (int)((BundleDelta)deltasMap.get(new Long(3L))).getType());
    }

    public void testUpdate() throws BundleException {
        State state = this.buildEmptyState();
        String B1_LOCATION = "org.eclipse.b";
        BundleDescription b1 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\n"), B1_LOCATION, 1L);
        StateResolverTest.assertTrue((String)"0.9", (boolean)state.addBundle(b1));
        StateDelta delta = state.resolve();
        b1 = state.getBundleByLocation(b1.getLocation());
        BundleDelta[] changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"1.0", (int)1, (int)changes.length);
        this.assertEquals("1.1", b1, changes[0].getBundle());
        StateResolverTest.assertEquals((String)"1.2", (int)9, (int)changes[0].getType());
        this.assertFullyResolved("1.3", b1);
        StateResolverTest.assertTrue((String)"1.8", (boolean)this.contains(state.getResolvedBundles(), b1));
        BundleDescription b11 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 2.0\nRequire-Bundle: non.existant.bundle\n"), B1_LOCATION, 1L);
        StateResolverTest.assertTrue((String)"1.8b", (boolean)state.updateBundle(b11));
        b11 = state.getBundle(b11.getBundleId());
        StateResolverTest.assertTrue((String)"1.9", (!this.contains(state.getResolvedBundles(), b11) ? 1 : 0) != 0);
        delta = state.resolve();
        changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"2.0", (int)2, (int)changes.length);
        HashMap<BundleDescription, BundleDelta> deltasMap = new HashMap<BundleDescription, BundleDelta>();
        int i = 0;
        while (i < changes.length) {
            deltasMap.put(changes[i].getBundle(), changes[i]);
            ++i;
        }
        StateResolverTest.assertNotNull((String)"2.1", deltasMap.get(b1));
        StateResolverTest.assertNotNull((String)"2.2", deltasMap.get(b11));
        StateResolverTest.assertEquals((String)"2.3", (int)16, (int)((BundleDelta)deltasMap.get(b1)).getType());
        StateResolverTest.assertEquals((String)"2.4", (int)4, (int)((BundleDelta)deltasMap.get(b11)).getType());
        BundleDescription b111 = state.getFactory().createBundleDescription(StateResolverTest.parseManifest("Bundle-SymbolicName: org.eclipse.b1\nBundle-Version: 1.0\n"), B1_LOCATION, 1L);
        StateResolverTest.assertTrue((String)"3.0", (boolean)state.updateBundle(b111));
        b111 = state.getBundle(b111.getBundleId());
        StateResolverTest.assertTrue((String)"3.1", (!this.contains(state.getResolvedBundles(), b111) ? 1 : 0) != 0);
        delta = state.resolve();
        changes = delta.getChanges();
        StateResolverTest.assertEquals((String)"3.2", (int)1, (int)changes.length);
        this.assertEquals("3.1", b111, changes[0].getBundle());
        StateResolverTest.assertEquals((String)"3.2", (int)12, (int)changes[0].getType());
        this.assertFullyResolved("3.3", b111);
    }

    public void testSingletons() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testHost101 = state.getFactory().createBundleDescription(state, manifest, "test.host101", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testFrag101 = state.getFactory().createBundleDescription(state, manifest, "test.frag101", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.dependent; singleton:=true");
        manifest.put("Require-Bundle", "test.host; bundle-version=\"[1.0.1,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testDependent = state.getFactory().createBundleDescription(state, manifest, "test.frag101", 4L);
        state.addBundle(testHost100);
        state.addBundle(testFrag100);
        state.addBundle(testHost101);
        state.addBundle(testFrag101);
        state.addBundle(testDependent);
        state.resolve();
        StateResolverTest.assertFalse((String)"1.0", (boolean)testHost100.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)testHost101.isResolved());
        StateResolverTest.assertFalse((String)"1.2", (boolean)testFrag100.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)testFrag101.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)testDependent.isResolved());
    }

    public void testSingletonsSameVersion() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost101 = state.getFactory().createBundleDescription(state, manifest, "test.host101", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag101 = state.getFactory().createBundleDescription(state, manifest, "test.frag101", 3L);
        state.addBundle(testHost100);
        state.addBundle(testFrag100);
        state.resolve();
        state.addBundle(testHost101);
        state.addBundle(testFrag101);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testHost100.isResolved());
        StateResolverTest.assertFalse((String)"1.1", (boolean)testHost101.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)testFrag100.isResolved());
        StateResolverTest.assertFalse((String)"1.3", (boolean)testFrag101.isResolved());
    }

    public void testSingletonsSelection1() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state.getFactory().createBundleDescription(state, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state.getFactory().createBundleDescription(state, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state.getFactory().createBundleDescription(state, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state.getFactory().createBundleDescription(state, manifest, "gef10", 3L);
        state.addBundle(sdk10);
        state.addBundle(platform10);
        state.addBundle(rcp10);
        state.addBundle(gef10);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk20 = state.getFactory().createBundleDescription(state, manifest, "sdk20", 4L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform20 = state.getFactory().createBundleDescription(state, manifest, "platform20", 5L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription rcp20 = state.getFactory().createBundleDescription(state, manifest, "rcp20", 6L);
        state.addBundle(sdk20);
        state.addBundle(platform20);
        state.addBundle(rcp20);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)sdk20.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)platform20.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)rcp20.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)gef10.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)sdk10.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)platform10.isResolved());
        StateResolverTest.assertFalse((String)"2.6", (boolean)rcp10.isResolved());
    }

    public void testSingletonsSelection2() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\", cycle");
        BundleDescription sdk10 = state.getFactory().createBundleDescription(state, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state.getFactory().createBundleDescription(state, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state.getFactory().createBundleDescription(state, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\", sdk");
        BundleDescription gef10 = state.getFactory().createBundleDescription(state, manifest, "gef10", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "cycle; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "gef");
        BundleDescription cycle10 = state.getFactory().createBundleDescription(state, manifest, "cycle10", 4L);
        state.addBundle(sdk10);
        state.addBundle(platform10);
        state.addBundle(rcp10);
        state.addBundle(gef10);
        state.addBundle(cycle10);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)cycle10.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk20 = state.getFactory().createBundleDescription(state, manifest, "sdk20", 5L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform20 = state.getFactory().createBundleDescription(state, manifest, "platform20", 6L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription rcp20 = state.getFactory().createBundleDescription(state, manifest, "rcp20", 7L);
        state.addBundle(sdk20);
        state.addBundle(platform20);
        state.addBundle(rcp20);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)sdk20.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)platform20.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)rcp20.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)gef10.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)cycle10.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)sdk10.isResolved());
        StateResolverTest.assertFalse((String)"2.6", (boolean)platform10.isResolved());
        StateResolverTest.assertFalse((String)"2.7", (boolean)rcp10.isResolved());
    }

    public void testSingletonsSelection3() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state.getFactory().createBundleDescription(state, manifest, "sdk10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "sdk");
        BundleDescription sdk_frag10 = state.getFactory().createBundleDescription(state, manifest, "sdk.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "sdk; bundle-version=2.0");
        BundleDescription sdk_frag210 = state.getFactory().createBundleDescription(state, manifest, "sdk.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state.getFactory().createBundleDescription(state, manifest, "platform10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "platform");
        BundleDescription platform_frag10 = state.getFactory().createBundleDescription(state, manifest, "platform.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "platform; bundle-version=2.0");
        BundleDescription platform_frag210 = state.getFactory().createBundleDescription(state, manifest, "platform.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state.getFactory().createBundleDescription(state, manifest, "rcp10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "rcp");
        BundleDescription rcp_frag10 = state.getFactory().createBundleDescription(state, manifest, "rcp.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "rcp; bundle-version=2.0");
        BundleDescription rcp_frag210 = state.getFactory().createBundleDescription(state, manifest, "rcp.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state.getFactory().createBundleDescription(state, manifest, "gef10", (long)bundleID++);
        state.addBundle(sdk10);
        state.addBundle(sdk_frag10);
        state.addBundle(sdk_frag210);
        state.addBundle(platform10);
        state.addBundle(platform_frag10);
        state.addBundle(platform_frag210);
        state.addBundle(rcp10);
        state.addBundle(rcp_frag10);
        state.addBundle(rcp_frag210);
        state.addBundle(gef10);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.0.1", (boolean)sdk_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.0.2", (boolean)sdk_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.1.1", (boolean)platform_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.1.2", (boolean)platform_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.2.1", (boolean)rcp_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.2.2", (boolean)rcp_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk20 = state.getFactory().createBundleDescription(state, manifest, "sdk20", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform20 = state.getFactory().createBundleDescription(state, manifest, "platform20", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription rcp20 = state.getFactory().createBundleDescription(state, manifest, "rcp20", (long)bundleID++);
        state.addBundle(sdk20);
        state.addBundle(platform20);
        state.addBundle(rcp20);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)sdk20.isResolved());
        StateResolverTest.assertTrue((String)"2.0.1", (boolean)sdk_frag10.isResolved());
        StateResolverTest.assertTrue((String)"2.0.2", (boolean)sdk_frag210.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)platform20.isResolved());
        StateResolverTest.assertTrue((String)"2.1.1", (boolean)platform_frag10.isResolved());
        StateResolverTest.assertTrue((String)"2.1.2", (boolean)platform_frag210.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)rcp20.isResolved());
        StateResolverTest.assertTrue((String)"2.2.1", (boolean)rcp_frag210.isResolved());
        StateResolverTest.assertTrue((String)"2.2.2", (boolean)rcp_frag10.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)gef10.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)sdk10.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)platform10.isResolved());
        StateResolverTest.assertFalse((String)"2.6", (boolean)rcp10.isResolved());
    }

    public void testSingletonsSelection4() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "sdk; version=1.0");
        manifest.put("Import-Package", "platform; version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state.getFactory().createBundleDescription(state, manifest, "sdk10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "sdk");
        BundleDescription sdk_frag10 = state.getFactory().createBundleDescription(state, manifest, "sdk.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "sdk; bundle-version=2.0");
        BundleDescription sdk_frag210 = state.getFactory().createBundleDescription(state, manifest, "sdk.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "platform; version=1.0");
        manifest.put("Import-Package", "rcp; version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state.getFactory().createBundleDescription(state, manifest, "platform10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "platform");
        BundleDescription platform_frag10 = state.getFactory().createBundleDescription(state, manifest, "platform.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "platform; bundle-version=2.0");
        BundleDescription platform_frag210 = state.getFactory().createBundleDescription(state, manifest, "platform.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "rcp; version=1.0");
        BundleDescription rcp10 = state.getFactory().createBundleDescription(state, manifest, "rcp10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp.frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "rcp");
        BundleDescription rcp_frag10 = state.getFactory().createBundleDescription(state, manifest, "rcp.frag10", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp.frag2; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "rcp; bundle-version=2.0");
        BundleDescription rcp_frag210 = state.getFactory().createBundleDescription(state, manifest, "rcp.frag210", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "rcp; version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state.getFactory().createBundleDescription(state, manifest, "gef10", (long)bundleID++);
        state.addBundle(sdk10);
        state.addBundle(sdk_frag10);
        state.addBundle(sdk_frag210);
        state.addBundle(platform10);
        state.addBundle(platform_frag10);
        state.addBundle(platform_frag210);
        state.addBundle(rcp10);
        state.addBundle(rcp_frag10);
        state.addBundle(rcp_frag210);
        state.addBundle(gef10);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.0.1", (boolean)sdk_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.0.2", (boolean)sdk_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.1.1", (boolean)platform_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.1.2", (boolean)platform_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.2.1", (boolean)rcp_frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.2.2", (boolean)rcp_frag210.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Export-Package", "sdk; version=2.0");
        manifest.put("Import-Package", "platform; version=\"[1.0,2.0]\"");
        BundleDescription sdk20 = state.getFactory().createBundleDescription(state, manifest, "sdk20", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Export-Package", "platform; version=2.0");
        manifest.put("Import-Package", "rcp; version=\"[1.0,2.0]\"");
        BundleDescription platform20 = state.getFactory().createBundleDescription(state, manifest, "platform20", (long)bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Export-Package", "rcp; version=2.0");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription rcp20 = state.getFactory().createBundleDescription(state, manifest, "rcp20", (long)bundleID++);
        state.addBundle(sdk20);
        state.addBundle(platform20);
        state.addBundle(rcp20);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)sdk20.isResolved());
        StateResolverTest.assertTrue((String)"2.0.1", (boolean)sdk_frag10.isResolved());
        StateResolverTest.assertTrue((String)"2.0.2", (boolean)sdk_frag210.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)platform20.isResolved());
        StateResolverTest.assertTrue((String)"2.1.1", (boolean)platform_frag10.isResolved());
        StateResolverTest.assertTrue((String)"2.1.2", (boolean)platform_frag210.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)rcp20.isResolved());
        StateResolverTest.assertTrue((String)"2.2.1", (boolean)rcp_frag10.isResolved());
        StateResolverTest.assertTrue((String)"2.2.2", (boolean)rcp_frag210.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)gef10.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)sdk10.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)platform10.isResolved());
        StateResolverTest.assertFalse((String)"2.6", (boolean)rcp10.isResolved());
    }

    public void testSingletonsSelection5() throws BundleException {
        State state = this.buildEmptyState();
        long id = 0L;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "base; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription base10 = state.getFactory().createBundleDescription(state, manifest, "base10", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "base; singleton:=true");
        manifest.put("Bundle-Version", "1.1");
        BundleDescription base11 = state.getFactory().createBundleDescription(state, manifest, "base11", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "requires; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "base; bundle-version=\"[1.0,1.1)\"");
        BundleDescription requires10 = state.getFactory().createBundleDescription(state, manifest, "requires10", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "requires; singleton:=true");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Require-Bundle", "base; bundle-version=\"[1.1,1.2)\"");
        BundleDescription requires11 = state.getFactory().createBundleDescription(state, manifest, "requires11", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "frag; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "requires; bundle-version=\"[1.0,1.1)\"");
        BundleDescription frag10 = state.getFactory().createBundleDescription(state, manifest, "frag10", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "frag; singleton:=true");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Fragment-Host", "requires; bundle-version=\"[1.1,1.2)\"");
        BundleDescription frag11 = state.getFactory().createBundleDescription(state, manifest, "frag11", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "fragb; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "requires; bundle-version=\"[1.0,1.1)\"");
        manifest.put("Export-Package", "fragb; version=1.0");
        BundleDescription fragb10 = state.getFactory().createBundleDescription(state, manifest, "frag10", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "fragb; singleton:=true");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Fragment-Host", "requires; bundle-version=\"[1.1,1.2)\"");
        manifest.put("Export-Package", "fragb; version=1.1");
        BundleDescription fragb11 = state.getFactory().createBundleDescription(state, manifest, "frag11", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "import");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "fragb; version=\"[1.0,1.0]\"");
        BundleDescription import10 = state.getFactory().createBundleDescription(state, manifest, "import10", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "import");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Import-Package", "fragb; version=\"[1.1,1.1]\"");
        BundleDescription import11 = state.getFactory().createBundleDescription(state, manifest, "import11", id++);
        state.addBundle(base10);
        state.addBundle(base11);
        state.addBundle(requires10);
        state.addBundle(requires11);
        state.addBundle(frag10);
        state.addBundle(frag11);
        state.addBundle(fragb10);
        state.addBundle(fragb11);
        state.addBundle(import10);
        state.addBundle(import11);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)base11.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)requires11.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)frag11.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)fragb11.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)import11.isResolved());
        StateResolverTest.assertFalse((String)"1.5", (boolean)base10.isResolved());
        StateResolverTest.assertFalse((String)"1.6", (boolean)requires10.isResolved());
        StateResolverTest.assertFalse((String)"1.7", (boolean)frag10.isResolved());
        StateResolverTest.assertFalse((String)"1.8", (boolean)fragb10.isResolved());
        StateResolverTest.assertFalse((String)"1.9", (boolean)import10.isResolved());
    }

    public void testSingletonsSelection6() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state.getFactory().createBundleDescription(state, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state.getFactory().createBundleDescription(state, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state.getFactory().createBundleDescription(state, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state.getFactory().createBundleDescription(state, manifest, "gef10", 3L);
        state.addBundle(sdk10);
        state.addBundle(platform10);
        state.addBundle(rcp10);
        state.addBundle(gef10);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk20 = state.getFactory().createBundleDescription(state, manifest, "sdk20", 4L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform20 = state.getFactory().createBundleDescription(state, manifest, "platform20", 5L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription rcp20 = state.getFactory().createBundleDescription(state, manifest, "rcp20", 6L);
        state.removeBundle(sdk10);
        state.removeBundle(platform10);
        state.removeBundle(rcp10);
        state.removeBundle(gef10);
        state.addBundle(sdk20);
        state.addBundle(platform20);
        state.addBundle(rcp20);
        state.addBundle(sdk10);
        state.addBundle(platform10);
        state.addBundle(rcp10);
        state.addBundle(gef10);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)sdk20.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)platform20.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)rcp20.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)gef10.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)sdk10.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)platform10.isResolved());
        StateResolverTest.assertFalse((String)"2.6", (boolean)rcp10.isResolved());
    }

    public void testSingletonsSelection7() throws BundleException {
        State state = this.buildEmptyState();
        long id = 0L;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "singleton; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "singleton");
        BundleDescription singleton1 = state.getFactory().createBundleDescription(state, manifest, "singleton1", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "singleton");
        manifest.put("Export-Package", "a;version=1.0.0");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, "a1", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "a");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "b", id++);
        state.addBundle(singleton1);
        state.addBundle(a1);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)singleton1.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a1.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "singleton; singleton:=true");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Export-Package", "singleton");
        BundleDescription singleton2 = state.getFactory().createBundleDescription(state, manifest, "singleton2", id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.1");
        manifest.put("Import-Package", "singleton");
        manifest.put("Export-Package", "a;version=1.0.1");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, "a2", id++);
        state.addBundle(singleton2);
        state.addBundle(a2);
        state.resolve(new BundleDescription[]{singleton1, singleton2, a1, a2});
        StateResolverTest.assertFalse((String)"2.0", (boolean)singleton1.isResolved());
        StateResolverTest.assertTrue((String)"2.1", (boolean)singleton2.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)a1.isResolved());
        StateResolverTest.assertTrue((String)"2.3", (boolean)a2.isResolved());
        StateResolverTest.assertTrue((String)"2.4", (boolean)b.isResolved());
        ExportPackageDescription[] imports = b.getResolvedImports();
        StateResolverTest.assertEquals((String)"Unexpected number of imports", (int)1, (int)imports.length);
        this.assertEquals("Unexpected exporter", a2, imports[0].getExporter());
    }

    public void testNonSingletonsSameVersion() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost101 = state.getFactory().createBundleDescription(state, manifest, "test.host101", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag101 = state.getFactory().createBundleDescription(state, manifest, "test.frag101", 3L);
        state.addBundle(testHost100);
        state.addBundle(testFrag100);
        state.resolve();
        state.addBundle(testHost101);
        state.addBundle(testFrag101);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testHost100.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)testHost101.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)testFrag100.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)testFrag101.isResolved());
    }

    public void testTransitiveUses() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        BundleDescription a1_100 = state.getFactory().createBundleDescription(state, manifest, "a1_100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        BundleDescription a2_100 = state.getFactory().createBundleDescription(state, manifest, "a2_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A2");
        BundleDescription b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=b");
        manifest.put("Import-Package", "b");
        BundleDescription c1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a, c");
        BundleDescription d1_100 = state.getFactory().createBundleDescription(state, manifest, "d1_100", 4L);
        state.addBundle(a1_100);
        state.addBundle(a2_100);
        state.addBundle(b1_100);
        state.addBundle(c1_100);
        state.addBundle(d1_100);
        state.resolve();
        ExportPackageDescription[] b1ResolvedImports = b1_100.getResolvedImports();
        ExportPackageDescription[] d1ResolvedImports = d1_100.getResolvedImports();
        ExportPackageDescription[] isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A1");
        b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        state.updateBundle(b1_100);
        state.resolve();
        b1ResolvedImports = b1_100.getResolvedImports();
        d1ResolvedImports = d1_100.getResolvedImports();
        isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.2 Packages are not consistent: " + isConsistent), (Object)isConsistent);
    }

    public void testMultipleExportsUses01() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; version=2.0; uses:=d, d; version=2.0");
        BundleDescription a1_100 = state.getFactory().createBundleDescription(state, manifest, "a1_100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; version=1.0; uses:=d, d; version=1.0");
        BundleDescription a2_100 = state.getFactory().createBundleDescription(state, manifest, "a2_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b, b; mandatory:=\"test\"; test=value; uses:=d");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A2, d");
        BundleDescription b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=b");
        manifest.put("Import-Package", "b; test=value, d");
        BundleDescription c1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a, c, d");
        BundleDescription d1_100 = state.getFactory().createBundleDescription(state, manifest, "d1_100", 4L);
        state.addBundle(a1_100);
        state.addBundle(a2_100);
        state.addBundle(b1_100);
        state.addBundle(c1_100);
        state.addBundle(d1_100);
        state.resolve();
        ExportPackageDescription[] b1ResolvedImports = b1_100.getResolvedImports();
        ExportPackageDescription[] d1ResolvedImports = d1_100.getResolvedImports();
        ExportPackageDescription[] isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A1");
        b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        state.updateBundle(b1_100);
        state.resolve();
        b1ResolvedImports = b1_100.getResolvedImports();
        d1ResolvedImports = d1_100.getResolvedImports();
        isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.2 Packages are not consistent: " + isConsistent), (Object)isConsistent);
    }

    public void testRequireBundleUses() throws BundleException {
        State state = this.buildEmptyState();
        int id = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        BundleDescription a_100 = state.getFactory().createBundleDescription(state, manifest, "a_100", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Export-Package", "a");
        BundleDescription a_200 = state.getFactory().createBundleDescription(state, manifest, "a_200", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; visibility:=reexport");
        BundleDescription b_100 = state.getFactory().createBundleDescription(state, manifest, "b_100", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=b");
        manifest.put("Require-Bundle", "A, B");
        BundleDescription c_100 = state.getFactory().createBundleDescription(state, manifest, "c_100", (long)id++);
        state.addBundle(a_100);
        state.addBundle(b_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)b_100.isResolved());
        state.addBundle(a_200);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.1", (boolean)a_200.isResolved());
        state.addBundle(c_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.2", (boolean)c_100.isResolved());
        ExportPackageDescription[] c1ResolvedImports = state.getStateHelper().getVisiblePackages(c_100);
        StateResolverTest.assertTrue((String)"2.1", (c1ResolvedImports.length == 2 ? 1 : 0) != 0);
        int index = c1ResolvedImports[0].getName().equals("a") ? 0 : (c1ResolvedImports[1].getName().equals("a") ? 1 : -1);
        StateResolverTest.assertTrue((String)"2.2", (index >= 0 ? 1 : 0) != 0);
        this.assertEquals("2.2", c1ResolvedImports[index].getExporter(), a_100);
    }

    public void testCyclicTransitiveUses() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; uses:=d");
        manifest.put("Import-Package", "d");
        BundleDescription a1_100 = state.getFactory().createBundleDescription(state, manifest, "a1_100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; uses:=d");
        manifest.put("Import-Package", "d");
        BundleDescription a2_100 = state.getFactory().createBundleDescription(state, manifest, "a2_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A2");
        BundleDescription b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=b");
        manifest.put("Import-Package", "b");
        BundleDescription c1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d; uses:=c");
        manifest.put("Import-Package", "a, c");
        BundleDescription d1_100 = state.getFactory().createBundleDescription(state, manifest, "d1_100", 4L);
        state.addBundle(a1_100);
        state.addBundle(a2_100);
        state.addBundle(b1_100);
        state.addBundle(c1_100);
        state.addBundle(d1_100);
        state.resolve();
        StateResolverTest.assertFalse((String)"0.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)a2_100.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)d1_100.isResolved());
        ExportPackageDescription[] b1ResolvedImports = b1_100.getResolvedImports();
        ExportPackageDescription[] d1ResolvedImports = d1_100.getResolvedImports();
        ExportPackageDescription[] isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A1");
        b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        state.updateBundle(b1_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"2.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertFalse((String)"2.2", (boolean)a2_100.isResolved());
        StateResolverTest.assertTrue((String)"2.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"2.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertTrue((String)"2.5", (boolean)d1_100.isResolved());
        b1ResolvedImports = b1_100.getResolvedImports();
        d1ResolvedImports = d1_100.getResolvedImports();
        isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("3.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
    }

    public void testFragmentTransitiveUses() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; uses:=d");
        manifest.put("Import-Package", "d");
        BundleDescription a1_100 = state.getFactory().createBundleDescription(state, manifest, "a1_100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Export-Package", "a.frag; uses:=a");
        BundleDescription a1frag_100 = state.getFactory().createBundleDescription(state, manifest, "a1frag_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; uses:=d, a.frag; uses:=a");
        manifest.put("Import-Package", "d");
        BundleDescription a2_100 = state.getFactory().createBundleDescription(state, manifest, "a2_100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A2, a.frag");
        BundleDescription b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 3L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=b");
        manifest.put("Import-Package", "b");
        BundleDescription c1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", 4L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d; uses:=c");
        manifest.put("Import-Package", "a.frag, c");
        BundleDescription d1_100 = state.getFactory().createBundleDescription(state, manifest, "d1_100", 5L);
        state.addBundle(a1_100);
        state.addBundle(a1frag_100);
        state.addBundle(a2_100);
        state.addBundle(b1_100);
        state.addBundle(c1_100);
        state.addBundle(d1_100);
        state.resolve();
        StateResolverTest.assertFalse((String)"0.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)a2_100.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)d1_100.isResolved());
        ExportPackageDescription[] b1ResolvedImports = b1_100.getResolvedImports();
        ExportPackageDescription[] d1ResolvedImports = d1_100.getResolvedImports();
        ExportPackageDescription[] isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("1.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Import-Package", "a;bundle-symbolic-name=A1");
        b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", 2L);
        state.updateBundle(b1_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"2.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertFalse((String)"2.2", (boolean)a2_100.isResolved());
        StateResolverTest.assertTrue((String)"2.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"2.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertTrue((String)"2.5", (boolean)d1_100.isResolved());
        b1ResolvedImports = b1_100.getResolvedImports();
        d1ResolvedImports = d1_100.getResolvedImports();
        isConsistent = this.isConsistent(b1ResolvedImports, d1ResolvedImports);
        StateResolverTest.assertNull((String)("3.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
    }

    public void testFragmentUses01() throws BundleException {
        long id = 0L;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        manifest.put("Require-Bundle", "C2");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Import-Package", "b; good=true");
        BundleDescription a1frag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; good=true; uses:=c");
        manifest.put("Import-Package", "c; good=true");
        BundleDescription b1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; good=true");
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; bad=true");
        BundleDescription c2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        state.addBundle(a1);
        state.addBundle(a1frag);
        state.addBundle(b1);
        state.addBundle(c1);
        state.addBundle(c2);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a1.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)a1frag.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b1.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c1.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)c2.isResolved());
    }

    public void testFragmentUses02() throws BundleException {
        long id = 0L;
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.resolverMode", "development");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        manifest.put("Require-Bundle", "C2");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Import-Package", "b; good=true");
        BundleDescription a1frag = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; good=true; uses:=c");
        manifest.put("Import-Package", "c; good=true");
        BundleDescription b1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; good=true");
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; bad=true");
        BundleDescription c2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), id++);
        state.addBundle(a1);
        state.addBundle(a1frag);
        state.addBundle(b1);
        state.addBundle(c1);
        state.addBundle(c2);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a1.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)a1frag.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b1.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c1.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)c2.isResolved());
    }

    public void testCyclicUsesExportDrop() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "W");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; b; version=1.0");
        manifest.put("Import-Package", "c, a, b");
        BundleDescription w1_100 = state.getFactory().createBundleDescription(state, manifest, "w1_100", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "X");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c");
        manifest.put("Import-Package", "d");
        BundleDescription x1_100 = state.getFactory().createBundleDescription(state, manifest, "x1_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Y");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d");
        manifest.put("Import-Package", "a");
        BundleDescription y1_100 = state.getFactory().createBundleDescription(state, manifest, "y1_100", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Z");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; version = 2.0");
        BundleDescription z1_100 = state.getFactory().createBundleDescription(state, manifest, "z1_100", 3L);
        state.addBundle(w1_100);
        state.addBundle(x1_100);
        state.addBundle(y1_100);
        state.addBundle(z1_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)w1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)x1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)y1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)z1_100.isResolved());
        StateResolverTest.assertEquals((String)"1.1", (int)1, (int)w1_100.getSelectedExports().length);
        StateResolverTest.assertEquals((String)"1.2", (String)"b", (String)w1_100.getSelectedExports()[0].getName());
    }

    public void testRemovalPending() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> wManifest = new Hashtable<String, String>();
        wManifest.put("Bundle-ManifestVersion", "2");
        wManifest.put("Bundle-SymbolicName", "W");
        wManifest.put("Bundle-Version", "1.0.0");
        wManifest.put("Export-Package", "a; b; version=1.0");
        wManifest.put("Import-Package", "a, b");
        BundleDescription w1_100 = state.getFactory().createBundleDescription(state, wManifest, "w1_100", 0L);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "X");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a");
        BundleDescription x1_100 = state.getFactory().createBundleDescription(state, manifest, "x1_100", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "Y");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a");
        BundleDescription y1_100 = state.getFactory().createBundleDescription(state, manifest, "y1_100", 2L);
        state.addBundle(w1_100);
        state.addBundle(x1_100);
        state.addBundle(y1_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)w1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)x1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)y1_100.isResolved());
        BundleDescription w1_100_prime = state.getFactory().createBundleDescription(state, wManifest, "w1_100", 0L);
        state.updateBundle(w1_100_prime);
        state.resolve(new BundleDescription[0]);
        StateResolverTest.assertTrue((String)"1.1", (boolean)w1_100_prime.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)x1_100.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)y1_100.isResolved());
        ExportPackageDescription[] exports_w1_100 = w1_100.getSelectedExports();
        ExportPackageDescription[] imports_w1_100_prime = w1_100_prime.getResolvedImports();
        ExportPackageDescription[] isConsistent = this.isConsistent(exports_w1_100, imports_w1_100_prime);
        StateResolverTest.assertNull((String)("2.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
        state.resolve(new BundleDescription[]{w1_100});
        StateResolverTest.assertTrue((String)"3.1", (boolean)w1_100_prime.isResolved());
        StateResolverTest.assertTrue((String)"3.2", (boolean)x1_100.isResolved());
        StateResolverTest.assertTrue((String)"3.3", (boolean)y1_100.isResolved());
        ExportPackageDescription[] exports_w1_100_prime = w1_100_prime.getSelectedExports();
        imports_w1_100_prime = w1_100_prime.getResolvedImports();
        isConsistent = this.isConsistent(exports_w1_100_prime, imports_w1_100_prime);
        StateResolverTest.assertNull((String)("4.1 Packages are not consistent: " + isConsistent), (Object)isConsistent);
    }

    public void testFragmentConstraints01() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a.frag");
        BundleDescription d1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", (long)id++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; uses:=d");
        manifest.put("Import-Package", "b; version=2.0");
        manifest.put("Require-Bundle", "C1; bundle-version=\"[2.0, 3.0)\"");
        BundleDescription a1_100 = state.getFactory().createBundleDescription(state, manifest, "a1_100", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Export-Package", "a.frag");
        manifest.put("Import-Package", "b; version=1.0");
        manifest.put("Require-Bundle", "C1; bundle-version=\"[2.0, 3.0)\"");
        BundleDescription a1frag_100 = state.getFactory().createBundleDescription(state, manifest, "a1frag_100", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; version=2.1");
        BundleDescription b1_100 = state.getFactory().createBundleDescription(state, manifest, "b1_100", (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C1");
        manifest.put("Bundle-Version", "2.0.1");
        manifest.put("Export-Package", "c");
        BundleDescription c1_100 = state.getFactory().createBundleDescription(state, manifest, "c1_100", (long)id++);
        state.addBundle(d1_100);
        state.addBundle(a1_100);
        state.addBundle(a1frag_100);
        state.addBundle(b1_100);
        state.addBundle(c1_100);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)a1frag_100.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)d1_100.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Export-Package", "a.frag");
        manifest.put("Import-Package", "b; version=2.1");
        manifest.put("Require-Bundle", "C1; bundle-version=\"[2.5, 4.0)\"");
        a1frag_100 = state.getFactory().createBundleDescription(state, manifest, "a1frag_100", a1frag_100.getBundleId());
        state.updateBundle(a1frag_100);
        state.resolve(new BundleDescription[]{a1frag_100});
        StateResolverTest.assertTrue((String)"1.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertFalse((String)"1.2", (boolean)a1frag_100.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertFalse((String)"1.5", (boolean)d1_100.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Export-Package", "a.frag");
        manifest.put("Import-Package", "b; version=\"[1.0,2.0)\"");
        a1frag_100 = state.getFactory().createBundleDescription(state, manifest, "a1frag_100", a1frag_100.getBundleId());
        state.updateBundle(a1frag_100);
        state.resolve(new BundleDescription[]{a1frag_100});
        StateResolverTest.assertTrue((String)"2.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertFalse((String)"2.2", (boolean)a1frag_100.isResolved());
        StateResolverTest.assertTrue((String)"2.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"2.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)d1_100.isResolved());
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A1.Frag");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "A1");
        manifest.put("Export-Package", "a.frag");
        manifest.put("Require-Bundle", "C1; bundle-version=\"[1.0, 1.5)\"");
        a1frag_100 = state.getFactory().createBundleDescription(state, manifest, "a1frag_100", a1frag_100.getBundleId());
        state.updateBundle(a1frag_100);
        state.resolve(new BundleDescription[]{a1frag_100});
        StateResolverTest.assertTrue((String)"3.1", (boolean)a1_100.isResolved());
        StateResolverTest.assertFalse((String)"3.2", (boolean)a1frag_100.isResolved());
        StateResolverTest.assertTrue((String)"3.3", (boolean)b1_100.isResolved());
        StateResolverTest.assertTrue((String)"3.4", (boolean)c1_100.isResolved());
        StateResolverTest.assertFalse((String)"3.5", (boolean)d1_100.isResolved());
    }

    public void testFragmentConstraints02() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, e");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag4");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d, e");
        BundleDescription aFrag4 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a, b, c");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(aFrag4);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertFalse((String)"0.5", (boolean)aFrag4.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)b.isResolved());
        ExportPackageDescription[] aResolvedImports = a.getResolvedImports();
        ExportPackageDescription[] bSelectedExports = b.getSelectedExports();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedImports.length);
        StateResolverTest.assertEquals((String)"1.1", (int)3, (int)bSelectedExports.length);
        int i = 0;
        while (i < aResolvedImports.length) {
            StateResolverTest.assertEquals((Object)bSelectedExports[i], (Object)aResolvedImports[i]);
            ++i;
        }
    }

    public void testFragmentConstraints03() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x");
        manifest.put("Import-Package", "a");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, e");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag4");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d, e");
        BundleDescription aFrag4 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a, b, c");
        manifest.put("Import-Package", "x");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(aFrag4);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertFalse((String)"0.5", (boolean)aFrag4.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)b.isResolved());
        ExportPackageDescription[] aResolvedImports = a.getResolvedImports();
        ExportPackageDescription[] aSelectedExports = a.getSelectedExports();
        ExportPackageDescription[] bResolvedImports = b.getResolvedImports();
        ExportPackageDescription[] bSelectedExports = b.getSelectedExports();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedImports.length);
        StateResolverTest.assertEquals((String)"1.1", (int)3, (int)bSelectedExports.length);
        int i = 0;
        while (i < aResolvedImports.length) {
            this.assertEquals("1.2", bSelectedExports[i], aResolvedImports[i]);
            ++i;
        }
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)aSelectedExports.length);
        StateResolverTest.assertEquals((String)"2.1", (int)1, (int)bResolvedImports.length);
        this.assertEquals("2.2", aSelectedExports[0], bResolvedImports[0]);
    }

    public void testFragmentConstraints04() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d, e");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d, f");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b1, b2, b3");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c1, c2, c3");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d1, d2, d3");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"0.7", (boolean)d.isResolved());
        BundleDescription[] aResolvedRequires = a.getResolvedRequires();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedRequires.length);
        this.assertEquals("1.1", b, aResolvedRequires[0]);
        this.assertEquals("1.2", c, aResolvedRequires[1]);
        this.assertEquals("1.3", d, aResolvedRequires[2]);
    }

    public void testFragmentConstraints05() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d, e");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d, f");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "c, d");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b1, b2, b3");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c1, c2, c3");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "a");
        manifest.put("Export-Package", "d1, d2, d3");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"0.7", (boolean)d.isResolved());
        BundleDescription[] aResolvedRequires = a.getResolvedRequires();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedRequires.length);
        this.assertEquals("1.1", b, aResolvedRequires[0]);
        this.assertEquals("1.2", c, aResolvedRequires[1]);
        this.assertEquals("1.3", d, aResolvedRequires[2]);
        BundleDescription[] dResolvedRequires = d.getResolvedRequires();
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)dResolvedRequires.length);
        this.assertEquals("2.1", a, dResolvedRequires[0]);
    }

    public void testFragmentConstraints06() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a");
        manifest.put("Require-Bundle", "b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d");
        manifest.put("Require-Bundle", "c, d, e");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, e");
        manifest.put("Require-Bundle", "c, d, f");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c");
        manifest.put("Require-Bundle", "c, d");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a, b, c");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c1, c2, c3");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d1, d2, d3");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"0.7", (boolean)d.isResolved());
        ExportPackageDescription[] aResolvedImports = a.getResolvedImports();
        ExportPackageDescription[] bSelectedExports = b.getSelectedExports();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedImports.length);
        StateResolverTest.assertEquals((String)"1.1", (int)3, (int)bSelectedExports.length);
        int i = 0;
        while (i < aResolvedImports.length) {
            StateResolverTest.assertEquals((Object)bSelectedExports[i], (Object)aResolvedImports[i]);
            ++i;
        }
        BundleDescription[] aResolvedRequires = a.getResolvedRequires();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedRequires.length);
        this.assertEquals("1.1", b, aResolvedRequires[0]);
        this.assertEquals("1.2", c, aResolvedRequires[1]);
        this.assertEquals("1.3", d, aResolvedRequires[2]);
    }

    public void testFragmentConstraints07() throws BundleException {
        int id = 0;
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "x");
        manifest.put("Import-Package", "a");
        manifest.put("Require-Bundle", "b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, d");
        manifest.put("Require-Bundle", "c, d, e");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c, e");
        manifest.put("Require-Bundle", "c, d, f");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "aFrag3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Import-Package", "b, c");
        manifest.put("Require-Bundle", "c, d");
        BundleDescription aFrag3 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a, b, c");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c1, c2, c3");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d1, d2, d3");
        manifest.put("Import-Package", "x");
        manifest.put("Require-Bundle", "a");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + "_" + manifest.get("Bundle-Version"), (long)id++);
        state.addBundle(a);
        state.addBundle(aFrag1);
        state.addBundle(aFrag2);
        state.addBundle(aFrag3);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertFalse((String)"0.3", (boolean)aFrag2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag3.isResolved());
        StateResolverTest.assertTrue((String)"0.5", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"0.6", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"0.7", (boolean)d.isResolved());
        ExportPackageDescription[] aResolvedImports = a.getResolvedImports();
        ExportPackageDescription[] aSelectedExports = a.getSelectedExports();
        ExportPackageDescription[] bSelectedExports = b.getSelectedExports();
        ExportPackageDescription[] dResolvedImports = d.getResolvedImports();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedImports.length);
        StateResolverTest.assertEquals((String)"1.1", (int)3, (int)bSelectedExports.length);
        int i = 0;
        while (i < aResolvedImports.length) {
            StateResolverTest.assertEquals((Object)bSelectedExports[i], (Object)aResolvedImports[i]);
            ++i;
        }
        BundleDescription[] aResolvedRequires = a.getResolvedRequires();
        StateResolverTest.assertEquals((String)"1.0", (int)3, (int)aResolvedRequires.length);
        this.assertEquals("1.1", b, aResolvedRequires[0]);
        this.assertEquals("1.2", c, aResolvedRequires[1]);
        this.assertEquals("1.3", d, aResolvedRequires[2]);
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)aSelectedExports.length);
        StateResolverTest.assertEquals((String)"2.1", (int)1, (int)dResolvedImports.length);
        this.assertEquals("2.2", aSelectedExports[0], dResolvedImports[0]);
    }

    public void testFragmentsBug188199() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "a");
        manifest.put("Import-Package", "c");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "A");
        manifest.put("Export-Package", "a.frag");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "a, a.frag");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "c");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        state.addBundle(a);
        state.addBundle(aFrag);
        state.addBundle(b);
        state.addBundle(c);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)aFrag.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)c.isResolved());
        state.removeBundle(c);
        state.resolve(false);
        StateResolverTest.assertFalse((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"1.2", (boolean)aFrag.isResolved());
        StateResolverTest.assertFalse((String)"1.3", (boolean)b.isResolved());
        state.addBundle(c);
        state.resolve();
        StateResolverTest.assertTrue((String)"2.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)aFrag.isResolved());
        StateResolverTest.assertTrue((String)"2.3", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"2.4", (boolean)c.isResolved());
        ExportPackageDescription[] aExports = a.getSelectedExports();
        ExportPackageDescription[] bImports = b.getResolvedImports();
        StateResolverTest.assertTrue((String)"3.1", (aExports.length == 2 ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"3.2", (bImports.length == 2 ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"3.3", (aExports[0] == bImports[0] ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"3.4", (aExports[1] == bImports[1] ? 1 : 0) != 0);
    }

    public void testFragmentsMultipleVersion() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription a1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + '_' + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "A");
        BundleDescription aFrag1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + '_' + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "2.0");
        BundleDescription a2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + '_' + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "AFrag");
        manifest.put("Bundle-Version", "2.0");
        manifest.put("Fragment-Host", "A");
        BundleDescription aFrag2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + '_' + (String)manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a1);
        state.addBundle(aFrag1);
        state.addBundle(a2);
        state.addBundle(aFrag2);
        state.resolve();
        StateResolverTest.assertTrue((String)"0.1", (boolean)a1.isResolved());
        StateResolverTest.assertTrue((String)"0.2", (boolean)aFrag1.isResolved());
        StateResolverTest.assertTrue((String)"0.3", (boolean)a2.isResolved());
        StateResolverTest.assertTrue((String)"0.4", (boolean)aFrag2.isResolved());
        state.removeBundle(a2);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"1.1", (boolean)a1.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)aFrag2.isResolved());
        StateResolverTest.assertFalse((String)"1.3", (boolean)aFrag1.isResolved());
        StateResolverTest.assertEquals((String)"1.4", (Object)a1, (Object)aFrag2.getHost().getSupplier());
    }

    public void testPlatformProperties01() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, "org.eclipse.osgi", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.b, pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.4");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.b");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.d, pkg.system.b");
        manifest.put("Require-Capability", "osgi.ee; filter:=\"(&(osgi.ee=JavaSE)(version>=1.4))\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.d");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Require-Capability", "osgi.ee; filter:=\"(&(osgi.ee=JavaSE)(version>=1.2))\"");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "system.b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription systemB = state.getFactory().createBundleDescription(state, manifest, "system.b", (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.c");
        props[0].put("org.osgi.framework.executionenvironment", "J2SE-1.2");
        props[0].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"JavaSE\"; version:Version=\"1.2\"");
        props[1].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b, pkg.system.c");
        props[1].put("org.osgi.framework.executionenvironment", "J2SE-1.4");
        props[1].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.2, 1.3, 1.4\"");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(systemB);
        state.resolve();
        List ids = systemBundle.getCapabilities("osgi.identity");
        StateResolverTest.assertNotNull((String)"Null osgi.identity", (Object)ids);
        StateResolverTest.assertEquals((String)"Wrong number of identities", (int)1, (int)ids.size());
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"1.5", (boolean)systemB.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[1].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b.getResolvedImports()[0].getExporter() == systemB ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.2", (c.getResolvedImports()[1].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.3", (d.getResolvedImports()[0].getExporter() == systemB ? 1 : 0) != 0);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.b; uses:=\"pkg.system.b\"");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription b_updated = state.getFactory().createBundleDescription(state, manifest, "B", b.getBundleId());
        state.updateBundle(b_updated);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.d; uses:=\"pkg.system.b\"");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription d_updated = state.getFactory().createBundleDescription(state, manifest, "D", d.getBundleId());
        state.updateBundle(d_updated);
        state.resolve(new BundleDescription[]{b_updated, d_updated});
        StateResolverTest.assertTrue((String)"3.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"3.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"3.2", (boolean)b_updated.isResolved());
        StateResolverTest.assertTrue((String)"3.3", (boolean)systemB.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[1].getExporter() == systemB ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b_updated.getResolvedImports()[0].getExporter() == systemB ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.2", (c.getResolvedImports()[1].getExporter() == systemB ? 1 : 0) != 0);
    }

    public void testPlatformProperties02() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.system.bundle");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, "test.system.bundle", (long)bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.b, pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.4");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.b");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "system.b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription systemB = state.getFactory().createBundleDescription(state, manifest, "system.b", (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.c");
        props[0].put("org.osgi.framework.executionenvironment", "J2SE-1.2");
        props[0].put("osgi.system.bundle", "test.system.bundle");
        props[1].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b, pkg.system.c");
        props[1].put("org.osgi.framework.executionenvironment", "J2SE-1.4");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(systemB);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)systemB.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[1].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b.getResolvedImports()[0].getExporter() == systemB ? 1 : 0) != 0);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Export-Package", "pkg.b; uses:=\"pkg.system.b\"");
        manifest.put("Import-Package", "pkg.system.b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription b_updated = state.getFactory().createBundleDescription(state, manifest, "B", b.getBundleId());
        state.updateBundle(b_updated);
        state.resolve(new BundleDescription[]{b_updated});
        StateResolverTest.assertTrue((String)"3.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"3.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"3.2", (boolean)b_updated.isResolved());
        StateResolverTest.assertTrue((String)"3.3", (boolean)systemB.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[1].getExporter() == systemB ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b_updated.getResolvedImports()[0].getExporter() == systemB ? 1 : 0) != 0);
    }

    public void testPlatformProperties03() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        String configuredSystemBundle = "org.eclipse.osgi";
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Export-Package", "system.bundle.exported.pkg");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, configuredSystemBundle, (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "system.bundle");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", configuredSystemBundle);
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "system.bundle.exported.pkg; bundle-symbolic-name=\"system.bundle\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "system.bundle.exported.pkg; bundle-symbolic-name=\"" + configuredSystemBundle + "\"");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.a; bundle-symbolic-name=\"system.bundle\"");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, "E", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.a; bundle-symbolic-name=\"" + configuredSystemBundle + "\"");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, "F", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "system.bundle");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, "G", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", configuredSystemBundle);
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, "H", (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"1.5", (boolean)e.isResolved());
        StateResolverTest.assertTrue((String)"1.6", (boolean)f.isResolved());
        StateResolverTest.assertTrue((String)"1.7", (boolean)g.isResolved());
        StateResolverTest.assertTrue((String)"1.8", (boolean)h.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedRequires()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b.getResolvedRequires()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.2", (c.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.3", (d.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.4", (e.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.5", (f.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.6", (g.getHost().getHosts()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.7", (h.getHost().getHosts()[0] == systemBundle ? 1 : 0) != 0);
    }

    public void testPlatformProperties04() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        String configuredSystemBundle = "test.system.bundle";
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Export-Package", "system.bundle.exported.pkg");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, configuredSystemBundle, (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "system.bundle");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", configuredSystemBundle);
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "system.bundle.exported.pkg; bundle-symbolic-name=\"system.bundle\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "system.bundle.exported.pkg; bundle-symbolic-name=\"" + configuredSystemBundle + "\"");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.a; bundle-symbolic-name=\"system.bundle\"");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, "E", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.a; bundle-symbolic-name=\"" + configuredSystemBundle + "\"");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, "F", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", "system.bundle");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, "G", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Fragment-Host", configuredSystemBundle);
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, "H", (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b");
        props[0].put("osgi.system.bundle", configuredSystemBundle);
        state.setPlatformProperties(props);
        state.addBundle(systemBundle);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.addBundle(f);
        state.addBundle(g);
        state.addBundle(h);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"1.5", (boolean)e.isResolved());
        StateResolverTest.assertTrue((String)"1.6", (boolean)f.isResolved());
        StateResolverTest.assertTrue((String)"1.7", (boolean)g.isResolved());
        StateResolverTest.assertTrue((String)"1.8", (boolean)h.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedRequires()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.1", (b.getResolvedRequires()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.2", (c.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.3", (d.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.4", (e.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.5", (f.getResolvedImports()[0].getExporter() == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.6", (g.getHost().getHosts()[0] == systemBundle ? 1 : 0) != 0);
        StateResolverTest.assertTrue((String)"2.7", (h.getHost().getHosts()[0] == systemBundle ? 1 : 0) != 0);
    }

    public void testPlatformPropertiesBug188075() throws BundleException, IOException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Eclipse-PlatformFilter", "(!(test=value))");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Eclipse-PlatformFilter", "(test=value)");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        Dictionary props = new Hashtable<String, String>();
        props.put("test", "value");
        state.setPlatformProperties(props);
        state.addBundle(a);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertFalse((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        BundleContext context = OSGiTestsActivator.getContext();
        File stateCache = context.getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
        props = state.getPlatformProperties()[0];
        StateResolverTest.assertEquals((String)"2.0", (Object)"value", props.get("test"));
        BundleDescription aCache = state.getBundle("A", null);
        BundleDescription bCache = state.getBundle("B", null);
        StateResolverTest.assertFalse((String)"2.1", (boolean)aCache.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)bCache.isResolved());
    }

    public void testPlatformPropertiesBug207500a() throws BundleException, IOException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Eclipse-PlatformFilter", "(test=value1)");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Eclipse-PlatformFilter", "(test=value2)");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        Dictionary props = new Hashtable<String, CatchAllValue>();
        props.put("test", new CatchAllValue("*"));
        state.setPlatformProperties(props);
        state.addBundle(a);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        BundleContext context = OSGiTestsActivator.getContext();
        File stateCache = context.getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
        props = state.getPlatformProperties()[0];
        StateResolverTest.assertNull((String)"2.0", props.get("test"));
        BundleDescription aCache = state.getBundle("A", null);
        BundleDescription bCache = state.getBundle("B", null);
        StateResolverTest.assertTrue((String)"2.1", (boolean)aCache.isResolved());
        StateResolverTest.assertTrue((String)"2.2", (boolean)bCache.isResolved());
        state.setResolver(this.platformAdminService.getResolver());
        state.resolve(false);
        StateResolverTest.assertFalse((String)"3.1", (boolean)aCache.isResolved());
        StateResolverTest.assertFalse((String)"3.2", (boolean)bCache.isResolved());
    }

    public void testPlatformPropertiesBug207500b() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "libwrapper-linux-x86-32.so; wrapper-linux-x86-32; osname=linux; processor=x86");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        Hashtable<String, CatchAllValue> props = new Hashtable<String, CatchAllValue>();
        ((Dictionary)props).put("osgi.os", new CatchAllValue("*"));
        ((Dictionary)props).put("osgi.arch", new CatchAllValue("*"));
        ((Dictionary)props).put("osgi.lang", new CatchAllValue("*"));
        ((Dictionary)props).put("osgi.ws", new CatchAllValue("*"));
        state.setPlatformProperties(props);
        state.addBundle(a);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
    }

    public void testPlatformPropertiesBug246640a() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        String configuredSystemBundle = "org.eclipse.osgi; singleton:=true";
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf(configuredSystemBundle) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Bundle-Version", "2.0");
        BundleDescription systemBundle2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf(configuredSystemBundle) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "require.system.b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "org.eclipse.osgi; bundle-version=2.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription requireSystemBundle = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.c");
        props[0].put("org.osgi.framework.executionenvironment", "J2SE-1.2");
        props[1].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b, pkg.system.c");
        props[1].put("org.osgi.framework.executionenvironment", "J2SE-1.4");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle1);
        state.addBundle(systemBundle2);
        state.addBundle(a);
        state.addBundle(requireSystemBundle);
        state.resolve();
        StateResolverTest.assertFalse((String)"1.0", (boolean)systemBundle1.isResolved());
        StateResolverTest.assertTrue((String)"1.0.1", (boolean)systemBundle2.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)requireSystemBundle.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[0].getExporter() == systemBundle2 ? 1 : 0) != 0);
    }

    public void testPlatformPropertiesBug246640b() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        String configuredSystemBundle = "test.system.bundle; singleton:=true";
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle1 = state.getFactory().createBundleDescription(state, manifest, String.valueOf(configuredSystemBundle) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", configuredSystemBundle);
        manifest.put("Bundle-Version", "2.0");
        BundleDescription systemBundle2 = state.getFactory().createBundleDescription(state, manifest, String.valueOf(configuredSystemBundle) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Import-Package", "pkg.system.b");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "require.system.b");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "test.system.bundle; bundle-version=2.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.2");
        BundleDescription requireSystemBundle = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable()};
        props[0].put("osgi.system.bundle", "test.system.bundle");
        props[0].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.c");
        props[0].put("org.osgi.framework.executionenvironment", "J2SE-1.2");
        props[1].put("org.osgi.framework.system.packages", "pkg.system.a, pkg.system.b, pkg.system.c");
        props[1].put("org.osgi.framework.executionenvironment", "J2SE-1.4");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle1);
        state.addBundle(systemBundle2);
        state.addBundle(a);
        state.addBundle(requireSystemBundle);
        state.resolve();
        StateResolverTest.assertFalse((String)"1.0", (boolean)systemBundle1.isResolved());
        StateResolverTest.assertTrue((String)"1.0.1", (boolean)systemBundle2.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)requireSystemBundle.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (a.getResolvedImports()[0].getExporter() == systemBundle2 ? 1 : 0) != 0);
    }

    public void testEECapabilityRequirement() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, "org.eclipse.osgi", (long)bundleID++);
        state.addBundle(systemBundle);
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-RequiredExecutionEnvironment", "OSGi/Minimum-1.1");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        bundles.add(a);
        state.addBundle(a);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-RequiredExecutionEnvironment", "CDC-1.1/Foundation-1.1");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        bundles.add(b);
        state.addBundle(b);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.4");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        bundles.add(c);
        state.addBundle(c);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-RequiredExecutionEnvironment", "AA/BB");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        bundles.add(d);
        state.addBundle(d);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "E");
        manifest.put("Bundle-RequiredExecutionEnvironment", "CC-XX/DD-YY");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, "E", (long)bundleID++);
        bundles.add(e);
        state.addBundle(e);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-RequiredExecutionEnvironment", "EE-2.0/FF-YY");
        BundleDescription f = state.getFactory().createBundleDescription(state, manifest, "F", (long)bundleID++);
        bundles.add(f);
        state.addBundle(f);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "G");
        manifest.put("Bundle-RequiredExecutionEnvironment", "GG-XX/HH-1.0");
        BundleDescription g = state.getFactory().createBundleDescription(state, manifest, "G", (long)bundleID++);
        bundles.add(g);
        state.addBundle(g);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "H");
        manifest.put("Bundle-RequiredExecutionEnvironment", "II-1.0/JJ-2.0");
        BundleDescription h = state.getFactory().createBundleDescription(state, manifest, "H", (long)bundleID++);
        bundles.add(h);
        state.addBundle(h);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "OSGi/Minimum-1.0, OSGi/Minimum-1.1, OSGi/Minimum-1.2");
        props[1].put("org.osgi.framework.executionenvironment", "CDC-1.0/Foundation-1.0, CDC-1.1/Foundation-1.1");
        props[2].put("org.osgi.framework.executionenvironment", "J2SE-1.2, J2SE-1.3, J2SE-1.4, J2SE-1.5, JavaSE-1.6");
        props[3].put("org.osgi.framework.executionenvironment", "AA/BB");
        props[4].put("org.osgi.framework.executionenvironment", "CC-XX/DD-YY");
        props[5].put("org.osgi.framework.executionenvironment", "EE-1.0/FF-YY, EE-2.0/FF-YY");
        props[6].put("org.osgi.framework.executionenvironment", "GG-XX/HH-1.0, GG-XX/HH-2.0");
        props[7].put("org.osgi.framework.executionenvironment", "II-1.0/JJ-2.0");
        state.setPlatformProperties(props);
        state.resolve();
        this.checkEECapabilities(systemBundle.getWiring().getCapabilities("osgi.ee"), bundles);
        state.setPlatformProperties(new Hashtable());
        state.resolve(false);
        StateResolverTest.assertTrue((String)"2.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertFalse((String)"2.1", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"2.2", (boolean)b.isResolved());
        StateResolverTest.assertFalse((String)"2.3", (boolean)c.isResolved());
        StateResolverTest.assertFalse((String)"2.4", (boolean)d.isResolved());
        StateResolverTest.assertFalse((String)"2.5", (boolean)e.isResolved());
        StateResolverTest.assertFalse((String)"2.7", (boolean)f.isResolved());
        StateResolverTest.assertFalse((String)"2.8", (boolean)g.isResolved());
        StateResolverTest.assertFalse((String)"2.9", (boolean)h.isResolved());
        props[0].put("org.osgi.framework.executionenvironment", "OSGi/Minimum-1.1");
        props[1].put("org.osgi.framework.executionenvironment", "CDC-1.1/Foundation-1.1");
        props[2].put("org.osgi.framework.executionenvironment", "J2SE-1.4");
        props[3].put("org.osgi.framework.executionenvironment", "AA/BB");
        props[4].put("org.osgi.framework.executionenvironment", "CC-XX/DD-YY");
        props[5].put("org.osgi.framework.executionenvironment", "EE-2.0/FF-YY");
        props[6].put("org.osgi.framework.executionenvironment", "GG-XX/HH-1.0");
        props[7].put("org.osgi.framework.executionenvironment", "II-1.0/JJ-2.0");
        props[0].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\"");
        props[1].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"CDC/Foundation\"; version:List<Version>=\"1.0, 1.1\"");
        props[2].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.2, 1.3, 1.4, 1.5, 1.6\"");
        props[3].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"AA/BB\"");
        props[4].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"CC-XX/DD-YY\"");
        props[5].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"EE/FF-YY\"; version:List<Version>=\"1.0, 2.0\"");
        props[6].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"GG-XX/HH\"; version:List<Version>=\"1.0, 2.0\"");
        props[7].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"II-1.0/JJ-2.0\"");
        state.setPlatformProperties(props);
        state.resolve(false);
        this.checkEECapabilities(systemBundle.getWiring().getCapabilities("osgi.ee"), bundles);
    }

    private void checkEECapabilities(List eeCapabilities, List bundles) {
        StateResolverTest.assertEquals((String)"Wrong number of ee capabilities.", (int)8, (int)eeCapabilities.size());
        int i = 0;
        while (i < eeCapabilities.size()) {
            Capability eeCap = (Capability)eeCapabilities.get(i);
            StateResolverTest.assertEquals((String)("Wrong namespace: " + eeCap), (String)"osgi.ee", (String)eeCap.getNamespace());
            Map attrs = eeCap.getAttributes();
            switch (i) {
                case 0: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"OSGi/Minimum", attrs.get("osgi.ee"));
                    List v0 = (List)attrs.get("version");
                    StateResolverTest.assertEquals((String)("Wrong number of versions: " + i), (int)3, (int)v0.size());
                    StateResolverTest.assertTrue((String)"Does not contain 1.0.", (boolean)v0.contains(new Version("1.0")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.1.", (boolean)v0.contains(new Version("1.1")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.2.", (boolean)v0.contains(new Version("1.2")));
                    break;
                }
                case 1: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"CDC/Foundation", attrs.get("osgi.ee"));
                    List v1 = (List)attrs.get("version");
                    StateResolverTest.assertEquals((String)("Wrong number of versions: " + i), (int)2, (int)v1.size());
                    StateResolverTest.assertTrue((String)"Does not contain 1.0.", (boolean)v1.contains(new Version("1.0")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.1.", (boolean)v1.contains(new Version("1.1")));
                    break;
                }
                case 2: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"JavaSE", attrs.get("osgi.ee"));
                    List v2 = (List)attrs.get("version");
                    StateResolverTest.assertEquals((String)("Wrong number of versions: " + i), (int)5, (int)v2.size());
                    StateResolverTest.assertTrue((String)"Does not contain 1.2.", (boolean)v2.contains(new Version("1.2")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.3.", (boolean)v2.contains(new Version("1.3")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.4.", (boolean)v2.contains(new Version("1.4")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.5.", (boolean)v2.contains(new Version("1.5")));
                    StateResolverTest.assertTrue((String)"Does not contain 1.6.", (boolean)v2.contains(new Version("1.6")));
                    break;
                }
                case 3: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"AA/BB", attrs.get("osgi.ee"));
                    List v3 = (List)attrs.get("version");
                    StateResolverTest.assertNull((String)"versions is not null", (Object)v3);
                    break;
                }
                case 4: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"CC-XX/DD-YY", attrs.get("osgi.ee"));
                    List v4 = (List)attrs.get("version");
                    StateResolverTest.assertNull((String)"versions is not null", (Object)v4);
                    break;
                }
                case 5: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"EE/FF-YY", attrs.get("osgi.ee"));
                    List v5 = (List)attrs.get("version");
                    StateResolverTest.assertEquals((String)("Wrong number of versions: " + i), (int)2, (int)v5.size());
                    StateResolverTest.assertTrue((String)"Does not contain 1.0.", (boolean)v5.contains(new Version("1.0")));
                    StateResolverTest.assertTrue((String)"Does not contain 2.0.", (boolean)v5.contains(new Version("2.0")));
                    break;
                }
                case 6: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"GG-XX/HH", attrs.get("osgi.ee"));
                    List v6 = (List)attrs.get("version");
                    StateResolverTest.assertEquals((String)("Wrong number of versions: " + i), (int)2, (int)v6.size());
                    StateResolverTest.assertTrue((String)"Does not contain 1.0.", (boolean)v6.contains(new Version("1.0")));
                    StateResolverTest.assertTrue((String)"Does not contain 2.0.", (boolean)v6.contains(new Version("2.0")));
                    break;
                }
                case 7: {
                    StateResolverTest.assertEquals((String)("Wrong ee name: " + i), (Object)"II-1.0/JJ-2.0", attrs.get("osgi.ee"));
                    List v7 = (List)attrs.get("version");
                    StateResolverTest.assertNull((String)"versions is not null", (Object)v7);
                    break;
                }
            }
            ++i;
        }
        StateResolverTest.assertEquals((String)"Wrong number of bundles.", (int)eeCapabilities.size(), (int)bundles.size());
        i = 0;
        while (i < bundles.size()) {
            BundleDescription bundle = (BundleDescription)bundles.get(i);
            StateResolverTest.assertTrue((String)("The bundle is not resolved: " + bundle), (boolean)bundle.isResolved());
            BundleWiring wiring = bundle.getWiring();
            List eeWires = wiring.getRequiredWires("osgi.ee");
            StateResolverTest.assertNotNull((String)"ee wires is null.", (Object)eeWires);
            StateResolverTest.assertEquals((String)"Wrong number of ee wires", (int)1, (int)eeWires.size());
            BundleWire wire = (BundleWire)eeWires.get(0);
            StateResolverTest.assertEquals((String)"Wired to wrong ee capability.", eeCapabilities.get(i), (Object)wire.getCapability());
            ++i;
        }
    }

    public void testEECapabilityRequirement1() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, "org.eclipse.osgi", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-RequiredExecutionEnvironment", "CDC-1.0/Foundation-1.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-RequiredExecutionEnvironment", "OSGi/Minimum-1.1");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, "B", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.4");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, "C", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.4, OSGi/Minimum-1.1");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "D");
        manifest.put("Bundle-RequiredExecutionEnvironment", "AA-BB");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, "D", (long)bundleID++);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "OSGi/Minimum-1.0, OSGi/Minimum-1.1, OSGi/Minimum-1.2, CDC-1.0/Foundation-1.0, CDC-1.1/Foundation-1.1, AA-BB");
        props[1].put("org.osgi.framework.executionenvironment", "OSGi/Minimum-1.0, OSGi/Minimum-1.1, OSGi/Minimum-1.2, JRE-1.1, J2SE-1.2, J2SE-1.3, J2SE-1.4");
        props[2].put("org.osgi.framework.executionenvironment", "OSGi/Minimum-1.0, OSGi/Minimum-1.1, JRE-1.1, J2SE-1.2, J2SE-1.3");
        state.setPlatformProperties(props);
        state.addBundle(systemBundle);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"1.5", (boolean)e.isResolved());
        BundleWiring wiringA = a.getWiring();
        BundleWiring wiringB = b.getWiring();
        BundleWiring wiringC = c.getWiring();
        BundleWiring wiringD = d.getWiring();
        BundleWiring wiringE = e.getWiring();
        List wiresA = wiringA.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)wiresA.size());
        List wiresB = wiringB.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.1", (int)1, (int)wiresB.size());
        List wiresC = wiringC.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.2", (int)1, (int)wiresC.size());
        List wiresD = wiringD.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.3", (int)1, (int)wiresD.size());
        List wiresE = wiringE.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.4", (int)1, (int)wiresE.size());
        props[0].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\", osgi.ee; osgi.ee=\"CDC/Foundation\"; version:List<Version>=\"1.0, 1.1\", osgi.ee; osgi.ee=\"AA-BB\"");
        props[1].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\", osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4\"");
        props[2].put("org.osgi.framework.system.capabilities", "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1\", osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3\"");
        state.setPlatformProperties(props);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"1.0", (boolean)systemBundle.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"1.5", (boolean)e.isResolved());
        wiringA = a.getWiring();
        wiringB = b.getWiring();
        wiringC = c.getWiring();
        wiringD = d.getWiring();
        wiringE = e.getWiring();
        wiresA = wiringA.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.0", (int)1, (int)wiresA.size());
        wiresB = wiringB.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.1", (int)1, (int)wiresB.size());
        wiresC = wiringC.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.2", (int)1, (int)wiresC.size());
        wiresD = wiringD.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.3", (int)1, (int)wiresD.size());
        wiresE = wiringE.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"2.4", (int)1, (int)wiresE.size());
    }

    public void testEEBug377510() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        BundleDescription systemBundle = state.getFactory().createBundleDescription(state, manifest, "org.eclipse.osgi", (long)bundleID++);
        state.addBundle(systemBundle);
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Import-Package", "test");
        manifest.put("Bundle-RequiredExecutionEnvironment", "JavaSE-1.6");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, "A", (long)bundleID++);
        bundles.add(a);
        state.addBundle(a);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A.FRAG");
        manifest.put("Fragment-Host", "A");
        manifest.put("Import-Package", "test");
        manifest.put("Bundle-RequiredExecutionEnvironment", "J2SE-1.5");
        BundleDescription aFrag = state.getFactory().createBundleDescription(state, manifest, "A.FRAG", (long)bundleID++);
        bundles.add(aFrag);
        state.addBundle(aFrag);
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "J2SE-1.5");
        props[0].put("org.osgi.framework.system.packages.extra", "test");
        props[1].put("org.osgi.framework.executionenvironment", "J2SE-1.5, JavaSE-1.6");
        props[1].put("org.osgi.framework.system.packages.extra", "test");
        state.setPlatformProperties(props);
        state.resolve();
        StateResolverTest.assertTrue((String)"host not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"fragment not resolved", (boolean)aFrag.isResolved());
    }

    private ExportPackageDescription[] isConsistent(ExportPackageDescription[] pkgs1, ExportPackageDescription[] pkgs2) {
        int i = 0;
        while (i < pkgs1.length) {
            int j = 0;
            while (j < pkgs2.length) {
                if (pkgs1[i].getName().equals(pkgs2[j].getName()) && pkgs1[i] != pkgs2[j]) {
                    return new ExportPackageDescription[]{pkgs1[i], pkgs2[j]};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean contains(Object[] array, Object element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Dictionary loadManifest(String manifest) {
        URL url = this.getContext().getBundle().getEntry(MANIFEST_ROOT + manifest);
        try {
            CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap();
            ManifestElement.parseBundleManifest((InputStream)url.openStream(), (Map)headers);
            return headers.asUnmodifiableDictionary();
        }
        catch (IOException e) {
            StateResolverTest.fail((String)("Unexpected error loading manifest: " + manifest), (Throwable)e);
        }
        catch (BundleException e) {
            StateResolverTest.fail((String)("Unexpected error loading manifest: " + manifest), (Throwable)e);
        }
        return null;
    }

    public void testSelectionPolicy() throws BundleException {
        State state = this.buildEmptyState();
        Resolver resolver = state.getResolver();
        resolver.setSelectionPolicy(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof BaseDescription) || !(o2 instanceof BaseDescription)) {
                    throw new IllegalArgumentException();
                }
                Version v1 = null;
                Version v2 = null;
                v1 = ((BaseDescription)o1).getVersion();
                v2 = ((BaseDescription)o2).getVersion();
                return v1.compareTo(v2);
            }
        });
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testHost101 = state.getFactory().createBundleDescription(state, manifest, "test.host101", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testFrag101 = state.getFactory().createBundleDescription(state, manifest, "test.frag101", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.dependent; singleton:=true");
        manifest.put("Require-Bundle", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testDependent = state.getFactory().createBundleDescription(state, manifest, "test.frag101", bundleID++);
        state.addBundle(testHost100);
        state.addBundle(testFrag100);
        state.addBundle(testHost101);
        state.addBundle(testFrag101);
        state.addBundle(testDependent);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testHost100.isResolved());
        StateResolverTest.assertFalse((String)"1.1", (boolean)testHost101.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)testFrag100.isResolved());
        StateResolverTest.assertFalse((String)"1.3", (boolean)testFrag101.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)testDependent.isResolved());
    }

    public void testBug187616() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testHost101 = state.getFactory().createBundleDescription(state, manifest, "test.host101", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.1");
        BundleDescription testFrag101 = state.getFactory().createBundleDescription(state, manifest, "test.frag101", bundleID++);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.dependent; singleton:=true");
        manifest.put("Require-Bundle", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testDependent = state.getFactory().createBundleDescription(state, manifest, "test.frag101", bundleID++);
        state.addBundle(testHost100);
        state.addBundle(testFrag100);
        state.addBundle(testHost101);
        state.addBundle(testFrag101);
        state.addBundle(testDependent);
        StateDelta stateDelta = state.resolve();
        StateResolverTest.assertFalse((String)"1.0", (boolean)testHost100.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)testHost101.isResolved());
        StateResolverTest.assertFalse((String)"1.2", (boolean)testFrag100.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)testFrag101.isResolved());
        StateResolverTest.assertTrue((String)"1.4", (boolean)testDependent.isResolved());
        BundleDelta[] bDelta = stateDelta.getChanges(9, false);
        StateResolverTest.assertTrue((String)"2.0", (bDelta.length == 5 ? 1 : 0) != 0);
    }

    public void testBug217150() throws BundleException {
        State state = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.host; singleton:=true");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testHost100 = state.getFactory().createBundleDescription(state, manifest, "test.host100", bundleID++);
        try {
            testHost100.getFragments();
            StateResolverTest.fail((String)"Expected to get an exception here!!!");
        }
        catch (IllegalStateException illegalStateException) {}
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "test.frag; singleton:=true");
        manifest.put("Fragment-Host", "test.host; bundle-version=\"[1.0.0,2.0.0)\"");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription testFrag100 = state.getFactory().createBundleDescription(state, manifest, "test.frag100", bundleID++);
        BundleDescription[] hosts = testFrag100.getHost().getHosts();
        StateResolverTest.assertNotNull((String)"hosts is null", (Object)hosts);
        StateResolverTest.assertEquals((String)"Unexpected number of hosts", (int)0, (int)hosts.length);
    }

    public void testNativeCodeResolution01() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("osgi.ws", "win32");
        props[0].put("osgi.os", "win32");
        props[0].put("osgi.arch", "x86");
        props[0].put("osgi.nl", "en_US");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=Windows2000;osname=\"Windows 2003\";osname=Windows95;osname=Windows98;osname=WindowsNT;osname=WindowsXP;osname=\"Windows NT (unknown)\";osname=\"Windows Vista\"; language=en");
        BundleDescription testNativeBundle = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle.isResolved());
    }

    public void testNativeCodeResolution02() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.os.name", "WIN32");
        props[0].put("org.osgi.framework.processor", "x86");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=Windows2000;osname=\"Windows 2003\";osname=Windows95;osname=Windows98;osname=WindowsNT;osname=WindowsXP;osname=\"Windows NT (unknown)\";osname=\"Windows Vista\"");
        BundleDescription testNativeBundle = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle.isResolved());
    }

    public void testNativeCodeResolution03() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.os.name", "win32");
        props[0].put("org.osgi.framework.processor", "X86");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=Windows2000;osname=\"Windows 2003\";osname=Windows95;osname=Windows98;osname=WindowsNT;osname=WindowsXP;osname=\"Windows NT (unknown)\";osname=\"Windows Vista\"");
        BundleDescription testNativeBundle = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle.isResolved());
    }

    public void testNativeCodeResolution04() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.os.name", "DoesNotExist");
        props[0].put("org.osgi.framework.processor", "InVaLid");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=iNvAlid;osname=doeSnoTexist");
        BundleDescription testNativeBundle = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle.isResolved());
    }

    public void testNativeCodeResolution05() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable(), new Hashtable()};
        props[0].put("osgi.ws", "win32");
        props[0].put("osgi.os", "win32");
        props[0].put("osgi.arch", "x86");
        props[0].put("osgi.nl", "en_US");
        props[1].put("osgi.ws", "win32");
        props[1].put("osgi.os", "win32");
        props[1].put("osgi.arch", "x86_64");
        props[1].put("osgi.nl", "en_US");
        props[2].put("osgi.ws", "win32");
        props[2].put("osgi.os", "win32");
        props[2].put("osgi.arch", "x86");
        props[2].put("osgi.nl", "fr_FR");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=win32; language=en");
        BundleDescription testNativeBundle1 = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle2");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86_64;osname=win32; language=en");
        BundleDescription testNativeBundle2 = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle3");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=win32; language=fr");
        BundleDescription testNativeBundle3 = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle1);
        state.addBundle(testNativeBundle2);
        state.addBundle(testNativeBundle3);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle1.isResolved());
        StateResolverTest.assertTrue((String)"2.0", (boolean)testNativeBundle2.isResolved());
        StateResolverTest.assertTrue((String)"3.0", (boolean)testNativeBundle3.isResolved());
    }

    public void testNativeCodeResolution06() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable(), new Hashtable(), new Hashtable()};
        props[1].put("osgi.ws", "win32");
        props[1].put("osgi.os", "win32");
        props[1].put("osgi.arch", "x86_64");
        props[2].put("osgi.ws", "win32");
        props[2].put("osgi.os", "win32");
        props[2].put("osgi.arch", "x86");
        state.setPlatformProperties(props);
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        long bundleID = 0L;
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "NativeBundle1");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-NativeCode", "Bundle-NativeCode: nativefile1.txt;processor=x86;osname=win32");
        BundleDescription testNativeBundle1 = state.getFactory().createBundleDescription(state, manifest, "NativeBundle", bundleID++);
        state.addBundle(testNativeBundle1);
        state.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)testNativeBundle1.isResolved());
    }

    public void testMultiStateAdd01() throws BundleException {
        State state1 = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state1.getFactory().createBundleDescription(state1, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state1.getFactory().createBundleDescription(state1, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state1.getFactory().createBundleDescription(state1, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state1.getFactory().createBundleDescription(state1, manifest, "gef10", 3L);
        state1.addBundle(sdk10);
        state1.addBundle(platform10);
        state1.addBundle(rcp10);
        state1.addBundle(gef10);
        state1.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        State state2 = this.buildEmptyState();
        try {
            state2.addBundle(rcp10);
            StateResolverTest.fail((String)"Expected IllegalStateException on adding to multiple states");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testMultiStateAdd02() throws BundleException {
        State state1 = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state1.getFactory().createBundleDescription(state1, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state1.getFactory().createBundleDescription(state1, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state1.getFactory().createBundleDescription(state1, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state1.getFactory().createBundleDescription(state1, manifest, "gef10", 3L);
        state1.addBundle(sdk10);
        state1.addBundle(platform10);
        state1.addBundle(rcp10);
        state1.addBundle(gef10);
        state1.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        state1.removeBundle(rcp10);
        State state2 = this.buildEmptyState();
        try {
            state2.addBundle(rcp10);
            StateResolverTest.fail((String)"Expected IllegalStateException on adding to multiple states");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testMultiStateAdd03() throws BundleException {
        State state1 = this.buildEmptyState();
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "sdk; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "platform; bundle-version=\"[1.0,2.0]\"");
        BundleDescription sdk10 = state1.getFactory().createBundleDescription(state1, manifest, "sdk10", 0L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "platform; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,2.0]\"");
        BundleDescription platform10 = state1.getFactory().createBundleDescription(state1, manifest, "platform10", 1L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "rcp; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        BundleDescription rcp10 = state1.getFactory().createBundleDescription(state1, manifest, "rcp10", 2L);
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "gef; singleton:=true");
        manifest.put("Bundle-Version", "1.0");
        manifest.put("Require-Bundle", "rcp; bundle-version=\"[1.0,1.0]\"");
        BundleDescription gef10 = state1.getFactory().createBundleDescription(state1, manifest, "gef10", 3L);
        state1.addBundle(sdk10);
        state1.addBundle(platform10);
        state1.addBundle(rcp10);
        state1.addBundle(gef10);
        state1.resolve();
        StateResolverTest.assertTrue((String)"1.0", (boolean)sdk10.isResolved());
        StateResolverTest.assertTrue((String)"1.1", (boolean)platform10.isResolved());
        StateResolverTest.assertTrue((String)"1.2", (boolean)rcp10.isResolved());
        StateResolverTest.assertTrue((String)"1.3", (boolean)gef10.isResolved());
        state1.removeBundle(rcp10);
        state1.resolve(new BundleDescription[]{rcp10});
        State state2 = this.buildEmptyState();
        try {
            state2.addBundle(rcp10);
        }
        catch (IllegalStateException e) {
            StateResolverTest.fail((String)"Unexpected IllegalStateException on adding to state", (Throwable)e);
        }
    }

    private State createBug266935State() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "a");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        return state;
    }

    private BundleDescription updateStateBug266935(State state, BundleDescription a) throws BundleException {
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", a.getSymbolicName());
        manifest.put("Bundle-Version", a.getVersion().toString());
        BundleDescription newA = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), a.getBundleId());
        state.updateBundle(newA);
        return newA;
    }

    public void testBug266935_01() throws BundleException {
        State state = this.createBug266935State();
        BundleDescription a = state.getBundle("a", new Version("1.0"));
        BundleDescription newA = this.updateStateBug266935(state, a);
        state.removeBundle(a);
        state.resolve(new BundleDescription[]{newA});
    }

    public void testBug266935_02() throws BundleException {
        State state = this.createBug266935State();
        BundleDescription a = state.getBundle("a", new Version("1.0"));
        this.updateStateBug266935(state, a);
        state.removeBundle(a);
        state.resolve(new BundleDescription[]{a});
    }

    public void testBug266935_03() throws BundleException {
        State state = this.createBug266935State();
        BundleDescription a = state.getBundle("a", new Version("1.0"));
        BundleDescription newA = this.updateStateBug266935(state, a);
        state.removeBundle(newA);
        state.resolve(new BundleDescription[]{newA});
    }

    public void testBug266935_04() throws BundleException {
        State state = this.createBug266935State();
        BundleDescription a = state.getBundle("a", new Version("1.0"));
        BundleDescription newA = this.updateStateBug266935(state, a);
        state.removeBundle(newA);
        state.resolve(new BundleDescription[]{a});
    }

    public void testBug320124() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "d");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a");
        manifest.put("Require-Bundle", "e");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "e");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "e");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"C is not resolved", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"D is not resolved", (boolean)d.isResolved());
        ExportPackageDescription[] visible = state.getStateHelper().getVisiblePackages(a, 3);
        StateResolverTest.assertEquals((String)"Wrong number of visible", (int)2, (int)visible.length);
    }

    public void testBug324618() throws BundleException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("p1.MF");
        BundleDescription p1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("p2.MF");
        BundleDescription p2 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        manifest = this.loadManifest("c1.MF");
        BundleDescription c1 = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(p1);
        state.addBundle(p2);
        state.addBundle(c1);
        state.resolve();
        ExportPackageDescription x = state.linkDynamicImport(c1, "x");
        StateResolverTest.assertNotNull((String)"x dynamic import is null", (Object)x);
        ExportPackageDescription xSub = state.linkDynamicImport(c1, "x.sub");
        StateResolverTest.assertNotNull((String)"x.sub dynamic import is null", (Object)xSub);
        this.assertEquals("The exporter is not the same for x and x.sub", x.getExporter(), xSub.getExporter());
        ExportPackageDescription xExtra = state.linkDynamicImport(c1, "x.extra");
        StateResolverTest.assertNotNull((String)"x.extra dynamic import is null", (Object)xExtra);
    }

    public void testRequirements() throws BundleException, InvalidSyntaxException, IOException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("r1.MF");
        BundleDescription hostDescription = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(hostDescription);
        manifest = this.loadManifest("r2.MF");
        BundleDescription fragDescription = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(fragDescription);
        this.doTestRequirements((BundleRevision)hostDescription, (BundleRevision)fragDescription);
        File stateCache = OSGiTestsActivator.getContext().getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
        hostDescription = state.getBundle(0L);
        fragDescription = state.getBundle(1L);
        this.doTestRequirements((BundleRevision)hostDescription, (BundleRevision)fragDescription);
    }

    private void doTestRequirements(BundleRevision hostRevision, BundleRevision fragRevision) throws InvalidSyntaxException {
        List pReqs = hostRevision.getDeclaredRequirements("osgi.wiring.package");
        StateResolverTest.assertEquals((String)"Wrong number of reqs: osgi.wiring.package", (int)8, (int)pReqs.size());
        HashMap<String, String> matchingAttrs = new HashMap<String, String>();
        matchingAttrs.put("osgi.wiring.package", "importer.pkg1");
        matchingAttrs.put("version", (String)new Version("1.1"));
        this.checkRequirement((BundleRequirement)pReqs.get(0), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg2");
        this.checkRequirement((BundleRequirement)pReqs.get(1), matchingAttrs, null, "(resolution=optional)", true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg3");
        this.checkRequirement((BundleRequirement)pReqs.get(2), matchingAttrs, null, "(resolution=mandatory)", true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg4");
        this.checkRequirement((BundleRequirement)pReqs.get(3), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg5");
        this.checkRequirement((BundleRequirement)pReqs.get(4), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg6");
        this.checkRequirement((BundleRequirement)pReqs.get(5), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg7");
        this.checkRequirement((BundleRequirement)pReqs.get(6), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.package", "importer.pkg8");
        matchingAttrs.put("a1", "v1");
        matchingAttrs.put("a2", "v2");
        this.checkRequirement((BundleRequirement)pReqs.get(7), matchingAttrs, null, "(&(resolution=optional)(d1=v1)(d2=v2))", true);
        matchingAttrs.clear();
        List bReqs = hostRevision.getDeclaredRequirements("osgi.wiring.bundle");
        StateResolverTest.assertEquals((String)"Wrong number of reqs: osgi.wiring.bundle", (int)8, (int)bReqs.size());
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b1");
        matchingAttrs.put("bundle-version", (String)new Version("1.1"));
        this.checkRequirement((BundleRequirement)bReqs.get(0), matchingAttrs, null, "(&(visibility=reexport)(resolution=optional))", true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b2");
        this.checkRequirement((BundleRequirement)bReqs.get(1), matchingAttrs, null, "(&(|(visibility=private)(!(visibility=*)))(|(resolution=mandatory)(!(resolution=*))))", true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b3");
        this.checkRequirement((BundleRequirement)bReqs.get(2), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b4");
        this.checkRequirement((BundleRequirement)bReqs.get(3), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b5");
        this.checkRequirement((BundleRequirement)bReqs.get(4), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b6");
        this.checkRequirement((BundleRequirement)bReqs.get(5), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b7");
        this.checkRequirement((BundleRequirement)bReqs.get(6), matchingAttrs, null, null, true);
        matchingAttrs.put("osgi.wiring.bundle", "requirer.b8");
        matchingAttrs.put("a1", "v1");
        matchingAttrs.put("a2", "v2");
        this.checkRequirement((BundleRequirement)bReqs.get(7), matchingAttrs, null, "(&(resolution=optional)(d1=v1)(d2=v2))", true);
        matchingAttrs.clear();
        List cReqs = hostRevision.getDeclaredRequirements("require.c1");
        StateResolverTest.assertEquals((String)"Wrong number of reqs: require.c1", (int)1, (int)cReqs.size());
        matchingAttrs.put("a1", "v1");
        this.checkRequirement((BundleRequirement)cReqs.get(0), matchingAttrs, null, "(&(|(effective=resolve)(!(effective=*)))(resolution=optional)(filter=\\(a1=v1\\)))", true);
        cReqs = hostRevision.getDeclaredRequirements("require.c2");
        StateResolverTest.assertEquals((String)"Wrong number of reqs: require.c2", (int)1, (int)cReqs.size());
        matchingAttrs.clear();
        this.checkRequirement((BundleRequirement)cReqs.get(0), matchingAttrs, null, "(&(|(effective=resolve)(!(effective=*)))(|(resolution=mandatory)(!(resolution=*))))", false);
        cReqs = hostRevision.getDeclaredRequirements("require.c3");
        StateResolverTest.assertEquals((String)"Wrong number of reqs: require.c3", (int)1, (int)cReqs.size());
        matchingAttrs.clear();
        this.checkRequirement((BundleRequirement)cReqs.get(0), matchingAttrs, "(&(a1=v1)(a2=v2))", "(&(resolution=optional)(d1=v1)(d2=v2))", false);
        List fReqs = fragRevision.getDeclaredRequirements("osgi.wiring.host");
        StateResolverTest.assertEquals((String)"Wrong number of host reqs: osgi.wiring.host", (int)1, (int)fReqs.size());
        matchingAttrs.clear();
        matchingAttrs.put("osgi.wiring.host", "r1");
        matchingAttrs.put("bundle-version", (String)new Version(1, 1, 1));
        matchingAttrs.put("a1", "v1");
        matchingAttrs.put("a2", "v2");
        this.checkRequirement((BundleRequirement)fReqs.get(0), matchingAttrs, null, "(&(d1=v1)(d2=v2))", true);
    }

    private void checkRequirement(BundleRequirement req, Map matchingAttrs, String attributesFilterSpec, String directivesFilterSpec, boolean reqFilter) throws InvalidSyntaxException {
        if (attributesFilterSpec == null) {
            StateResolverTest.assertTrue((String)("Requirement attrs is not empty: " + req), (boolean)req.getAttributes().isEmpty());
        } else {
            Filter filter = FrameworkUtil.createFilter((String)attributesFilterSpec);
            StateResolverTest.assertTrue((String)("Cannot match attribute filter: " + filter), (boolean)filter.matches(req.getAttributes()));
        }
        Map directives = req.getDirectives();
        String reqFilterSpec = (String)directives.get("filter");
        if (reqFilterSpec != null) {
            Filter filter = FrameworkUtil.createFilter((String)reqFilterSpec);
            StateResolverTest.assertTrue((String)("Cannot match requirement filter: " + filter), (boolean)filter.matches(matchingAttrs));
        } else if (reqFilter) {
            StateResolverTest.fail((String)("Requirement must have filter directive: " + req));
        }
        if (directivesFilterSpec != null) {
            Filter directivesFilter = FrameworkUtil.createFilter((String)directivesFilterSpec);
            StateResolverTest.assertTrue((String)("Cannot match directive filter: " + directivesFilterSpec), (boolean)directivesFilter.matches(req.getDirectives()));
        }
    }

    public void testCapabilities() throws InvalidSyntaxException, BundleException, IOException {
        State state = this.buildEmptyState();
        long bundleID = 0L;
        Dictionary manifest = this.loadManifest("r1.MF");
        BundleDescription hostDescription = state.getFactory().createBundleDescription(state, manifest, (String)manifest.get("Bundle-SymbolicName"), bundleID++);
        state.addBundle(hostDescription);
        this.doTestCapabilities((BundleRevision)hostDescription);
        File stateCache = OSGiTestsActivator.getContext().getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
        hostDescription = state.getBundle(0L);
    }

    private void doTestCapabilities(BundleRevision hostRevision) throws InvalidSyntaxException {
        List bundleCaps = hostRevision.getDeclaredCapabilities("osgi.wiring.bundle");
        StateResolverTest.assertEquals((String)"Wrong number of: osgi.wiring.bundle", (int)1, (int)bundleCaps.size());
        this.checkCapability((BundleCapability)bundleCaps.get(0), "(&(osgi.wiring.bundle=r1)(a1=v1)(a2=v2))", "(&(d1=v1)(d2=v2)(singleton=true)(fragment-attachment=resolve-time))");
        List hostCaps = hostRevision.getDeclaredCapabilities("osgi.wiring.host");
        StateResolverTest.assertEquals((String)"Wrong number of: osgi.wiring.host", (int)1, (int)hostCaps.size());
        this.checkCapability((BundleCapability)hostCaps.get(0), "(&(osgi.wiring.host=r1)(a1=v1)(a2=v2))", "(&(d1=v1)(d2=v2)(singleton=true)(fragment-attachment=resolve-time))");
        List pkgCaps = hostRevision.getDeclaredCapabilities("osgi.wiring.package");
        StateResolverTest.assertEquals((String)"Wrong number of: osgi.wiring.package", (int)3, (int)pkgCaps.size());
        this.checkCapability((BundleCapability)pkgCaps.get(0), "(&(osgi.wiring.package=exporter.pkg1)(bundle-symbolic-name=r1)(bundle-version=1.0)(version=1.0))", null);
        this.checkCapability((BundleCapability)pkgCaps.get(1), "(&(osgi.wiring.package=exporter.pkg2)(bundle-symbolic-name=r1)(bundle-version=1.0)(a1=v1)(a2=v2))", "(&(include=C1,C2)(exclude=C3,C4)(mandatory=a1,a2)(uses=importer.pkg1,importer.pkg2))");
        this.checkCapability((BundleCapability)pkgCaps.get(2), "(&(osgi.wiring.package=exporter.pkg3)(bundle-symbolic-name=r1)(bundle-version=1.0)(a1=v1)(a2=v2))", "(&(mandatory=a1,a2)(d1=v1)(d2=v2))");
        List gCaps = hostRevision.getDeclaredCapabilities("provide.c1");
        StateResolverTest.assertEquals((String)"Wrong number of: provide.c1", (int)1, (int)gCaps.size());
        this.checkCapability((BundleCapability)gCaps.get(0), "(&(a1=v1)(a2=v2))", "(&(|(effective=resolve)(!(effective=*)))(uses=importer.pkg1,importer.pkg2))");
        gCaps = hostRevision.getDeclaredCapabilities("provide.c2");
        StateResolverTest.assertEquals((String)"Wrong number of: provide.c1", (int)1, (int)gCaps.size());
        this.checkCapability((BundleCapability)gCaps.get(0), "(&(a1=v1)(a2=v2))", "(&(|(effective=resolve)(!(effective=*)))(uses=importer.pkg1,importer.pkg2)(d1=v1)(d2=v2))");
    }

    private void checkCapability(BundleCapability cap, String attributeFilterSpec, String directiveFilterSpec) throws InvalidSyntaxException {
        Filter attributesFilter = FrameworkUtil.createFilter((String)attributeFilterSpec);
        StateResolverTest.assertTrue((String)("Cannot match attribute filter: " + attributesFilter), (boolean)attributesFilter.matches(cap.getAttributes()));
        if (directiveFilterSpec != null) {
            Filter directivesFilter = FrameworkUtil.createFilter((String)directiveFilterSpec);
            StateResolverTest.assertTrue((String)("Cannot match directive filter: " + directivesFilter), (boolean)directivesFilter.matches(cap.getDirectives()));
        }
    }

    public void testRanges() throws BundleException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "a");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a; version=1.0.0");
        manifest.put("Provide-Capability", "test.a; version:Version=1.0.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "a; bundle-version=\"[1.0, 1.1)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "a; version=\"[1.0,2.0)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Bundle", "a; bundle-version=\"[1.0,2.0)\"");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "e");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Capability", "test.a; filter:=\"(version>=1.0.0)\"");
        BundleDescription e = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.addBundle(b);
        state.addBundle(c);
        state.addBundle(d);
        state.addBundle(e);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"C is not resolved", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"D is not resolved", (boolean)d.isResolved());
        StateResolverTest.assertTrue((String)"E is not resolved", (boolean)e.isResolved());
    }

    public void testBug369880() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "test");
        state.setPlatformProperties(props);
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.osgi; bundle-version=\"[1.0, 1.1)\"");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        state.addBundle(b);
        state.resolve();
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        BundleWiring aWiring = a.getWiring();
        List aRequirements = a.getRequirements("osgi.ee");
        List aRequiredWires = aWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from system bundle", (int)1, (int)aRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from system bundle", (int)1, (int)aRequiredWires.size());
        BundleWiring bWiring = b.getWiring();
        List bRequirements = b.getRequirements("osgi.ee");
        List bRequiredWires = bWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from fragment", (int)1, (int)bRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from fragment", (int)1, (int)bRequiredWires.size());
    }

    public void testResolveFragmentEE01() throws BundleException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "test");
        state.setPlatformProperties(props);
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.osgi; bundle-version=\"[1.0, 1.1)\"");
        manifest.put("Require-Capability", "osgi.ee; filter:=\"(osgi.ee=test)\"");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Require-Capability", "osgi.identity; filter:=\"(osgi.identity=b)\"");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(b);
        state.addBundle(a);
        state.addBundle(c);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"C is not resolved", (boolean)c.isResolved());
        BundleWiring aWiring = a.getWiring();
        List aRequirements = a.getRequirements("osgi.ee");
        List aRequiredWires = aWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from system bundle", (int)1, (int)aRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from system bundle", (int)1, (int)aRequiredWires.size());
        BundleWiring bWiring = b.getWiring();
        List bRequirements = b.getRequirements("osgi.ee");
        List bRequiredWires = bWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from fragment", (int)1, (int)bRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from fragment", (int)1, (int)bRequiredWires.size());
        BundleWiring cWiring = c.getWiring();
        List cRequirements = c.getRequirements("osgi.identity");
        List cRequiredWires = cWiring.getRequiredWires("osgi.identity");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.identity requirements from c", (int)1, (int)cRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from c", (int)1, (int)cRequiredWires.size());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Fragment-Host", "org.eclipse.osgi; bundle-version=\"[1.0, 1.1)\"");
        manifest.put("Require-Capability", "osgi.ee; filter:=\"(osgi.ee=fail)\"");
        b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), b.getBundleId());
        state.updateBundle(b);
        state.resolve(false);
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertFalse((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertFalse((String)"C is not resolved", (boolean)c.isResolved());
    }

    public void testResolveFragmentEE02() throws BundleException, IOException {
        State state = this.buildEmptyState();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.executionenvironment", "test");
        state.setPlatformProperties(props);
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "b");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription b = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "c");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Import-Package", "d");
        manifest.put("Fragment-Host", "b");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription c = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(b);
        state.addBundle(a);
        state.addBundle(c);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertFalse((String)"C is resolved", (boolean)c.isResolved());
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "d");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "d");
        manifest.put("Bundle-RequiredExecutionEnvironment", "test");
        BundleDescription d = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(d);
        state.resolve();
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertFalse((String)"C is resolved", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"D is not resolved", (boolean)d.isResolved());
        state.resolve(new BundleDescription[]{b});
        StateResolverTest.assertTrue((String)"A is not resolved", (boolean)a.isResolved());
        StateResolverTest.assertTrue((String)"B is not resolved", (boolean)b.isResolved());
        StateResolverTest.assertTrue((String)"C is not resolved", (boolean)c.isResolved());
        StateResolverTest.assertTrue((String)"D is not resolved", (boolean)d.isResolved());
        BundleWiring aWiring = a.getWiring();
        List aRequirements = a.getRequirements("osgi.ee");
        List aRequiredWires = aWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from system bundle", (int)1, (int)aRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from system bundle", (int)1, (int)aRequiredWires.size());
        BundleWiring bWiring = b.getWiring();
        List bRequirements = b.getRequirements("osgi.ee");
        List bRequiredWires = bWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from fragment", (int)1, (int)bRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from fragment", (int)1, (int)bRequiredWires.size());
        BundleWiring cWiring = c.getWiring();
        List cRequirements = c.getRequirements("osgi.ee");
        List cRequiredWires = cWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from c", (int)1, (int)cRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from c", (int)1, (int)cRequiredWires.size());
        File stateCache = OSGiTestsActivator.getContext().getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
        a = state.getBundle("org.eclipse.osgi", null);
        b = state.getBundle("b", null);
        c = state.getBundle("c", null);
        d = state.getBundle("d", null);
        aWiring = a.getWiring();
        aRequirements = a.getRequirements("osgi.ee");
        aRequiredWires = aWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from system bundle", (int)1, (int)aRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from system bundle", (int)1, (int)aRequiredWires.size());
        bWiring = b.getWiring();
        bRequirements = b.getRequirements("osgi.ee");
        bRequiredWires = bWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from fragment", (int)1, (int)bRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from fragment", (int)1, (int)bRequiredWires.size());
        cWiring = c.getWiring();
        cRequirements = c.getRequirements("osgi.ee");
        cRequiredWires = cWiring.getRequiredWires("osgi.ee");
        StateResolverTest.assertEquals((String)"Wrong number of osgi.ee requirements from c", (int)1, (int)cRequirements.size());
        StateResolverTest.assertEquals((String)"Wrong number of wires from c", (int)1, (int)cRequiredWires.size());
    }

    public void testBug376322() throws BundleException, IOException {
        State state = this.buildEmptyState();
        int bundleID = 0;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "org.eclipse.osgi");
        manifest.put("Bundle-Version", "1.0.0");
        BundleDescription a = state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + manifest.get("Bundle-Version"), (long)bundleID++);
        state.addBundle(a);
        String longExport = ("aQute.libg.header,aQute.libg.version,com.liferay.alloy.util,com.liferay.counter.model.impl;version=\"6.2.0\",com.liferay.counter.model;version=\"6.2.0\",com.liferay.counter.service.base;version=\"6.2.0\",com.liferay.counter.service.impl;version=\"6.2.0\",com.liferay.counter.service.persistence;version=\"6.2.0\",com.liferay.counter.service;version=\"6.2.0\",com.liferay.counter;version=\"6.2.0\",com.liferay.mail.dependencies.fedora.cyrus;version=\"6.2.0\",com.liferay.mail.dependencies.fedora.ksh;version=\"6.2.0\",com.liferay.mail.dependencies.fedora.sendmail;version=\"6.2.0\",com.liferay.mail.dependencies.fedora;version=\"6.2.0\",com.liferay.mail.dependencies;version=\"6.2.0\",com.liferay.mail.messaging;version=\"6.2.0\",com.liferay.mail.model;version=\"6.2.0\",com.liferay.mail.service.impl;version=\"6.2.0\",com.liferay.mail.service.persistence;version=\"6.2.0\",com.liferay.mail.service;version=\"6.2.0\",com.liferay.mail.util;version=\"6.2.0\",com.liferay.mail;version=\"6.2.0\",com.liferay.portal.action;version=\"6.2.0\",com.liferay.portal.apache.bridges.struts;version=\"6.2.0\",com.liferay.portal.apache.bridges;version=\"6.2.0\",com.liferay.portal.apache;version=\"6.2.0\",com.liferay.portal.asset;version=\"6.2.0\",com.liferay.portal.atom;version=\"6.2.0\",com.liferay.portal.audit;version=\"6.2.0\",com.liferay.portal.bean;version=\"6.2.0\",com.liferay.portal.bi.rules;version=\"6.2.0\",com.liferay.portal.bi;version=\"6.2.0\",com.liferay.portal.cache.cluster.clusterlink.messaging;version=\"6.2.0\",com.liferay.portal.cache.cluster.clusterlink;version=\"6.2.0\",com.liferay.portal.cache.cluster;version=\"6.2.0\",com.liferay.portal.cache.ehcache;version=\"6.2.0\",com.liferay.portal.cache.key;version=\"6.2.0\",com.liferay.portal.cache.keypool;version=\"6.2.0\",com.liferay.portal.cache.memcached;version=\"6.2.0\",com.liferay.portal.cache.memory;version=\"6.2.0\",com.liferay.portal.cache.transactional;version=\"6.2.0\",com.liferay.portal.cache;version=\"6.2.0\",com.liferay.portal.captcha.recaptcha;version=\"6.2.0\",com.liferay.portal.captcha.simplecaptcha;version=\"6.2.0\",com.liferay.portal.captcha;version=\"6.2.0\",com.liferay.portal.ccpp;version=\"6.2.0\",com.liferay.portal.cluster;version=\"6.2.0\",com.liferay.portal.configuration.easyconf;version=\"6.2.0\",com.liferay.portal.configuration;version=\"6.2.0\",com.liferay.portal.convert.action;version=\"6.2.0\",com.liferay.portal.convert.messaging;version=\"6.2.0\",com.liferay.portal.convert;version=\"6.2.0\",com.liferay.portal.dao.db;version=\"6.2.0\",com.liferay.portal.dao.jdbc.aop;version=\"6.2.0\",com.liferay.portal.dao.jdbc.pool.c3p0;version=\"6.2.0\",com.liferay.portal.dao.jdbc.pool;version=\"6.2.0\",com.liferay.portal.dao.jdbc.spring;version=\"6.2.0\",com.liferay.portal.dao.jdbc.util;version=\"6.2.0\",com.liferay.portal.dao.jdbc;version=\"6.2.0\",com.liferay.portal.dao.orm.common;version=\"6.2.0\",com.liferay.portal.dao.orm.hibernate.jmx;version=\"6.2.0\",com.liferay.portal.dao.orm.hibernate.region;version=\"6.2.0\",com.liferay.portal.dao.orm.hibernate;version=\"6.2.0\",com.liferay.portal.dao.orm.jpa;version=\"6.2.0\",com.liferay.portal.dao.orm;version=\"6.2.0\",com.liferay.portal.dao.shard.advice;version=\"6.2.0\",com.liferay.portal.dao.shard;version=\"6.2.0\",com.liferay.portal.dao;version=\"6.2.0\",com.liferay.portal.definitions;version=\"6.2.0\",com.liferay.portal.dependencies;version=\"6.2.0\",com.liferay.portal.deploy.auto.exploded.tomcat;version=\"6.2.0\",com.liferay.portal.deploy.auto.exploded;version=\"6.2.0\",com.liferay.portal.deploy.auto;version=\"6.2.0\",com.liferay.portal.deploy.dependencies;version=\"6.2.0\",com.liferay.portal.deploy.hot.messaging;version=\"6.2.0\",com.liferay.portal.deploy.hot;version=\"6.2.0\",com.liferay.portal.deploy.sandbox;version=\"6.2.0\",com.liferay.portal.deploy;version=\"6.2.0\",com.liferay.portal.editor.fckeditor.command.impl;version=\"6.2.0\",com.liferay.portal.editor.fckeditor.command;version=\"6.2.0\",com.liferay.portal.editor.fckeditor.exception;version=\"6.2.0\",com.liferay.portal.editor.fckeditor.receiver.impl;version=\"6.2.0\",com.liferay.portal.editor.fckeditor.receiver;version=\"6.2.0\",com.liferay.portal.editor.fckeditor;version=\"6.2.0\",com.liferay.portal.editor;version=\"6.2.0\",com.liferay.portal.events.dependencies;version=\"6.2.0\",com.liferay.portal.events;version=\"6.2.0\",com.liferay.portal.executor;version=\"6.2.0\",com.liferay.portal.facebook;version=\"6.2.0\",com.liferay.portal.format;version=\"6.2.0\",com.liferay.portal.freemarker;version=\"6.2.0\",com.liferay.portal.googleapps;version=\"6.2.0\",com.liferay.portal.im;version=\"6.2.0\",com.liferay.portal.image;version=\"6.2.0\",com.liferay.portal.increment;version=\"6.2.0\",com.liferay.portal.javadoc;version=\"6.2.0\",com.liferay.portal.jcr.jackrabbit.dependencies;version=\"6.2.0\",com.liferay.portal.jcr.jackrabbit;version=\"6.2.0\",com.liferay.portal.jcr;version=\"6.2.0\",com.liferay.portal.jericho;version=\"6.2.0\",com.liferay.portal.json.jabsorb.serializer;version=\"6.2.0\",com.liferay.portal.json.jabsorb;version=\"6.2.0\",com.liferay.portal.json.transformer;version=\"6.2.0\",com.liferay.portal.json;version=\"6.2.0\",com.liferay.portal.jsonwebservice.action;version=\"6.2.0\",com.liferay.portal.jsonwebservice;version=\"6.2.0\",com.liferay.portal.kernel.annotation;version=\"6.2.0\",com.liferay.portal.kernel.atom;version=\"6.2.0\",com.liferay.portal.kernel.audit;version=\"6.2.0\",com.liferay.portal.kernel.bean;version=\"6.2.0\",com.liferay.portal.kernel.bi.reporting.messaging;version=\"6.2.0\",com.liferay.portal.kernel.bi.reporting.servlet;version=\"6.2.0\",com.liferay.portal.kernel.bi.reporting;version=\"6.2.0\",com.liferay.portal.kernel.bi.rules;version=\"6.2.0\",com.liferay.portal.kernel.bi;version=\"6.2.0\",com.liferay.portal.kernel.cache.cluster;version=\"6.2.0\",com.liferay.portal.kernel.cache.key;version=\"6.2.0\",com.liferay.portal.kernel.cache;version=\"6.2.0\",com.liferay.portal.kernel.cal;version=\"6.2.0\",com.liferay.portal.kernel.captcha;version=\"6.2.0\",com.liferay.portal.kernel.cluster.messaging;version=\"6.2.0\",com.liferay.portal.kernel.cluster;version=\"6.2.0\",com.liferay.portal.kernel.concurrent;version=\"6.2.0\",com.liferay.portal.kernel.configuration;version=\"6.2.0\",com.liferay.portal.kernel.dao.db;version=\"6.2.0\",com.liferay.portal.kernel.dao.jdbc;version=\"6.2.0\",com.liferay.portal.kernel.dao.orm;version=\"6.2.0\",com.liferay.portal.kernel.dao.search;version=\"6.2.0\",com.liferay.portal.kernel.dao.shard;version=\"6.2.0\",com.liferay.portal.kernel.dao;version=\"6.2.0\",com.liferay.portal.kernel.deploy.auto;version=\"6.2.0\",com.liferay.portal.kernel.deploy.hot;version=\"6.2.0\",com.liferay.portal.kernel.deploy.sandbox;version=\"6.2.0\",com.liferay.portal.kernel.deploy;version=\"6.2.0\",com.liferay.portal.kernel.editor;version=\"6.2.0\",com.liferay.portal.kernel.events;version=\"6.2.0\",com.liferay.portal.kernel.exception,com.liferay.portal.kernel.exception;version=\"6.2.0\",com.liferay.portal.kernel.executor;version=\"6.2.0\",com.liferay.portal.kernel.facebook;version=\"6.2.0\",com.liferay.portal.kernel.format;version=\"6.2.0\",com.liferay.portal.kernel.freemarker;version=\"6.2.0\",com.liferay.portal.kernel.googleapps.comparator;version=\"6.2.0\",com.liferay.portal.kernel.googleapps;version=\"6.2.0\",com.liferay.portal.kernel.image;version=\"6.2.0\",com.liferay.portal.kernel.increment;version=\"6.2.0\",com.liferay.portal.kernel.io.delta;version=\"6.2.0\",com.liferay.portal.kernel.io.unsync;version=\"6.2.0\",com.liferay.portal.kernel.io;version=\"6.2.0\",com.liferay.portal.kernel.javadoc;version=\"6.2.0\",com.liferay.portal.kernel.jmx.model;version=\"6.2.0\",com.liferay.portal.kernel.jmx;version=\"6.2.0\",com.liferay.portal.kernel.jndi;version=\"6.2.0\",com.liferay.portal.kernel.json;version=\"6.2.0\",com.liferay.portal.kernel.jsonwebservice;version=\"6.2.0\",com.liferay.portal.kernel.language;version=\"6.2.0\",com.liferay.portal.kernel.lar;version=\"6.2.0\",com.liferay.portal.kernel.ldap;version=\"6.2.0\",com.liferay.portal.kernel.log;version=\"6.2.0\",com.liferay.portal.kernel.mail;version=\"6.2.0\",com.liferay.portal.kernel.management.jmx;version=\"6.2.0\",com.liferay.portal.kernel.management;version=\"6.2.0\",com.liferay.portal.kernel.memory;version=\"6.2.0\",com.liferay.portal.kernel.messaging.async;version=\"6.2.0\",com.liferay.portal.kernel.messaging.config;version=\"6.2.0\",com.liferay.portal.kernel.messaging.jmx;version=\"6.2.0\",com.liferay.portal.kernel.messaging.proxy;version=\"6.2.0\",com.liferay.portal.kernel.messaging.sender;version=\"6.2.0\",com.liferay.portal.kernel.messaging;version=\"6.2.0\",com.liferay.portal.kernel.metadata;version=\"6.2.0\",com.liferay.portal.kernel.mobile.device.rulegroup.action;version=\"6.2.0\",com.liferay.portal.kernel.mobile.device.rulegroup.rule;version=\"6.2.0\",com.liferay.portal.kernel.mobile.device.rulegroup;version=\"6.2.0\",com.liferay.portal.kernel.mobile.device;version=\"6.2.0\",com.liferay.portal.kernel.mobile;version=\"6.2.0\",com.liferay.portal.kernel.monitoring.statistics;version=\"6.2.0\",com.liferay.portal.kernel.monitoring;version=\"6.2.0\",com.liferay.portal.kernel.nio.charset;version=\"6.2.0\",com.liferay.portal.kernel.nio;version=\"6.2.0\",com.liferay.portal.kernel.notifications;version=\"6.2.0\",com.liferay.portal.kernel.oauth;version=\"6.2.0\",com.liferay.portal.kernel.parsers.bbcode;version=\"6.2.0\",com.liferay.portal.kernel.parsers;version=\"6.2.0\",com.liferay.portal.kernel.plugin;version=\"6.2.0\",com.liferay.portal.kernel.poller.comet;version=\"6.2.0\",com.liferay.portal.kernel.poller;version=\"6.2.0\",com.liferay.portal.kernel.pop;version=\"6.2.0\",com.liferay.portal.kernel.portlet;version=\"6.2.0\",com.liferay.portal.kernel.process.log;version=\"6.2.0\",com.liferay.portal.kernel.process;version=\"6.2.0\",com.liferay.portal.kernel.repository.cmis.search;version=\"6.2.0\",com.liferay.portal.kernel.repository.cmis;version=\"6.2.0\",com.liferay.portal.kernel.repository.model;version=\"6.2.0\",com.liferay.portal.kernel.repository.search;version=\"6.2.0\",com.liferay.portal.kernel.repository;version=\"6.2.0\",com.liferay.portal.kernel.resource;version=\"6.2.0\",com.liferay.portal.kernel.sanitizer;version=\"6.2.0\",com.liferay.portal.kernel.scheduler.config;version=\"6.2.0\",com.liferay.portal.kernel.scheduler.messaging;version=\"6.2.0\",com.liferay.portal.kernel.scheduler;version=\"6.2.0\",com.liferay.portal.kernel.scripting;version=\"6.2.0\",com.liferay.portal.kernel.search.facet.collector;version=\"6.2.0\",com.liferay.portal.kernel.search.facet.config;version=\"6.2.0\",com.liferay.portal.kernel.search.facet.util;version=\"6.2.0\",com.liferay.portal.kernel.search.facet;version=\"6.2.0\",com.liferay.portal.kernel.search.messaging;version=\"6.2.0\",com.liferay.portal.kernel.search;version=\"6.2.0\",com.liferay.portal.kernel.security.jaas;version=\"6.2.0\",com.liferay.portal.kernel.security;version=\"6.2.0\",com.liferay.portal.kernel.servlet.filters.compoundsessionid;version=\"6.2.0\",com.liferay.portal.kernel.servlet.filters.invoker;version=\"6.2.0\",com.liferay.portal.kernel.servlet.filters;version=\"6.2.0\",com.liferay.portal.kernel.servlet.taglib.aui;version=\"6.2.0\",com.liferay.portal.kernel.servlet.taglib.ui;version=\"6.2.0\",com.liferay.portal.kernel.servlet.taglib;version=\"6.2.0\",com.liferay.portal.kernel.servlet;version=\"6.2.0\",com.liferay.portal.kernel.spring.aop;version=\"6.2.0\",com.liferay.portal.kernel.spring.context;version=\"6.2.0\",com.liferay.portal.kernel.spring;version=\"6.2.0\",com.liferay.portal.kernel.staging.permission;version=\"6.2.0\",com.liferay.portal.kernel.staging;version=\"6.2.0\",com.liferay.portal.kernel.struts;version=\"6.2.0\",com.liferay.portal.kernel.templateparser;version=\"6.2.0\",com.liferay.portal.kernel.test;version=\"6.2.0\",com.liferay.portal.kernel.transaction;version=\"6.2.0\",com.liferay.portal.kernel.upgrade.util;version=\"6.2.0\",com.liferay.portal.kernel.upgrade;version=\"6.2.0\",com.liferay.portal.kernel.upload;version=\"6.2.0\",com.liferay.portal.kernel.util;version=\"6.2.0\",com.liferay.portal.kernel.uuid;version=\"6.2.0\",com.liferay.portal.kernel.velocity;version=\"6.2.0\",com.liferay.portal.kernel.webcache;version=\"6.2.0\",com.liferay.portal.kernel.webdav;version=\"6.2.0\",com.liferay.portal.kernel.workflow.comparator;version=\"6.2.0\",com.liferay.portal.kernel.workflow.messaging;version=\"6.2.0\",com.liferay.portal.kernel.workflow.permission;version=\"6.2.0\",com.liferay.portal.kernel.workflow;version=\"6.2.0\",com.liferay.portal.kernel.xml.simple;version=\"6.2.0\",com.liferay.portal.kernel.xml;version=\"6.2.0\",com.liferay.portal.kernel.xmlrpc;version=\"6.2.0\",com.liferay.portal.kernel.zip;version=\"6.2.0\",com.liferay.portal.kernel;version=\"6.2.0\",com.liferay.portal.language;version=\"6.2.0\",com.liferay.portal.lar;version=\"6.2.0\",com.liferay.portal.license.util;version=\"6.2.0\",com.liferay.portal.license;version=\"6.2.0\",com.liferay.portal.liveusers.messaging;version=\"6.2.0\",com.liferay.portal.liveusers;version=\"6.2.0\",com.liferay.portal.log;version=\"6.2.0\",com.liferay.portal.management;version=\"6.2.0\",com.liferay.portal.messaging.async;version=\"6.2.0\",com.liferay.portal.messaging.proxy;version=\"6.2.0\",com.liferay.portal.messaging;version=\"6.2.0\",com.liferay.portal.metadata;version=\"6.2.0\",com.liferay.portal.mobile.device.messaging;version=\"6.2.0\",com.liferay.portal.mobile.device.rulegroup.action.impl;version=\"6.2.0\",com.liferay.portal.mobile.device.rulegroup.action;version=\"6.2.0\",com.liferay.portal.mobile.device.rulegroup.rule.impl;version=\"6.2.0\",com.liferay.portal.mobile.device.rulegroup.rule;version=\"6.2.0\",com.liferay.portal.mobile.device.rulegroup;version=\"6.2.0\",com.liferay.portal.mobile.device;version=\"6.2.0\",com.liferay.portal.mobile;version=\"6.2.0\",com.liferay.portal.model.impl;version=\"6.2.0\",com.liferay.portal.model;version=\"6.2.0\",com.liferay.portal.monitoring.jmx;version=\"6.2.0\",com.liferay.portal.monitoring.messaging;version=\"6.2.0\",com.liferay.portal.monitoring.statistics.portal;version=\"6.2.0\",com.liferay.portal.monitoring.statistics.portlet;version=\"6.2.0\",com.liferay.portal.monitoring.statistics.service;version=\"6.2.0\",com.liferay.portal.monitoring.statistics;version=\"6.2.0\",com.liferay.portal.monitoring;version=\"6.2.0\",com.liferay.portal.notifications;version=\"6.2.0\",com.liferay.portal.oauth;version=\"6.2.0\",com.liferay.portal.osgi.service;version=\"6.2.0\",com.liferay.portal.osgi;version=\"6.2.0\",com.liferay.portal.parsers.bbcode;version=\"6.2.0\",com.liferay.portal.parsers.creole.ast.extension;version=\"6.2.0\",com.liferay.portal.parsers.creole.ast.link;version=\"6.2.0\",com.liferay.portal.parsers.creole.ast.table;version=\"6.2.0\",com.liferay.portal.parsers.creole.ast;version=\"6.2.0\",com.liferay.portal.parsers.creole.grammar;version=\"6.2.0\",com.liferay.portal.parsers.creole.parser;version=\"6.2.0\",com.liferay.portal.parsers.creole.visitor.impl;version=\"6.2.0\",com.liferay.portal.parsers.creole.visitor;version=\"6.2.0\",com.liferay.portal.parsers.creole;version=\"6.2.0\",com.liferay.portal.parsers;version=\"6.2.0\",com.liferay.portal.plugin;version=\"6.2.0\",com.liferay.portal.poller.comet;version=\"6.2.0\",com.liferay.portal.poller.messaging;version=\"6.2.0\",com.liferay.portal.poller;version=\"6.2.0\",com.liferay.portal.pop.messaging;version=\"6.2.0\",com.liferay.portal.pop;version=\"6.2.0\",com.liferay.portal.repository.cmis.model;version=\"6.2.0\",com.liferay.portal.repository.cmis;version=\"6.2.0\",com.liferay.portal.repository.liferayrepository.model;version=\"6.2.0\",com.liferay.portal.repository.liferayrepository.util;version=\"6.2.0\",com.liferay.portal.repository.liferayrepository;version=\"6.2.0\",com.liferay.portal.repository.proxy;version=\"6.2.0\",com.liferay.portal.repository.search;version=\"6.2.0\",com.liferay.portal.repository.util;version=\"6.2.0\",com.liferay.portal.repository;version=\"6.2.0\",com.liferay.portal.sanitizer;version=\"6.2.0\",com.liferay.portal.scheduler.job;version=\"6.2.0\",com.liferay.portal.scheduler.messaging;version=\"6.2.0\",com.liferay.portal.scheduler.quartz;version=\"6.2.0\",com.liferay.portal.scheduler;version=\"6.2.0\",com.liferay.portal.scripting.beanshell;version=\"6.2.0\",com.liferay.portal.scripting.groovy;version=\"6.2.0\",com.liferay.portal.scripting.javascript;version=\"6.2.0\",com.liferay.portal.scripting.python;version=\"6.2.0\",com.liferay.portal.scripting.ruby;version=\"6.2.0\",com.liferay.portal.scripting;version=\"6.2.0\",com.liferay.portal.search.generic;version=\"6.2.0\",com.liferay.portal.search.lucene.cluster;version=\"6.2.0\",com.liferay.portal.search.lucene.dump;version=\"6.2.0\",com.liferay.portal.search.lucene.highlight;version=\"6.2.0\",com.liferay.portal.search.lucene.messaging;version=\"6.2.0\",com.liferay.portal.search.lucene;version=\"6.2.0\",com.liferay.portal.search;version=\"6.2.0\",com.liferay.portal.security.auth;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.jboss;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.jetty;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.jonas;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.resin;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.tomcat;version=\"6.2.0\",com.liferay.portal.security.jaas.ext.weblogic;version=\"6.2.0\",com.liferay.portal.security.jaas.ext;version=\"6.2.0\",com.liferay.portal.security.jaas;version=\"6.2.0\",com.liferay.portal.security.lang;version=\"6.2.0\",com.liferay.portal.security.ldap;version=\"6.2.0\",com.liferay.portal.security.ntlm.msrpc;version=\"6.2.0\",com.liferay.portal.security.ntlm;version=\"6.2.0\",com.liferay.portal.security.permission.comparator;version=\"6.2.0\",com.liferay.portal.security.permission;version=\"6.2.0\",com.liferay.portal.security.pwd;version=\"6.2.0\",com.liferay.portal.security;version=\"6.2.0\",com.liferay.portal.service,com.liferay.portal.service.base;version=\"6.2.0\",com.liferay.portal.service.http;version=\"6.2.0\",com.liferay.portal.service.impl;version=\"6.2.0\",com.liferay.portal.service.permission;version=\"6.2.0\",com.liferay.portal.service.persistence.impl;version=\"6.2.0\",com.liferay.portal.service.persistence;version=\"6.2.0\",com.liferay.portal.service;version=\"6.2.0\",com.liferay.portal.servlet.filters.absoluteredirects;version=\"6.2.0\",com.liferay.portal.servlet.filters.audit;version=\"6.2.0\",com.liferay.portal.servlet.filters.autologin;version=\"6.2.0\",com.liferay.portal.servlet.filters.cache;version=\"6.2.0\",com.liferay.portal.servlet.filters.charbufferpool;version=\"6.2.0\",com.liferay.portal.servlet.filters.compoundsessionid;version=\"6.2.0\",com.liferay.portal.servlet.filters.doubleclick;version=\"6.2.0\",com.liferay.portal.servlet.filters.dynamiccss;version=\"6.2.0\",com.liferay.portal.servlet.filters.etag;version=\"6.2.0\",com.liferay.portal.servlet.filters.fragment;version=\"6.2.0\",com.liferay.portal.servlet.filters.gzip;version=\"6.2.0\",com.liferay.portal.servlet.filters.header;version=\"6.2.0\",com.liferay.portal.servlet.filters.i18n;version=\"6.2.0\",com.liferay.portal.servlet.filters.ignore;version=\"6.2.0\",com.liferay.portal.servlet.filters.language;version=\"6.2.0\",com.liferay.portal.servlet.filters.minifier;version=\"6.2.0\",com.liferay.portal.servlet.filters.monitoring.jmx;version=\"6.2.0\",com.liferay.portal.servlet.filters.monitoring;version=\"6.2.0\",com.liferay.portal.servlet.filters.secure;version=\"6.2.0\",com.liferay.portal.servlet.filters.servletauthorizing;version=\"6.2.0\",com.liferay.portal.servlet.filters.servletcontextinclude;version=\"6.2.0\",com.liferay.portal.servlet.filters.sessionid;version=\"6.2.0\",com.liferay.portal.servlet.filters.sessionmaxallowed;version=\"6.2.0\",com.liferay.portal.servlet.filters.sso.cas;version=\"6.2.0\",com.liferay.portal.servlet.filters.sso.ntlm;version=\"6.2.0\",com.liferay.portal.servlet.filters.sso.opensso;version=\"6.2.0\",com.liferay.portal.servlet.filters.sso;version=\"6.2.0\",com.liferay.portal.servlet.filters.strip;version=\"6.2.0\",com.liferay.portal.servlet.filters.themepreview;version=\"6.2.0\",com.liferay.portal.servlet.filters.threaddump;version=\"6.2.0\",com.liferay.portal.servlet.filters.threadlocal;version=\"6.2.0\",com.liferay.portal.servlet.filters.unsyncprintwriterpool;version=\"6.2.0\",com.liferay.portal.servlet.filters.validhostname;version=\"6.2.0\",com.liferay.portal.servlet.filters.validhtml;version=\"6.2.0\",com.liferay.portal.servlet.filters.virtualhost;version=\"6.2.0\",com.liferay.portal.servlet.filters;version=\"6.2.0\",com.liferay.portal.servlet.taglib.ui;version=\"6.2.0\",com.liferay.portal.servlet.taglib;version=\"6.2.0\",com.liferay.portal.servlet;version=\"6.2.0\",com.liferay.portal.setup;version=\"6.2.0\",com.liferay.portal.sharepoint.dws;version=\"6.2.0\",com.liferay.portal.sharepoint.methods;version=\"6.2.0\",com.liferay.portal.sharepoint;version=\"6.2.0\",com.liferay.portal.spring.annotation;version=\"6.2.0\",com.liferay.portal.spring.aop;version=\"6.2.0\",com.liferay.portal.spring.bean;version=\"6.2.0\",com.liferay.portal.spring.context;version=\"6.2.0\",com.liferay.portal.spring.hibernate;version=\"6.2.0\",com.liferay.portal.spring.jndi;version=\"6.2.0\",com.liferay.portal.spring.jpa;version=\"6.2.0\",com.liferay.portal.spring.remoting;version=\"6.2.0\",com.liferay.portal.spring.servlet;version=\"6.2.0\",com.liferay.portal.spring.transaction;version=\"6.2.0\",com.liferay.portal.spring.util;version=\"6.2.0\",com.liferay.portal.spring;version=\"6.2.0\",com.liferay.portal.staging.permission;version=\"6.2.0\",com.liferay.portal.staging;version=\"6.2.0\",com.liferay.portal.struts;version=\"6.2.0\",com.liferay.portal.theme;version=\"6.2.0\",com.liferay.portal.tools.comparator;version=\"6.2.0\",com.liferay.portal.tools.dependencies;version=\"6.2.0\",com.liferay.portal.tools.deploy;version=\"6.2.0\",com.liferay.portal.tools.jspc.common;version=\"6.2.0\",com.liferay.portal.tools.jspc.resin;version=\"6.2.0\",com.liferay.portal.tools.jspc;version=\"6.2.0\",com.liferay.portal.tools.samplesqlbuilder.dependencies;version=\"6.2.0\",com.liferay.portal.tools.samplesqlbuilder;version=\"6.2.0\",com.liferay.portal.tools.servicebuilder.dependencies;version=\"6.2.0\",com.liferay.portal.tools.servicebuilder;version=\"6.2.0\",com.liferay.portal.tools.sql.dependencies;version=\"6.2.0\",com.liferay.portal.tools.sql;version=\"6.2.0\",com.liferay.portal.tools;version=\"6.2.0\",com.liferay.portal.upgrade.util;version=\"6.2.0\",com.liferay.portal.upgrade.v5_2_5_to_6_0_0.util;version=\"6.2.0\",com.liferay.portal.upgrade.v5_2_5_to_6_0_0;version=\"6.2.0\",com.liferay.portal.upgrade.v5_2_7_to_6_0_0;version=\"6.2.0\",com.liferay.portal.upgrade.v5_2_8_to_6_0_5.util;version=\"6.2.0\",com.liferay.portal.upgrade.v5_2_8_to_6_0_5;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_0.util;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_0;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_1.util;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_12_to_6_1_0;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_1;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_2;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_3;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_5.util;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_5;version=\"6.2.0\",com.liferay.portal.upgrade.v6_0_6;version=\"6.2.0\",com.liferay.portal.upgrade.v6_1_0.util;version=\"6.2.0\",com.liferay.portal.upgrade.v6_1_0;version=\"6.2.0\",com.liferay.portal.upgrade.v6_1_1;version=\"6.2.0\",com.liferay.portal.upgrade.v6_2_0;version=\"6.2.0\",com.liferay.portal.upgrade;version=\"6.2.0\",com.liferay.portal.upload;version=\"6.2.0\",com.liferay.portal.util.comparator;version=\"6.2.0\",com.liferay.portal.util.dependencies;version=\"6.2.0\",com.liferay.portal.util;version=\"6.2.0\",com.liferay.portal.uuid;version=\"6.2.0\",com.liferay.portal.velocity;version=\"6.2.0\",com.liferay.portal.verify;version=\"6.2.0\",com.liferay.portal.webcache;version=\"6.2.0\",com.liferay.portal.webdav.methods;version=\"6.2.0\",com.liferay.portal.webdav;version=\"6.2.0\",com.liferay.portal.webserver.dependencies;version=\"6.2.0\",com.liferay.portal.webserver;version=\"6.2.0\",com.liferay.portal.words.dependencies;version=\"6.2.0\",com.liferay.portal.words;version=\"6.2.0\",com.liferay.portal.workflow.permission;version=\"6.2.0\",com.liferay.portal.workflow;version=\"6.2.0\",com.liferay.portal.xml.xpath;version=\"6.2.0\",com.liferay.portal.xml;version=\"6.2.0\",com.liferay.portal.xmlrpc;version=\"6.2.0\",com.liferay.portal.zip;version=\"6.2.0\",com.liferay.portal;version=\"6.2.0\",com.liferay.portlet.activities.action;version=\"6.2.0\",com.liferay.portlet.activities;version=\"6.2.0\",com.liferay.portlet.addressbook;version=\"6.2.0\",com.liferay.portlet.admin.action;version=\"6.2.0\",com.liferay.portlet.admin.dependencies;version=\"6.2.0\",com.liferay.portlet.admin.messaging;version=\"6.2.0\",com.liferay.portlet.admin.util;version=\"6.2.0\",com.liferay.portlet.admin;version=\"6.2.0\",com.liferay.portlet.amazonrankings.action;version=\"6.2.0\",com.liferay.portlet.amazonrankings.model;version=\"6.2.0\",com.liferay.portlet.amazonrankings.util;version=\"6.2.0\",com.liferay.portlet.amazonrankings;version=\"6.2.0\",com.liferay.portlet.announcements.action;version=\"6.2.0\",com.liferay.portlet.announcements.dependencies;version=\"6.2.0\",com.liferay.portlet.announcements.messaging;version=\"6.2.0\",com.liferay.portlet.announcements.model.impl;version=\"6.2.0\",com.liferay.portlet.announcements.model;version=\"6.2.0\",com.liferay.portlet.announcements.service.base;version=\"6.2.0\",com.liferay.portlet.announcements.service.http;version=\"6.2.0\",com.liferay.portlet.announcements.service.impl;version=\"6.2.0\",com.liferay.portlet.announcements.service.permission;version=\"6.2.0\",com.liferay.portlet.announcements.service.persistence;version=\"6.2.0\",com.liferay.portlet.announcements.service;version=\"6.2.0\",com.liferay.portlet.announcements.util;version=\"6.2.0\",com.liferay.portlet.announcements;version=\"6.2.0\",com.liferay.portlet.asset.action;version=\"6.2.0\",com.liferay.portlet.asset.model.impl;version=\"6.2.0\",com.liferay.portlet.asset.model;version=\"6.2.0\",com.liferay.portlet.asset.service.base;version=\"6.2.0\",com.liferay.portlet.asset.service.http;version=\"6.2.0\",com.liferay.portlet.asset.service.impl;version=\"6.2.0\",com.liferay.portlet.asset.service.permission;version=\"6.2.0\",com.liferay.portlet.asset.service.persistence;version=\"6.2.0\",com.liferay.portlet.asset.service;version=\"6.2.0\",com.liferay.portlet.asset.util.comparator;version=\"6.2.0\",com.liferay.portlet.asset.util;version=\"6.2.0\",com.liferay.portlet.asset;version=\"6.2.0\",com.liferay.portlet.assetcategoryadmin.action;version=\"6.2.0\",com.liferay.portlet.assetcategoryadmin;version=\"6.2.0\",com.liferay.portlet.assetpublisher.action;version=\"6.2.0\",com.liferay.portlet.assetpublisher.search;version=\"6.2.0\",com.liferay.portlet.assetpublisher.util;version=\"6.2.0\",com.liferay.portlet.assetpublisher;version=\"6.2.0\",com.liferay.portlet.assettagadmin.action;version=\"6.2.0\",com.liferay.portlet.assettagadmin;version=\"6.2.0\",com.liferay.portlet.blogs.action;version=\"6.2.0\",com.liferay.portlet.blogs.asset;version=\"6.2.0\",com.liferay.portlet.blogs.atom;version=\"6.2.0\",com.liferay.portlet.blogs.dependencies;version=\"6.2.0\",com.liferay.portlet.blogs.lar;version=\"6.2.0\",com.liferay.portlet.blogs.messaging;version=\"6.2.0\",com.liferay.portlet.blogs.model.impl;version=\"6.2.0\",com.liferay.portlet.blogs.model;version=\"6.2.0\",com.liferay.portlet.blogs.service.base;version=\"6.2.0\",com.liferay.portlet.blogs.service.http;version=\"6.2.0\",com.liferay.portlet.blogs.service.impl;version=\"6.2.0\",com.liferay.portlet.blogs.service.permission;version=\"6.2.0\",com.liferay.portlet.blogs.service.persistence;version=\"6.2.0\",com.liferay.portlet.blogs.service;version=\"6.2.0\",com.liferay.portlet.blogs.social;version=\"6.2.0\",com.liferay.portlet.blogs.util.comparator;version=\"6.2.0\",com.liferay.portlet.blogs.util;version=\"6.2.0\",com.liferay.portlet.blogs.workflow;version=\"6.2.0\",com.liferay.portlet.blogs;version=\"6.2.0\",com.liferay.portlet.blogsadmin.search;version=\"6.2.0\",com.liferay.portlet.blogsadmin;version=\"6.2.0\",com.liferay.portlet.bookmarks.action;version=\"6.2.0\",com.liferay.portlet.bookmarks.asset;version=\"6.2.0\",com.liferay.portlet.bookmarks.lar;version=\"6.2.0\",com.liferay.portlet.bookmarks.model.impl;version=\"6.2.0\",com.liferay.portlet.bookmarks.model;version=\"6.2.0\",com.liferay.portlet.bookmarks.service.base;version=\"6.2.0\",com.liferay.portlet.bookmarks.service.http;version=\"6.2.0\",com.liferay.portlet.bookmarks.service.impl;version=\"6.2.0\",com.liferay.portlet.bookmarks.service.permission;version=\"6.2.0\",com.liferay.portlet.bookmarks.service.persistence;version=\"6.2.0\",com.liferay.portlet.bookmarks.service;version=\"6.2.0\",com.liferay.portlet.bookmarks.social;version=\"6.2.0\",com.liferay.portlet.bookmarks.util.comparator;version=\"6.2.0\",com.liferay.portlet.bookmarks.util;version=\"6.2.0\",com.liferay.portlet.bookmarks;version=\"6.2.0\",com.liferay.portlet.calendar.action;version=\"6.2.0\",com.liferay.portlet.calendar.asset;version=\"6.2.0\",com.liferay.portlet.calendar.dependencies;version=\"6.2.0\",com.liferay.portlet.calendar.lar;version=\"6.2.0\",com.liferay.portlet.calendar.messaging;version=\"6.2.0\",com.liferay.portlet.calendar.model.impl;version=\"6.2.0\",com.liferay.portlet.calendar.model;version=\"6.2.0\",com.liferay.portlet.calendar.service.base;version=\"6.2.0\",com.liferay.portlet.calendar.service.http;version=\"6.2.0\",com.liferay.portlet.calendar.service.impl;version=\"6.2.0\",com.liferay.portlet.calendar.service.permission;version=\"6.2.0\",com.liferay.portlet.calendar.service.persistence;version=\"6.2.0\",com.liferay.portlet.calendar.service;version=\"6.2.0\",com.liferay.portlet.calendar.social;version=\"6.2.0\",com.liferay.portlet.calendar.util.comparator;version=\"6.2.0\",com.liferay.portlet.calendar.util;version=\"6.2.0\",com.liferay.portlet.calendar;version=\"6.2.0\",com.liferay.portlet.communities.messaging;version=\"6.2.0\",com.liferay.portlet.communities;version=\"6.2.0\",com.liferay.portlet.currencyconverter.action;version=\"6.2.0\",com.liferay.portlet.currencyconverter.model;version=\"6.2.0\",com.liferay.portlet.currencyconverter.util;version=\"6.2.0\",com.liferay.portlet.currencyconverter;version=\"6.2.0\",com.liferay.portlet.directory.asset;version=\"6.2.0\",com.liferay.portlet.directory.util;version=\"6.2.0\",com.liferay.portlet.directory.workflow;version=\"6.2.0\",com.liferay.portlet.directory;version=\"6.2.0\",com.liferay.portlet.documentlibrary.action;version=\"6.2.0\",com.liferay.portlet.documentlibrary.antivirus;version=\"6.2.0\",com.liferay.portlet.documentlibrary.asset;version=\"6.2.0\",com.liferay.portlet.documentlibrary.atom;version=\"6.2.0\",com.liferay.portlet.documentlibrary.lar;version=\"6.2.0\",com.liferay.portlet.documentlibrary.messaging;version=\"6.2.0\",com.liferay.portlet.documentlibrary.model.impl;version=\"6.2.0\",com.liferay.portlet.documentlibrary.model;version=\"6.2.0\",com.liferay.portlet.documentlibrary.search;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service.base;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service.http;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service.impl;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service.permission;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service.persistence;version=\"6.2.0\",com.liferay.portlet.documentlibrary.service;version=\"6.2.0\",com.liferay.portlet.documentlibrary.sharepoint;version=\"6.2.0\",com.liferay.portlet.documentlibrary.social;version=\"6.2.0\",com.liferay.portlet.documentlibrary.store;version=\"6.2.0\",com.liferay.portlet.documentlibrary.util.comparator;version=\"6.2.0\",com.liferay.portlet.documentlibrary.util;version=\"6.2.0\",com.liferay.portlet.documentlibrary.webdav;version=\"6.2.0\",com.liferay.portlet.documentlibrary.workflow;version=\"6.2.0\",com.liferay.portlet.documentlibrary;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.action;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.asset;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.dependencies;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.model.impl;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.model;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.search;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service.base;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service.http;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service.impl;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service.permission;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service.persistence;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.service;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.util.comparator;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.util;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists.workflow;version=\"6.2.0\",com.liferay.portlet.dynamicdatalists;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.action;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.dependencies.alloy;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.dependencies.ddm;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.dependencies.readonly;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.dependencies;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.lar;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.model.impl;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.model;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.search;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service.base;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service.http;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service.impl;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service.permission;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service.persistence;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.service;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.storage.query;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.storage;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.util.comparator;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping.util;version=\"6.2.0\",com.liferay.portlet.dynamicdatamapping;version=\"6.2.0\",com.liferay.portlet.expando.action;version=\"6.2.0\",com.liferay.portlet.expando.model.impl;version=\"6.2.0\",com.liferay.portlet.expando.model;version=\"6.2.0\",com.liferay.portlet.expando.service.base;version=\"6.2.0\",com.liferay.portlet.expando.service.http;version=\"6.2.0\",com.liferay.portlet.expando.service.impl;version=\"6.2.0\",com.liferay.portlet.expando.service.permission;version=\"6.2.0\",com.liferay.portlet.expando.service.persistence;version=\"6.2.0\",com.liferay.portlet.expando.service;version=\"6.2.0\",com.liferay.portlet.expando.util.comparator;version=\"6.2.0\",com.liferay.portlet.expando.util;version=\"6.2.0\",com.liferay.portlet.expando;version=\"6.2.0\",com.liferay.portlet.flags.action;version=\"6.2.0\",com.liferay.portlet.flags.dependencies;version=\"6.2.0\",com.liferay.portlet.flags.messaging;version=\"6.2.0\",com.liferay.portlet.flags.service.base;version=\"6.2.0\",com.liferay.portlet.flags.service.http;version=\"6.2.0\",com.liferay.portlet.flags.service.impl;version=\"6.2.0\",com.liferay.portlet.flags.service;version=\"6.2.0\",com.liferay.portlet.flags;version=\"6.2.0\",com.liferay.portlet.grouppages.action;version=\"6.2.0\",com.liferay.portlet.grouppages;version=\"6.2.0\",com.liferay.portlet.helloworld;version=\"6.2.0\",com.liferay.portlet.iframe.action;version=\"6.2.0\",com.liferay.portlet.iframe.util;version=\"6.2.0\",com.liferay.portlet.iframe;version=\"6.2.0\",com.liferay.portlet.imagegallerydisplay.action;version=\"6.2.0\",com.liferay.portlet.imagegallerydisplay.util;version=\"6.2.0\",com.liferay.portlet.imagegallerydisplay;version=\"6.2.0\",com.liferay.portlet.invitation.action;version=\"6.2.0\",com.liferay.portlet.invitation.dependencies;version=\"6.2.0\",com.liferay.portlet.invitation.util;version=\"6.2.0\",com.liferay.portlet.invitation;version=\"6.2.0\",com.liferay.portlet.journal.action;version=\"6.2.0\",com.liferay.portlet.journal.asset;version=\"6.2.0\",com.liferay.portlet.journal.atom;version=\"6.2.0\",com.liferay.portlet.journal.dependencies;version=\"6.2.0\",com.liferay.portlet.journal.lar;version=\"6.2.0\",com.liferay.portlet.journal.messaging;version=\"6.2.0\",com.liferay.portlet.journal.model.impl;version=\"6.2.0\",com.liferay.portlet.journal.model;version=\"6.2.0\",com.liferay.portlet.journal.search;version=\"6.2.0\",com.liferay.portlet.journal.service.base;version=\"6.2.0\",com.liferay.portlet.journal.service.http;version=\"6.2.0\",com.liferay.portlet.journal.service.impl;version=\"6.2.0\",com.liferay.portlet.journal.service.permission;version=\"6.2.0\",com.liferay.portlet.journal.service.persistence;version=\"6.2.0\",com.liferay.portlet.journal.service;version=\"6.2.0\",com.liferay.portlet.journal.util.comparator;version=\"6.2.0\",com.liferay.portlet.journal.util;version=\"6.2.0\",com.liferay.portlet.journal.webdav;version=\"6.2.0\",com.liferay.portlet.journal.workflow;version=\"6.2.0\",com.liferay.portlet.journal;version=\"6.2.0\",com.liferay.portlet.journalarticles.action;version=\"6.2.0\",com.liferay.portlet.journalarticles;version=\"6.2.0\",com.liferay.portlet.journalcontent.action;version=\"6.2.0\",com.liferay.portlet.journalcontent.util;version=\"6.2.0\",com.liferay.portlet.journalcontent;version=\"6.2.0\",com.liferay.portlet.journalcontentsearch.action;version=\"6.2.0\",com.liferay.portlet.journalcontentsearch.util;version=\"6.2.0\",com.liferay.portlet.journalcontentsearch;version=\"6.2.0\",com.liferay.portlet.language.action;version=\"6.2.0\",com.liferay.portlet.language;version=\"6.2.0\",com.liferay.portlet.layoutconfiguration.util.velocity;version=\"6.2.0\",com.liferay.portlet.layoutconfiguration.util.xml;version=\"6.2.0\",com.liferay.portlet.layoutconfiguration.util;version=\"6.2.0\",com.liferay.portlet.layoutconfiguration;version=\"6.2.0\",com.liferay.portlet.layoutprototypes.action;version=\"6.2.0\",com.liferay.portlet.layoutprototypes;version=\"6.2.0\",com.liferay.portlet.layoutsadmin.action;version=\"6.2.0\",com.liferay.portlet.layoutsadmin.util;version=\"6.2.0\",com.liferay.portlet.layoutsadmin;version=\"6.2.0\",com.liferay.portlet.layoutsetprototypes.action;version=\"6.2.0\",com.liferay.portlet.layoutsetprototypes;version=\"6.2.0\",com.liferay.portlet.login.action;version=\"6.2.0\",com.liferay.portlet.login.util;version=\"6.2.0\",com.liferay.portlet.login;version=\"6.2.0\",com.liferay.portlet.messageboards.action;version=\"6.2.0\",com.liferay.portlet.messageboards.asset;version=\"6.2.0\",com.liferay.portlet.messageboards.dependencies;version=\"6.2.0\",com.liferay.portlet.messageboards.lar;version=\"6.2.0\",com.liferay.portlet.messageboards.messaging;version=\"6.2.0\",com.liferay.portlet.messageboards.model.impl;version=\"6.2.0\",com.liferay.portlet.messageboards.model;version=\"6.2.0\",com.liferay.portlet.messageboards.pop;version=\"6.2.0\",com.liferay.portlet.messageboards.service.base;version=\"6.2.0\",com.liferay.portlet.messageboards.service.http;version=\"6.2.0\",com.liferay.portlet.messageboards.service.impl;version=\"6.2.0\",com.liferay.portlet.messageboards.service.permission;version=\"6.2.0\",com.liferay.portlet.messageboards.service.persistence;version=\"6.2.0\",com.liferay.portlet.messageboards.service;version=\"6.2.0\",com.liferay.portlet.messageboards.social;version=\"6.2.0\",com.liferay.portlet.messageboards.util.comparator;version=\"6.2.0\",com.liferay.portlet.messageboards.util;version=\"6.2.0\",com.liferay.portlet.messageboards.workflow;version=\"6.2.0\",com.liferay.portlet.messageboards;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.action;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.model.impl;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.model;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.search;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service.base;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service.http;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service.impl;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service.permission;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service.persistence;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.service;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules.util;version=\"6.2.0\",com.liferay.portlet.mobiledevicerules;version=\"6.2.0\",com.liferay.portlet.monitoring.action;version=\"6.2.0\",com.liferay.portlet.monitoring;version=\"6.2.0\",com.liferay.portlet.myaccount.action;version=\"6.2.0\",com.liferay.portlet.myaccount;version=\"6.2.0\",com.liferay.portlet.mypages.action;version=\"6.2.0\",com.liferay.portlet.mypages;version=\"6.2.0\",com.liferay.portlet.myplaces.action;version=\"6.2.0\",com.liferay.portlet.myplaces;version=\"6.2.0\",com.liferay.portlet.nestedportlets.action;version=\"6.2.0\",com.liferay.portlet.nestedportlets;version=\"6.2.0\",com.liferay.portlet.network.model;version=\"6.2.0\",com.liferay.portlet.network.util;version=\"6.2.0\",com.liferay.portlet.network;version=\"6.2.0\",com.liferay.portlet.pagecomments.lar;version=\"6.2.0\",com.liferay.portlet.pagecomments;version=\"6.2.0\",com.liferay.portlet.pageratings.lar;version=\"6.2.0\",com.liferay.portlet.pageratings;version=\"6.2.0\",com.liferay.portlet.passwordpoliciesadmin.action;version=\"6.2.0\",com.liferay.portlet.passwordpoliciesadmin.search;version=\"6.2.0\",com.liferay.portlet.passwordpoliciesadmin.util;version=\"6.2.0\",com.liferay.portlet.passwordpoliciesadmin;version=\"6.2.0\",com.liferay.portlet.plugininstaller.action;version=\"6.2.0\",com.liferay.portlet.plugininstaller;version=\"6.2.0\",com.liferay.portlet.pluginsadmin.action;version=\"6.2.0\",com.liferay.portlet.pluginsadmin;version=\"6.2.0\",com.liferay.portlet.polls.action;version=\"6.2.0\",com.liferay.portlet.polls.lar;version=\"6.2.0\",com.liferay.portlet.polls.model.impl;version=\"6.2.0\",com.liferay.portlet.polls.model;version=\"6.2.0\",com.liferay.portlet.polls.service.base;version=\"6.2.0\",com.liferay.portlet.polls.service.http;version=\"6.2.0\",com.liferay.portlet.polls.service.impl;version=\"6.2.0\",com.liferay.portlet.polls.service.permission;version=\"6.2.0\",com.liferay.portlet.polls.service.persistence;version=\"6.2.0\",com.liferay.portlet.polls.service;version=\"6.2.0\",com.liferay.portlet.polls.util;version=\"6.2.0\",com.liferay.portlet.polls;version=\"6.2.0\",com.liferay.portlet.pollsdisplay.action;version=\"6.2.0\",com.liferay.portlet.pollsdisplay;version=\"6.2.0\",com.liferay.portlet.portalsettings.action;version=\"6.2.0\",com.liferay.portlet.portalsettings;version=\"6.2.0\",com.liferay.portlet.portletconfiguration.action;version=\"6.2.0\",com.liferay.portlet.portletconfiguration.util;version=\"6.2.0\",com.liferay.portlet.portletconfiguration;version=\"6.2.0\",com.liferay.portlet.portletsharing.action;version=\"6.2.0\",com.liferay.portlet.portletsharing;version=\"6.2.0\",com.liferay.portlet.quicknote.action;version=\"6.2.0\",com.liferay.portlet.quicknote;version=\"6.2.0\",com.liferay.portlet.ratings.action;version=\"6.2.0\",com.liferay.portlet.ratings.model.impl;version=\"6.2.0\",com.liferay.portlet.ratings.model;version=\"6.2.0\",com.liferay.portlet.ratings.service.base;version=\"6.2.0\",com.liferay.portlet.ratings.service.http;version=\"6.2.0\",com.liferay.portlet.ratings.service.impl;version=\"6.2.0\",com.liferay.portlet.ratings.service.persistence;version=\"6.2.0\",com.liferay.portlet.ratings.service;version=\"6.2.0\",com.liferay.portlet.ratings;version=\"6.2.0\",com.liferay.portlet.requests.action;version=\"6.2.0\",com.liferay.portlet.requests;version=\"6.2.0\",com.liferay.portlet.rolesadmin.action;version=\"6.2.0\",com.liferay.portlet.rolesadmin.search;version=\"6.2.0\",com.liferay.portlet.rolesadmin.util;version=\"6.2.0\",com.liferay.portlet.rolesadmin;version=\"6.2.0\",com.liferay.portlet.rss.action;version=\"6.2.0\",com.liferay.portlet.rss.lar;version=\"6.2.0\",com.liferay.portlet.rss.util;version=\"6.2.0\",com.liferay.portlet.rss;version=\"6.2.0\",com.liferay.portlet.search.action;version=\"6.2.0\",com.liferay.portlet.search;version=\"6.2.0\",com.liferay.portlet.shopping.action;version=\"6.2.0\",com.liferay.portlet.shopping.dependencies;version=\"6.2.0\",com.liferay.portlet.shopping.model.impl;version=\"6.2.0\",com.liferay.portlet.shopping.model;version=\"6.2.0\",com.liferay.portlet.shopping.search;version=\"6.2.0\",com.liferay.portlet.shopping.service.base;version=\"6.2.0\",com.liferay.portlet.shopping.service.http;version=\"6.2.0\",com.liferay.portlet.shopping.service.impl;version=\"6.2.0\",com.liferay.portlet.shopping.service.permission;version=\"6.2.0\",com.liferay.portlet.shopping.service.persistence;version=\"6.2.0\",com.liferay.portlet.shopping.service;version=\"6.2.0\",com.liferay.portlet.shopping.util.comparator;version=\"6.2.0\",com.liferay.portlet.shopping.util;version=\"6.2.0\",com.liferay.portlet.shopping;version=\"6.2.0\",com.liferay.portlet.sites.action;version=\"6.2.0\",com.liferay.portlet.sites.dependencies;version=\"6.2.0\",com.liferay.portlet.sites.search;version=\"6.2.0\",com.liferay.portlet.sites.util;version=\"6.2.0\",com.liferay.portlet.sites;version=\"6.2.0\",com.liferay.portlet.sitesadmin.search;version=\"6.2.0\",com.liferay.portlet.sitesadmin;version=\"6.2.0\",com.liferay.portlet.social.model.impl;version=\"6.2.0\",com.liferay.portlet.social.model;version=\"6.2.0\",com.liferay.portlet.social.service.base;version=\"6.2.0\",com.liferay.portlet.social.service.http;version=\"6.2.0\",com.liferay.portlet.social.service.impl;version=\"6.2.0\",com.liferay.portlet.social.service.persistence;version=\"6.2.0\",com.liferay.portlet.social.service;version=\"6.2.0\",com.liferay.portlet.social.util.comparator;version=\"6.2.0\",com.liferay.portlet.social.util;version=\"6.2.0\",com.liferay.portlet.social;version=\"6.2.0\",com.liferay.portlet.socialactivity.action;version=\"6.2.0\",com.liferay.portlet.socialactivity;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.action;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.model.impl;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.model;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service.base;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service.http;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service.impl;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service.permission;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service.persistence;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.service;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.util.comparator;version=\"6.2.0\",com.liferay.portlet.softwarecatalog.util;version=\"6.2.0\",com.liferay.portlet.softwarecatalog;version=\"6.2.0\",com.liferay.portlet.stagingbar.action;version=\"6.2.0\",com.liferay.portlet.stagingbar;version=\"6.2.0\",com.liferay.portlet.tagscompiler.util;version=\"6.2.0\",com.liferay.portlet.tagscompiler;version=\"6.2.0\",com.liferay.portlet.translator.model;version=\"6.2.0\",com.liferay.portlet.translator.util;version=\"6.2.0\",com.liferay.portlet.translator;version=\"6.2.0\",com.liferay.portlet.unitconverter.model;version=\"6.2.0\",com.liferay.portlet.unitconverter.util;version=\"6.2.0\",com.liferay.portlet.unitconverter;version=\"6.2.0\",com.liferay.portlet.usergroupsadmin.action;version=\"6.2.0\",com.liferay.portlet.usergroupsadmin.search;version=\"6.2.0\",com.liferay.portlet.usergroupsadmin;version=\"6.2.0\",com.liferay.portlet.usersadmin.action;version=\"6.2.0\",com.liferay.portlet.usersadmin.atom;version=\"6.2.0\",com.liferay.portlet.usersadmin.search;version=\"6.2.0\",com.liferay.portlet.usersadmin.util;version=\"6.2.0\",com.liferay.portlet.usersadmin;version=\"6.2.0\",com.liferay.portlet.webproxy.action;version=\"6.2.0\",com.liferay.portlet.webproxy;version=\"6.2.0\",com.liferay.portlet.wiki.action;version=\"6.2.0\",com.liferay.portlet.wiki.asset;version=\"6.2.0\",com.liferay.portlet.wiki.dependencies;version=\"6.2.0\",com.liferay.portlet.wiki.engines.antlrwiki.translator.internal;version=\"6.2.0\",com.liferay.portlet.wiki.engines.antlrwiki.translator;version=\"6.2.0\",com.liferay.portlet.wiki.engines.antlrwiki;version=\"6.2.0\",com.liferay.portlet.wiki.engines.jspwiki.filters;version=\"6.2.0\",com.liferay.portlet.wiki.engines.jspwiki.plugin;version=\"6.2.0\",com.liferay.portlet.wiki.engines.jspwiki;version=\"6.2.0\",com.liferay.portlet.wiki.engines.mediawiki.matchers;version=\"6.2.0\",com.liferay.portlet.wiki.engines.mediawiki;version=\"6.2.0\",com.liferay.portlet.wiki.engines;version=\"6.2.0\",com.liferay.portlet.wiki.importers.mediawiki;version=\"6.2.0\",com.liferay.portlet.wiki.importers;version=\"6.2.0\",com.liferay.portlet.wiki.lar;version=\"6.2.0\",com.liferay.portlet.wiki.model.impl;version=\"6.2.0\",com.liferay.portlet.wiki.model;version=\"6.2.0\",com.liferay.portlet.wiki.security.permission;version=\"6.2.0\",com.liferay.portlet.wiki.security;version=\"6.2.0\",com.liferay.portlet.wiki.service.base;version=\"6.2.0\",com.liferay.portlet.wiki.service.http;version=\"6.2.0\",com.liferay.portlet.wiki.service.impl;version=\"6.2.0\",com.liferay.portlet.wiki.service.permission;version=\"6.2.0\",com.liferay.portlet.wiki.service.persistence;version=\"6.2.0\",com.liferay.portlet.wiki.service;version=\"6.2.0\",com.liferay.portlet.wiki.social;version=\"6.2.0\",com.liferay.portlet.wiki.translators;version=\"6.2.0\",com.liferay.portlet.wiki.util.comparator;version=\"6.2.0\",com.liferay.portlet.wiki.util;version=\"6.2.0\",com.liferay.portlet.wiki.workflow;version=\"6.2.0\",com.liferay.portlet.wiki;version=\"6.2.0\",com.liferay.portlet.wikidisplay.action;version=\"6.2.0\",com.liferay.portlet.wikidisplay;version=\"6.2.0\",com.liferay.portlet.workflowdefinitionlinks.action;version=\"6.2.0\",com.liferay.portlet.workflowdefinitionlinks;version=\"6.2.0\",com.liferay.portlet.workflowdefinitions.action;version=\"6.2.0\",com.liferay.portlet.workflowdefinitions;version=\"6.2.0\",com.liferay.portlet.workflowinstances.action;version=\"6.2.0\",com.liferay.portlet.workflowinstances;version=\"6.2.0\",com.liferay.portlet.workflowtasks.action;version=\"6.2.0\",com.liferay.portlet.workflowtasks.search;version=\"6.2.0\",com.liferay.portlet.workflowtasks;version=\"6.2.0\",com.liferay.portlet.xslcontent.action;version=\"6.2.0\",com.liferay.portlet.xslcontent.util;version=\"6.2.0\",com.liferay.portlet.xslcontent;version=\"6.2.0\",com.liferay.portlet;version=\"6.2.0\",com.liferay.taglib.aui.base;version=\"6.2.0\",com.liferay.taglib.aui;version=\"6.2.0\",com.liferay.taglib.core;version=\"6.2.0\",com.liferay.taglib.faces.converter;version=\"6.2.0\",com.liferay.taglib.faces.util;version=\"6.2.0\",com.liferay.taglib.faces.validator;version=\"6.2.0\",com.liferay.taglib.faces;version=\"6.2.0\",com.liferay.taglib.portlet;version=\"6.2.0\",com.liferay.taglib.portletext;version=\"6.2.0\",com.liferay.taglib.security;version=\"6.2.0\",com.liferay.taglib.theme;version=\"6.2.0\",com.liferay.taglib.ui;version=\"6.2.0\",com.liferay.taglib.util;version=\"6.2.0\",com.liferay.taglib;version=\"6.2.0\",com.liferay.util.ant;version=\"6.2.0\",com.liferay.util.aspectj;version=\"6.2.0\",com.liferay.util.axis;version=\"6.2.0\",com.liferay.util.bean,com.liferay.util.bean;version=\"6.2.0\",com.liferay.util.bridges.alloy;version=\"6.2.0\",com.liferay.util.bridges.bsf;version=\"6.2.0\",com.liferay.util.bridges.common;version=\"6.2.0\",com.liferay.util.bridges.groovy;version=\"6.2.0\",com.liferay.util.bridges.javascript;version=\"6.2.0\",com.liferay.util.bridges.jsf.common.comparator;version=\"6.2.0\",com.liferay.util.bridges.jsf.common;version=\"6.2.0\",com.liferay.util.bridges.jsf.icefaces;version=\"6.2.0\",com.liferay.util.bridges.jsf.myfaces;version=\"6.2.0\",com.liferay.util.bridges.jsf.sun;version=\"6.2.0\",com.liferay.util.bridges.jsf;version=\"6.2.0\",com.liferay.util.bridges.jsp;version=\"6.2.0\",com.liferay.util.bridges.mvc;version=\"6.2.0\",com.liferay.util.bridges.php;version=\"6.2.0\",com.liferay.util.bridges.python;version=\"6.2.0\",com.liferay.util.bridges.ruby;version=\"6.2.0\",com.liferay.util.bridges.scripting;version=\"6.2.0\",com.liferay.util.bridges.struts;version=\"6.2.0\",com.liferay.util.bridges.wai;version=\"6.2.0\",com.liferay.util.bridges;version=\"6.2.0\",com.liferay.util.cal;version=\"6.2.0\",com.liferay.util.dao.orm.hibernate;version=\"6.2.0\",com.liferay.util.dao.orm;version=\"6.2.0\",com.liferay.util.dao;version=\"6.2.0\",com.liferay.util.derby;version=\"6.2.0\",com.liferay.util.diff;version=\"6.2.0\",com.liferay.util.format;version=\"6.2.0\",com.liferay.util.freemarker;version=\"6.2.0\",com.liferay.util.jazzy;version=\"6.2.0\",com.liferay.util.json;version=\"6.2.0\",com.liferay.util.ldap;version=\"6.2.0\",com.liferay.util.log4j;version=\"6.2.0\",com.liferay.util.lucene;version=\"6.2.0\",com.liferay.util.mail;version=\"6.2.0\",com.liferay.util.poi;version=\"6.2.0\",com.liferay.util.portlet;version=\"6.2.0\",com.liferay.util.service;version=\"6.2.0\",com.liferay.util.servlet.filters;version=\"6.2.0\",com.liferay.util.servlet;version=\"6.2.0\",com.liferay.util.sl4fj;version=\"6.2.0\",com.liferay.util.spring.transaction;version=\"6.2.0\",com.liferay.util.spring;version=\"6.2.0\",com.liferay.util.transport;version=\"6.2.0\",com.liferay.util.xml.descriptor;version=\"6.2.0\",com.liferay.util.xml;version=\"6.2.0\",com.liferay.util;version=\"6.2.0\",com.liferay;version=\"6.2.0\",freemarker.ext.servlet,freemarker.template,javax.annotation.security;version=\"1.1.0\",javax.annotation;version=\"1.1.0\",javax.el;version=\"2.2.0\",javax.faces.convert,javax.faces.webapp,javax.mail.event;version=\"1.4\",javax.mail.internet;version=\"1.4\",javax.mail.search;version=\"1.4\",javax.mail.util;version=\"1.4\",javax.mail;version=\"1.4\",javax.portlet.filter;version=\"2.0.0\",javax.portlet;version=\"2.0.0\",javax.servlet.annotation;version=\"3.0.0\",javax.servlet.descriptor;version=\"3.0.0\",javax.servlet.http;version=\"3.0.0\",javax.servlet.jsp.el;version=\"2.2\",javax.servlet.jsp.jstl.core;version=\"1.2\",javax.servlet.jsp.jstl.fmt;version=\"1.2\",javax.servlet.jsp.jstl.sql;version=\"1.2\",javax.servlet.jsp.jstl.tlv;version=\"1.2\",javax.servlet.jsp.resources;version=\"2.2\",javax.servlet.jsp.tagext;version=\"2.2\",javax.servlet.jsp;version=\"2.2\",javax.servlet.resources;version=\"3.0.0\",javax.servlet;version=\"3.0.0\",org.aopalliance.aop,org.aopalliance.intercept,org.apache.commons.codec,org.apache.commons.codec.binary,org.apache.commons.codec.digest,org.apache.commons.codec.languages,org.apache.commons.codec.net,org.apache.commons.fileupload,org.apache.commons.fileupload.disk,org.apache.commons.fileupload.portlet,org.apache.commons.fileupload.servlet,org.apache.commons.fileupload.util,org.apache.commons.io,org.apache.commons.io.comparator,org.apache.commons.io.filefilter,org.apache.commons.io.input,org.apache.commons.io.output,org.apache.commons.lang,org.apache.commons.lang.builder,org.apache.commons.lang.enums,org.apache.commons.lang.exception,org.apache.commons.lang.math,org.apache.commons.lang.mutable,org.apache.commons.lang.reflect,org.apache.commons.lang.text,org.apache.commons.lang.time,org.apache.commons.logging;version=\"1.1.1\",org.apache.el,org.apache.jasper,org.apache.jasper.runtime,org.apache.jasper.servlet,org.apache.log4j,org.apache.log4j.chainsaw,org.apache.log4j.config,org.apache.log4j.helpers,org.apache.log4j.jdbc,org.apache.log4j.jmx,org.apache.log4j.lf5,org.apache.log4j.lf5.util,org.apache.log4j.lf5.viewer,org.apache.log4j.net,org.apache.log4j.nt,org.apache.log4j.or,org.apache.log4j.or.jms,org.apache.log4j.or.sax,org.apache.log4j.pattern,org.apache.log4j.spi,org.apache.log4j.varia,org.apache.log4j.xml,org.apache.naming,org.apache.naming.factory,org.apache.naming.java,org.apache.naming.resources,org.apache.naming.resources.jndi,org.apache.taglibs.standard.functions,org.apache.taglibs.standard.resources,org.apache.taglibs.standard.tag.common.core,org.apache.taglibs.standard.tag.rt.core,org.apache.taglibs.standard.tei,org.apache.taglibs.standard.tlv,org.apache.tomcat,org.eclipse.jdt.core.compiler;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.core;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.antadapter;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.apt.dispatch;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.apt.model;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.apt.util;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.ast;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.batch;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.classfmt;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.codegen;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.env;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.flow;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.impl;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.lookup;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.parser.diagnose;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.parser;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.problem;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.tool;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler.util;version=\"3.7.0.I20110613-1736\",org.eclipse.jdt.internal.compiler;version=\"3.7.0.I20110613-1736\",org.objectweb.asm,org.objectweb.asm.commons,org.objectweb.asm.signature,org.slf4j.impl;version=\"6.2.0\",org.slf4j;version=\"6.2.0\",org.springframework.aop.aspectj.annotation;version=\"3.0.6.RELEASE\",org.springframework.aop.aspectj.autoproxy;version=\"3.0.6.RELEASE\",org.springframework.aop.aspectj;version=\"3.0.6.RELEASE\",org.springframework.aop.config;version=\"3.0.6.RELEASE\",org.springframework.aop.framework.adapter;version=\"3.0.6.RELEASE\",org.springframework.aop.framework.autoproxy.target;version=\"3.0.6.RELEASE\",org.springframework.aop.framework.autoproxy;version=\"3.0.6.RELEASE\",org.springframework.aop.framework;version=\"3.0.6.RELEASE\",org.springframework.aop.interceptor;version=\"3.0.6.RELEASE\",org.springframework.aop.scope;version=\"3.0.6.RELEASE\",org.springframework.aop.support.annotation;version=\"3.0.6.RELEASE\",org.springframework.aop.support;version=\"3.0.6.RELEASE\",org.springframework.aop.target.dynamic;version=\"3.0.6.RELEASE\",org.springframework.aop.target;version=\"3.0.6.RELEASE\",org.springframework.aop;version=\"3.0.6.RELEASE\",org.springframework.asm.commons;version=\"3.0.6.RELEASE\",org.springframework.asm.signature;version=\"3.0.6.RELEASE\",org.springframework.asm;version=\"3.0.6.RELEASE\",org.springframework.beans.annotation;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.access.el;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.access;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.annotation;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.aspectj;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.config;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.parsing;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.serviceloader;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.support;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.wiring;version=\"3.0.6.RELEASE\",org.springframework.beans.factory.xml;version=\"3.0.6.RELEASE\",org.springframework.beans.factory;version=\"3.0.6.RELEASE\",org.springframework.beans.propertyeditors;version=\"3.0.6.RELEASE\",org.springframework.beans.support;version=\"3.0.6.RELEASE\",org.springframework.beans;version=\"3.0.6.RELEASE\",org.springframework.cache.ehcache;version=\"3.0.6.RELEASE\",org.springframework.context.access;version=\"3.0.6.RELEASE\",org.springframework.context.annotation;version=\"3.0.6.RELEASE\",org.springframework.context.config;version=\"3.0.6.RELEASE\",org.springframework.context.event;version=\"3.0.6.RELEASE\",org.springframework.context.expression;version=\"3.0.6.RELEASE\",org.springframework.context.i18n;version=\"3.0.6.RELEASE\",org.springframework.context.support;version=\"3.0.6.RELEASE\",org.springframework.context.weaving;version=\"3.0.6.RELEASE\",org.springframework.context;version=\"3.0.6.RELEASE\",org.springframework.core.annotation;version=\"3.0.6.RELEASE\",org.springframework.core.convert.converter;version=\"3.0.6.RELEASE\",org.springframework.core.convert.support;version=\"3.0.6.RELEASE\",org.springframework.core.convert;version=\"3.0.6.RELEASE\",org.springframework.core.enums;version=\"3.0.6.RELEASE\",org.springframework.core.io.support;version=\"3.0.6.RELEASE\",org.springframework.core.io;version=\"3.0.6.RELEASE\",org.springframework.core.serializer.support;version=\"3.0.6.RELEASE\",org.springframework.core.serializer;version=\"3.0.6.RELEASE\",org.springframework.core.style;version=\"3.0.6.RELEASE\",org.springframework.core.task.support;version=\"3.0.6.RELEASE\",org.springframework.core.task;version=\"3.0.6.RELEASE\",org.springframework.core.type.classreading;version=\"3.0.6.RELEASE\",org.springframework.core.type.filter;version=\"3.0.6.RELEASE\",org.springframework.core.type;version=\"3.0.6.RELEASE\",org.springframework.core;version=\"3.0.6.RELEASE\",org.springframework.dao.annotation;version=\"3.0.6.RELEASE\",org.springframework.dao.support;version=\"3.0.6.RELEASE\",org.springframework.dao;version=\"3.0.6.RELEASE\",org.springframework.ejb.access;version=\"3.0.6.RELEASE\",org.springframework.ejb.config;version=\"3.0.6.RELEASE\",org.springframework.ejb.interceptor;version=\"3.0.6.RELEASE\",org.springframework.ejb.support;version=\"3.0.6.RELEASE\",org.springframework.expression.common;version=\"3.0.6.RELEASE\",org.springframework.expression.spel.ast;version=\"3.0.6.RELEASE\",org.springframework.expression.spel.generated;version=\"3.0.6.RELEASE\",org.springframework.expression.spel.standard;version=\"3.0.6.RELEASE\",org.springframework.expression.spel.support;version=\"3.0.6.RELEASE\",org.springframework.expression.spel;version=\"3.0.6.RELEASE\",org.springframework.expression;version=\"3.0.6.RELEASE\",org.springframework.format.annotation;version=\"3.0.6.RELEASE\",org.springframework.format.datetime.joda;version=\"3.0.6.RELEASE\",org.springframework.format.datetime;version=\"3.0.6.RELEASE\",org.springframework.format.number;version=\"3.0.6.RELEASE\",org.springframework.format.support;version=\"3.0.6.RELEASE\",org.springframework.format;version=\"3.0.6.RELEASE\",org.springframework.http.client.support;version=\"3.0.6.RELEASE\",org.springframework.http.client;version=\"3.0.6.RELEASE\",org.springframework.http.converter.feed;version=\"3.0.6.RELEASE\",org.springframework.http.converter.json;version=\"3.0.6.RELEASE\",org.springframework.http.converter.xml;version=\"3.0.6.RELEASE\",org.springframework.http.converter;version=\"3.0.6.RELEASE\",org.springframework.http.server;version=\"3.0.6.RELEASE\",org.springframework.http;version=\"3.0.6.RELEASE\",org.springframework.instrument.classloading.glassfish;version=\"3.0.6.RELEASE\",org.springframework.instrument.classloading.jboss;version=\"3.0.6.RELEASE\",org.springframework.instrument.classloading.oc4j;version=\"3.0.6.RELEASE\",org.springframework.instrument.classloading.weblogic;version=\"3.0.6.RELEASE\",org.springframework.instrument.classloading;version=\"3.0.6.RELEASE\",org.springframework.jca.cci.connection;version=\"3.0.6.RELEASE\",org.springframework.jca.cci.core.support;version=\"3.0.6.RELEASE\",org.springframework.jca.cci.core;version=\"3.0.6.RELEASE\",org.springframework.jca.cci.object;version=\"3.0.6.RELEASE\",org.springframework.jca.cci;version=\"3.0.6.RELEASE\",org.springframework.jca.context;version=\"3.0.6.RELEASE\",org.springframework.jca.endpoint;version=\"3.0.6.RELEASE\",org.springframework.jca.support;version=\"3.0.6.RELEASE\",org.springframework.jca.work.glassfish;version=\"3.0.6.RELEASE\",org.springframework.jca.work.jboss;version=\"3.0.6.RELEASE\",org.springframework.jca.work;version=\"3.0.6.RELEASE\",org.springframework.jdbc.config;version=\"3.0.6.RELEASE\",org.springframework.jdbc.core.metadata;version=\"3.0.6.RELEASE\",org.springframework.jdbc.core.namedparam;version=\"3.0.6.RELEASE\",org.springframework.jdbc.core.simple;version=\"3.0.6.RELEASE\",org.springframework.jdbc.core.support;version=\"3.0.6.RELEASE\",org.springframework.jdbc.core;version=\"3.0.6.RELEASE\",org.springframework.jdbc.datasource.embedded;version=\"3.0.6.RELEASE\",org.springframework.jdbc.datasource.init;version=\"3.0.6.RELEASE\",org.springframework.jdbc.datasource.lookup;version=\"3.0.6.RELEASE\",org.springframework.jdbc.datasource;version=\"3.0.6.RELEASE\",org.springframework.jdbc.object;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support.incrementer;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support.lob;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support.nativejdbc;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support.rowset;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support.xml;version=\"3.0.6.RELEASE\",org.springframework.jdbc.support;version=\"3.0.6.RELEASE\",org.springframework.jdbc;version=\"3.0.6.RELEASE\",org.springframework.jms.config;version=\"3.0.6.RELEASE\",org.springframework.jms.connection;version=\"3.0.6.RELEASE\",org.springframework.jms.core.support;version=\"3.0.6.RELEASE\",org.springframework.jms.core;version=\"3.0.6.RELEASE\",org.springframework.jms.listener.adapter;version=\"3.0.6.RELEASE\",org.springframework.jms.listener.endpoint;version=\"3.0.6.RELEASE\",org.springframework.jms.listener;version=\"3.0.6.RELEASE\",org.springframework.jms.remoting;version=\"3.0.6.RELEASE\",org.springframework.jms.support.converter;version=\"3.0.6.RELEASE\",org.springframework.jms.support.destination;version=\"3.0.6.RELEASE\",org.springframework.jms.support;version=\"3.0.6.RELEASE\",org.springframework.jms;version=\"3.0.6.RELEASE\",org.springframework.jmx.access;version=\"3.0.6.RELEASE\",org.springframework.jmx.export.annotation;version=\"3.0.6.RELEASE\",org.springframework.jmx.export.assembler;version=\"3.0.6.RELEASE\",org.springframework.jmx.export.metadata;version=\"3.0.6.RELEASE\",org.springframework.jmx.export.naming;version=\"3.0.6.RELEASE\",org.springframework.jmx.export.notification;version=\"3.0.6.RELEASE\",org.springframework.jmx.export;version=\"3.0.6.RELEASE\",org.springframework.jmx.support;version=\"3.0.6.RELEASE\",org.springframework.jmx;version=\"3.0.6.RELEASE\",org.springframework.jndi.support;version=\"3.0.6.RELEASE\",org.springframework.jndi;version=\"3.0.6.RELEASE\",org.springframework.mail.javamail;version=\"3.0.6.RELEASE\",org.springframework.mail;version=\"3.0.6.RELEASE\",org.springframework.mock.staticmock;version=\"3.0.6.RELEASE\",org.springframework.orm.hibernate3.annotation;version=\"3.0.6.RELEASE\",org.springframework.orm.hibernate3.support;version=\"3.0.6.RELEASE\",org.springframework.orm.hibernate3;version=\"3.0.6.RELEASE\",org.springframework.orm.ibatis.support;version=\"3.0.6.RELEASE\",org.springframework.orm.ibatis;version=\"3.0.6.RELEASE\",org.springframework.orm.jdo.support;version=\"3.0.6.RELEASE\",org.springframework.orm.jdo;version=\"3.0.6.RELEASE\",org.springframework.orm.jpa.aspectj;version=\"3.0.6.RELEASE\",org.springframework.orm.jpa" + ".persistenceunit;version=\"3.0.6.RELEASE\",org.springframework.orm.jpa.support;version=\"3.0.6.RELEASE\",org.springframework.orm.jpa.vendor;version=\"3.0.6.RELEASE\",org.springframework.orm.jpa;version=\"3.0.6.RELEASE\",org.springframework.orm;version=\"3.0.6.RELEASE\",org.springframework.oxm.castor;version=\"3.0.6.RELEASE\",org.springframework.oxm.config;version=\"3.0.6.RELEASE\",org.springframework.oxm.jaxb;version=\"3.0.6.RELEASE\",org.springframework.oxm.jibx;version=\"3.0.6.RELEASE\",org.springframework.oxm.mime;version=\"3.0.6.RELEASE\",org.springframework.oxm.support;version=\"3.0.6.RELEASE\",org.springframework.oxm.xmlbeans;version=\"3.0.6.RELEASE\",org.springframework.oxm.xstream;version=\"3.0.6.RELEASE\",org.springframework.oxm;version=\"3.0.6.RELEASE\",org.springframework.remoting.caucho;version=\"3.0.6.RELEASE\",org.springframework.remoting.httpinvoker;version=\"3.0.6.RELEASE\",org.springframework.remoting.jaxrpc;version=\"3.0.6.RELEASE\",org.springframework.remoting.jaxws;version=\"3.0.6.RELEASE\",org.springframework.remoting.rmi;version=\"3.0.6.RELEASE\",org.springframework.remoting.soap;version=\"3.0.6.RELEASE\",org.springframework.remoting.support;version=\"3.0.6.RELEASE\",org.springframework.remoting;version=\"3.0.6.RELEASE\",org.springframework.scheduling.annotation;version=\"3.0.6.RELEASE\",org.springframework.scheduling.aspectj;version=\"3.0.6.RELEASE\",org.springframework.scheduling.backportconcurrent;version=\"3.0.6.RELEASE\",org.springframework.scheduling.commonj;version=\"3.0.6.RELEASE\",org.springframework.scheduling.concurrent;version=\"3.0.6.RELEASE\",org.springframework.scheduling.config;version=\"3.0.6.RELEASE\",org.springframework.scheduling.quartz;version=\"3.0.6.RELEASE\",org.springframework.scheduling.support;version=\"3.0.6.RELEASE\",org.springframework.scheduling.timer;version=\"3.0.6.RELEASE\",org.springframework.scheduling;version=\"3.0.6.RELEASE\",org.springframework.scripting.bsh;version=\"3.0.6.RELEASE\",org.springframework.scripting.config;version=\"3.0.6.RELEASE\",org.springframework.scripting.groovy;version=\"3.0.6.RELEASE\",org.springframework.scripting.jruby;version=\"3.0.6.RELEASE\",org.springframework.scripting.support;version=\"3.0.6.RELEASE\",org.springframework.scripting;version=\"3.0.6.RELEASE\",org.springframework.stereotype;version=\"3.0.6.RELEASE\",org.springframework.transaction.annotation;version=\"3.0.6.RELEASE\",org.springframework.transaction.aspectj;version=\"3.0.6.RELEASE\",org.springframework.transaction.config;version=\"3.0.6.RELEASE\",org.springframework.transaction.interceptor;version=\"3.0.6.RELEASE\",org.springframework.transaction.jta;version=\"3.0.6.RELEASE\",org.springframework.transaction.support;version=\"3.0.6.RELEASE\",org.springframework.transaction;version=\"3.0.6.RELEASE\",org.springframework.ui.context.support;version=\"3.0.6.RELEASE\",org.springframework.ui.context;version=\"3.0.6.RELEASE\",org.springframework.ui.freemarker;version=\"3.0.6.RELEASE\",org.springframework.ui.jasperreports;version=\"3.0.6.RELEASE\",org.springframework.ui.velocity;version=\"3.0.6.RELEASE\",org.springframework.ui;version=\"3.0.6.RELEASE\",org.springframework.util.comparator;version=\"3.0.6.RELEASE\",org.springframework.util.xml;version=\"3.0.6.RELEASE\",org.springframework.util;version=\"3.0.6.RELEASE\",org.springframework.validation.beanvalidation;version=\"3.0.6.RELEASE\",org.springframework.validation.support;version=\"3.0.6.RELEASE\",org.springframework.validation;version=\"3.0.6.RELEASE\",org.springframework.web.bind.annotation.support;version=\"3.0.6.RELEASE\",org.springframework.web.bind.annotation;version=\"3.0.6.RELEASE\",org.springframework.web.bind.support;version=\"3.0.6.RELEASE\",org.springframework.web.bind;version=\"3.0.6.RELEASE\",org.springframework.web.client.support;version=\"3.0.6.RELEASE\",org.springframework.web.client;version=\"3.0.6.RELEASE\",org.springframework.web.context.request;version=\"3.0.6.RELEASE\",org.springframework.web.context.support;version=\"3.0.6.RELEASE\",org.springframework.web.context;version=\"3.0.6.RELEASE\",org.springframework.web.filter;version=\"3.0.6.RELEASE\",org.springframework.web.jsf.el;version=\"3.0.6.RELEASE\",org.springframework.web.jsf;version=\"3.0.6.RELEASE\",org.springframework.web.multipart.commons;version=\"3.0.6.RELEASE\",org.springframework.web.multipart.support;version=\"3.0.6.RELEASE\",org.springframework.web.multipart;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.bind.annotation;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.bind;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.context;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.handler;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.multipart;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.mvc.annotation;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.mvc;version=\"3.0.6.RELEASE\",org.springframework.web.portlet.util;version=\"3.0.6.RELEASE\",org.springframework.web.portlet;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.config;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.handler;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.i18n;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.mvc.annotation;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.mvc.multiaction;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.mvc.support;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.mvc;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.resource;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.support;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.tags.form;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.tags;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.theme;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.document;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.feed;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.freemarker;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.jasperreports;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.json;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.tiles2;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.tiles;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.velocity;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.xml;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view.xslt;version=\"3.0.6.RELEASE\",org.springframework.web.servlet.view;version=\"3.0.6.RELEASE\",org.springframework.web.servlet;version=\"3.0.6.RELEASE\",org.springframework.web.struts;version=\"3.0.6.RELEASE\",org.springframework.web.util;version=\"3.0.6.RELEASE\",org.springframework.web;version=\"3.0.6.RELEASE\"").intern();
        Dictionary[] props = new Dictionary[]{new Hashtable()};
        props[0].put("org.osgi.framework.system.packages.extra", longExport);
        state.setPlatformProperties(props);
        File stateCache = OSGiTestsActivator.getContext().getDataFile("statecache");
        stateCache.mkdirs();
        StateObjectFactory.defaultFactory.writeState(state, stateCache);
        state = StateObjectFactory.defaultFactory.readState(stateCache);
    }

    public static class CatchAllValue {
        public CatchAllValue(String s) {
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

