/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;

public class DSImplementationTestCase
extends AbstractDSModelTestCase {
    public void testAddImplementationComponent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<implementation class=\"");
        buffer.append("org.example.ds.SampleCommandProvider1\">");
        buffer.append("</implementation>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSImplementationTestCase.assertNotNull((Object)component);
        IDSImplementation implementation = component.getImplementation();
        DSImplementationTestCase.assertTrue((implementation != null ? 1 : 0) != 0);
        String className = implementation.getClassName();
        DSImplementationTestCase.assertTrue((boolean)className.equals("org.example.ds.SampleCommandProvider1"));
        DSImplementationTestCase.assertEquals((String)implementation.getName(), (String)className);
    }

    public void testDefaultValuesService() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<implementation>");
        buffer.append("\n");
        buffer.append("</implementation>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        DSImplementationTestCase.assertNotNull((Object)component);
        IDSImplementation implementation = component.getImplementation();
        DSImplementationTestCase.assertNotNull((Object)implementation);
        DSImplementationTestCase.assertTrue((implementation.getClassName() == null ? 1 : 0) != 0);
    }

    public void testAddImplementationFactory() {
        StringBuffer buffer = new StringBuffer();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation Implementation = factory.createImplementation();
        String className = "org.example.ds.SampleCommandProvider";
        Implementation.setClassName(className);
        IDSComponent component = this.fModel.getDSComponent();
        component.setImplementation(Implementation);
        String content = component.toString();
        DSImplementationTestCase.assertTrue((content.indexOf("class=\"" + className + "\"") != -1 ? 1 : 0) != 0);
        IDSImplementation Implementation0 = component.getImplementation();
        DSImplementationTestCase.assertNotNull((Object)Implementation0);
        DSImplementationTestCase.assertTrue((boolean)Implementation0.getClassName().equals(className));
    }
}

