/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.AnnotationHover;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.pde.internal.ui.editor.text.XMLDoubleClickStrategy;
import org.eclipse.pde.internal.ui.editor.text.XMLReconcilingStrategy;
import org.eclipse.pde.internal.ui.editor.text.XMLScanner;
import org.eclipse.pde.internal.ui.editor.text.XMLTagScanner;
import org.eclipse.swt.graphics.Color;

public class XMLConfiguration
extends ChangeAwareSourceViewerConfiguration {
    private AnnotationHover fAnnotationHover;
    private XMLDoubleClickStrategy fDoubleClickStrategy;
    private XMLTagScanner fTagScanner;
    private XMLScanner fPdeScanner;
    private TextAttribute fXMLCommentAttr;
    private MultilineDamagerRepairer fDamagerRepairer;

    public XMLConfiguration(IColorManager colorManager) {
        this(colorManager, null);
    }

    public XMLConfiguration(IColorManager colorManager, PDESourcePage page) {
        super(page, colorManager);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag", "__xml_string"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected XMLScanner getPDEScanner() {
        if (this.fPdeScanner == null) {
            this.fPdeScanner = new XMLScanner(this.fColorManager);
        }
        return this.fPdeScanner;
    }

    protected XMLTagScanner getPDETagScanner() {
        if (this.fTagScanner == null) {
            this.fTagScanner = new XMLTagScanner(this.fColorManager);
        }
        return this.fTagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("_pde_xml_partitioning");
        MultilineDamagerRepairer dr = new MultilineDamagerRepairer((ITokenScanner)this.getPDEScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new MultilineDamagerRepairer((ITokenScanner)this.getPDETagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        this.fXMLCommentAttr = BasePDEScanner.createTextAttribute(this.fColorManager, "editor.color.xml_comment");
        this.fDamagerRepairer = new MultilineDamagerRepairer(null, this.fXMLCommentAttr);
        reconciler.setDamager((IPresentationDamager)this.fDamagerRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.fDamagerRepairer, "__xml_comment");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationHover();
        }
        return this.fAnnotationHover;
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTagScanner == null) {
            return;
        }
        if (this.affectsColorPresentation(event)) {
            this.fColorManager.handlePropertyChangeEvent(event);
        }
        this.fTagScanner.adaptToPreferenceChange(event);
        this.fPdeScanner.adaptToPreferenceChange(event);
        String property = event.getProperty();
        if (property.startsWith("editor.color.xml_comment")) {
            this.adaptTextAttribute(event);
        }
    }

    private void adaptTextAttribute(PropertyChangeEvent event) {
        String property = event.getProperty();
        this.fXMLCommentAttr = property.endsWith("_bold") ? this.adaptToStyleChange(event, 1, this.fXMLCommentAttr) : (property.endsWith("_italic") ? this.adaptToStyleChange(event, 2, this.fXMLCommentAttr) : new TextAttribute(this.fColorManager.getColor(event.getProperty()), this.fXMLCommentAttr.getBackground(), this.fXMLCommentAttr.getStyle()));
        this.fDamagerRepairer.setDefaultTextAttribute(this.fXMLCommentAttr);
    }

    private TextAttribute adaptToStyleChange(PropertyChangeEvent event, int styleAttribute, TextAttribute textAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        }
        boolean bl = activeValue = (textAttribute.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            Color foreground = textAttribute.getForeground();
            Color background = textAttribute.getBackground();
            int style = eventValue ? textAttribute.getStyle() | styleAttribute : textAttribute.getStyle() & ~styleAttribute;
            textAttribute = new TextAttribute(foreground, background, style);
        }
        return textAttribute;
    }

    @Override
    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("editor.color.default") || property.startsWith("editor.color.instr") || property.startsWith("editor.color.string") || property.startsWith("editor.color.externalized_string") || property.startsWith("editor.color.tag") || property.startsWith("editor.color.xml_comment");
    }

    @Override
    public boolean affectsColorPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("editor.color.default") || property.equals("editor.color.instr") || property.equals("editor.color.string") || property.equals("editor.color.externalized_string") || property.equals("editor.color.tag") || property.equals("editor.color.xml_comment");
    }

    @Override
    protected int getInfoImplementationType() {
        return 1;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "_pde_xml_partitioning";
    }

    @Override
    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IBaseModel model;
        if (this.fSourcePage != null && this.fReconciler == null && (model = this.fSourcePage.getInputContext().getModel()) instanceof IReconcilingParticipant) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.addParticipant((IReconcilingParticipant)model);
            ISortableContentOutlinePage outline = this.fSourcePage.getContentOutline();
            if (outline instanceof IReconcilingParticipant) {
                strategy.addParticipant((IReconcilingParticipant)outline);
            }
            Reconciler reconciler = new Reconciler();
            reconciler.setReconcilingStrategy((IReconcilingStrategy)strategy, "__dftl_partition_content_type");
            if (!(model instanceof PluginModel)) {
                XMLReconcilingStrategy xmlStrategy = new XMLReconcilingStrategy(sourceViewer);
                reconciler.setReconcilingStrategy((IReconcilingStrategy)xmlStrategy, "__xml_string");
                reconciler.setReconcilingStrategy((IReconcilingStrategy)xmlStrategy, "__custom_tag");
                reconciler.setDocumentPartitioning("__xml_string");
            }
            reconciler.setDelay(500);
            this.fReconciler = reconciler;
        }
        return this.fReconciler;
    }
}

