/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tests;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class LocalDiskRepositoryTest {
    private static int testCount;
    protected PersonIdent committer;
    private final File trash = new File(new File("target"), "trash");
    private final List<Repository> toClose = new ArrayList<Repository>();

    @Before
    public void setUp() throws Exception {
        this.committer = new PersonIdent("J. Committer", "jcommitter@example.com");
    }

    @After
    public void tearDown() throws Exception {
        RepositoryCache.clear();
        Iterator<Repository> it = this.toClose.iterator();
        while (it.hasNext()) {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                Repository r = it.next();
                if (r == null) continue;
                r.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.toClose.clear();
    }

    protected Repository createWorkRepository() throws IOException {
        return this.createRepository(false);
    }

    private Repository createRepository(boolean bare) throws IOException {
        File gitdir = this.createUniqueTestGitDir(bare);
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.setMustExist(true);
        repositoryBuilder.setGitDir(gitdir);
        Repository db = repositoryBuilder.build();
        Assert.assertFalse((boolean)gitdir.exists());
        db.create();
        this.toClose.add(db);
        return db;
    }

    protected File createUniqueTestGitDir(boolean bare) throws IOException {
        String gitdirName = this.createUniqueTestFolderPrefix();
        if (!bare) {
            gitdirName = String.valueOf(gitdirName) + "/";
        }
        gitdirName = String.valueOf(gitdirName) + ".git";
        File gitdir = new File(this.trash, gitdirName);
        return gitdir.getCanonicalFile();
    }

    private String createUniqueTestFolderPrefix() {
        return "test" + System.currentTimeMillis() + "_" + testCount++;
    }
}

