/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.internal.tools.pomversion;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.internal.tools.pomversion.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PomVersionErrorReporter
implements IResourceChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final IPath POM_PATH = new Path("pom.xml");
    public static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    public static final int VERSION = 1;
    public static final IPath FEATURE_PATH = new Path("feature.xml");
    private static final String ELEMENT_PROJECT = "project";
    private static final String ELEMENT_VERSION = "version";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    void cleanMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.releng.tools.pomVersionProblem", false, 2);
        }
        catch (CoreException e) {
            RelEngPlugin.log(e);
        }
    }

    public void validate(IProject project) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        this.cleanMarkers((IResource)project);
        String severity = RelEngPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.releng.tools.invalidPomVersionErrorLevel");
        if ("Ignore".equals(severity)) {
            return;
        }
        IFile pom = project.getFile(POM_PATH);
        if (!pom.exists()) {
            return;
        }
        IFile manifest = project.getFile(MANIFEST_PATH);
        if (manifest.exists()) {
            Version bundleVersion = Version.emptyVersion;
            try {
                HashMap headers = new HashMap();
                ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), headers);
                String ver = (String)headers.get("Bundle-Version");
                if (ver == null) {
                    return;
                }
                bundleVersion = Version.parseVersion((String)ver);
            }
            catch (IOException iOException) {
                return;
            }
            catch (CoreException coreException) {
                return;
            }
            catch (BundleException bundleException) {
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser parser = parserFactory.newSAXParser();
                PomVersionHandler handler = new PomVersionHandler(pom, bundleVersion, severity);
                parser.parse(pom.getContents(), (DefaultHandler)handler);
            }
            catch (Exception exception) {
                return;
            }
        }
        IFile feature = project.getFile(FEATURE_PATH);
        if (feature.exists()) {
            try {
                Version featureVersion = Version.emptyVersion;
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser parser = parserFactory.newSAXParser();
                FeatureVersionHandler handler = new FeatureVersionHandler();
                try {
                    parser.parse(feature.getContents(), (DefaultHandler)handler);
                }
                catch (OperationCanceledException operationCanceledException) {}
                String version = handler.getVersion();
                if (version == null) {
                    return;
                }
                featureVersion = Version.parseVersion((String)version);
                PomVersionHandler pomHandler = new PomVersionHandler(pom, featureVersion, severity, true);
                parser.parse(pom.getContents(), (DefaultHandler)pomHandler);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void reportMarker(String message, int lineNumber, int charStart, int charEnd, String correctedVersion, IFile pom, String severity) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            if (severity.equals("Warning")) {
                attributes.put("severity", 1);
            } else {
                attributes.put("severity", 2);
            }
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            attributes.put("lineNumber", lineNumber);
            attributes.put("charStart", charStart);
            attributes.put("charEnd", charEnd);
            attributes.put("pom.CorrectVersion", correctedVersion);
            MarkerUtilities.createMarker((IResource)pom, attributes, (String)"org.eclipse.releng.tools.pomVersionProblem");
        }
        catch (CoreException e) {
            RelEngPlugin.log(e);
        }
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        try {
            manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
            ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument document = textBuf.getDocument();
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
            return document;
        }
        catch (CoreException e) {
            RelEngPlugin.log(e);
            return null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            PomResourceDeltaVisitor visitor = new PomResourceDeltaVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                RelEngPlugin.log(e);
            }
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.eclipse.releng.tools.invalidPomVersionErrorLevel".equals(event.getKey())) {
            String newSeverity = (String)event.getNewValue();
            Object oldSeverity = event.getOldValue();
            if (newSeverity != null) {
                if ("Ignore".equals(newSeverity)) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                } else if (oldSeverity == null || "Ignore".equals(oldSeverity)) {
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
                }
                this.validateWorkspace();
            }
        }
    }

    public void validateWorkspace() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            this.validate(projects[i]);
            ++i;
        }
        RelEngPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.releng.tools.workspaceValidated", 1);
    }

    class FeatureVersionHandler
    extends DefaultHandler {
        private String featureVersion;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.featureVersion = attributes.getValue(PomVersionErrorReporter.ELEMENT_VERSION);
            throw new OperationCanceledException();
        }

        public String getVersion() {
            return this.featureVersion;
        }
    }

    class PomResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        PomResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta != null) {
                IResource resource = delta.getResource();
                switch (resource.getType()) {
                    case 4: {
                        if (delta.getKind() == 2) {
                            return false;
                        }
                        IProject project = (IProject)resource;
                        try {
                            if (project.isAccessible() && (project.getDescription().hasNature("org.eclipse.pde.PluginNature") || project.getDescription().hasNature("org.eclipse.pde.FeatureNature"))) {
                                if ((delta.getFlags() & 0x4000) > 0) {
                                    PomVersionErrorReporter.this.validate(project);
                                    return false;
                                }
                                return true;
                            }
                        }
                        catch (CoreException ce) {
                            RelEngPlugin.log(ce);
                        }
                        return false;
                    }
                    case 2: 
                    case 8: {
                        return true;
                    }
                    case 1: {
                        switch (delta.getKind()) {
                            case 2: {
                                IProject p;
                                if (!resource.getProjectRelativePath().equals((Object)FEATURE_PATH) && !resource.getProjectRelativePath().equals((Object)MANIFEST_PATH) || !(p = resource.getProject()).isAccessible()) break;
                                PomVersionErrorReporter.this.cleanMarkers((IResource)p);
                                break;
                            }
                            case 1: {
                                if (!resource.getProjectRelativePath().equals((Object)FEATURE_PATH) && !resource.getProjectRelativePath().equals((Object)MANIFEST_PATH) && !resource.getProjectRelativePath().equals((Object)POM_PATH)) break;
                                PomVersionErrorReporter.this.validate(resource.getProject());
                                break;
                            }
                            case 4: {
                                if ((delta.getFlags() & 0x100) <= 0 || !resource.getProjectRelativePath().equals((Object)FEATURE_PATH) && !resource.getProjectRelativePath().equals((Object)MANIFEST_PATH) && !resource.getProjectRelativePath().equals((Object)POM_PATH)) break;
                                PomVersionErrorReporter.this.validate(resource.getProject());
                                break;
                            }
                        }
                        return false;
                    }
                }
            }
            return false;
        }
    }

    class PomVersionHandler
    extends DefaultHandler {
        private Version version;
        private Stack<String> elements = new Stack();
        private boolean checkVersion = false;
        private boolean isFeatureProject = false;
        private Locator locator;
        IFile pom = null;
        String severity = null;

        public PomVersionHandler(IFile file, Version bundleVersion, String pref) {
            this(file, bundleVersion, pref, false);
        }

        public PomVersionHandler(IFile file, Version version, String pref, boolean isFeatureProject) {
            this.pom = file;
            this.severity = pref;
            this.version = version;
            this.isFeatureProject = isFeatureProject;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (PomVersionErrorReporter.ELEMENT_VERSION.equals(qName) && !this.elements.isEmpty() && PomVersionErrorReporter.ELEMENT_PROJECT.equals(this.elements.peek())) {
                this.checkVersion = true;
            }
            this.elements.push(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elements.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.checkVersion) {
                this.checkVersion = false;
                try {
                    String versionString;
                    String origVer = versionString = new String(ch, start, length);
                    int index = versionString.indexOf(PomVersionErrorReporter.SNAPSHOT_SUFFIX);
                    if (index >= 0) {
                        versionString = versionString.substring(0, index);
                    }
                    Version bundleVersion2 = new Version(this.version.getMajor(), this.version.getMinor(), this.version.getMicro());
                    String correctedVersion = bundleVersion2.toString();
                    if (index >= 0) {
                        correctedVersion = correctedVersion.concat(PomVersionErrorReporter.SNAPSHOT_SUFFIX);
                    }
                    Version pomVersion = null;
                    try {
                        pomVersion = Version.parseVersion((String)versionString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        IDocument doc = PomVersionErrorReporter.this.createDocument(this.pom);
                        int lineOffset = doc.getLineOffset(this.locator.getLineNumber() - 1);
                        int linLength = doc.getLineLength(this.locator.getLineNumber() - 1);
                        String str = doc.get(lineOffset, linLength);
                        index = str.indexOf(origVer);
                        int charStart = lineOffset + index;
                        int charEnd = charStart + origVer.length();
                        String message = this.isFeatureProject ? Messages.PomVersionErrorReporter_pom_version_error_marker_message_feature : Messages.PomVersionErrorReporter_pom_version_error_marker_message;
                        PomVersionErrorReporter.this.reportMarker(NLS.bind((String)message, (Object)versionString, (Object)bundleVersion2.toString()), this.locator.getLineNumber(), charStart, charEnd, correctedVersion, this.pom, this.severity);
                    }
                    if (pomVersion == null) {
                        return;
                    }
                    Version pomVersion2 = new Version(pomVersion.getMajor(), pomVersion.getMinor(), pomVersion.getMicro());
                    if (!bundleVersion2.equals((Object)pomVersion2)) {
                        IDocument doc = PomVersionErrorReporter.this.createDocument(this.pom);
                        int lineOffset = doc.getLineOffset(this.locator.getLineNumber() - 1);
                        int linLength = doc.getLineLength(this.locator.getLineNumber() - 1);
                        String str = doc.get(lineOffset, linLength);
                        index = str.indexOf(origVer);
                        int charStart = lineOffset + index;
                        int charEnd = charStart + origVer.length();
                        String message = this.isFeatureProject ? Messages.PomVersionErrorReporter_pom_version_error_marker_message_feature : Messages.PomVersionErrorReporter_pom_version_error_marker_message;
                        PomVersionErrorReporter.this.reportMarker(NLS.bind((String)message, (Object)pomVersion2.toString(), (Object)bundleVersion2.toString()), this.locator.getLineNumber(), charStart, charEnd, correctedVersion, this.pom, this.severity);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (BadLocationException e) {
                    RelEngPlugin.log(e);
                }
            }
        }
    }
}

