/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.releng.tools.GetBugsOperation;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.texteditor.SWTUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuildNotesPage
extends WizardPage {
    private static final String FOLDER_BIN = "bin";
    private static final String EXT_HTML = "html";
    private static final String BUILD_NOTES_HTML = "/build_notes.html";
    private String FILE_PATH_KEY = "BuildNotesPage.filePath";
    private String UPDATE_FILE_KEY = "BuildNotesPage.updateNotesButton";
    private Button updateNotesButton;
    private boolean updateNotesButtonChecked;
    private SyncInfoSet syncInfoSet;
    private IDialogSettings settings;
    private Text reportText;
    private Map<Integer, String> bugSummaryMap;
    private boolean validPath;
    private Text filePath;
    private Button browse;
    private IFile iFile;

    protected BuildNotesPage(String pageName, String title, IDialogSettings settings, ImageDescriptor image) {
        super(pageName, title, image);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        GridData data = new GridData(1808);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.updateNotesButton = new Button(composite, 32);
        this.updateNotesButton.setText(Messages.getString("BuildNotesPage.2"));
        this.updateNotesButton.setLayoutData((Object)data);
        this.updateNotesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildNotesPage.this.updateNotesButtonChecked = BuildNotesPage.this.updateNotesButton.getSelection();
                if (BuildNotesPage.this.updateNotesButtonChecked) {
                    BuildNotesPage.this.filePath.setEnabled(true);
                    BuildNotesPage.this.filePath.setText(BuildNotesPage.this.filePath.getText());
                    BuildNotesPage.this.browse.setEnabled(true);
                } else {
                    BuildNotesPage.this.filePath.setEnabled(false);
                    BuildNotesPage.this.setErrorMessage(null);
                    BuildNotesPage.this.browse.setEnabled(false);
                }
                BuildNotesPage.this.updateButtons();
            }
        });
        Label label = new Label(composite, 16384);
        label.setText(Messages.getString("BuildNotesPage.3"));
        data = new GridData(768);
        this.filePath = new Text(composite, 2048);
        this.filePath.setLayoutData((Object)data);
        this.filePath.addModifyListener(e -> {
            Path path = new Path(this.filePath.getText());
            this.validPath = false;
            if (!path.isEmpty()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (path.isValidPath(this.filePath.getText()) && file.getParent().exists()) {
                    if (path.getFileExtension().equals(EXT_HTML)) {
                        this.setErrorMessage(null);
                        this.validPath = true;
                        this.iFile = file;
                    } else {
                        this.setErrorMessage(Messages.getString("BuildNotesPage.5"));
                    }
                } else {
                    this.setErrorMessage(Messages.getString("BuildNotesPage.6"));
                }
            } else {
                this.setErrorMessage(Messages.getString("BuildNotesPage.7"));
            }
            this.updateButtons();
        });
        this.browse = new Button(composite, 8);
        this.browse.setText(Messages.getString("BuildNotesPage.8"));
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource iResource = BuildNotesPage.this.buildNotesFileDialog();
                if (iResource instanceof IFile) {
                    IFile iFile = (IFile)iResource;
                    BuildNotesPage.this.filePath.setText(iFile.getFullPath().toString());
                } else if (iResource instanceof IFolder) {
                    IFolder iFolder = (IFolder)iResource;
                    BuildNotesPage.this.filePath.setText(String.valueOf(iFolder.getFullPath().toString()) + BuildNotesPage.BUILD_NOTES_HTML);
                } else if (iResource instanceof IProject) {
                    IProject iProject = (IProject)iResource;
                    BuildNotesPage.this.filePath.setText(String.valueOf(iProject.getFullPath().toString()) + BuildNotesPage.BUILD_NOTES_HTML);
                }
            }
        });
        SWTUtil.setButtonDimensionHint((Button)this.browse);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.reportText = new Text(composite, 2634);
        this.reportText.setLayoutData((Object)data);
        this.initialize();
        this.setControl((Control)composite);
    }

    private void initialize() {
        this.initSelections();
    }

    private void initSelections() {
        if (this.settings == null || this.settings.get(this.UPDATE_FILE_KEY) == null || this.settings.get(this.FILE_PATH_KEY) == null) {
            this.updateNotesButton.setSelection(false);
            this.updateNotesButtonChecked = false;
            this.browse.setEnabled(false);
            this.filePath.setEnabled(false);
            return;
        }
        boolean b = this.settings.getBoolean(this.UPDATE_FILE_KEY);
        this.updateNotesButton.setSelection(b);
        this.updateNotesButtonChecked = b;
        this.filePath.setText(this.settings.get(this.FILE_PATH_KEY));
        this.browse.setEnabled(true);
        this.filePath.setEnabled(true);
    }

    public void updateButtons() {
        if (this.isUpdateNotesButtonChecked() && !this.getValidPath()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public void updateNotesFile() {
        if (this.bugSummaryMap != null && !this.filePath.isDisposed()) {
            Path path = new Path(this.filePath.getText());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile((IPath)path);
            if (file.exists()) {
                this.writeUpdate(file);
            } else if (file.getParent().exists()) {
                try {
                    this.getContainer().run(true, true, monitor -> {
                        monitor.beginTask(Messages.getString("BuildNotesPage.11"), 100);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
                        buffer.append("<html>\n\n");
                        buffer.append("<head>\n");
                        buffer.append("   <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
                        buffer.append("   <meta name=\"Build\" content=\"Build\">\n");
                        buffer.append("   <title>Eclipse Platform Release Notes (3.3) - JFace and Workbench</title>\n");
                        buffer.append("</head>\n\n");
                        buffer.append("<body>\n\n");
                        buffer.append("<h1>Eclipse Platform Build Notes (3.3)<br>\n");
                        buffer.append("JFace and Workbench</h1>");
                        try {
                            Throwable throwable = null;
                            Object var5_7 = null;
                            try (ByteArrayInputStream c = new ByteArrayInputStream(buffer.toString().getBytes());){
                                try {
                                    file.create((InputStream)c, true, monitor);
                                }
                                catch (CoreException e1) {
                                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e1);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e2) {
                            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e2);
                        }
                        monitor.done();
                    });
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
                catch (InterruptedException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
                this.writeUpdate(file);
            }
        }
    }

    public void writeUpdate(IFile file) {
        BufferedInputStream originalContents = null;
        try {
            int character;
            originalContents = new BufferedInputStream(file.getContents());
            StringBuffer buffer = new StringBuffer();
            while ((character = originalContents.read()) != -1) {
                buffer.append((char)character);
            }
            String marker = "</h1>";
            SimpleDateFormat formatter = new SimpleDateFormat("MMMM dd, yyyy, h:mm a");
            Date currentTime = new Date();
            String dateString = formatter.format(currentTime);
            dateString = dateString.replaceAll("AM", "a.m.");
            dateString = dateString.replaceAll("PM", "p.m.");
            int index = buffer.indexOf(marker) + marker.length();
            if (index != -1) {
                StringBuffer insertBuffer = new StringBuffer();
                insertBuffer.append("\n<p>Integration Build (" + dateString + ")</p>\n");
                insertBuffer.append("  <p>Problem reports updated</p>\n");
                insertBuffer.append("  <p>\n");
                for (Map.Entry<Integer, String> entry : this.bugSummaryMap.entrySet()) {
                    Integer bug = entry.getKey();
                    String summary = entry.getValue();
                    insertBuffer.append("<a href=\"https://bugs.eclipse.org/bugs/show_bug.cgi?id=");
                    insertBuffer.append(bug);
                    insertBuffer.append("\">Bug ");
                    insertBuffer.append(bug);
                    insertBuffer.append("</a. ");
                    insertBuffer.append(String.valueOf(summary) + "<br>\n");
                }
                insertBuffer.append("  </p>");
                buffer.insert(index, "\n" + insertBuffer.toString());
                try {
                    this.getContainer().run(true, true, monitor -> {
                        monitor.beginTask(Messages.getString("BuildNotesPage.38"), 100);
                        ByteArrayInputStream c = new ByteArrayInputStream(buffer.toString().getBytes());
                        try {
                            file.setContents((InputStream)c, true, true, monitor);
                            c.close();
                        }
                        catch (CoreException e1) {
                            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e1);
                        }
                        catch (IOException e2) {
                            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e2);
                        }
                        monitor.done();
                    });
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
                catch (InterruptedException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
        }
        catch (CoreException e) {
            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String tempText;
            this.reportText.setText("");
            GetBugsOperation getBugsOperation = new GetBugsOperation((ReleaseWizard)this.getWizard(), this.syncInfoSet);
            getBugsOperation.run(this);
            if (this.bugSummaryMap != null && (tempText = this.outputReport()) != null) {
                this.reportText.setText(tempText);
            }
        }
    }

    public IResource buildNotesFileDialog() {
        Object[] elements;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    IPath path = file.getFullPath();
                    if (path.getFileExtension().equals(BuildNotesPage.EXT_HTML)) {
                        return true;
                    }
                } else {
                    if (element instanceof IFolder) {
                        IFolder folder = (IFolder)element;
                        return !folder.getName().equals(BuildNotesPage.FOLDER_BIN);
                    }
                    if (element instanceof IProject) {
                        return true;
                    }
                }
                return false;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.getString("BuildNotesPage.42"));
        dialog.setMessage(Messages.getString("BuildNotesPage.43"));
        if (dialog.open() == 0 && (elements = dialog.getResult()) != null && elements.length > 0) {
            if (elements[0] instanceof IFile) {
                IFile iFile = (IFile)elements[0];
                return iFile;
            }
            if (elements[0] instanceof IFolder) {
                IFolder iFolder = (IFolder)elements[0];
                return iFolder;
            }
            if (elements[0] instanceof IProject) {
                IProject iProject = (IProject)elements[0];
                return iProject;
            }
        }
        return null;
    }

    public boolean isUpdateNotesButtonChecked() {
        return this.updateNotesButtonChecked;
    }

    public void setSyncInfoSet(SyncInfoSet syncInfoSet) {
        this.syncInfoSet = syncInfoSet;
    }

    public String outputReport() {
        StringBuffer buffer = new StringBuffer();
        if (this.bugSummaryMap.size() < 1) {
            buffer.append("The map file has been updated.\n");
        } else {
            buffer.append("The map file has been updated for the following Bug changes:\n");
            for (Map.Entry<Integer, String> entry : this.bugSummaryMap.entrySet()) {
                Integer bug = entry.getKey();
                String summary = entry.getValue();
                buffer.append("+ Bug " + bug + ". " + summary + "\n");
            }
        }
        buffer.append("\nThe following projects have changed:\n");
        IProject[] iProjects = ((ReleaseWizard)this.getWizard()).getSelectedProjects();
        int j = 0;
        while (j < iProjects.length) {
            buffer.append(String.valueOf(iProjects[j].getName()) + "\n");
            ++j;
        }
        return buffer.toString();
    }

    public void setMap(Map<Integer, String> map) {
        this.bugSummaryMap = map;
    }

    public boolean getValidPath() {
        return this.validPath;
    }

    public IFile getIFile() {
        return this.iFile;
    }

    public void saveSettings() {
        this.settings.put(this.UPDATE_FILE_KEY, this.updateNotesButtonChecked);
        this.settings.put(this.FILE_PATH_KEY, this.filePath.getText());
    }
}

