/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.releng.tools.MapEntry;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;

public class CVSTagHelper {
    private ArrayList<IResource> defaultTags;

    public CVSTag[] findMissingMapEntries(IResource[] resources) {
        this.defaultTags = new ArrayList();
        CVSTag[] tags = new CVSTag[resources.length];
        int i = 0;
        while (i < resources.length) {
            tags[i] = this.getTag(resources[i]);
            if (CVSTag.DEFAULT == tags[i]) {
                this.defaultTags.add(resources[i]);
            }
            ++i;
        }
        return tags;
    }

    public boolean warnAboutUnfoundMapEntries(String errorMessage) {
        if (this.defaultTags == null || this.defaultTags.size() <= 0) {
            return false;
        }
        String message = String.valueOf(errorMessage) + "\n";
        int i = 0;
        while (i < this.defaultTags.size()) {
            IResource aNotFoundResource = this.defaultTags.get(i);
            message = message.concat("\n" + aNotFoundResource.getName());
            ++i;
        }
        message = message.concat("\n\n" + Messages.getString("CVSTagHelper.1"));
        return !MessageDialog.openConfirm(null, (String)Messages.getString("CVSTagHelper.2"), (String)message);
    }

    private CVSTag getTag(IResource resource) {
        MapProject selectedMapProject = null;
        try {
            selectedMapProject = this.getSelectedMapProject();
            if (selectedMapProject == null) {
                CVSTag cVSTag = CVSTag.DEFAULT;
                return cVSTag;
            }
            MapEntry entry = selectedMapProject.getMapEntry(resource.getProject());
            if (entry == null) {
                CVSTag cVSTag = CVSTag.DEFAULT;
                return cVSTag;
            }
            CVSTag cVSTag = entry.getTag();
            return cVSTag;
        }
        finally {
            if (selectedMapProject != null) {
                selectedMapProject.dispose();
            }
        }
    }

    private MapProject getSelectedMapProject() {
        IPreferenceStore preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
        String path = preferenceStore.getString("defaultMapProject");
        if (path.length() <= 0) {
            return null;
        }
        try {
            return new MapProject(ResourcesPlugin.getWorkspace().getRoot().getProject(path));
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

