/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.releng.tools.CVSTagHelper;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.MapProjectSelectionWizard;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchSite;

public class CompareLocalToMap
extends WorkspaceAction {
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return CompareLocalToMap.hasProjectFromMapFile();
    }

    static boolean hasProjectFromMapFile() {
        String FOUND = new String();
        try {
            MapFile[] mapFiles = MapFile.findAllMapFiles((IResource)ResourcesPlugin.getWorkspace().getRoot());
            IResourceProxyVisitor visitor = resourceProxy -> {
                if (resourceProxy.getType() == 8) {
                    return true;
                }
                if (resourceProxy.getType() != 4 || !resourceProxy.isAccessible()) {
                    return false;
                }
                IProject project = (IProject)resourceProxy.requestResource();
                if (!RelEngPlugin.isShared(project)) {
                    return false;
                }
                if (CompareLocalToMap.contains(mapFiles, project)) {
                    throw new OperationCanceledException(FOUND);
                }
                return false;
            };
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
            return false;
        }
        catch (OperationCanceledException ex) {
            return ex.getMessage() == FOUND;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean contains(MapFile[] mapFiles, IProject project) {
        int i = 0;
        while (i < mapFiles.length) {
            if (mapFiles[i].contains(project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources;
        IPreferenceStore preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean("useDefaultMapProject") || preferenceStore.getString("defaultMapProject").length() <= 0) {
            MapProjectSelectionWizard wizard = new MapProjectSelectionWizard(Messages.getString("CompareLocalToMap.0"));
            wizard.execute(this.getShell());
            if (wizard.operationCancelled()) {
                return;
            }
        }
        if ((resources = this.getSelectedResources()).length == 0) {
            return;
        }
        CVSTagHelper tagHelper = new CVSTagHelper();
        CVSTag[] tags = tagHelper.findMissingMapEntries(resources);
        if (tags == null || tagHelper.warnAboutUnfoundMapEntries(Messages.getString("CompareLocalToMap.1"))) {
            return;
        }
        CVSCompareSubscriber s = new CVSCompareSubscriber(resources, tags, "Map Project");
        try {
            s.primeRemoteTree();
        }
        catch (CVSException e) {
            RelEngPlugin.log((CoreException)((Object)e));
        }
        CompareParticipant participant = new CompareParticipant(s);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        participant.refresh(resources, "Refreshing", "Refreshing", (IWorkbenchSite)this.getTargetPart().getSite());
    }
}

