/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.releng.tools.BuildNotesPage;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.ui.statushandlers.StatusManager;

public class GetBugsOperation {
    private static final CVSTag TAG_1_1 = new CVSTag("1.1", 2);
    private static final String BUG_DATABASE_PREFIX = "https://bugs.eclipse.org/bugs/show_bug.cgi?id=";
    private static final String BUG_DATABASE_POSTFIX = "&ctype=xml";
    private static final String SUM_OPEN_TAG = "<short_desc>";
    private static final String SUM_CLOSE_TAG = "</short_desc>";
    private static final String STATUS_OPEN_TAG = "<bug_status>";
    private static final String STATUS_CLOSE_TAG = "</bug_status";
    private static final String RES_OPEN_TAG = "<resolution>";
    private static final String RES_CLOSE_TAG = "</resolution>";
    private static final String RESOLVED = "RESOLVED";
    private static final String VERIFIED = "VERIFIED";
    private ReleaseWizard wizard;
    private SyncInfoSet syncInfoSet;
    private SyncInfo[] syncInfos;
    private Pattern bugPattern;

    protected GetBugsOperation(ReleaseWizard wizard, SyncInfoSet syncInfoSet) {
        this.wizard = wizard;
        this.syncInfoSet = syncInfoSet;
        this.bugPattern = Pattern.compile("bug (\\d+)", 66);
    }

    protected void run(BuildNotesPage page) {
        try {
            this.wizard.getContainer().run(true, true, monitor -> {
                monitor.beginTask(Messages.getString("GetBugsOperation.0"), 101);
                this.syncInfos = this.syncInfoSet.getSyncInfos();
                Set<Integer> bugTree = this.getBugNumbersFromComments(this.syncInfos, (IProgressMonitor)new SubProgressMonitor(monitor, 85, 2));
                Integer[] bugs = bugTree.toArray(new Integer[0]);
                Map<Integer, String> map = this.getBugzillaSummaries(bugs, (IProgressMonitor)new SubProgressMonitor(monitor, 15, 2));
                page.getShell().getDisplay().asyncExec(() -> page.setMap(map));
                monitor.done();
            });
        }
        catch (InterruptedException e) {
            CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
        }
    }

    protected Set<Integer> getBugNumbersFromComments(SyncInfo[] syncInfos, IProgressMonitor monitor) {
        monitor.beginTask("Scanning comments for bug numbers", syncInfos.length);
        TreeSet<Integer> set = new TreeSet<Integer>();
        int i = 0;
        while (i < syncInfos.length) {
            SyncInfo info = syncInfos[i];
            this.getBugNumbersForSyncInfo(info, monitor, set);
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return set;
    }

    private void getBugNumbersForSyncInfo(SyncInfo info, IProgressMonitor monitor, Set<Integer> set) {
        try {
            ICVSRemoteResource cvsRemoteResource;
            ICVSResource cvsLocal;
            ResourceSyncInfo rsync;
            CVSTag remoteTag = null;
            CVSTag localTag = null;
            IResource localResource = info.getLocal();
            if (localResource.exists() && (rsync = (cvsLocal = CVSWorkspaceRoot.getCVSResourceFor((IResource)localResource)).getSyncInfo()) != null) {
                localTag = new CVSTag(rsync.getRevision(), 2);
            }
            if (localTag == null) {
                localTag = this.getProjectTag(localResource.getProject());
            }
            if ((cvsRemoteResource = (ICVSRemoteResource)info.getRemote()) == null) {
                cvsRemoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)localResource);
                remoteTag = TAG_1_1;
            } else {
                rsync = cvsRemoteResource.getSyncInfo();
                if (rsync != null) {
                    remoteTag = new CVSTag(rsync.getRevision(), 2);
                }
            }
            if (remoteTag == null) {
                remoteTag = TAG_1_1;
            }
            RemoteLogOperation.LogEntryCache cache = new RemoteLogOperation.LogEntryCache();
            RemoteLogOperation logOp = new RemoteLogOperation(null, new ICVSRemoteResource[]{cvsRemoteResource}, localTag, remoteTag, cache);
            logOp.run(monitor);
            ILogEntry[] logEntries = cache.getLogEntries(cvsRemoteResource);
            int i = 0;
            while (i < logEntries.length) {
                ILogEntry entry = logEntries[i];
                if (!entry.getRevision().equals(remoteTag.getName()) || remoteTag == TAG_1_1) {
                    this.findBugNumber(entry.getComment(), set);
                }
                ++i;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
        }
        catch (InterruptedException e) {
            CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
        }
    }

    private CVSTag getProjectTag(IProject project) {
        IFile dotProject = project.getFile(".project");
        if (dotProject.exists()) {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)dotProject);
            try {
                CVSTag tag;
                if (cvsResource != null && cvsResource.getSyncInfo() != null && (tag = cvsResource.getSyncInfo().getTag()) != null) {
                    return tag;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.openError((Shell)this.wizard.getShell(), null, null, (Throwable)e);
            }
        }
        return new CVSTag();
    }

    protected void findBugNumber(String comment, Set<Integer> set) {
        if (comment == null) {
            return;
        }
        Matcher matcher = this.bugPattern.matcher(comment);
        while (matcher.find()) {
            Integer bugNumber = Integer.valueOf(matcher.group(1));
            set.add(bugNumber);
        }
    }

    protected Map<Integer, String> getBugzillaSummaries(Integer[] bugs, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("GetBugsOperation.1"), bugs.length + 1);
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int i = 0;
        while (i < bugs.length) {
            try {
                URLConnection url = new URL(BUG_DATABASE_PREFIX + bugs[i] + BUG_DATABASE_POSTFIX).openConnection();
                if (url instanceof HttpURLConnection) {
                    HttpURLConnection hURL = (HttpURLConnection)url;
                    hURL.setAllowUserInteraction(true);
                    hURL.connect();
                    DataInputStream in = new DataInputStream(hURL.getInputStream());
                    StringBuffer buffer = new StringBuffer();
                    try {
                        if (hURL.getResponseCode() != 200) {
                            throw new IOException("Bad response code");
                        }
                        while (true) {
                            buffer.append((char)in.readUnsignedByte());
                        }
                    }
                    catch (EOFException eOFException) {
                        hURL.disconnect();
                        String webPage = buffer.toString();
                        int summaryStartIndex = webPage.indexOf(SUM_OPEN_TAG);
                        int summaryEndIndex = webPage.indexOf(SUM_CLOSE_TAG, summaryStartIndex);
                        if (summaryStartIndex != -1 & summaryEndIndex != -1) {
                            String summary = webPage.substring(summaryStartIndex + SUM_OPEN_TAG.length(), summaryEndIndex);
                            summary = summary.replaceAll("&quot;", "\"");
                            summary = summary.replaceAll("&lt;", "<");
                            summary = summary.replaceAll("&gt;", ">");
                            summary = summary.replaceAll("&amp;", "&");
                            summary = summary.replaceAll("&apos;", "'");
                            int statusStartIndex = webPage.indexOf(STATUS_OPEN_TAG);
                            int statusEndIndex = webPage.indexOf(STATUS_CLOSE_TAG);
                            if (statusStartIndex != -1 && statusEndIndex != -1) {
                                String bugStatus = webPage.substring(statusStartIndex + STATUS_OPEN_TAG.length(), statusEndIndex);
                                if (bugStatus.equalsIgnoreCase(RESOLVED) || bugStatus.equalsIgnoreCase(VERIFIED)) {
                                    String resolution;
                                    int resStartIndex = webPage.indexOf(RES_OPEN_TAG);
                                    int resEndIndex = webPage.indexOf(RES_CLOSE_TAG);
                                    if (resStartIndex != -1 && resEndIndex != -1 && (resolution = webPage.substring(resStartIndex + RES_OPEN_TAG.length(), resEndIndex)) != null && !resolution.equals("")) {
                                        summary = String.valueOf(summary) + " (" + resolution + ")";
                                    }
                                } else {
                                    summary = String.valueOf(summary) + " (" + bugStatus + ")";
                                }
                            }
                            map.put(bugs[i], summary);
                        }
                    }
                }
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.releng.tools", Messages.getString("GetBugsOperation.Error"), (Throwable)e), 3);
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return map;
    }
}

