/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.releng.tools.MapEntry;
import org.eclipse.releng.tools.RelEngPlugin;

public class MapFile {
    @Deprecated
    public static final String MAP_FILE_EXTENSION = "map";
    private static final String MAP_FILE_NAME_ENDING = ".map";
    protected IFile file;
    protected MapEntry[] entries;

    public MapFile(IFile aFile) throws CoreException {
        this.file = aFile;
        this.loadEntries();
    }

    public IFile getFile() {
        return this.file;
    }

    protected void loadEntries() throws CoreException {
        ArrayList<MapEntry> list = new ArrayList<MapEntry>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.file.getContents();){
                BufferedReader aReader = new BufferedReader(new InputStreamReader(inputStream));
                String aLine = aReader.readLine();
                while (aLine != null) {
                    if (this.isMapLine(aLine)) {
                        list.add(new MapEntry(aLine));
                    }
                    aLine = aReader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.releng.tools", 0, "An I/O Error occurred process map file " + this.file.getFullPath().toString(), (Throwable)e));
        }
        this.entries = list.toArray(new MapEntry[list.size()]);
    }

    private boolean isMapLine(String line) {
        if (line.trim().length() == 0) {
            return false;
        }
        return !line.startsWith("!");
    }

    public boolean contains(IProject project) {
        int j = 0;
        while (j < this.entries.length) {
            if (this.entries[j].isMappedTo(project)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public MapEntry getMapEntry(IProject project) {
        int j = 0;
        while (j < this.entries.length) {
            if (this.entries[j].isMappedTo(project)) {
                return this.entries[j];
            }
            ++j;
        }
        return null;
    }

    public IProject[] getAccessibleProjects() {
        HashSet<IProject> list = new HashSet<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (this.entries == null || this.entries.length == 0) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isAccessible()) {
                int j = 0;
                while (j < this.entries.length) {
                    if (this.entries[j].isMappedTo(project)) {
                        list.add(project);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IProject[list.size()]);
    }

    public String getName() {
        return this.file.getName();
    }

    public static MapFile[] findAllMapFiles(IResource resource) throws CoreException {
        ArrayList mapFiles = new ArrayList();
        IResourceProxyVisitor visitor = resourceProxy -> {
            if (!resourceProxy.isAccessible()) {
                return false;
            }
            int type = resourceProxy.getType();
            if (type == 4) {
                return RelEngPlugin.isShared((IProject)resourceProxy.requestResource());
            }
            if (type == 1 && resourceProxy.getName().endsWith(MAP_FILE_NAME_ENDING)) {
                mapFiles.add(new MapFile((IFile)resourceProxy.requestResource()));
            }
            return true;
        };
        resource.accept(visitor, 0);
        return mapFiles.toArray(new MapFile[mapFiles.size()]);
    }

    public static boolean isMapFile(IFile aFile) {
        return MAP_FILE_EXTENSION.equals(aFile.getFileExtension());
    }
}

