/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.releng.tools.MapContentDocument;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class MapFileCompareEditorInput
extends CompareEditorInput {
    private MapContentDocument[] documents = new MapContentDocument[0];
    private DiffNode root = new DiffNode(0){

        public boolean hasChildren() {
            return true;
        }
    };
    private Viewer viewer;
    private MapProject mapProject = null;
    private IProject[] selectedProjects;
    private String tag;

    public MapFileCompareEditorInput() {
        super(new CompareConfiguration());
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        CompareConfiguration config = this.getCompareConfiguration();
        config.setRightEditable(false);
        config.setLeftEditable(false);
        config.setRightLabel("Proposed change");
        config.setLeftLabel("Current content");
        return this.root;
    }

    public void updateInput(IProject[] projects, String tag) {
        this.setSelectedProjects(projects);
        this.setTag(tag);
        MapContentDocument[] docs = this.constructDocuments();
        this.setDocuments(docs);
        this.buildTree();
    }

    public Viewer createDiffViewer(Composite parent) {
        this.viewer = super.createDiffViewer(parent);
        this.viewer.setInput((Object)this);
        return this.viewer;
    }

    public void updateMapProject(MapProject m) {
        this.mapProject = m;
    }

    private void setDocuments(MapContentDocument[] docs) {
        this.documents = docs;
    }

    private void buildTree() {
        int i;
        if (this.documents == null || this.documents.length == 0) {
            return;
        }
        if (this.root.hasChildren()) {
            IDiffElement[] children = this.root.getChildren();
            i = 0;
            while (i < children.length) {
                this.root.remove(children[i]);
                ++i;
            }
        }
        DiffNode[] diffNodes = new DiffNode[this.documents.length];
        i = 0;
        while (i < diffNodes.length) {
            ResourceNode resourceNode = new ResourceNode((IResource)this.documents[i].getMapFile().getFile()){

                public boolean isEditable() {
                    return false;
                }
            };
            diffNodes[i] = new DiffNode((IDiffContainer)this.root, 3, null, (ITypedElement)resourceNode, this.documents[i]){

                public Image getImage() {
                    return this.getLeft().getImage();
                }
            };
            ++i;
        }
        this.viewer.refresh();
    }

    private MapFile[] getChangedMapFiles() {
        if (this.selectedProjects == null || this.selectedProjects.length == 0) {
            return null;
        }
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        CVSTag[] tags = this.mapProject.getTagsFor(this.selectedProjects);
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (!tags[i].getName().equals(this.tag)) {
                projectList.add(this.selectedProjects[i]);
            }
            ++i;
        }
        IProject[] projects = projectList.toArray(new IProject[projectList.size()]);
        return this.mapProject.getMapFilesFor(projects);
    }

    private MapContentDocument[] constructDocuments() {
        MapFile[] mapFiles = this.getChangedMapFiles();
        if (mapFiles == null || mapFiles.length == 0) {
            return null;
        }
        MapContentDocument[] docs = new MapContentDocument[mapFiles.length];
        int i = 0;
        while (i < mapFiles.length) {
            docs[i] = new MapContentDocument(mapFiles[i]);
            int j = 0;
            while (j < this.selectedProjects.length) {
                if (mapFiles[i].contains(this.selectedProjects[j])) {
                    try {
                        docs[i].updateTag(this.selectedProjects[j], this.tag);
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.openError(null, null, null, (Throwable)e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return docs;
    }

    private void setSelectedProjects(IProject[] projects) {
        if (projects != null && projects.length != 0) {
            this.selectedProjects = new IProject[projects.length];
            System.arraycopy(projects, 0, this.selectedProjects, 0, projects.length);
        }
    }

    private void setTag(String t) {
        this.tag = t;
    }
}

