/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class MapProjectSelectionPage
extends WizardPage {
    private MapProject selectedMapProject;
    private IDialogSettings settings;
    private ListViewer mapProjectListViewer;
    protected Button useDefaultProjectButton;
    protected boolean useDefaultMapProject;
    private final String SELECTED_PROJECT_KEY = "Selected Project";

    public MapProjectSelectionPage(String pageName, String title, IDialogSettings settings, ImageDescriptor image) {
        super(pageName, title, image);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Composite topContainer = new Composite(parent, 0);
        topContainer.setLayout((Layout)new GridLayout());
        topContainer.setLayoutData((Object)new GridData(1808));
        this.mapProjectListViewer = this.createListViewer(topContainer);
        this.mapProjectListViewer.setInput(MapProjectSelectionPage.getMapFileProjects());
        this.useDefaultProjectButton = new Button(topContainer, 32);
        this.useDefaultProjectButton.setText(Messages.getString("MapProjectSelectionPage.0"));
        this.useDefaultProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapProjectSelectionPage.this.useDefaultMapProject = MapProjectSelectionPage.this.useDefaultProjectButton.getSelection();
                MapProjectSelectionPage.this.updateOthers();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.initializedViewer();
        this.setControl((Control)topContainer);
    }

    protected ListViewer createListViewer(Composite parent) {
        List tree = new List(parent, 2564);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 15;
        tree.setLayoutData((Object)gd);
        ListViewer result = new ListViewer(tree);
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set projects = (Set)inputElement;
                return projects.toArray(new IProject[projects.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addSelectionChangedListener(event -> this.updateOthers());
        result.setComparator((ViewerComparator)new ResourceComparator(1));
        return result;
    }

    private static Set<IProject> getMapFileProjects() {
        MapFile[] mapFiles;
        HashSet<IProject> projects = new HashSet<IProject>();
        try {
            mapFiles = MapFile.findAllMapFiles((IResource)RelEngPlugin.getWorkspace().getRoot());
        }
        catch (CoreException coreException) {
            return Collections.emptySet();
        }
        int i = 0;
        while (i < mapFiles.length) {
            projects.add(mapFiles[i].getFile().getProject());
            ++i;
        }
        Iterator iterator = projects.iterator();
        while (iterator.hasNext()) {
            MapProject mapProject = null;
            try {
                try {
                    mapProject = new MapProject((IProject)iterator.next());
                    if (mapProject.getValidMapFiles().length == 0) {
                        iterator.remove();
                    }
                }
                catch (CoreException coreException) {
                    iterator.remove();
                    if (mapProject == null) continue;
                    mapProject.dispose();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (mapProject != null) {
                    mapProject.dispose();
                }
                throw throwable;
            }
            if (mapProject == null) continue;
            mapProject.dispose();
        }
        return projects;
    }

    private void updateMapProject() {
        Object obj;
        IStructuredSelection selection;
        if (this.selectedMapProject != null) {
            this.selectedMapProject.dispose();
            this.selectedMapProject = null;
        }
        if (!(selection = (IStructuredSelection)this.mapProjectListViewer.getSelection()).isEmpty() && (obj = selection.getFirstElement()) instanceof IProject) {
            try {
                this.selectedMapProject = new MapProject((IProject)obj);
            }
            catch (CoreException coreException) {
                this.selectedMapProject = null;
            }
        }
        this.setPageComplete(this.isValid(this.selectedMapProject));
    }

    public void dispose() {
        if (this.selectedMapProject != null) {
            this.selectedMapProject.dispose();
            this.selectedMapProject = null;
        }
        super.dispose();
    }

    private void initializedViewer() {
        this.readSettings();
        this.updateOthers();
    }

    protected void updateOthers() {
        this.updateMapProject();
    }

    private void readSettings() {
        String name = this.settings.get("Selected Project");
        if (name != null) {
            StructuredSelection selection = new StructuredSelection((Object)RelEngPlugin.getWorkspace().getRoot().getProject(name));
            this.mapProjectListViewer.setSelection((ISelection)selection);
        }
        this.mapProjectListViewer.getList().setFocus();
    }

    public void saveSettings() {
        Object obj;
        IStructuredSelection selection = (IStructuredSelection)this.mapProjectListViewer.getSelection();
        if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof IProject) {
            this.settings.put("Selected Project", ((IProject)obj).getName());
        }
    }

    private boolean isValid(MapProject mapProject) {
        if (mapProject == null || !mapProject.getProject().isAccessible()) {
            this.setErrorMessage(Messages.getString("MapProjectSelectionPage.1"));
            return false;
        }
        if (RepositoryProvider.getProvider((IProject)mapProject.getProject()) == null) {
            this.setErrorMessage(String.valueOf(Messages.getString("MapProjectSelectionPage.2")) + mapProject.getProject().getName() + Messages.getString("MapProjectSelectionPage.3"));
            return false;
        }
        this.setErrorMessage(null);
        if (this.getWizard() instanceof ReleaseWizard) {
            ((ReleaseWizard)this.getWizard()).broadcastMapProjectChange(mapProject);
        }
        return true;
    }

    protected MapProject getSelectedMapProject() {
        return this.selectedMapProject;
    }

    protected boolean useDefaultMapProject() {
        return this.useDefaultMapProject;
    }
}

