/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.releng.tools.MapProjectSelectionPage;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class MapProjectSelectionWizard
extends Wizard {
    private static final String BOUNDS_HEIGHT = "bounds.height";
    private static final String BOUNDS_WIDTH = "bounds.width";
    private static final String BOUNDS_Y = "bounds.y";
    private static final String BOUNDS_X = "bounds.x";
    private boolean operationCancelled;
    private IPreferenceStore preferenceStore;
    private IDialogSettings section;
    private MapProjectSelectionPage mapProjectSelectionPage;

    public MapProjectSelectionWizard(String aTitle) {
        this.setWindowTitle(aTitle);
        IDialogSettings settings = RelEngPlugin.getDefault().getDialogSettings();
        this.section = settings.getSection("MapProjectSelectionWizard");
        if (this.section == null) {
            this.section = settings.addNewSection("MapProjectSelectionWizard");
        }
        this.setDialogSettings(this.section);
        this.operationCancelled = false;
        this.preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.getDialogSettings().get(BOUNDS_X) != null) {
            int x = this.getDialogSettings().getInt(BOUNDS_X);
            int y = this.getDialogSettings().getInt(BOUNDS_Y);
            int width = this.getDialogSettings().getInt(BOUNDS_WIDTH);
            int height = this.getDialogSettings().getInt(BOUNDS_HEIGHT);
            this.getShell().setBounds(x, y, width, height);
        }
        this.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                this.storeBounds(e);
            }

            public void controlResized(ControlEvent e) {
                this.storeBounds(e);
            }

            private void storeBounds(ControlEvent e) {
                Rectangle bounds = MapProjectSelectionWizard.this.getShell().getBounds();
                MapProjectSelectionWizard.this.getDialogSettings().put(MapProjectSelectionWizard.BOUNDS_X, bounds.x);
                MapProjectSelectionWizard.this.getDialogSettings().put(MapProjectSelectionWizard.BOUNDS_Y, bounds.y);
                MapProjectSelectionWizard.this.getDialogSettings().put(MapProjectSelectionWizard.BOUNDS_WIDTH, bounds.width);
                MapProjectSelectionWizard.this.getDialogSettings().put(MapProjectSelectionWizard.BOUNDS_HEIGHT, bounds.height);
            }
        });
    }

    public boolean execute(Shell shell) {
        this.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)this);
        return dialog.open() == 0;
    }

    public void addPages() {
        this.mapProjectSelectionPage = new MapProjectSelectionPage("MapProjectSelectionPage", Messages.getString("MapProjectSelectionWizard.1"), this.section, TeamUIPlugin.getImageDescriptor((String)"wizban/share_wizban.png"));
        this.mapProjectSelectionPage.setDescription(Messages.getString("MapProjectSelectionWizard.2"));
        this.addPage((IWizardPage)this.mapProjectSelectionPage);
    }

    public boolean performFinish() {
        this.mapProjectSelectionPage.saveSettings();
        this.preferenceStore.setValue("useDefaultMapProject", this.mapProjectSelectionPage.useDefaultMapProject());
        String fullPath = this.mapProjectSelectionPage.getSelectedMapProject().getProject().getFullPath().toString();
        this.preferenceStore.setValue("defaultMapProject", fullPath);
        return true;
    }

    public boolean performCancel() {
        this.operationCancelled = true;
        return true;
    }

    public boolean operationCancelled() {
        return this.operationCancelled;
    }
}

