/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderedMap<K, V> {
    private List<K> keys = new ArrayList<K>();
    private List<V> values = new ArrayList<V>();

    public void clear() {
        this.keys = new ArrayList<K>();
        this.values = new ArrayList<V>();
    }

    public boolean containsKey(K key) {
        Iterator<K> iter = this.keys.iterator();
        while (iter.hasNext()) {
            if (!key.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(V value) {
        Iterator<V> iter = this.values.iterator();
        while (iter.hasNext()) {
            if (!value.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public V get(K key) {
        int index = this.indexOf(key);
        return index == -1 ? null : (V)this.values.get(index);
    }

    private int indexOf(Object key) {
        int length = this.keys.size();
        int i = 0;
        while (i < length) {
            K tempKey = this.keys.get(i);
            if (key.equals(tempKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    public V put(K key, V value) {
        int index = this.indexOf(key);
        if (index == -1) {
            this.keys.add(key);
            this.values.add(value);
            return null;
        }
        V oldValue = this.values.get(index);
        this.values.set(index, value);
        return oldValue;
    }

    public void putAll(Map<K, V> other) {
        for (Map.Entry<K, V> entry : other.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(K key) {
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.keys.remove(index);
        return this.values.remove(index);
    }

    public int size() {
        return this.keys.size();
    }

    public Collection<V> values() {
        return this.values;
    }

    public Collection<K> keys() {
        return this.keys;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (K key : this.keys()) {
            V value = this.get(key);
            result.append(key);
            result.append('=');
            result.append(value);
            result.append(",\n");
        }
        if (result.length() > 2) {
            result = result.deleteCharAt(result.length() - 1);
            result = result.deleteCharAt(result.length() - 1);
        }
        result.append("}");
        return result.toString();
    }
}

