/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;
import org.eclipse.ui.part.PageBook;

public class ProjectComparePage
extends WizardPage {
    private IDialogSettings settings;
    private String NOTES_BUTTON_KEY = "ProjectComparePage.buildNotesButton";
    private SyncInfoSet syncInfoSet;
    private Button buildNotesButton;
    private boolean buildNotesButtonChecked;
    private PageBook pageBook;
    private Control compareView;
    private Label noneChangeMessage;
    private MapProject mapProject;
    private ISynchronizePageConfiguration configuration;
    private ParticipantPageSaveablePart input;

    public ProjectComparePage(String pageName, String title, IDialogSettings settings, ImageDescriptor image) {
        super(pageName, title, image);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        GridData data = new GridData(1808);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.pageBook.setFont(font);
        this.input = this.createCompareInput();
        this.input.createPartControl((Composite)this.pageBook);
        this.compareView = this.input.getControl();
        this.compareView.setFont(font);
        this.compareView.setLayoutData((Object)data);
        this.noneChangeMessage = new Label((Composite)this.pageBook, 64);
        this.noneChangeMessage.setText(Messages.getString("ProjectComparePage.1"));
        this.noneChangeMessage.setLayoutData((Object)data);
        this.noneChangeMessage.setFont(font);
        this.buildNotesButton = new Button(composite, 32);
        this.buildNotesButton.setText(Messages.getString("ProjectComparePage.2"));
        this.buildNotesButton.setFont(font);
        this.buildNotesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectComparePage.this.buildNotesButtonChecked = ProjectComparePage.this.buildNotesButton.getSelection();
            }
        });
        this.initialize();
        this.setControl((Control)composite);
    }

    private void initialize() {
        this.initBuildNotesButton();
    }

    private void initBuildNotesButton() {
        if (this.settings == null || this.settings.get(this.NOTES_BUTTON_KEY) == null) {
            this.buildNotesButton.setSelection(false);
            this.buildNotesButtonChecked = false;
            return;
        }
        boolean b = this.settings.getBoolean(this.NOTES_BUTTON_KEY);
        this.buildNotesButton.setSelection(b);
        this.buildNotesButtonChecked = b;
    }

    public void setVisible(boolean visible) {
        block6: {
            super.setVisible(visible);
            if (visible) {
                ReleaseWizard wizard = (ReleaseWizard)this.getWizard();
                try {
                    wizard.updateSelectedProject();
                    IProject[] projects = wizard.getSelectedProjects();
                    CVSTag[] tags = this.mapProject.getTagsFor(projects);
                    this.getContainer().run(true, true, monitor -> {
                        IResource[] r = null;
                        if (projects != null && projects.length != 0) {
                            try {
                                r = this.getOutOfSyncProjects(projects, tags, monitor);
                                wizard.setSelectedProjects(r);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    if (wizard.getSelectedProjects() == null || wizard.getSelectedProjects().length == 0) {
                        this.setPageComplete(false);
                        this.pageBook.showPage((Control)this.noneChangeMessage);
                        break block6;
                    }
                    this.setPageComplete(true);
                    this.pageBook.showPage(this.compareView);
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
                catch (InterruptedException e) {
                    CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
                }
            } else {
                this.setPageComplete(true);
            }
        }
    }

    public void updateMapProject(MapProject m) {
        this.mapProject = m;
    }

    private ParticipantPageSaveablePart createCompareInput() {
        CompareParticipant participant = new CompareParticipant(new CVSCompareSubscriber(new IResource[0], new CVSTag[0], Messages.getString("ProjectComparePage.3")));
        this.configuration = participant.createPageConfiguration();
        this.configuration.setMenuGroups("org.eclipse.team.ui.P_TOOLBAR_MENU", new String[]{"navigate", "layout", "ChangeSet"});
        this.configuration.setMenuGroups("org.eclipse.team.ui.P_CONTEXT_MENU", new String[0]);
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        ParticipantPageSaveablePart part = new ParticipantPageSaveablePart(this.getShell(), cc, this.configuration, (ISynchronizeParticipant)participant);
        this.setPageComplete(true);
        return part;
    }

    public void dispose() {
        super.dispose();
        this.input.getParticipant().dispose();
        this.input.dispose();
    }

    public IResource[] getOutOfSyncProjects(IProject[] projects, CVSTag[] tags, IProgressMonitor monitor) throws TeamException {
        CompareParticipant participant = (CompareParticipant)this.input.getParticipant();
        CVSCompareSubscriber subscriber = (CVSCompareSubscriber)participant.getSubscriber();
        subscriber.resetRoots((IResource[])projects, tags);
        try {
            subscriber.primeRemoteTree();
        }
        catch (CVSException e) {
            RelEngPlugin.log((CoreException)((Object)e));
        }
        participant.refreshNow((IResource[])projects, "", monitor);
        IResource[] r = participant.getSyncInfoSet().members((IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.syncInfoSet = participant.getSyncInfoSet();
        return r;
    }

    public boolean isBuildNotesButtonChecked() {
        return this.buildNotesButtonChecked;
    }

    public SyncInfoSet getSyncInfoSet() {
        return this.syncInfoSet;
    }

    public void saveSettings() {
        this.settings.put(this.NOTES_BUTTON_KEY, this.buildNotesButtonChecked);
    }
}

