/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.releng.tools.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.ui.SaveablePartAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageDialog;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;

public class ProjectValidationDialog
extends ParticipantPageDialog {
    private String title = Messages.getString("ProjectValidationDialog.2");

    public static void validateRelease(Shell shell, IProject[] p, CVSTag[] tags, IProgressMonitor monitor) throws TeamException {
        CompareParticipant participant = new CompareParticipant(new CVSCompareSubscriber((IResource[])p, tags, Messages.getString("ReleaseWizard.26")));
        try {
            participant.refreshNow((IResource[])p, Messages.getString("ReleaseWizard.20"), monitor);
            if (!monitor.isCanceled() && !participant.getSyncInfoSet().isEmpty()) {
                Display.getDefault().syncExec(() -> {
                    if (MessageDialog.openQuestion((Shell)shell, (String)"Workspace Differs From Released Contents", (String)"The local workspace contents does not match what is released. There is a good chance that the release failed. Do you want to see the difference?")) {
                        ProjectValidationDialog.openValidationFailedDialog(shell, participant);
                    }
                });
            }
        }
        finally {
            participant.dispose();
        }
    }

    private static void openValidationFailedDialog(Shell shell, CompareParticipant participant) {
        ISynchronizePageConfiguration configuration = participant.createPageConfiguration();
        configuration.setMenuGroups("org.eclipse.team.ui.P_TOOLBAR_MENU", new String[]{"navigate", "layout", "ChangeSet"});
        configuration.setMenuGroups("org.eclipse.team.ui.P_CONTEXT_MENU", new String[0]);
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        ParticipantPageSaveablePart part = new ParticipantPageSaveablePart(shell, cc, configuration, (ISynchronizeParticipant)participant);
        try {
            ProjectValidationDialog dialog = new ProjectValidationDialog(shell, (SaveablePartAdapter)part, (ISynchronizeParticipant)participant);
            dialog.open();
        }
        finally {
            part.dispose();
        }
    }

    public ProjectValidationDialog(Shell shell, SaveablePartAdapter input, ISynchronizeParticipant participant) {
        super(shell, input, participant);
        shell.setText(this.title);
    }
}

