/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.releng.tools.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RepositorySelectionDialog
extends Dialog {
    ICVSRepositoryLocation[] locations;
    ICVSRepositoryLocation location;
    private static final int TABLE_HEIGHT_HINT = 150;
    private static final int TABLE_WIDTH_HINT = 300;
    TableViewer viewer;
    Button okButton;

    public RepositorySelectionDialog(Shell shell) {
        super(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("RepositorySelectionDialog.0"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createLabel(composite, Messages.getString("RepositorySelectionDialog.1"), 1);
        Table table = new Table(composite, 2820);
        GridData data = new GridData();
        data.widthHint = 300;
        data.heightHint = 150;
        table.setLayoutData((Object)data);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object inputElement) {
                return RepositorySelectionDialog.this.locations;
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.location = null;
                this.okButton.setEnabled(false);
            } else {
                this.location = (ICVSRepositoryLocation)selection.getFirstElement();
                this.okButton.setEnabled(true);
            }
        });
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        this.viewer.setInput((Object)this.locations);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void cancelPressed() {
        this.location = null;
        super.cancelPressed();
    }

    public void setLocations(ICVSRepositoryLocation[] locations) {
        this.locations = locations;
    }

    public ICVSRepositoryLocation getLocation() {
        return this.location;
    }
}

