/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.ReleaseWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.internal.ccvs.core.CVSTag;

public class TagPage
extends WizardPage {
    private String tagString;
    private Combo tagCombo;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private final String DEFAULT_TAG_PREFIX = "v";
    private Button moveButton;
    private Button validateButton;
    private Button compareButton;
    private Button commitButton;
    private boolean moveButtonSelected;
    private boolean compareButtonSelected;
    private boolean commitButtonSelected;
    private boolean validateButtonSelected;
    private boolean hasError;
    private IDialogSettings settings;
    private String TAG_KEY = Messages.getString("TagPage.1");
    private String COMPARE_BUTTON_KEY = Messages.getString("TagPage.2");
    private String COMMIT_BUTTON_KEY = Messages.getString("TagPage.3");
    private String MOVE_BUTTON_KEY = Messages.getString("TagPage.4");
    private String VALIDATE_BUTTON_KEY = Messages.getString("TagPage.5");

    public TagPage(String pageName, String title, IDialogSettings settings, ImageDescriptor image) {
        super(pageName, title, image);
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label label = new Label(composite, 256);
        label.setText(Messages.getString("TagPage.6"));
        label.setLayoutData((Object)new GridData(768));
        label.setFont(font);
        Listener listener = event -> {
            this.tagString = null;
            this.modifyTag();
        };
        this.tagCombo = new Combo(composite, 0);
        this.tagCombo.addListener(13, listener);
        this.tagCombo.addListener(24, listener);
        this.tagCombo.setLayoutData((Object)new GridData(768));
        this.tagCombo.setFont(font);
        this.moveButton = new Button(composite, 32);
        this.moveButton.setVisible(true);
        this.moveButton.setText(Messages.getString("TagPage.7"));
        this.moveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagPage.this.moveButtonSelected = TagPage.this.moveButton.getSelection();
            }
        });
        this.moveButton.setFont(font);
        this.validateButton = new Button(composite, 32);
        this.validateButton.setText(Messages.getString("TagPage.8"));
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagPage.this.validateButtonSelected = TagPage.this.validateButton.getSelection();
            }
        });
        this.validateButton.setFont(font);
        Group group = new Group(composite, 16384);
        group.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 2, true, false);
        group.setLayoutData((Object)layoutData);
        group.setFont(font);
        group.setText(Messages.getString("TagPage.9"));
        this.compareButton = new Button((Composite)group, 16);
        this.compareButton.setText(Messages.getString("TagPage.10"));
        this.compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagPage.this.compareButtonSelected = TagPage.this.compareButton.getSelection();
                TagPage.this.updateFinishStatus();
            }
        });
        this.compareButton.setFont(font);
        this.commitButton = new Button((Composite)group, 16);
        this.commitButton.setText(Messages.getString("TagPage.11"));
        this.commitButton.setSelection(true);
        this.commitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagPage.this.commitButtonSelected = TagPage.this.commitButton.getSelection();
            }
        });
        this.commitButton.setFont(font);
        this.initializePage();
        this.setControl((Control)composite);
    }

    public String getTagString() {
        return this.tagString;
    }

    private void validateTag(String tag) {
        String message = null;
        this.hasError = false;
        if (tag.length() == 0) {
            this.hasError = true;
        } else {
            IStatus status = CVSTag.validateTagName((String)tag);
            if (!status.isOK()) {
                message = status.getMessage();
                this.hasError = true;
            }
        }
        this.setErrorMessage(message);
    }

    public boolean isMoveButtonSelected() {
        return this.moveButtonSelected;
    }

    public boolean compareButtonSelected() {
        return this.compareButtonSelected;
    }

    public boolean commitButtonSelected() {
        return this.commitButtonSelected;
    }

    private boolean isPageCompleted() {
        return !this.hasError;
    }

    public void saveSettings() {
        String[] tags = this.settings.getArray(this.TAG_KEY);
        if (tags == null) {
            tags = new String[]{};
        }
        tags = this.addToTagList(tags, this.tagCombo.getText());
        this.settings.put(this.TAG_KEY, tags);
        this.settings.put(this.COMPARE_BUTTON_KEY, this.compareButtonSelected);
        this.settings.put(this.COMMIT_BUTTON_KEY, this.commitButtonSelected);
        this.settings.put(this.MOVE_BUTTON_KEY, this.moveButtonSelected);
        this.settings.put(this.VALIDATE_BUTTON_KEY, this.validateButtonSelected);
    }

    private void readSettings() {
        if (this.settings.get(this.COMPARE_BUTTON_KEY) != null) {
            this.compareButton.setSelection(this.settings.getBoolean(this.COMPARE_BUTTON_KEY));
            this.compareButtonSelected = this.settings.getBoolean(this.COMPARE_BUTTON_KEY);
        } else {
            this.compareButton.setSelection(true);
            this.compareButtonSelected = true;
        }
        if (this.settings.get(this.COMMIT_BUTTON_KEY) != null) {
            this.commitButton.setSelection(this.settings.getBoolean(this.COMMIT_BUTTON_KEY));
            this.commitButtonSelected = this.settings.getBoolean(this.COMMIT_BUTTON_KEY);
        } else {
            this.commitButton.setSelection(false);
            this.commitButtonSelected = false;
        }
        if (this.settings.get(this.MOVE_BUTTON_KEY) != null) {
            this.moveButton.setSelection(this.settings.getBoolean(this.MOVE_BUTTON_KEY));
            this.moveButtonSelected = this.settings.getBoolean(this.MOVE_BUTTON_KEY);
        } else {
            this.moveButton.setSelection(false);
            this.moveButtonSelected = false;
        }
        if (this.settings.get(this.VALIDATE_BUTTON_KEY) != null) {
            this.validateButton.setSelection(this.settings.getBoolean(this.VALIDATE_BUTTON_KEY));
            this.validateButtonSelected = this.settings.getBoolean(this.VALIDATE_BUTTON_KEY);
        } else {
            this.validateButton.setSelection(true);
            this.validateButtonSelected = true;
        }
        if (this.settings.getArray(this.TAG_KEY) == null) {
            this.tagCombo.add(this.getTagTemplate());
        } else {
            String[] savedTags = this.settings.getArray(this.TAG_KEY);
            if (savedTags != null && savedTags.length > 0) {
                String[] newTags = this.addToTagList(savedTags, this.getTagTemplate());
                int i = 0;
                while (i < newTags.length) {
                    this.tagCombo.add(newTags[i]);
                    ++i;
                }
            } else {
                this.tagCombo.add(this.getTagTemplate());
            }
        }
    }

    private void initializePage() {
        if (this.settings != null) {
            this.readSettings();
        } else {
            this.commitButton.setSelection(false);
            this.compareButton.setSelection(true);
            this.validateButton.setSelection(true);
            this.moveButton.setSelection(false);
            this.commitButtonSelected = false;
            this.compareButtonSelected = true;
            this.moveButtonSelected = false;
            this.validateButtonSelected = true;
            this.tagCombo.add(this.getTagTemplate());
        }
        this.hasError = false;
        this.setPageComplete(false);
    }

    private void modifyTag() {
        this.tagString = this.tagCombo.getText();
        this.validateTag(this.tagString);
        this.setPageComplete(this.isPageCompleted());
    }

    private String getTagTemplate() {
        String tag = this.getTagPrefix();
        Calendar today = Calendar.getInstance();
        tag = String.valueOf(tag) + today.get(1);
        int month = today.get(2) + 1;
        tag = month < 10 ? String.valueOf(tag) + "0" + month : String.valueOf(tag) + month;
        int day = today.get(5);
        tag = day < 10 ? String.valueOf(tag) + "0" + day : String.valueOf(tag) + day;
        return tag;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ReleaseWizard wizard = (ReleaseWizard)this.getWizard();
        boolean b = wizard.getProjectSelectionPage().isCompareButtonChecked();
        if (visible && !b) {
            wizard.updateSelectedProject();
        }
        this.tagCombo.setFocus();
    }

    public boolean isValidateButtonSelected() {
        return this.validateButtonSelected;
    }

    private String[] addToTagList(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToTagList(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToTagList(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    private String getTagPrefix() {
        String s;
        String[] tags;
        if (this.settings != null && this.settings.getArray(this.TAG_KEY) != null && (tags = this.settings.getArray(this.TAG_KEY)) != null && tags.length > 0 && (s = this.parseFirstTag(tags[0])) != null) {
            return s;
        }
        return "v";
    }

    private String parseFirstTag(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0 || !Character.isLetter(s.charAt(0))) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < length) {
            if (Character.isDigit(s.charAt(i))) break;
            ++i;
        }
        return s.substring(0, i);
    }

    private void updateFinishStatus() {
        ((ReleaseWizard)this.getWizard()).getContainer().updateButtons();
    }
}

