/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.releng.tools.SourceFile;

public class XmlFile
extends SourceFile {
    public XmlFile(IFile file) {
        super(file);
    }

    @Override
    public boolean isCommentStart(String aLine) {
        return aLine.trim().contains(this.getCommentStart());
    }

    @Override
    public boolean isCommentEnd(String aLine, String commentStartString) {
        return aLine.trim().contains(this.getCommentEnd());
    }

    @Override
    public String getCommentStart() {
        return "<!--";
    }

    @Override
    public String getCommentEnd() {
        return "-->";
    }

    @Override
    public int getFileType() {
        return 7;
    }

    @Override
    protected void doInsert(String comment, IDocument document) throws BadLocationException, IOException {
        String tidyComment = comment.trim();
        tidyComment = String.valueOf(tidyComment) + "\n";
        if (this.containsXmlEncoding(document)) {
            tidyComment = "\n" + tidyComment;
        }
        int insertOffset = this.findInsertOffset(document);
        document.replace(insertOffset, 0, tidyComment);
    }

    private int findInsertOffset(IDocument document) throws BadLocationException {
        boolean inInstruction = false;
        int insertOffset = 0;
        int offset = 0;
        while (offset < document.getLength()) {
            char c = document.getChar(offset);
            if (Character.isWhitespace(c)) {
                insertOffset = offset;
            } else {
                char c2;
                char c3 = c2 = offset + 1 < document.getLength() ? document.getChar(offset + 1) : (char)'\u0000';
                if (inInstruction) {
                    if (c == '?' && c2 == '>') {
                        insertOffset = offset + 2;
                        inInstruction = false;
                        ++offset;
                    }
                } else {
                    if (c != '<' || c2 != '?') break;
                    inInstruction = true;
                    ++offset;
                }
            }
            ++offset;
        }
        return insertOffset;
    }

    public boolean containsXmlEncoding(IDocument xmlDoc) throws BadLocationException {
        if (xmlDoc.getLength() < 7) {
            return false;
        }
        int offset = 0;
        while (offset < xmlDoc.getLength()) {
            char c = xmlDoc.getChar(offset);
            if (!Character.isWhitespace(c) && c == '<' && offset + 4 < xmlDoc.getLength()) {
                String xmlTag = "" + c + xmlDoc.getChar(offset + 1) + xmlDoc.getChar(offset + 2) + xmlDoc.getChar(offset + 3) + xmlDoc.getChar(offset + 4);
                return xmlTag.compareToIgnoreCase("<?xml") == 0;
            }
            ++offset;
        }
        return false;
    }
}

