/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class FileTool {
    private static final int MAX_RETRY = 5;
    private static byte[] buffer = new byte[8192];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(ZipFile zipFile, File dstDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                File file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
                file.getParentFile().mkdirs();
                InputStream src = null;
                OutputStream dst = null;
                try {
                    src = zipFile.getInputStream(entry);
                    dst = new FileOutputStream(file);
                    FileTool.transferData(src, dst);
                }
                catch (Throwable throwable) {
                    if (dst != null) {
                        try {
                            dst.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (src == null) throw throwable;
                    try {
                        src.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (dst != null) {
                    try {
                        dst.close();
                    }
                    catch (IOException iOException) {}
                }
                if (src == null) continue;
                try {
                    src.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    public static void transferData(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            FileTool.transferData(is, os);
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void transferData(InputStream source, OutputStream destination) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = source.read(buffer, 0, buffer.length);
            if (bytesRead == -1) continue;
            destination.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] srcChildren = src.list();
            int i = 0;
            while (i < srcChildren.length) {
                File srcChild = new File(src, srcChildren[i]);
                File dstChild = new File(dst, srcChildren[i]);
                FileTool.copy(srcChild, dstChild);
                ++i;
            }
        } else {
            FileTool.transferData(src, dst);
        }
    }

    public static File getFileInPlugin(Plugin plugin, IPath path) {
        try {
            URL installURL = plugin.getBundle().getEntry(path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public static StringBuffer read(String fileName) throws IOException {
        return FileTool.read(new FileReader(fileName));
    }

    public static StringBuffer read(Reader reader) throws IOException {
        StringBuffer s = new StringBuffer();
        try {
            char[] charBuffer = new char[8196];
            int chars = reader.read(charBuffer);
            while (chars != -1) {
                s.append(charBuffer, 0, chars);
                chars = reader.read(charBuffer);
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return s;
    }

    public static void write(String fileName, StringBuffer content) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        try {
            writer.write(content.toString());
        }
        catch (Throwable throwable) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException iOException) {}
    }

    public static void delete(File file) {
        if (file.exists()) {
            int i = 0;
            while (i < 5) {
                if (file.delete()) {
                    i = 5;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++i;
            }
        }
    }
}

