/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.tests.ResourceHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileCharSequenceTests {
    private final String TEST_CONTENT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00dc\u00f6\u00e4\u00fc\u00e8\u00e9\u00f9abcdefghijklmnopqrstuvwxyz1234567890@'\"\n$\u00a2";
    private IProject fProject;

    @Before
    public void setUp() throws Exception {
        this.fProject = ResourceHelper.createProject("my-project");
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject("my-project");
    }

    @Test
    public void testFileCharSequence() throws Exception {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < 500) {
            buf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00dc\u00f6\u00e4\u00fc\u00e8\u00e9\u00f9abcdefghijklmnopqrstuvwxyz1234567890@'\"\n$\u00a2");
            ++i;
        }
        String encoding = "ISO-8859-1";
        this.testForEncoding(buf, encoding);
    }

    @Test
    public void testFileCharSequence2() throws Exception {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < 2000) {
            buf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00dc\u00f6\u00e4\u00fc\u00e8\u00e9\u00f9abcdefghijklmnopqrstuvwxyz1234567890@'\"\n$\u00a2");
            ++i;
        }
        String encoding = "UTF-8";
        this.testForEncoding(buf, encoding);
    }

    @Test
    public void testFileCharSequence3() throws Exception {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < FileCharSequenceProvider.BUFFER_SIZE * 2) {
            buf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00dc\u00f6\u00e4\u00fc\u00e8\u00e9\u00f9abcdefghijklmnopqrstuvwxyz1234567890@'\"\n$\u00a2");
            ++i;
        }
        String encoding = "UTF-16";
        this.testForEncoding(buf, encoding);
    }

    private void testForEncoding(CharSequence buf, String encoding) throws CoreException, IOException {
        IFolder folder = ResourceHelper.createFolder(this.fProject.getFolder("folder1"));
        IFile file1 = ResourceHelper.createFile(folder, "file1", buf.toString(), encoding);
        FileCharSequenceProvider provider = new FileCharSequenceProvider();
        CharSequence cs = null;
        try {
            cs = provider.newCharSequence(file1);
            this.assertEquals(encoding, cs, buf);
            this.assertSubSequence(encoding, cs, buf, 0, buf.length() / 6);
            this.assertSubSequence(encoding, cs, buf, buf.length() / 6, FileCharSequenceProvider.BUFFER_SIZE);
            int pos = 8 * buf.length() / 9;
            this.assertSubSequence(encoding, cs, buf, pos, buf.length() - pos);
            CharSequence seq1a = cs.subSequence(100, 100 + FileCharSequenceProvider.BUFFER_SIZE);
            CharSequence seq1e = buf.subSequence(100, 100 + FileCharSequenceProvider.BUFFER_SIZE);
            this.assertSubSequence(encoding, seq1a, seq1e, 500, 500);
            this.assertSubSequence(encoding, seq1a, seq1e, FileCharSequenceProvider.BUFFER_SIZE, 0);
        }
        finally {
            if (cs != null) {
                provider.releaseCharSequence(cs);
            }
            file1.delete(true, null);
        }
    }

    private void assertSubSequence(String message, CharSequence actual, CharSequence expected, int start, int length) {
        CharSequence actualSub = actual.subSequence(start, start + length);
        CharSequence expectedSub = expected.subSequence(start, start + length);
        this.assertEquals(String.valueOf(message) + " - subsequence(" + start + ", " + length + ")", actualSub, expectedSub);
    }

    private void assertEquals(String desc, CharSequence actual, CharSequence expected) {
        int i = 0;
        while (i < expected.length()) {
            Assert.assertEquals((String)(String.valueOf(desc) + " - forward " + i), (long)expected.charAt(i), (long)actual.charAt(i));
            ++i;
        }
        Assert.assertEquals((String)(String.valueOf(desc) + " - length"), (long)expected.length(), (long)actual.length());
        i = expected.length() - 1;
        while (i >= 0) {
            Assert.assertEquals((String)(String.valueOf(desc) + " - backward " + i), (long)expected.charAt(i), (long)actual.charAt(i));
            --i;
        }
        i = 0;
        while (i < expected.length()) {
            Assert.assertEquals((String)(String.valueOf(desc) + " - forward - steps" + i), (long)expected.charAt(i), (long)actual.charAt(i));
            i += 567;
        }
        i = 0;
        while (i < expected.length()) {
            Assert.assertEquals((String)(String.valueOf(desc) + " - forward - buffersize" + i), (long)expected.charAt(i), (long)actual.charAt(i));
            i += FileCharSequenceProvider.BUFFER_SIZE;
        }
        this.assertOutOfBound(String.valueOf(desc) + "access at length", actual, expected.length());
        this.assertOutOfBound(String.valueOf(desc) + "access at -1", actual, -1);
        Assert.assertEquals((String)(String.valueOf(desc) + " - length"), (Object)actual.toString(), (Object)expected.toString());
    }

    private void assertOutOfBound(String message, CharSequence cs, int i) {
        try {
            cs.charAt(i);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        Assert.assertFalse((String)message, (boolean)true);
    }
}

