/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.tests.ResourceHelper;
import org.junit.rules.ExternalResource;

public class JUnitSourceSetup
extends ExternalResource {
    public static final String STANDARD_PROJECT_NAME = "JUnitSource";
    private IProject fProject = null;
    private final String fProjectName;

    public IProject getStandardProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(STANDARD_PROJECT_NAME);
    }

    public JUnitSourceSetup() {
        this(STANDARD_PROJECT_NAME);
    }

    public JUnitSourceSetup(String projectName) {
        this.fProjectName = projectName;
    }

    public void before() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectName);
        if (!project.exists()) {
            this.fProject = ResourceHelper.createJUnitSourceProject(this.fProjectName);
        }
    }

    public void after() {
        if (this.fProject != null) {
            try {
                ResourceHelper.deleteProject(this.fProjectName);
            }
            catch (CoreException e) {
                throw new AssertionError((Object)e);
            }
            this.fProject = null;
        }
    }
}

