/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.tests.SearchTestPlugin;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.ui.PartInitException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class PositionTrackerTest {
    FileSearchQuery fQuery1;
    @ClassRule
    public static JUnitSourceSetup junitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
    }

    @Test
    public void testInsertAt0() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] elements = result.getElements();
        try {
            int i = 0;
            while (i < elements.length) {
                this.checkInsertAtZero(result, (IFile)elements[i]);
                ++i;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    @Test
    public void testInsertInsideMatch() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        FileSearchResult result = (FileSearchResult)this.fQuery1.getSearchResult();
        Object[] elements = result.getElements();
        try {
            int i = 0;
            while (i < elements.length) {
                this.checkInsertInsideMatch(result, (IFile)elements[i]);
                ++i;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    private void checkInsertInsideMatch(FileSearchResult result, IFile file) throws PartInitException, BadLocationException {
        Match[] matches = result.getMatches((Object)file);
        try {
            Position currentPosition;
            SearchTestPlugin.openTextEditor(SearchPlugin.getActivePage(), file);
            ITextFileBuffer fb = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            IDocument doc = fb.getDocument();
            int i = 0;
            while (i < matches.length) {
                currentPosition = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(matches[i]);
                Assert.assertNotNull((Object)currentPosition);
                doc.replace(currentPosition.offset + 1, 0, "Test");
                ++i;
            }
            i = 0;
            while (i < matches.length) {
                currentPosition = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(matches[i]);
                Assert.assertNotNull((Object)currentPosition);
                String text = doc.get(currentPosition.offset, currentPosition.length);
                StringBuffer buf = new StringBuffer();
                buf.append(text.charAt(0));
                buf.append(text.substring(5));
                Assert.assertEquals((Object)buf.toString(), (Object)((FileSearchQuery)result.getQuery()).getSearchString());
                ++i;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    private void checkInsertAtZero(AbstractTextSearchResult result, IFile file) throws PartInitException, BadLocationException {
        Match[] matches = result.getMatches((Object)file);
        int[] originalStarts = new int[matches.length];
        int i = 0;
        while (i < originalStarts.length) {
            originalStarts[i] = matches[i].getOffset();
            ++i;
        }
        try {
            SearchTestPlugin.openTextEditor(SearchPlugin.getActivePage(), file);
            ITextFileBuffer fb = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            IDocument doc = fb.getDocument();
            doc.replace(0, 0, "Test");
            int i2 = 0;
            while (i2 < originalStarts.length) {
                Position currentPosition = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(matches[i2]);
                Assert.assertNotNull((Object)currentPosition);
                Assert.assertEquals((long)(originalStarts[i2] + "Test".length()), (long)currentPosition.getOffset());
                ++i2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }
}

