/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.tests.ResourceHelper;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResultUpdaterTest {
    private FileSearchQuery fQuery1;
    private IProject fProject;
    private static final String PROJECT_TO_MODIFY = "ModifiableProject";

    @Before
    public void setUp() throws Exception {
        this.fProject = ResourceHelper.createJUnitSourceProject(PROJECT_TO_MODIFY);
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.fProject}, (String[])fileNamePatterns, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject(PROJECT_TO_MODIFY);
    }

    @Test
    public void testRemoveFile() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] elements = result.getElements();
        int fileCount = result.getMatchCount(elements[0]);
        int totalCount = result.getMatchCount();
        ResourceHelper.delete((IResource)((IFile)elements[0]));
        Assert.assertEquals((long)(totalCount - fileCount), (long)result.getMatchCount());
        Assert.assertEquals((long)0L, (long)result.getMatchCount(elements[0]));
    }

    @Test
    public void testRemoveProject() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        ResourceHelper.delete((IResource)this.fProject);
        Assert.assertEquals((long)0L, (long)result.getMatchCount());
    }
}

