/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.ole.win32;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.examples.ole.win32.OlePlugin;
import org.eclipse.swt.examples.ole.win32.OleWebBrowser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public class OleBrowserView
extends ViewPart {
    private Composite displayArea;
    private OleFrame webFrame;
    private OleWebBrowser webBrowser;
    private Text webUrl;
    private OleControlSite webControlSite;
    private ProgressBar webProgress;
    private Label webStatus;
    private Button webNavigateButton;
    private ToolItem webCommandBackward;
    private ToolItem webCommandForward;
    private ToolItem webCommandHome;
    private ToolItem webCommandStop;
    private ToolItem webCommandRefresh;
    private ToolItem webCommandSearch;
    private boolean activated = false;
    private static final int DISPID_AMBIENT_DLCONTROL = -5512;
    private static final int DLCTL_NO_SCRIPTS = 128;

    public OleBrowserView() {
        OlePlugin.initResources();
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.displayArea.setLayout((Layout)gridLayout);
        this.createToolbar();
        this.createBrowserFrame();
        this.createStatusArea();
        this.createBrowserControl();
    }

    public void dispose() {
        if (this.activated) {
            this.webControlSite.deactivateInPlaceClient();
            this.activated = false;
        }
        if (this.webBrowser != null) {
            this.webBrowser.dispose();
        }
        this.webBrowser = null;
        super.dispose();
    }

    public void setFocus() {
        this.webUrl.setFocus();
    }

    private void createToolbar() {
        ToolBar bar = new ToolBar(this.displayArea, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bar.setLayoutData((Object)gridData);
        this.webCommandBackward = new ToolItem(bar, 0);
        this.webCommandBackward.setToolTipText(OlePlugin.getResourceString("browser.Back.tooltip"));
        this.webCommandBackward.setText(OlePlugin.getResourceString("browser.Back.text"));
        this.webCommandBackward.setImage(OlePlugin.images[0]);
        this.webCommandBackward.setEnabled(false);
        this.webCommandBackward.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.GoBack();
            }
        });
        this.webCommandForward = new ToolItem(bar, 0);
        this.webCommandForward.setToolTipText(OlePlugin.getResourceString("browser.Forward.tooltip"));
        this.webCommandForward.setText(OlePlugin.getResourceString("browser.Forward.text"));
        this.webCommandForward.setImage(OlePlugin.images[1]);
        this.webCommandForward.setEnabled(false);
        this.webCommandForward.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.GoForward();
            }
        });
        new ToolItem(bar, 2);
        this.webCommandHome = new ToolItem(bar, 0);
        this.webCommandHome.setToolTipText(OlePlugin.getResourceString("browser.Home.tooltip"));
        this.webCommandHome.setText(OlePlugin.getResourceString("browser.Home.text"));
        this.webCommandHome.setImage(OlePlugin.images[2]);
        this.webCommandHome.setEnabled(false);
        this.webCommandHome.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.GoHome();
            }
        });
        this.webCommandStop = new ToolItem(bar, 0);
        this.webCommandStop.setToolTipText(OlePlugin.getResourceString("browser.Stop.tooltip"));
        this.webCommandStop.setText(OlePlugin.getResourceString("browser.Stop.text"));
        this.webCommandStop.setImage(OlePlugin.images[3]);
        this.webCommandStop.setEnabled(false);
        this.webCommandStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.Stop();
            }
        });
        this.webCommandRefresh = new ToolItem(bar, 0);
        this.webCommandRefresh.setToolTipText(OlePlugin.getResourceString("browser.Refresh.tooltip"));
        this.webCommandRefresh.setText(OlePlugin.getResourceString("browser.Refresh.text"));
        this.webCommandRefresh.setImage(OlePlugin.images[4]);
        this.webCommandRefresh.setEnabled(false);
        this.webCommandRefresh.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.Refresh();
            }
        });
        new ToolItem(bar, 2);
        this.webCommandSearch = new ToolItem(bar, 0);
        this.webCommandSearch.setToolTipText(OlePlugin.getResourceString("browser.Search.tooltip"));
        this.webCommandSearch.setText(OlePlugin.getResourceString("browser.Search.text"));
        this.webCommandSearch.setImage(OlePlugin.images[5]);
        this.webCommandSearch.setEnabled(false);
        this.webCommandSearch.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.GoSearch();
            }
        });
        Composite addressBar = new Composite(this.displayArea, 0);
        gridData = new GridData(784);
        gridData.horizontalSpan = 3;
        addressBar.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        addressBar.setLayout((Layout)gridLayout);
        Label addressLabel = new Label(addressBar, 0);
        gridData = new GridData(272);
        addressLabel.setLayoutData((Object)gridData);
        addressLabel.setText(OlePlugin.getResourceString("browser.Address.label"));
        addressLabel.setFont(OlePlugin.browserFont);
        this.webUrl = new Text(addressBar, 2052);
        this.webUrl.setFont(OlePlugin.browserFont);
        gridData = new GridData(784);
        this.webUrl.setLayoutData((Object)gridData);
        this.webUrl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                OleBrowserView.this.webNavigateButton.getShell().setDefaultButton(OleBrowserView.this.webNavigateButton);
            }
        });
        this.webNavigateButton = new Button(addressBar, 8);
        gridData = new GridData(272);
        this.webNavigateButton.setLayoutData((Object)gridData);
        this.webNavigateButton.setText(OlePlugin.getResourceString("browser.Go.text"));
        this.webNavigateButton.setFont(OlePlugin.browserFont);
        this.webNavigateButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (OleBrowserView.this.webBrowser == null) {
                    return;
                }
                OleBrowserView.this.webBrowser.Navigate(OleBrowserView.this.webUrl.getText());
            }
        });
    }

    private void createBrowserFrame() {
        this.webFrame = new OleFrame(this.displayArea, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.webFrame.setLayoutData((Object)gridData);
    }

    private void createStatusArea() {
        this.webProgress = new ProgressBar(this.displayArea, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 4;
        this.webProgress.setLayoutData((Object)gridData);
        this.webStatus = new Label(this.displayArea, 2060);
        gridData = new GridData(784);
        gridData.horizontalSpan = 2;
        this.webStatus.setLayoutData((Object)gridData);
        this.webStatus.setFont(OlePlugin.browserFont);
    }

    private void createBrowserControl() {
        try {
            this.webControlSite = new OleControlSite((Composite)this.webFrame, 0, "Shell.Explorer");
            Variant download = new Variant(128);
            this.webControlSite.setSiteProperty(-5512, download);
            OleAutomation oleAutomation = new OleAutomation((OleClientSite)this.webControlSite);
            this.webBrowser = new OleWebBrowser(oleAutomation);
        }
        catch (SWTException ex) {
            Label label = new Label((Composite)this.webFrame, 2048);
            OlePlugin.logError(OlePlugin.getResourceString("error.CouldNotCreateBrowserControl"), ex);
            label.setText(OlePlugin.getResourceString("error.CouldNotCreateBrowserControl"));
            return;
        }
        this.webControlSite.addEventListener(108, new OleListener(){

            public void handleEvent(OleEvent event) {
                Variant progress = event.arguments[0];
                Variant maxProgress = event.arguments[1];
                if (progress == null || maxProgress == null) {
                    return;
                }
                OleBrowserView.this.webProgress.setMaximum(maxProgress.getInt());
                OleBrowserView.this.webProgress.setSelection(progress.getInt());
            }
        });
        this.webControlSite.addEventListener(102, new OleListener(){

            public void handleEvent(OleEvent event) {
                Variant statusText = event.arguments[0];
                if (statusText == null) {
                    return;
                }
                String text = statusText.getString();
                if (text != null) {
                    OleBrowserView.this.webStatus.setText(text);
                }
            }
        });
        this.webControlSite.addPropertyListener(-525, new OleListener(){

            public void handleEvent(OleEvent event) {
                if (event.detail == 0) {
                    return;
                }
                int state = OleBrowserView.this.webBrowser.getReadyState();
                switch (state) {
                    case 0: {
                        OleBrowserView.this.webStatus.setText(OlePlugin.getResourceString("browser.State.Uninitialized.text"));
                        OleBrowserView.this.webCommandBackward.setEnabled(false);
                        OleBrowserView.this.webCommandForward.setEnabled(false);
                        OleBrowserView.this.webCommandHome.setEnabled(false);
                        OleBrowserView.this.webCommandRefresh.setEnabled(false);
                        OleBrowserView.this.webCommandStop.setEnabled(false);
                        OleBrowserView.this.webCommandSearch.setEnabled(false);
                        break;
                    }
                    case 1: {
                        OleBrowserView.this.webStatus.setText(OlePlugin.getResourceString("browser.State.Loading.text"));
                        OleBrowserView.this.webCommandHome.setEnabled(true);
                        OleBrowserView.this.webCommandRefresh.setEnabled(true);
                        OleBrowserView.this.webCommandStop.setEnabled(true);
                        OleBrowserView.this.webCommandSearch.setEnabled(true);
                        break;
                    }
                    case 2: {
                        OleBrowserView.this.webStatus.setText(OlePlugin.getResourceString("browser.State.Loaded.text"));
                        OleBrowserView.this.webCommandStop.setEnabled(true);
                        break;
                    }
                    case 3: {
                        OleBrowserView.this.webStatus.setText(OlePlugin.getResourceString("browser.State.Interactive.text"));
                        OleBrowserView.this.webCommandStop.setEnabled(true);
                        break;
                    }
                    case 4: {
                        OleBrowserView.this.webStatus.setText(OlePlugin.getResourceString("browser.State.Complete.text"));
                        OleBrowserView.this.webCommandStop.setEnabled(false);
                    }
                }
            }
        });
        this.webControlSite.addEventListener(105, new OleListener(){

            public void handleEvent(OleEvent event) {
                if (event.type != 105) {
                    return;
                }
                int commandID = event.arguments[0] != null ? event.arguments[0].getInt() : 0;
                boolean commandEnabled = event.arguments[1] != null ? event.arguments[1].getBoolean() : false;
                switch (commandID) {
                    case 2: {
                        OleBrowserView.this.webCommandBackward.setEnabled(commandEnabled);
                        break;
                    }
                    case 1: {
                        OleBrowserView.this.webCommandForward.setEnabled(commandEnabled);
                    }
                }
            }
        });
        boolean bl = this.activated = this.webControlSite.doVerb(-5) == 0;
        if (this.activated) {
            this.webBrowser.GoHome();
        }
    }
}

