/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.ole.win32;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

class OleWebBrowser {
    public static final int CSC_UPDATECOMMANDS = -1;
    public static final int CSC_NAVIGATEFORWARD = 1;
    public static final int CSC_NAVIGATEBACK = 2;
    public static final int READYSTATE_UNINITIALIZED = 0;
    public static final int READYSTATE_LOADING = 1;
    public static final int READYSTATE_LOADED = 2;
    public static final int READYSTATE_INTERACTIVE = 3;
    public static final int READYSTATE_COMPLETE = 4;
    public static final int BeforeNavigate = 100;
    public static final int NavigateComplete = 101;
    public static final int StatusTextChange = 102;
    public static final int ProgressChange = 108;
    public static final int DownloadComplete = 104;
    public static final int CommandStateChange = 105;
    public static final int DownloadBegin = 106;
    public static final int NewWindow = 107;
    public static final int TitleChange = 113;
    public static final int FrameBeforeNavigate = 200;
    public static final int FrameNavigateComplete = 201;
    public static final int FrameNewWindow = 204;
    public static final int Quit = 103;
    public static final int WindowMove = 109;
    public static final int WindowResize = 110;
    public static final int WindowActivate = 111;
    public static final int PropertyChange = 112;
    public static final int DISPID_READYSTATE = -525;
    private OleAutomation oleAutomation;

    public OleWebBrowser(OleAutomation oleAutomation) {
        this.oleAutomation = oleAutomation;
    }

    public void dispose() {
        if (this.oleAutomation != null) {
            this.oleAutomation.dispose();
        }
        this.oleAutomation = null;
    }

    public String getLocationName() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"LocationName"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleAutomation.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return null;
        }
        return pVarResult.getString();
    }

    public String getLocationURL() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"LocationURL"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleAutomation.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return null;
        }
        return pVarResult.getString();
    }

    public int getReadyState() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"ReadyState"});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.oleAutomation.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() != 3) {
            return -1;
        }
        return pVarResult.getInt();
    }

    public void GoBack() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"GoBack"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invoke(dispIdMember);
    }

    public void GoForward() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"GoForward"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invoke(dispIdMember);
    }

    public void GoHome() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"GoHome"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invoke(dispIdMember);
    }

    public void GoSearch() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"GoSearch"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invoke(dispIdMember);
    }

    public void Navigate(String url) {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"Navigate", "URL"});
        int dispIdMember = rgdispid[0];
        Variant[] rgvarg = new Variant[]{new Variant(url)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        this.oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
    }

    public void Refresh() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"Refresh"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invokeNoReply(dispIdMember);
    }

    public void Stop() {
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"Stop"});
        int dispIdMember = rgdispid[0];
        this.oleAutomation.invoke(dispIdMember);
    }
}

