/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.accessibility;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BarChart
extends Canvas {
    static ResourceBundle bundle = ResourceBundle.getBundle("examples_accessibility");
    List<Object[]> data = new ArrayList<Object[]>();
    String title;
    int color = 3;
    int selectedItem = -1;
    int valueMin = 0;
    int valueMax = 10;
    int valueIncrement = 1;
    static final int GAP = 4;
    static final int AXIS_WIDTH = 2;

    public BarChart(Composite parent, int style) {
        super(parent, style);
        this.addListeners();
    }

    void addListeners() {
        this.addPaintListener(e -> {
            GC gc = e.gc;
            Rectangle rect = this.getClientArea();
            Display display = this.getDisplay();
            int count = this.data.size();
            Point valueSize = gc.stringExtent(Integer.valueOf(this.valueMax).toString());
            int leftX = rect.x + 8 + valueSize.x;
            int bottomY = rect.y + rect.height - 8 - valueSize.y;
            int unitWidth = (rect.width - 16 - valueSize.x - 2) / count - 4;
            int unitHeight = (rect.height - 12 - 2 - 2 * valueSize.y) / ((this.valueMax - this.valueMin) / this.valueIncrement);
            int titleWidth = gc.stringExtent((String)this.title).x;
            int center = (Math.max(titleWidth, count * (unitWidth + 4) + 4) - titleWidth) / 2;
            gc.setForeground(display.getSystemColor(2));
            gc.drawString(this.title, leftX + 2 + center, rect.y + 4);
            gc.setLineWidth(2);
            gc.drawLine(leftX, rect.y + 4 + valueSize.y, leftX, bottomY);
            int i1 = this.valueMin;
            while (i1 <= this.valueMax) {
                int y = bottomY - i1 * unitHeight;
                gc.drawLine(leftX, y, leftX - 4, y);
                gc.drawString(Integer.valueOf(i1).toString(), rect.x + 4, y - valueSize.y);
                i1 += this.valueIncrement;
            }
            gc.drawLine(leftX, bottomY, rect.x + rect.width - 4, bottomY);
            int i2 = 0;
            while (i2 < count) {
                Object[] dataItem1 = this.data.get(i2);
                String itemLabel = (String)dataItem1[0];
                int x1 = leftX + 2 + 4 + i2 * (unitWidth + 4);
                gc.drawString(itemLabel, x1, bottomY + 4);
                ++i2;
            }
            gc.setBackground(display.getSystemColor(this.color));
            int i3 = 0;
            while (i3 < count) {
                Object[] dataItem2 = this.data.get(i3);
                int itemValue1 = (Integer)dataItem2[1];
                int x2 = leftX + 2 + 4 + i3 * (unitWidth + 4);
                gc.fillRectangle(x2, bottomY - 2 - itemValue1 * unitHeight, unitWidth, itemValue1 * unitHeight);
                ++i3;
            }
            if (this.isFocusControl()) {
                if (this.selectedItem == -1) {
                    gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
                } else {
                    Object[] dataItem3 = this.data.get(this.selectedItem);
                    int itemValue2 = (Integer)dataItem3[1];
                    int x3 = leftX + 2 + 4 + this.selectedItem * (unitWidth + 4);
                    gc.drawFocus(x3, bottomY - itemValue2 * unitHeight - 2, unitWidth, itemValue2 * unitHeight + 2 + 4 + valueSize.y);
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BarChart.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                BarChart.this.redraw();
            }
        });
        this.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            if (this.getClientArea().contains(e.x, e.y)) {
                this.setFocus();
                int item = -1;
                int count = this.data.size();
                int i = 0;
                while (i < count) {
                    if (this.itemBounds(i).contains(e.x, e.y)) {
                        item = i;
                        break;
                    }
                    ++i;
                }
                if (item != this.selectedItem) {
                    this.selectedItem = item;
                    this.redraw();
                    this.getAccessible().setFocus(item);
                    this.getAccessible().selectionChanged();
                }
            }
        }));
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean change = false;
                switch (e.keyCode) {
                    case 0x1000002: 
                    case 0x1000004: {
                        ++BarChart.this.selectedItem;
                        if (BarChart.this.selectedItem >= BarChart.this.data.size()) {
                            BarChart.this.selectedItem = 0;
                        }
                        change = true;
                        break;
                    }
                    case 0x1000001: 
                    case 0x1000003: {
                        --BarChart.this.selectedItem;
                        if (BarChart.this.selectedItem <= -1) {
                            BarChart.this.selectedItem = BarChart.this.data.size() - 1;
                        }
                        change = true;
                        break;
                    }
                    case 0x1000007: {
                        BarChart.this.selectedItem = 0;
                        change = true;
                        break;
                    }
                    case 0x1000008: {
                        BarChart.this.selectedItem = BarChart.this.data.size() - 1;
                        change = true;
                    }
                }
                if (change) {
                    BarChart.this.redraw();
                    BarChart.this.getAccessible().setFocus(BarChart.this.selectedItem);
                    BarChart.this.getAccessible().selectionChanged();
                }
            }
        });
        this.addTraverseListener(e -> {
            switch (e.detail) {
                case 8: 
                case 16: {
                    e.doit = true;
                }
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(bundle.getString("name"));
                int childID = e.childID;
                if (childID == -1) {
                    e.result = BarChart.this.title;
                } else {
                    Object[] item = BarChart.this.data.get(childID);
                    e.result = formatter.format(item);
                }
            }

            public void getDescription(AccessibleEvent e) {
                int childID = e.childID;
                if (childID != -1) {
                    Object[] item = BarChart.this.data.get(childID);
                    String value = item[1].toString();
                    String colorName = bundle.getString("color" + BarChart.this.color);
                    MessageFormat formatter = new MessageFormat("");
                    formatter.applyPattern(bundle.getString("color_value"));
                    e.result = formatter.format(new String[]{colorName, value});
                }
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = e.childID == -1 ? 33 : 34;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = BarChart.this.data.size();
            }

            public void getChildren(AccessibleControlEvent e) {
                int count = BarChart.this.data.size();
                Object[] children = new Object[count];
                int i = 0;
                while (i < count) {
                    children[i] = i;
                    ++i;
                }
                e.children = children;
            }

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = BarChart.this.toControl(e.x, e.y);
                int childID = -2;
                if (BarChart.this.getClientArea().contains(testPoint)) {
                    childID = -1;
                    int count = BarChart.this.data.size();
                    int i = 0;
                    while (i < count) {
                        if (BarChart.this.itemBounds(i).contains(testPoint)) {
                            childID = i;
                            break;
                        }
                        ++i;
                    }
                }
                e.childID = childID;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = null;
                Point pt = null;
                int childID = e.childID;
                if (childID == -1) {
                    location = BarChart.this.getClientArea();
                    pt = BarChart.this.getParent().toDisplay(location.x, location.y);
                } else {
                    location = BarChart.this.itemBounds(childID);
                    pt = BarChart.this.toDisplay(location.x, location.y);
                }
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getFocus(AccessibleControlEvent e) {
                int childID = -2;
                if (BarChart.this.isFocusControl()) {
                    childID = BarChart.this.selectedItem == -1 ? -1 : BarChart.this.selectedItem;
                }
                e.childID = childID;
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = BarChart.this.selectedItem == -1 ? -2 : BarChart.this.selectedItem;
            }

            public void getValue(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID != -1) {
                    Object[] dataItem = BarChart.this.data.get(childID);
                    e.result = ((Integer)dataItem[1]).toString();
                }
            }

            public void getState(AccessibleControlEvent e) {
                int childID = e.childID;
                e.detail = 0x100000;
                if (BarChart.this.isFocusControl()) {
                    e.detail |= 4;
                }
                if (childID != -1) {
                    e.detail |= 0x200000;
                    if (childID == BarChart.this.selectedItem) {
                        e.detail |= 2;
                    }
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int count = this.data.size();
        GC gc = new GC((Drawable)this);
        int titleWidth = gc.stringExtent((String)this.title).x;
        Point valueSize = gc.stringExtent(Integer.valueOf(this.valueMax).toString());
        int itemWidth = 0;
        int i = 0;
        while (i < count) {
            Object[] dataItem = this.data.get(i);
            String itemLabel = (String)dataItem[0];
            itemWidth = Math.max(itemWidth, gc.stringExtent((String)itemLabel).x);
            ++i;
        }
        gc.dispose();
        int width = Math.max(titleWidth, count * (itemWidth + 4) + 4) + 12 + 2 + valueSize.x;
        int height = 14 + valueSize.y * ((this.valueMax - this.valueMin) / this.valueIncrement + 3);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        Rectangle trim = this.computeTrim(0, 0, width + border * 2, height + border * 2);
        return new Point(trim.width, trim.height);
    }

    public void addData(String label, int value) {
        this.checkWidget();
        this.data.add(new Object[]{label, value});
    }

    public void setTitle(String title) {
        this.checkWidget();
        this.title = title;
    }

    public void setColor(int color) {
        this.checkWidget();
        this.color = color;
    }

    public void setValueMin(int min) {
        this.checkWidget();
        this.valueMin = min;
    }

    public void setValueMax(int max) {
        this.checkWidget();
        this.valueMax = max;
    }

    public void setValueIncrement(int increment) {
        this.checkWidget();
        this.valueIncrement = increment;
    }

    Rectangle itemBounds(int index) {
        Rectangle rect = this.getClientArea();
        GC gc = new GC((Drawable)this);
        Point valueSize = gc.stringExtent(Integer.valueOf(this.valueMax).toString());
        gc.dispose();
        int leftX = rect.x + 8 + valueSize.x;
        int bottomY = rect.y + rect.height - 8 - valueSize.y;
        int unitWidth = (rect.width - 16 - valueSize.x - 2) / this.data.size() - 4;
        int unitHeight = (rect.height - 12 - 2 - 2 * valueSize.y) / ((this.valueMax - this.valueMin) / this.valueIncrement);
        Object[] dataItem = this.data.get(index);
        int itemValue = (Integer)dataItem[1];
        int x = leftX + 2 + 4 + index * (unitWidth + 4);
        return new Rectangle(x, bottomY - itemValue * unitHeight - 2, unitWidth, itemValue * unitHeight + 2 + 4 + valueSize.y);
    }
}

