/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.addressbook;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.addressbook.DataEntryDialog;
import org.eclipse.swt.examples.addressbook.SearchDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AddressBook {
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("examples_addressbook");
    private Shell shell;
    private Table table;
    private SearchDialog searchDialog;
    private File file;
    private boolean isModified;
    private String[] copyBuffer;
    private int lastSortColumn = -1;
    private static final String DELIMITER = "\t";
    private static final String[] columnNames = new String[]{resAddressBook.getString("Last_name"), resAddressBook.getString("First_name"), resAddressBook.getString("Business_phone"), resAddressBook.getString("Home_phone"), resAddressBook.getString("Email"), resAddressBook.getString("Fax")};

    public static void main(String[] args) {
        Display display = new Display();
        AddressBook application = new AddressBook();
        Shell shell = application.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = AddressBook.this.closeAddressBook();
            }
        });
        this.createMenuBar();
        this.searchDialog = new SearchDialog(this.shell);
        this.searchDialog.setSearchAreaNames(columnNames);
        this.searchDialog.setSearchAreaLabel(resAddressBook.getString("Column"));
        this.searchDialog.addFindListener(() -> this.findEntry());
        this.table = new Table((Composite)this.shell, 67588);
        this.table.setHeaderVisible(true);
        this.table.setMenu(this.createPopUpMenu());
        this.table.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length > 0) {
                this.editEntry(items[0]);
            }
        }));
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(columnNames[i]);
            column.setWidth(150);
            int columnIndex = i++;
            column.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.sort(columnIndex)));
        }
        this.newAddressBook();
        this.shell.setSize(this.table.computeSize((int)-1, (int)-1).x, 300);
        this.shell.open();
        return this.shell;
    }

    private boolean closeAddressBook() {
        TableItem[] items;
        if (this.isModified) {
            MessageBox box = new MessageBox(this.shell, 456);
            box.setText(this.shell.getText());
            box.setMessage(resAddressBook.getString("Close_save"));
            int choice = box.open();
            if (choice == 256) {
                return false;
            }
            if (choice == 64 && !this.save()) {
                return false;
            }
        }
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
        return true;
    }

    private Menu createMenuBar() {
        Menu menuBar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menuBar);
        this.createFileMenu(menuBar);
        this.createEditMenu(menuBar);
        this.createSearchMenu(menuBar);
        this.createHelpMenu(menuBar);
        return menuBar;
    }

    private String[] decodeLine(String line) {
        if (line == null) {
            return null;
        }
        String[] parsedLine = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < parsedLine.length - 1) {
            int index = line.indexOf(DELIMITER);
            if (index <= -1) {
                return null;
            }
            parsedLine[i] = line.substring(0, index);
            line = line.substring(index + DELIMITER.length(), line.length());
            ++i;
        }
        if (line.indexOf(DELIMITER) != -1) {
            return null;
        }
        parsedLine[parsedLine.length - 1] = line;
        return parsedLine;
    }

    private void displayError(String msg) {
        MessageBox box = new MessageBox(this.shell, 1);
        box.setMessage(msg);
        box.open();
    }

    private void editEntry(TableItem item) {
        DataEntryDialog dialog = new DataEntryDialog(this.shell);
        dialog.setLabels(columnNames);
        String[] values = new String[this.table.getColumnCount()];
        int i = 0;
        while (i < values.length) {
            values[i] = item.getText(i);
            ++i;
        }
        dialog.setValues(values);
        values = dialog.open();
        if (values != null) {
            item.setText(values);
            this.isModified = true;
        }
    }

    private String encodeLine(String[] tableItems) {
        String line = "";
        int i = 0;
        while (i < tableItems.length - 1) {
            line = String.valueOf(line) + tableItems[i] + DELIMITER;
            ++i;
        }
        line = String.valueOf(line) + tableItems[tableItems.length - 1] + "\n";
        return line;
    }

    private boolean findEntry() {
        Cursor waitCursor = this.shell.getDisplay().getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        boolean matchCase = this.searchDialog.getMatchCase();
        boolean matchWord = this.searchDialog.getMatchWord();
        String searchString = this.searchDialog.getSearchString();
        int column = this.searchDialog.getSelectedSearchArea();
        searchString = matchCase ? searchString : searchString.toLowerCase();
        boolean found = false;
        if (this.searchDialog.getSearchDown()) {
            int i = this.table.getSelectionIndex() + 1;
            while (i < this.table.getItemCount()) {
                found = this.findMatch(searchString, this.table.getItem(i), column, matchWord, matchCase);
                if (found) {
                    this.table.setSelection(i);
                    break;
                }
                ++i;
            }
        } else {
            int i = this.table.getSelectionIndex() - 1;
            while (i > -1) {
                found = this.findMatch(searchString, this.table.getItem(i), column, matchWord, matchCase);
                if (found) {
                    this.table.setSelection(i);
                    break;
                }
                --i;
            }
        }
        this.shell.setCursor(null);
        return found;
    }

    private boolean findMatch(String searchString, TableItem item, int column, boolean matchWord, boolean matchCase) {
        String tableText;
        String string = tableText = matchCase ? item.getText(column) : item.getText(column).toLowerCase();
        return matchWord ? tableText != null && tableText.equals(searchString) : tableText != null && tableText.indexOf(searchString) != -1;
    }

    private void newAddressBook() {
        this.shell.setText(String.valueOf(resAddressBook.getString("Title_bar")) + resAddressBook.getString("New_title"));
        this.file = null;
        this.isModified = false;
    }

    private void newEntry() {
        DataEntryDialog dialog = new DataEntryDialog(this.shell);
        dialog.setLabels(columnNames);
        String[] data = dialog.open();
        if (data != null) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(data);
            this.isModified = true;
        }
    }

    private void openAddressBook() {
        String element;
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        fileDialog.setFilterExtensions(new String[]{"*.adr;", "*.*"});
        fileDialog.setFilterNames(new String[]{String.valueOf(resAddressBook.getString("Book_filter_name")) + " (*.adr)", String.valueOf(resAddressBook.getString("All_filter_name")) + " (*.*)"});
        String name = fileDialog.open();
        if (name == null) {
            return;
        }
        File file = new File(name);
        if (!file.exists()) {
            this.displayError(String.valueOf(resAddressBook.getString("File")) + file.getName() + " " + resAddressBook.getString("Does_not_exist"));
            return;
        }
        Cursor waitCursor = this.shell.getDisplay().getSystemCursor(1);
        this.shell.setCursor(waitCursor);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String[] data = new String[]{};
        try {
            fileReader = new FileReader(file.getAbsolutePath());
            bufferedReader = new BufferedReader(fileReader);
            String nextLine = bufferedReader.readLine();
            while (nextLine != null) {
                String[] newData = new String[data.length + 1];
                System.arraycopy(data, 0, newData, 0, data.length);
                newData[data.length] = nextLine;
                data = newData;
                nextLine = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.displayError(String.valueOf(resAddressBook.getString("File_not_found")) + "\n" + file.getName());
            this.shell.setCursor(null);
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + file.getName());
                    return;
                }
            }
            return;
        }
        catch (IOException iOException) {
            try {
                this.displayError(String.valueOf(resAddressBook.getString("IO_error_read")) + "\n" + file.getName());
            }
            catch (Throwable throwable) {
                this.shell.setCursor(null);
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException2) {
                        this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + file.getName());
                        return;
                    }
                }
                throw throwable;
            }
            this.shell.setCursor(null);
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException3) {
                    this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + file.getName());
                    return;
                }
            }
            return;
        }
        this.shell.setCursor(null);
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + file.getName());
                return;
            }
        }
        String[][] tableInfo = new String[data.length][this.table.getColumnCount()];
        int writeIndex = 0;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            String[] line = this.decodeLine(element);
            if (line != null) {
                tableInfo[writeIndex++] = line;
            }
            ++n2;
        }
        if (writeIndex != data.length) {
            String[][] result = new String[writeIndex][this.table.getColumnCount()];
            System.arraycopy(tableInfo, 0, result, 0, writeIndex);
            tableInfo = result;
        }
        Arrays.sort(tableInfo, new RowComparator(0));
        stringArray = tableInfo;
        n = tableInfo.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            TableItem item = new TableItem(this.table, 0);
            item.setText((String[])element);
            ++n2;
        }
        this.shell.setText(String.valueOf(resAddressBook.getString("Title_bar")) + fileDialog.getFileName());
        this.isModified = false;
        this.file = file;
    }

    private boolean save() {
        if (this.file == null) {
            return this.saveAs();
        }
        Cursor waitCursor = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(waitCursor);
        TableItem[] items = this.table.getItems();
        String[] lines = new String[items.length];
        int i = 0;
        while (i < items.length) {
            String[] itemText = new String[this.table.getColumnCount()];
            int j = 0;
            while (j < itemText.length) {
                itemText[j] = items[i].getText(j);
                ++j;
            }
            lines[i] = this.encodeLine(itemText);
            ++i;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.file.getAbsolutePath(), false);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                fileWriter.write(line);
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.displayError(String.valueOf(resAddressBook.getString("File_not_found")) + "\n" + this.file.getName());
            this.shell.setCursor(null);
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + this.file.getName());
                    return false;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            try {
                this.displayError(String.valueOf(resAddressBook.getString("IO_error_write")) + "\n" + this.file.getName());
            }
            catch (Throwable throwable) {
                this.shell.setCursor(null);
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException2) {
                        this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + this.file.getName());
                        return false;
                    }
                }
                throw throwable;
            }
            this.shell.setCursor(null);
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException3) {
                    this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + this.file.getName());
                    return false;
                }
            }
            return false;
        }
        this.shell.setCursor(null);
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                this.displayError(String.valueOf(resAddressBook.getString("IO_error_close")) + "\n" + this.file.getName());
                return false;
            }
        }
        this.shell.setText(String.valueOf(resAddressBook.getString("Title_bar")) + this.file.getName());
        this.isModified = false;
        return true;
    }

    private boolean saveAs() {
        File file;
        FileDialog saveDialog = new FileDialog(this.shell, 8192);
        saveDialog.setFilterExtensions(new String[]{"*.adr;", "*.*"});
        saveDialog.setFilterNames(new String[]{"Address Books (*.adr)", "All Files "});
        saveDialog.open();
        String name = saveDialog.getFileName();
        if (name.isEmpty()) {
            return false;
        }
        if (name.indexOf(".adr") != name.length() - 4) {
            name = String.valueOf(name) + ".adr";
        }
        if ((file = new File(saveDialog.getFilterPath(), name)).exists()) {
            MessageBox box = new MessageBox(this.shell, 200);
            box.setText(resAddressBook.getString("Save_as_title"));
            box.setMessage(String.valueOf(resAddressBook.getString("File")) + file.getName() + " " + resAddressBook.getString("Query_overwrite"));
            if (box.open() != 64) {
                return false;
            }
        }
        this.file = file;
        return this.save();
    }

    private void sort(int column) {
        if (this.table.getItemCount() <= 1) {
            return;
        }
        TableItem[] items = this.table.getItems();
        String[][] data = new String[items.length][this.table.getColumnCount()];
        int i = 0;
        while (i < items.length) {
            int j = 0;
            while (j < this.table.getColumnCount()) {
                data[i][j] = items[i].getText(j);
                ++j;
            }
            ++i;
        }
        Arrays.sort(data, new RowComparator(column));
        if (this.lastSortColumn != column) {
            this.table.setSortColumn(this.table.getColumn(column));
            this.table.setSortDirection(1024);
            i = 0;
            while (i < data.length) {
                items[i].setText(data[i]);
                ++i;
            }
            this.lastSortColumn = column;
        } else {
            this.table.setSortDirection(128);
            int j = data.length - 1;
            int i2 = 0;
            while (i2 < data.length) {
                items[i2].setText(data[j--]);
                ++i2;
            }
            this.lastSortColumn = -1;
        }
    }

    private void createFileMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(resAddressBook.getString("File_menu_title"));
        Menu menu = new Menu((Decorations)this.shell, 4);
        item.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                items[1].setEnabled(AddressBook.this.table.getSelectionCount() != 0);
                items[5].setEnabled(AddressBook.this.file != null && AddressBook.this.isModified);
                items[6].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("New_contact"));
        subItem.setAccelerator(SWT.MOD1 + 78);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.newEntry()));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Edit_contact"));
        subItem.setAccelerator(SWT.MOD1 + 69);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            this.editEntry(items[0]);
        }));
        new MenuItem(menu, 2);
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("New_address_book"));
        subItem.setAccelerator(SWT.MOD1 + 66);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.closeAddressBook()) {
                this.newAddressBook();
            }
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Open_address_book"));
        subItem.setAccelerator(SWT.MOD1 + 79);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.closeAddressBook()) {
                this.openAddressBook();
            }
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Save_address_book"));
        subItem.setAccelerator(SWT.MOD1 + 83);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.save();
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Save_book_as"));
        subItem.setAccelerator(SWT.MOD1 + 65);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.saveAs();
        }));
        new MenuItem(menu, 2);
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Exit"));
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.shell.close()));
    }

    private MenuItem createEditMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(resAddressBook.getString("Edit_menu_title"));
        Menu menu = new Menu((Decorations)this.shell, 4);
        item.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                int count = AddressBook.this.table.getSelectionCount();
                items[0].setEnabled(count != 0);
                items[1].setEnabled(count != 0);
                items[2].setEnabled(AddressBook.this.copyBuffer != null);
                items[3].setEnabled(count != 0);
                items[5].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem subItem = new MenuItem(menu, 8);
        subItem.setText(resAddressBook.getString("Edit"));
        subItem.setAccelerator(SWT.MOD1 + 69);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            this.editEntry(items[0]);
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Copy"));
        subItem.setAccelerator(SWT.MOD1 + 67);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            this.copyBuffer = new String[this.table.getColumnCount()];
            int i = 0;
            while (i < this.copyBuffer.length) {
                this.copyBuffer[i] = items[0].getText(i);
                ++i;
            }
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Paste"));
        subItem.setAccelerator(SWT.MOD1 + 86);
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.copyBuffer == null) {
                return;
            }
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(this.copyBuffer);
            this.isModified = true;
        }));
        subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("Delete"));
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            items[0].dispose();
            this.isModified = true;
        }));
        new MenuItem(menu, 2);
        subItem = new MenuItem(menu, 64);
        subItem.setText(resAddressBook.getString("Sort"));
        Menu submenu = this.createSortMenu();
        subItem.setMenu(submenu);
        return item;
    }

    private Menu createSortMenu() {
        Menu submenu = new Menu((Decorations)this.shell, 4);
        int i = 0;
        while (i < columnNames.length) {
            MenuItem subitem = new MenuItem(submenu, 0);
            subitem.setText(columnNames[i]);
            int column = i++;
            subitem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.sort(column)));
        }
        return submenu;
    }

    private void createSearchMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(resAddressBook.getString("Search_menu_title"));
        Menu searchMenu = new Menu((Decorations)this.shell, 4);
        item.setMenu(searchMenu);
        item = new MenuItem(searchMenu, 0);
        item.setText(resAddressBook.getString("Find"));
        item.setAccelerator(SWT.MOD1 + 70);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.searchDialog.setMatchCase(false);
            this.searchDialog.setMatchWord(false);
            this.searchDialog.setSearchDown(true);
            this.searchDialog.setSearchString("");
            this.searchDialog.setSelectedSearchArea(0);
            this.searchDialog.open();
        }));
        item = new MenuItem(searchMenu, 0);
        item.setText(resAddressBook.getString("Find_next"));
        item.setAccelerator(0x100000C);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.searchDialog.open()));
    }

    private Menu createPopUpMenu() {
        Menu popUpMenu = new Menu((Decorations)this.shell, 8);
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                int count = AddressBook.this.table.getSelectionCount();
                items[2].setEnabled(count != 0);
                items[3].setEnabled(count != 0);
                items[4].setEnabled(AddressBook.this.copyBuffer != null);
                items[5].setEnabled(count != 0);
                items[7].setEnabled(AddressBook.this.table.getItemCount() != 0);
            }
        });
        MenuItem item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_new"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.newEntry()));
        new MenuItem(popUpMenu, 2);
        item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_edit"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            this.editEntry(items[0]);
        }));
        item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_copy"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            this.copyBuffer = new String[this.table.getColumnCount()];
            int i = 0;
            while (i < this.copyBuffer.length) {
                this.copyBuffer[i] = items[0].getText(i);
                ++i;
            }
        }));
        item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_paste"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.copyBuffer == null) {
                return;
            }
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(this.copyBuffer);
            this.isModified = true;
        }));
        item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_delete"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            items[0].dispose();
            this.isModified = true;
        }));
        new MenuItem(popUpMenu, 2);
        item = new MenuItem(popUpMenu, 8);
        item.setText(resAddressBook.getString("Pop_up_find"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.searchDialog.open()));
        return popUpMenu;
    }

    private void createHelpMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText(resAddressBook.getString("Help_menu_title"));
        Menu menu = new Menu((Decorations)this.shell, 4);
        item.setMenu(menu);
        MenuItem subItem = new MenuItem(menu, 0);
        subItem.setText(resAddressBook.getString("About"));
        subItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            MessageBox box = new MessageBox(this.shell, 0);
            box.setText(String.valueOf(resAddressBook.getString("About_1")) + this.shell.getText());
            box.setMessage(String.valueOf(this.shell.getText()) + resAddressBook.getString("About_2"));
            box.open();
        }));
    }

    private class RowComparator
    implements Comparator<String[]> {
        private int column;

        public RowComparator(int col) {
            this.column = col;
        }

        @Override
        public int compare(String[] row1, String[] row2) {
            return row1[this.column].compareTo(row2[this.column]);
        }
    }
}

