/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;

class BrowserTab
extends Tab {
    Browser browser;
    Group browserGroup;
    Button mozillaButton;
    Button webKitButton;
    String errorMessage;
    String lastText;
    String lastUrl;

    BrowserTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createBackgroundModeGroup() {
    }

    @Override
    void createColorAndFontGroup() {
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.browserGroup = new Group((Composite)this.exampleGroup, 0);
        this.browserGroup.setLayout((Layout)new GridLayout());
        this.browserGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserGroup.setText("Browser");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.mozillaButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.webKitButton.getSelection()) {
            style |= 0x10000;
        }
        try {
            this.browser = new Browser((Composite)this.browserGroup, style);
        }
        catch (SWTError e) {
            try {
                this.browser = new Browser((Composite)this.browserGroup, style & 0xFFFE7FFF);
            }
            catch (SWTError sWTError) {
                this.errorMessage = e.getMessage();
                return;
            }
            MessageBox dialog = new MessageBox(this.shell, 40);
            String resourceString = (style & 0x8000) != 0 ? "MozillaNotFound" : "WebKitNotFound";
            dialog.setMessage(ControlExample.getResourceString(resourceString, e.getMessage()));
            dialog.open();
        }
        if (this.lastUrl != null) {
            this.browser.setUrl(this.lastUrl);
        } else if (this.lastText != null) {
            this.browser.setText(this.lastText);
        } else {
            StringBuffer sb;
            block23: {
                InputStream htmlStream = ControlExample.class.getResourceAsStream("browser-content.html");
                BufferedReader br = new BufferedReader(new InputStreamReader(htmlStream));
                sb = new StringBuffer(300);
                try {
                    try {
                        int read = 0;
                        while ((read = br.read()) != -1) {
                            sb.append((char)read);
                        }
                    }
                    catch (IOException e) {
                        this.log(e.getMessage());
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            this.log(e2.getMessage());
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        this.log(e.getMessage());
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.log(e.getMessage());
                }
            }
            String text = sb.toString();
            this.browser.setText(text);
        }
        this.lastUrl = null;
        this.lastText = null;
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.backgroundImageButton.dispose();
    }

    @Override
    void createSizeGroup() {
        super.createSizeGroup();
        this.fillHButton.setSelection(true);
        this.fillVButton.setSelection(true);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.mozillaButton = new Button((Composite)this.styleGroup, 32);
        this.mozillaButton.setText("SWT.MOZILLA");
        this.mozillaButton.addListener(13, event -> this.webKitButton.setSelection(false));
        this.webKitButton = new Button((Composite)this.styleGroup, 32);
        this.webKitButton.setText("SWT.WEBKIT");
        this.webKitButton.addListener(13, event -> this.mozillaButton.setSelection(false));
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                BrowserTab.this.setExampleWidgetSize();
            }
        });
        tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.errorMessage != null && tabFolder.getSelection()[0].getText().equals(this.getTabText())) {
                MessageBox dialog = new MessageBox(this.shell, 40);
                dialog.setMessage(ControlExample.getResourceString("BrowserNotFound", this.errorMessage));
                dialog.open();
            }
        }));
        return this.tabFolderPage;
    }

    @Override
    void disposeExampleWidgets() {
        if (this.browser != null) {
            String url = this.browser.getUrl();
            if (url.length() > 0 && !url.equals("about:blank")) {
                this.lastUrl = url;
            } else {
                String text = this.browser.getText();
                if (text.length() > 0) {
                    this.lastText = text;
                }
            }
        }
        super.disposeExampleWidgets();
    }

    public static String getContents(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer(300);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            int read = 0;
            while ((read = br.read()) != -1) {
                sb.append((char)read);
            }
        }
        return sb.toString();
    }

    @Override
    String[] getCustomEventNames() {
        return new String[]{"AuthenticationListener", "CloseWindowListener", "LocationListener", "OpenWindowListener", "ProgressListener", "StatusTextListener", "TitleListener", "VisibilityWindowListener"};
    }

    @Override
    Widget[] getExampleWidgets() {
        if (this.browser != null) {
            return new Widget[]{this.browser};
        }
        return super.getExampleWidgets();
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Text", "Url", "ToolTipText"};
    }

    @Override
    String getTabText() {
        return "Browser";
    }

    @Override
    void hookCustomListener(final String eventName) {
        if (this.browser == null) {
            return;
        }
        if (eventName == "AuthenticationListener") {
            this.browser.addAuthenticationListener(event -> this.log(eventName, (TypedEvent)event));
        }
        if (eventName == "CloseWindowListener") {
            this.browser.addCloseWindowListener(event -> this.log(eventName, (TypedEvent)event));
        }
        if (eventName == "LocationListener") {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".changed", (TypedEvent)event);
                }

                public void changing(LocationEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".changing", (TypedEvent)event);
                }
            });
        }
        if (eventName == "OpenWindowListener") {
            this.browser.addOpenWindowListener(event -> this.log(eventName, (TypedEvent)event));
        }
        if (eventName == "ProgressListener") {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".changed", (TypedEvent)event);
                }

                public void completed(ProgressEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".completed", (TypedEvent)event);
                }
            });
        }
        if (eventName == "StatusTextListener") {
            this.browser.addStatusTextListener(event -> this.log(eventName, (TypedEvent)event));
        }
        if (eventName == "TitleListener") {
            this.browser.addTitleListener(event -> this.log(eventName, (TypedEvent)event));
        }
        if (eventName == "VisibilityWindowListener") {
            this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".hide", (TypedEvent)event);
                }

                public void show(WindowEvent event) {
                    BrowserTab.this.log(String.valueOf(eventName) + ".show", (TypedEvent)event);
                }
            });
        }
    }

    @Override
    boolean rtlSupport() {
        return false;
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.mozillaButton.setSelection(this.browser == null ? false : (this.browser.getStyle() & 0x8000) != 0);
        this.webKitButton.setSelection(this.browser == null ? false : (this.browser.getStyle() & 0x10000) != 0);
        this.borderButton.setSelection(this.browser == null ? false : (this.browser.getStyle() & 0x800) != 0);
    }
}

