/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.controlexample.BrowserTab;
import org.eclipse.swt.examples.controlexample.ButtonTab;
import org.eclipse.swt.examples.controlexample.CanvasTab;
import org.eclipse.swt.examples.controlexample.ColorTab;
import org.eclipse.swt.examples.controlexample.ComboTab;
import org.eclipse.swt.examples.controlexample.CoolBarTab;
import org.eclipse.swt.examples.controlexample.DateTimeTab;
import org.eclipse.swt.examples.controlexample.DialogTab;
import org.eclipse.swt.examples.controlexample.ExpandBarTab;
import org.eclipse.swt.examples.controlexample.GroupTab;
import org.eclipse.swt.examples.controlexample.LabelTab;
import org.eclipse.swt.examples.controlexample.LinkTab;
import org.eclipse.swt.examples.controlexample.ListTab;
import org.eclipse.swt.examples.controlexample.MenuTab;
import org.eclipse.swt.examples.controlexample.ProgressBarTab;
import org.eclipse.swt.examples.controlexample.SashTab;
import org.eclipse.swt.examples.controlexample.ScaleTab;
import org.eclipse.swt.examples.controlexample.ShellTab;
import org.eclipse.swt.examples.controlexample.SliderTab;
import org.eclipse.swt.examples.controlexample.SpinnerTab;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.examples.controlexample.TabFolderTab;
import org.eclipse.swt.examples.controlexample.TableTab;
import org.eclipse.swt.examples.controlexample.TextTab;
import org.eclipse.swt.examples.controlexample.ToolBarTab;
import org.eclipse.swt.examples.controlexample.ToolTipTab;
import org.eclipse.swt.examples.controlexample.TreeTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ControlExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_control");
    private ShellTab shellTab;
    private TabFolder tabFolder;
    private Tab[] tabs;
    Image[] images;
    static final int ciClosedFolder = 0;
    static final int ciOpenFolder = 1;
    static final int ciTarget = 2;
    static final int ciBackground = 3;
    static final int ciParentBackground = 4;
    static final String[] imageLocations = new String[]{"closedFolder.gif", "openFolder.gif", "target.gif", "backgroundImage.png", "parentBackgroundImage.png"};
    static final int[] imageTypes;
    boolean startup = true;

    static {
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        imageTypes = nArray;
    }

    public ControlExample(Composite parent) {
        this.initResources();
        this.tabFolder = new TabFolder(parent, 0);
        Tab[] tabArray = this.tabs = this.createTabs();
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(tab.getTabText());
            item.setControl((Control)tab.createTabFolderPage(this.tabFolder));
            item.setData((Object)tab);
            ++n2;
        }
        Point size = parent.computeSize(-1, -1);
        Rectangle monitorArea = parent.getMonitor().getClientArea();
        boolean isMac = SWT.getPlatform().equals("cocoa");
        if (size.x > monitorArea.width && isMac) {
            TabItem[] tabItems = this.tabFolder.getItems();
            int i = 0;
            while (i < tabItems.length) {
                tabItems[i].setText(this.tabs[i].getShortTabText());
                ++i;
            }
        }
        this.startup = false;
    }

    Tab[] createTabs() {
        Tab[] tabArray = new Tab[26];
        tabArray[0] = new ButtonTab(this);
        tabArray[1] = new CanvasTab(this);
        tabArray[2] = new ColorTab(this);
        tabArray[3] = new ComboTab(this);
        tabArray[4] = new CoolBarTab(this);
        tabArray[5] = new DateTimeTab(this);
        tabArray[6] = new DialogTab(this);
        tabArray[7] = new ExpandBarTab(this);
        tabArray[8] = new GroupTab(this);
        tabArray[9] = new LabelTab(this);
        tabArray[10] = new LinkTab(this);
        tabArray[11] = new ListTab(this);
        tabArray[12] = new MenuTab(this);
        tabArray[13] = new ProgressBarTab(this);
        tabArray[14] = new SashTab(this);
        tabArray[15] = new ScaleTab(this);
        this.shellTab = new ShellTab(this);
        tabArray[16] = this.shellTab;
        tabArray[17] = new SliderTab(this);
        tabArray[18] = new SpinnerTab(this);
        tabArray[19] = new TabFolderTab(this);
        tabArray[20] = new TableTab(this);
        tabArray[21] = new TextTab(this);
        tabArray[22] = new ToolBarTab(this);
        tabArray[23] = new ToolTipTab(this);
        tabArray[24] = new TreeTab(this);
        tabArray[25] = new BrowserTab(this);
        return tabArray;
    }

    public void dispose() {
        if (this.shellTab != null) {
            this.shellTab.closeAllShells();
        }
        this.shellTab = null;
        this.tabFolder = null;
        this.freeResources();
    }

    void freeResources() {
        if (this.images != null) {
            Image[] imageArray = this.images;
            int n = this.images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
            this.images = null;
        }
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object ... args) {
        try {
            return MessageFormat.format(ControlExample.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    void initResources() {
        Class<ControlExample> clazz = ControlExample.class;
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        InputStream sourceStream = clazz.getResourceAsStream(imageLocations[i]);
                        ImageData source = new ImageData(sourceStream);
                        if (imageTypes[i] == 1) {
                            ImageData mask = source.getTransparencyMask();
                            this.images[i] = new Image(null, source, mask);
                        } else {
                            this.images[i] = new Image(null, source);
                        }
                        try {
                            sourceStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? ControlExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout());
        ControlExample instance = new ControlExample((Composite)shell);
        shell.setText(ControlExample.getResourceString("window.title"));
        ControlExample.setShellSize(instance, shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        instance.dispose();
        display.dispose();
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    static void setShellSize(ControlExample instance, Shell shell) {
        Point size = shell.computeSize(-1, -1);
        Rectangle monitorArea = shell.getMonitor().getClientArea();
        shell.setSize(Math.min(size.x, monitorArea.width), Math.min(size.y, monitorArea.height));
    }
}

