/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

class CoolBarTab
extends Tab {
    CoolBar coolBar;
    CoolItem pushItem;
    CoolItem dropDownItem;
    CoolItem radioItem;
    CoolItem checkItem;
    CoolItem textItem;
    Group coolBarGroup;
    Button horizontalButton;
    Button verticalButton;
    Button dropDownButton;
    Button flatButton;
    Button lockedButton;
    Point[] sizes;
    int[] wrapIndices;
    int[] order;

    CoolBarTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createOtherGroup() {
        super.createOtherGroup();
        this.lockedButton = new Button((Composite)this.otherGroup, 32);
        this.lockedButton.setText(ControlExample.getResourceString("Locked"));
        this.lockedButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setWidgetLocked()));
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.coolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.coolBarGroup.setLayout((Layout)new GridLayout());
        this.coolBarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.coolBarGroup.setText("CoolBar");
    }

    @Override
    void createExampleWidgets() {
        CoolItem[] coolItems;
        int style = this.getDefaultStyle();
        int itemStyle = 0;
        int toolBarStyle = 0x800000;
        boolean vertical = false;
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
            toolBarStyle |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
            toolBarStyle |= 0x200;
            vertical = true;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.dropDownButton.getSelection()) {
            itemStyle |= 4;
        }
        this.coolBar = new CoolBar((Composite)this.coolBarGroup, style);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 2);
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.PUSH");
        this.pushItem = new CoolItem(this.coolBar, itemStyle);
        this.pushItem.setControl((Control)toolBar);
        this.pushItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 4);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        item = new ToolItem(toolBar, 4);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.dropDownItem = new CoolItem(this.coolBar, itemStyle);
        this.dropDownItem.setControl((Control)toolBar);
        this.dropDownItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        this.radioItem = new CoolItem(this.coolBar, itemStyle);
        this.radioItem.setControl((Control)toolBar);
        this.radioItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        this.checkItem = new CoolItem(this.coolBar, itemStyle);
        this.checkItem.setControl((Control)toolBar);
        this.checkItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        if (!vertical) {
            Text text = new Text((Composite)this.coolBar, 2052);
            this.textItem = new CoolItem(this.coolBar, itemStyle);
            this.textItem.setControl((Control)text);
            this.textItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
            Point textSize = text.computeSize(-1, -1);
            textSize = this.textItem.computeSize(textSize.x, textSize.y);
            this.textItem.setMinimumSize(textSize);
            this.textItem.setPreferredSize(textSize);
            this.textItem.setSize(textSize);
        }
        CoolItem[] coolItemArray = coolItems = this.coolBar.getItems();
        int n = coolItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBar bar;
            CoolItem coolItem = coolItemArray[n2];
            Control control = coolItem.getControl();
            Point size = control.computeSize(-1, -1);
            Point coolSize = coolItem.computeSize(size.x, size.y);
            if (control instanceof ToolBar && (bar = (ToolBar)control).getItemCount() > 0) {
                if (vertical) {
                    size.y = bar.getItem((int)0).getBounds().height;
                } else {
                    size.x = bar.getItem(0).getWidth();
                }
            }
            coolItem.setMinimumSize(size);
            coolItem.setPreferredSize(coolSize);
            coolItem.setSize(coolSize);
            ++n2;
        }
        if (this.order != null && this.order.length == this.coolBar.getItemCount()) {
            this.coolBar.setItemLayout(this.order, this.wrapIndices, this.sizes);
        } else {
            this.coolBar.setWrapIndices(new int[]{1, 3});
        }
        this.coolBar.addListener(11, event -> this.exampleGroup.layout());
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.horizontalButton = new Button((Composite)this.styleGroup, 16);
        this.horizontalButton.setText("SWT.HORIZONTAL");
        this.verticalButton = new Button((Composite)this.styleGroup, 16);
        this.verticalButton.setText("SWT.VERTICAL");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        Group itemGroup = new Group((Composite)this.styleGroup, 0);
        itemGroup.setLayout((Layout)new GridLayout());
        itemGroup.setLayoutData((Object)new GridData(272));
        itemGroup.setText(ControlExample.getResourceString("Item_Styles"));
        this.dropDownButton = new Button((Composite)itemGroup, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
    }

    @Override
    void disposeExampleWidgets() {
        if (this.coolBar != null) {
            this.sizes = this.coolBar.getItemSizes();
            this.wrapIndices = this.coolBar.getWrapIndices();
            this.order = this.coolBar.getItemOrder();
        }
        super.disposeExampleWidgets();
    }

    @Override
    Item[] getExampleWidgetItems() {
        return this.coolBar.getItems();
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.coolBar};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"ToolTipText"};
    }

    @Override
    String getShortTabText() {
        return "CB";
    }

    @Override
    String getTabText() {
        return "CoolBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.horizontalButton.setSelection((this.coolBar.getStyle() & 0x100) != 0);
        this.verticalButton.setSelection((this.coolBar.getStyle() & 0x200) != 0);
        this.borderButton.setSelection((this.coolBar.getStyle() & 0x800) != 0);
        this.flatButton.setSelection((this.coolBar.getStyle() & 0x800000) != 0);
        this.dropDownButton.setSelection((this.coolBar.getItem(0).getStyle() & 4) != 0);
        this.lockedButton.setSelection(this.coolBar.getLocked());
        if (!this.instance.startup) {
            this.setWidgetLocked();
        }
    }

    void setWidgetLocked() {
        this.coolBar.setLocked(this.lockedButton.getSelection());
    }

    class CoolItemSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        CoolItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                    return;
                }
                CoolItem coolItem = (CoolItem)event.widget;
                Rectangle itemBounds = coolItem.getBounds();
                itemBounds.width = event.x - itemBounds.x;
                Point pt = CoolBarTab.this.coolBar.toDisplay(new Point(itemBounds.x, itemBounds.y));
                itemBounds.x = pt.x;
                itemBounds.y = pt.y;
                ToolBar toolBar = (ToolBar)coolItem.getControl();
                ToolItem[] tools = toolBar.getItems();
                int toolCount = tools.length;
                int i = 0;
                while (i < toolCount) {
                    Rectangle toolBounds = tools[i].getBounds();
                    pt = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
                    toolBounds.x = pt.x;
                    toolBounds.y = pt.y;
                    Rectangle intersection = itemBounds.intersection(toolBounds);
                    if (!intersection.equals((Object)toolBounds)) break;
                    ++i;
                }
                this.menu = new Menu((Decorations)CoolBarTab.this.shell, 8 | CoolBarTab.this.coolBar.getStyle() & 0x6000000);
                int j = i;
                while (j < toolCount) {
                    String text;
                    MenuItem menuItem;
                    ToolItem tool = tools[j];
                    Image image = tool.getImage();
                    if (image == null) {
                        new MenuItem(this.menu, 2);
                    } else if ((tool.getStyle() & 4) != 0) {
                        menuItem = new MenuItem(this.menu, 64);
                        menuItem.setImage(image);
                        text = tool.getToolTipText();
                        if (text != null) {
                            menuItem.setText(text);
                        }
                        Menu m = new Menu(this.menu);
                        menuItem.setMenu(m);
                        int k = 0;
                        while (k < 9) {
                            text = ControlExample.getResourceString("DropDownData_" + k);
                            if (text.length() != 0) {
                                MenuItem mi = new MenuItem(m, 0);
                                mi.setText(text);
                            } else {
                                new MenuItem(m, 2);
                            }
                            ++k;
                        }
                    } else {
                        menuItem = new MenuItem(this.menu, 0);
                        menuItem.setImage(image);
                        text = tool.getToolTipText();
                        if (text != null) {
                            menuItem.setText(text);
                        }
                    }
                    ++j;
                }
                pt = CoolBarTab.this.coolBar.toDisplay(new Point(event.x, event.y));
                this.menu.setLocation(pt.x, pt.y);
                this.menu.setVisible(true);
                while (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
                    if (CoolBarTab.this.display.readAndDispatch()) continue;
                    CoolBarTab.this.display.sleep();
                }
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        }
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;
        private boolean visible = false;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.menu == null) {
                this.menu = new Menu((Decorations)CoolBarTab.this.shell, 8 | CoolBarTab.this.coolBar.getStyle() & 0x6000000);
                this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent e) {
                        DropDownSelectionListener.this.visible = false;
                    }
                });
                int i = 0;
                while (i < 9) {
                    String text = ControlExample.getResourceString("DropDownData_" + i);
                    if (text.length() != 0) {
                        MenuItem menuItem = new MenuItem(this.menu, 0);
                        menuItem.setText(text);
                        menuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setMenuVisible(false)));
                    } else {
                        new MenuItem(this.menu, 2);
                    }
                    ++i;
                }
            }
            if (event.detail == 4) {
                if (this.visible) {
                    this.setMenuVisible(false);
                } else {
                    ToolItem toolItem = (ToolItem)event.widget;
                    ToolBar toolBar = toolItem.getParent();
                    Rectangle toolItemBounds = toolItem.getBounds();
                    Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                    this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                    this.setMenuVisible(true);
                }
            }
        }

        private void setMenuVisible(boolean visible) {
            this.menu.setVisible(visible);
            this.visible = visible;
        }
    }
}

